(function ($) {

  "use strict";

  // remove ads on theme options panel
  jQuery(window).load(function(){
    jQuery('#redux-header .rAds').hide();
  });


  /*
   * A custom function that checks if element is in array, we'll need it later
   */
  function in_array(el, arr) {
  	for(var i in arr) {
  		if(arr[i] == el) return true;
  	}
  	return false;
  }

  jQuery( function( $ ) {
  	/*
  	 * Sortable images
  	 */
  	$('ul.naturally_gallery_mtb').sortable({
  		items:'li',
  		cursor:'-webkit-grabbing', /* mouse cursor */
  		scrollSensitivity:40,
  		/*
  		You can set your custom CSS styles while this element is dragging
  		start:function(event,ui){
  			ui.item.css({'background-color':'grey'});
  		},
  		*/
  		stop:function(event,ui){
  			ui.item.removeAttr('style');

  			var sort = new Array(), /* array of image IDs */
  			    gallery = $(this); /* ul.naturally_gallery_mtb */

  			/* each time after dragging we resort our array */
  			gallery.find('li').each(function(index){
  				sort.push( $(this).attr('data-id') );
  			});
  			/* add the array value to the hidden input field */
  			gallery.parent().next().val( sort.join() );
  			/* console.log(sort); */
  		}
  	});
  	/*
  	 * Multiple images uploader
  	 */
  	$('.naturally_upload_gallery_button').click( function(e){ /* on button click*/
  		e.preventDefault();

  		var button = $(this),
  		    hiddenfield = button.prev(),
  		    hiddenfieldvalue = hiddenfield.val().split(","), /* the array of added image IDs */
  	    	    custom_uploader = wp.media({
  			title: 'Insert images', /* popup title */
  			library : {type : 'image'},
  			button: {text: 'Use these images'}, /* "Insert" button text */
  			multiple: true
  		    }).on('select', function() {

  			var attachments = custom_uploader.state().get('selection').map(function( a ) {
  				a.toJSON();
              	return a;
  			}),
  			thesamepicture = false,
  			i;

  			/* loop through all the images */
            		for (i = 0; i < attachments.length; ++i) {

  				/* if you don't want the same images to be added multiple time */
  				if( !in_array( attachments[i].id, hiddenfieldvalue ) ) {

  					/* add HTML element with an image */
  					$('ul.naturally_gallery_mtb').append('<li data-id="' + attachments[i].id + '"><span style="background-image:url(' + attachments[i].attributes.url + ')"></span><a href="#" class="naturally_gallery_remove">×</a></li>');
  					/* add an image ID to the array of all images */
  					hiddenfieldvalue.push( attachments[i].id );
  				} else {
  					thesamepicture = true;
  				}
            		}
  			/* refresh sortable */
  			$( "ul.naturally_gallery_mtb" ).sortable( "refresh" );
  			/* add the IDs to the hidden field value */
  			hiddenfield.val( hiddenfieldvalue.join() );
  			/* you can print a message for users if you want to let you know about the same images */
  			if( thesamepicture == true ) alert('The same images are not allowed.');
  		}).open();
  	});

  	/*
  	 * Remove certain images
  	 */
  	$('body').on('click', '.naturally_gallery_remove', function(){
  		var id = $(this).parent().attr('data-id'),
  		    gallery = $(this).parent().parent(),
  		    hiddenfield = gallery.parent().next(),
  		    hiddenfieldvalue = hiddenfield.val().split(","),
  		    i = hiddenfieldvalue.indexOf(id);

  		$(this).parent().remove();

  		/* remove certain array element */
  		if(i != -1) {
  			hiddenfieldvalue.splice(i, 1);
  		}

  		/* add the IDs to the hidden field value */
  		hiddenfield.val( hiddenfieldvalue.join() );

  		/* refresh sortable */
  		gallery.sortable( "refresh" );

  		return false;
  	});
  	/*
  	 * Selected item
  	 */
  	$('body').on('mousedown', 'ul.naturally_gallery_mtb li', function(){
  		var el = $(this);
  		el.parent().find('li').removeClass('naturally-active');
  		el.addClass('naturally-active');
  	});
  });


/*-----------------------------------------------------------------------------------

 	Custom JS - All back-end jQuery

-----------------------------------------------------------------------------------*/

jQuery(document).ready(function() {


	// A few overrides to the rwmb metaboxes.

	jQuery('.rwmb-text').addClass('widefat');
	jQuery('.rwmb-oembed').css('width', '80%');
	jQuery('.rwmb-textarea').removeClass('large-text').addClass('widefat');
	jQuery('.rwmb-delete-file').on(function(e) {
		e.preventDefault();
		jQuery(this).parent().parent().slideUp(600);
	});

	// Show metaboxes according to the current post format.



/*----------------------------------------------------------------------------------*/
/*	Gallery Options
/*----------------------------------------------------------------------------------*/

	var galleryOptions = jQuery('#gallery_settings');
	var galleryTrigger = jQuery('#post-format-gallery');

	galleryOptions.css('display', 'none');

/*----------------------------------------------------------------------------------*/
/*	Video Options
/*----------------------------------------------------------------------------------*/

	var embedOptions = jQuery('#embed-settings');
	var embedTrigger = jQuery('#post-format-video');
	var embedTrigger2 = jQuery('#post-format-audio');

	embedOptions.css('display', 'none');

/*----------------------------------------------------------------------------------*/
/*	The Brain
/*----------------------------------------------------------------------------------*/

	var group = jQuery('#post-formats-select input');


	group.change( function() {

		if (jQuery(this).val() == 'gallery') {
			galleryOptions.css('display', 'block');
			ninethemeHideAll(galleryOptions);

		} else if(jQuery(this).val() == 'video') {
			embedOptions.css('display', 'block');
			ninethemeHideAll(embedOptions);

		} else if(jQuery(this).val() == 'audio') {
			embedOptions.css('display', 'block');
			ninethemeHideAll(embedOptions);

		} else {
			embedOptions.css('display', 'none');
			galleryOptions.css('display', 'none');
		}

	});

	if(galleryTrigger.is(':checked'))
		galleryOptions.css('display', 'block');

	if(embedTrigger.is(':checked'))
		embedOptions.css('display', 'block');

	if(embedTrigger2.is(':checked'))
		embedOptions.css('display', 'block');

	function ninethemeHideAll(notThisOne) {
		embedOptions.css('display', 'none');
		galleryOptions.css('display', 'none');
		notThisOne.css('display', 'block');
	}

/*----------------------------------------------------------------------------------*/
/*	displaying page custom color
/*----------------------------------------------------------------------------------*/

	var badgestyle = jQuery('#naturally_badge');
	var badgecustom = jQuery('.naturally_custom_badge_field');

	if( badgestyle.val() == 'custom') {
		badgecustom.slideDown();
	}
	else {
		badgecustom.slideUp();
	}
	badgestyle.on('change', function(){
		if(badgestyle.val() == 'custom') {
		badgecustom.slideDown();
		}
		else {
		badgecustom.slideUp();
		}
	});

	var attrtype = jQuery('#naturally_product_single_attr');
	var attrcustom = jQuery('.naturally_product_custom_attr_field');

	if( attrtype.val() == 'custom') {
		attrcustom.slideDown();
	}
	else {
		attrcustom.slideUp();
	}
	attrtype.on('change', function(){
		if(attrtype.val() == 'custom') {
		attrcustom.slideDown();
		}
		else {
		attrcustom.slideUp();
		}
	});

});
})(jQuery);
