(function(window, document, $) {
    "use strict";

    function ntrLoading() {
        var myLoading = $('[data-ntr-loading]');
        if (myLoading.length) {
            $(window).on('load', function() {
                setTimeout(function() {
                    myLoading.removeClass('is-active');
                }, 300);
            });
        }
    }

    function ntrBacktop() {
        var myBacktop = $('[data-ntr-backtop]');
        var myWishlistBtn = $('.wishlist--count');
        if (myBacktop.length) {
            var myTimer;
            $(window).on('scroll', function() {
                if (myTimer) {
                    clearTimeout(myTimer);
                }
                myTimer = setTimeout(function() {
                    if ($(window).scrollTop() > 200) {
                        myBacktop.addClass('is-active');
                        myWishlistBtn.addClass('is-active');
                    } else {
                        myBacktop.removeClass('is-active');
                        myWishlistBtn.removeClass('is-active');
                    }
                }, 200);
            });
            myBacktop.on('click', function(e) {
                e.preventDefault();
                $('html, body').animate({
                    scrollTop: 0
                }, 800);
            });
        }
    }

    function ntrAnimation() {
        $(window).on('load', function() {
            setTimeout(function() {
                AOS.init();
            }, 300);
        });
    }

    function ntrBackground() {
        var myElements = $('[data-ntr-background]');
        if (myElements.length) {
            myElements.each(function(i, el) {
                var myElement = $(el);
                var myBackground = myElement.data('ntrBackground');
                if (!myBackground) {
                    return true; // next iteration
                }
                myElement.css({
                    'background-image': 'url("' + myBackground + '")'
                });
                myElement.removeAttr('data-ntr-background');
            });
        }
    }

    function ntrMap() {
        var myMaps = $('[data-ntr-map]');
        if (myMaps.length) {
            if (typeof google !== 'undefined') {
                myMaps.each(function(i, el) {
                    var myMap = el;
                    var myData = $(myMap).data('ntrMap');
                    if (!myData.lat || !myData.lng) {
                        return true; // next iteration
                    }
                    var myGoogleMap = new google.maps.Map(myMap, {
                        disableDefaultUI: myData.hideControls || false,
                        zoom: myData.zoom || 17,
                        center: {
                            lat: myData.lat,
                            lng: myData.lng
                        }
                    });
                    if (myData.marker === true) {
                        var myMarker = new google.maps.Marker({
                            position: {
                                lat: myData.lat,
                                lng: myData.lng
                            },
                            map: myGoogleMap
                        });
                    }
                });
            }
        }
    }

    function ntrUISlider() {
        var mySliders = $('[data-ntr-ui-slider]');
        if (mySliders.length) {
            mySliders.each(function(i, el) {
                var mySlider = $(el);
                var myData = mySlider.data('ntrUiSlider');
                mySlider.slider({
                    range: true,
                    min: myData.min,
                    max: myData.max,
                    values: [myData.value1, myData.value2]
                });
            });
        }
    }

    function ntrUISpinner() {
        var mySpinners = $('[data-ntr-ui-spinner]');
        if (mySpinners.length) {
            mySpinners.each(function(i, el) {
                var mySpinner = $(el);
                var myData = mySpinner.data('ntrUiSpinner');
                mySpinner.spinner({
                    min: myData.min || null,
                    max: myData.max || null,
                    change: function(event, ui) {
                        var self = $(this);
                        var myVal = self.spinner('value');
                        var myMin = self.spinner('option', 'min');
                        var myMax = self.spinner('option', 'max');
                        if (myVal === null || myVal < myMin) {
                            myVal = myMin;
                        }
                        if (myVal > myMax) {
                            myVal = myMax;
                        }
                        myVal = parseInt(myVal, 10);
                        self.spinner('value', myVal);
                    }
                });
            });
        }
    }

    function ntrUITooltip() {
        var myTooltips = $('[data-ntr-ui-tooltip]');
        if (myTooltips.length) {
            myTooltips.each(function(i, el) {
                var myTooltip = $(el);
                var myData = myTooltip.data('ntrUiTooltip');
                if (!myData) {
                    return true; // next iteration
                }
                var myPosition = {};
                var myClasses = {
                    'ui-tooltip': 'ui-corner-all ui-widget-shadow'
                };
                if (myData.position === 'top') {
                    myPosition.my = 'center bottom-25';
                    myPosition.at = 'center top';
                    myClasses = {
                        'ui-tooltip': 'ui-corner-all ui-widget-shadow is-top'
                    };
                }
                if (myData.position === 'left') {
                    myPosition.my = 'right-25 center';
                    myPosition.at = 'left center';
                    myClasses = {
                        'ui-tooltip': 'ui-corner-all ui-widget-shadow is-left'
                    };
                }
                if (myData.position === 'right') {
                    myPosition.my = 'left+25 center';
                    myPosition.at = 'right center';
                    myClasses = {
                        'ui-tooltip': 'ui-corner-all ui-widget-shadow is-right'
                    };
                }
                if (myData.position === 'bottom') {
                    myPosition.my = 'center top+25';
                    myPosition.at = 'center bottom';
                    myClasses = {
                        'ui-tooltip': 'ui-corner-all ui-widget-shadow is-bottom'
                    };
                }
                myTooltip.tooltip({
                    classes: myClasses,
                    position: myPosition,
                    items: myTooltip,
                    content: function() {
                        return myData.content;
                    }
                });
            });
        }
    }

    function ntrLightbox() {
        var myLightboxes = $('[data-ntr-lightbox]');
        if (myLightboxes.length) {
            myLightboxes.each(function(i, el) {
                var myLightbox = $(el);
                var myData = myLightbox.data('ntrLightbox');
                var myOptions = {};
                if (!myData || !myData.type) {
                    return true; // next iteration
                }
                if (myData.type === 'gallery') {
                    if (!myData.selector) {
                        return true; // next iteration
                    }
                    myOptions = {
                        delegate: myData.selector,
                        type: 'image',
                        gallery: {
                            enabled: true
                        }
                    };

                }
                if (myData.type === 'image') {
                    myOptions = {
                        type: 'image'
                    };
                }
                if (myData.type === 'iframe') {
                    myOptions = {
                        type: 'iframe'
                    };
                }
                if (myData.type === 'inline') {
                    myOptions = {
                        type: 'inline',
                    };
                }
                if (myData.type === 'modal') {
                    myOptions = {
                        type: 'inline',
                        modal: false
                    };
                }
                if (myData.type === 'ajax') {
                    myOptions = {
                        type: 'ajax',
                        overflowY: 'scroll'
                    };
                }
                myLightbox.magnificPopup(myOptions);
            });
        }
    }

    function ntrRatingSelect() {
        var myRatings = $('[data-ntr-rating-select]');
        if (myRatings.length) {
            myRatings.each(function(i, el) {
                var myRating = $(el);
                var myRatingItems = $('.rating-select_item', myRating);
                var myRatingResult = $('select', myRating);
                myRatingItems.on('mouseenter', function(e) {
                    var self = $(this);
                    var selfIndex = self.index();
                    var selfAndPrevs = myRatingItems.slice(0, (selfIndex + 1));
                    selfAndPrevs.not('.is-selected').removeClass('is-star-outline').addClass('is-star');
                });
                myRatingItems.on('mouseleave', function(e) {
                    myRatingItems.not('.is-selected').removeClass('is-star').addClass('is-star-outline');
                });
                myRatingItems.on('click', function(e) {
                    e.preventDefault();
                    var self = $(this);
                    var selfId = self.data('id');
                    var selfIndex = self.index();
                    var selfAndPrevs = myRatingItems.slice(0, (selfIndex + 1));
                    // Reset Items
                    myRatingItems.removeClass('is-star is-selected').addClass('is-star-outline');
                    // Select Self and Prevs
                    selfAndPrevs.removeClass('is-star-outline').addClass('is-star is-selected');
                    // Set Value
                    myRatingResult.val(selfId).trigger('change');
                });
            });
        }
    }

    function ntrHeader() {
        var myHeader = $('[data-ntr-header]');
        if (myHeader.length) {
            var myHeaderSearch = $('.header_search', myHeader);
            var myHeaderSearchForm = $('.header_search_form', myHeader);
            var myHeaderSearchInput = $('.header_search_input', myHeader);
            var myHeaderSearchOpen = $('.header_search_open', myHeader);
            var myHeaderSearchClose = $('.header_search_close', myHeader);
            var myHeaderLang = $('.header_lang', myHeader);
            var myHeaderLangLabel = $('.header_lang_label', myHeader);
            var myHeaderNav = $('.header_nav');
            var myHeaderNavArrows = $('.header_nav_arrow', myHeaderNav);
            var myHeaderNavToggle = $('.header_nav_toggle', myHeader);
            var myHeaderNavClose = $('.header_nav_close', myHeader);
            var myHeaderCart = $('.header_cart', myHeader);
            var myHeaderCartLabel = $('.header_cart_label', myHeader);
            var myHeaderHandlers = {
                searchOpen: function() {
                    myHeaderSearch.addClass('is-active');
                    myHeaderSearchInput.focus();
                    $(document).on('click.ntrHeaderSearch', function(e) {
                        if (!$(e.target).closest(myHeaderSearchOpen).length) {
                            if (!$(e.target).closest(myHeaderSearch).length) {
                                myHeaderHandlers.searchClose();
                            }
                        }
                    });
                    $(document).on('keyup.ntrHeaderSearch', function(e) {
                        if (e.keyCode === 27) {
                            myHeaderHandlers.searchClose();
                        }
                    });
                },
                searchClose: function() {
                    myHeaderSearch.removeClass('is-active');
                    myHeaderSearchForm[0].reset();
                    $(document).off('click.ntrHeaderSearch');
                    $(document).off('keyup.ntrHeaderSearch');
                },
                langOpen: function() {
                    myHeaderLang.addClass('is-active');
                    $(document).on('click.ntrHeaderLang', function(e) {
                        if (!$(e.target).closest(myHeaderLang).length) {
                            myHeaderHandlers.langClose();
                        }
                    });
                    $(document).on('keyup.ntrHeaderLang', function(e) {
                        if (e.keyCode === 27) {
                            myHeaderHandlers.langClose();
                        }
                    });
                },
                langClose: function() {
                    myHeaderLang.removeClass('is-active');
                    $(document).off('click.ntrHeaderLang');
                    $(document).off('keyup.ntrHeaderLang');
                },
                navOpen: function() {
                    myHeaderNav.addClass('is-active');
                    $(document).on('click.ntrHeaderNav', function(e) {
                        if (!$(e.target).closest(myHeaderNavToggle).length) {
                            if (!$(e.target).closest(myHeaderNav).length) {
                                myHeaderHandlers.navClose();
                            }
                        }
                    });
                    $(document).on('keyup.ntrHeaderNav', function(e) {
                        if (e.keyCode === 27) {
                            myHeaderHandlers.navClose();
                        }
                    });
                },
                navClose: function() {
                    myHeaderNav.removeClass('is-active');
                    $(document).off('click.ntrHeaderNav');
                    $(document).off('keyup.ntrHeaderNav');
                },
                cartOpen: function() {
                    myHeaderCart.addClass('is-active');
                    $(document).on('click.ntrHeaderCart', function(e) {
                        if (!$(e.target).closest(myHeaderCart).length) {
                            myHeaderHandlers.cartClose();
                        }
                    });
                    $(document).on('keyup.ntrHeaderCart', function(e) {
                        if (e.keyCode === 27) {
                            myHeaderHandlers.cartClose();
                        }
                    });
                },
                cartClose: function() {
                    myHeaderCart.removeClass('is-active');
                    $(document).off('click.ntrHeaderCart');
                    $(document).off('keyup.ntrHeaderCart');
                },
            };

            // Handlers
            myHeaderSearchOpen.on('click', function(e) {
                e.preventDefault();
                if (myHeaderSearch.hasClass('is-active')) {
                    myHeaderHandlers.searchClose();
                } else {
                    myHeaderHandlers.searchOpen();
                }
            });
            myHeaderSearchClose.on('click', function(e) {
                e.preventDefault();
                myHeaderHandlers.searchClose();
            });

            // Conditional Handlers
            var myMedia = window.matchMedia('(max-width: 1199px)');
            var myMediaHandler = function(m) {
                if (m.matches) {
                    myHeaderLangLabel.on('click.ntrHeaderLangLabel', function(e) {
                        //e.preventDefault();
                        if (myHeaderLang.hasClass('is-active')) {
                            myHeaderHandlers.langClose();
                        } else {
                            myHeaderHandlers.langOpen();
                        }
                    });
                    myHeaderNavToggle.on('click.ntrHeaderNavToggle', function(e) {
                        e.preventDefault();
                        if (myHeaderNav.hasClass('is-active')) {
                            myHeaderHandlers.navClose();
                        } else {
                            myHeaderHandlers.navOpen();
                        }
                    });
                    myHeaderNavClose.on('click.ntrHeaderNavClose', function(e) {
                        e.preventDefault();
                        myHeaderHandlers.navClose();
                    });
                    myHeaderNavArrows.on('click.ntrHeaderNavArrows', function(e) {
                        e.preventDefault();
                        var myArrow = $(this);
                        var myParent = myArrow.parent('li');
                        if (myParent.hasClass('is-active')) {
                            myParent.removeClass('is-active');
                            $('.icon', myArrow).toggleClass('is-arrow-up2 is-arrow-down2');
                        } else {
                            myParent.addClass('is-active');
                            $('.icon', myArrow).toggleClass('is-arrow-down2 is-arrow-up2');
                        }
                    });
                    myHeaderCartLabel.on('click.ntrHeaderCartLabel', function(e) {
                        //e.preventDefault();
                        if (myHeaderCart.hasClass('is-active')) {
                            myHeaderHandlers.cartClose();
                        } else {
                            myHeaderHandlers.cartOpen();
                        }
                    });
                } else {
                    // Remove Lang Events
                    $(document).off('click.ntrHeaderLang');
                    $(document).off('keyup.ntrHeaderLang');
                    myHeaderLangLabel.off('click.ntrHeaderLangLabel');

                    // Remove Nav Events
                    $(document).off('click.ntrHeaderNav');
                    $(document).off('keyup.ntrHeaderNav');
                    myHeaderNavToggle.off('click.ntrHeaderNavToggle');
                    myHeaderNavClose.off('click.ntrHeaderNavClose');
                    myHeaderNavArrows.off('click.ntrHeaderNavArrows');

                    // Remove Cart Events
                    $(document).off('click.ntrHeaderCart');
                    $(document).off('keyup.ntrHeaderCart');
                    myHeaderCartLabel.off('click.ntrHeaderCartLabel');
                }
            };
            myMedia.addListener(myMediaHandler);
            myMediaHandler(myMedia);

            // Sticky
            if (myHeader.hasClass('is-sticky')) {
                var myWindow = $(window);
                var myHeaderHolder = $('.header_holder', myHeader);
                var myHeaderContainer = $('.header_container', myHeader);
                var myHeaderHeight = myHeaderContainer.outerHeight();
                var myHeaderTimer;
                if (!myHeader.hasClass('is-overlay')) {
                    myHeaderHolder.css({
                        'height': myHeaderHeight
                    });
                }
                myWindow.on('scroll', function() {
                    if (myHeaderTimer) {
                        clearTimeout(myHeaderTimer);
                    }
                    myHeaderTimer = setTimeout(function() {
                        if (myWindow.scrollTop() > myHeaderHeight) {
                            myHeader.addClass('is-sticky-active');
                        } else if (myWindow.scrollTop() < 1) {
                            myHeader.removeClass('is-sticky-active');
                        }
                    }, 200);
                });
            }
        }
    }

    function ntrNav() {
        var myContainer = $('[data-ntr-nav]');
        if (myContainer.length) {
            var myToggleButton = $('.nav_toggle_button', myContainer);
            myToggleButton.on('click', function(e) {
                e.preventDefault();
                var myButton = $(this);
                var myButtonToggle = myButton.parent('.nav_toggle');
                myButtonToggle.toggleClass('is-active');
            });
        }
    }

    function ntrNav2() {
        var myContainer = $('[data-ntr-nav2]');
        if (myContainer.length) {
            var myToggles = $('.nav2_toggle', myContainer);
            var myTogglesButtons = $('.nav2_toggle_button', myContainer);
            myTogglesButtons.on('click', function(e) {
                e.preventDefault();
                var myButton = $(this);
                var myButtonToggle = myButton.parent('.nav2_toggle');
                myToggles.not(myButtonToggle).removeClass('is-active');
                myButtonToggle.toggleClass('is-active');
            });
        }
    }

    function ntrSliderProducts() {
        var myContainer = $('[data-ntr-slider-products]');
        if (myContainer.length) {
            var mySlick = $('.slick-slider', myContainer);
            mySlick.slick({
                arrows: false,
                autoplay: true,
                dots: true,
                speed: 300,
                slidesToShow: 4,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [{
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 2,
                        }
                    },
                    {
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 3,
                        }
                    }
                ]
            });
        }
    }

    function ntrShopSidebar() {
        var myContainer = $('[data-ntr-shop-sidebar]');
        if (myContainer.length) {
            var myFilterSlider = $('.shop-sidebar_filter_slider', myContainer);
            if (myFilterSlider.length) {
                var myFilterSliderForm = $('.shop-sidebar_filter_form', myContainer);
                var myFilterSliderLabel = $('.shop-sidebar_filter_label', myContainer);
                myFilterSlider.on('slide', function(event, ui) {
                    $('input[name="min_price"]', myFilterSliderForm).val(ui.values[0]);
                    $('input[name="max_price"]', myFilterSliderForm).val(ui.values[1]);
                    $('span', myFilterSliderLabel).html('$' + ui.values[0] + ' - $' + ui.values[1]);
                });
            }
        }
    }

    function ntrBlogSingle() {
        var myContainer = $('[data-ntr-blog-single]');
        if (myContainer.length) {
            var myMediaGallery = $('.blog-single_media_gallery', myContainer);
            if (myMediaGallery.length) {
                var myMediaGallerySlick = $('.slick-slider', myMediaGallery);
                myMediaGallerySlick.slick({
                    fade: true,
                    cssEase: 'linear',
                    speed: 300,
                    prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                    nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                });
            }
        }
    }

    function ntrElementsSidebar() {
        var mySidebar = $('[data-ntr-elements-sidebar]');
        if (mySidebar.length) {
            var myBacktop = $('.back-top');
            var myButton = $('.elements-sidebar_button', mySidebar);
            var myIcon = $('.icon', myButton);
            myButton.on('click', function(e) {
                e.preventDefault();
                myButton.toggleClass('is-active');
                myIcon.toggleClass('is-menu is-close');
                mySidebar.toggleClass('is-active');
                if (mySidebar.hasClass('is-active')) {
                    myBacktop.css({
                        right: '250px'
                    });
                } else {
                    myBacktop.removeAttr('style');
                }
            });
        }
    }

    function ntrShopHeader() {
        var myContainer = $('[data-ntr-shop-header]');
        if (myContainer.length) {
            var myProducts = $('.shop-products');
            var myLayoutItems = $('.shop-header_layout_item', myContainer);
            var myActiveLayout = 'is-grid-3';
            var myActiveLayoutItem = myLayoutItems.filter('.is-active').first();
            if (myActiveLayoutItem.length) {
                myActiveLayout = 'is-' + myActiveLayoutItem.data('layout');
            }
            myProducts.addClass(myActiveLayout);
            myLayoutItems.on('click', function(e) {
                e.preventDefault();
                var myLayoutItem = $(this);
                if (!myLayoutItem.hasClass('is-active')) {
                    myLayoutItems.removeClass('is-active');
                    myLayoutItem.addClass('is-active');
                    myProducts.removeClass('is-grid-3 is-grid-4 is-list').addClass('is-' + myLayoutItem.data('layout'));
                    Waypoint.refreshAll();
                }
            });
        }
    }

    function ntrSliderRelated() {
        var myContainer = $('[data-ntr-slider-related]');
        if (myContainer.length) {
            var mySlick = $('.slick-slider', myContainer);
            mySlick.slick({
                arrows: false,
                dots: true,
                speed: 300,
                slidesToShow: 3,
                slidesToScroll: 1,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [{
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 2,
                        }
                    }
                ]
            });
        }
    }

    function ntrSliderPostGallery() {
        var myContainer = $('[data-ntr-slider-postgallery]');
        if (myContainer.length) {
            var mySlick = $('.slick-slider', myContainer);
            mySlick.slick({
                arrows: true,
                dots: true,
                fade: true,
                cssEase: 'linear',
                //speed: 300,
                slidesToShow: 1,
                slidesToScroll: 1,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
            });
        }
    }

    // ntrHeaderMiniCart
    function ntrTemplateHeaderMiniCart() {
        $('body:not(.elementor-page) .naturally_mini_cart').each(function () {
            var myHeader = $(this);
            if (myHeader.length) {
                var myHeaderCart = $('.header_cart', myHeader);
                var myHeaderCartLabel = $('.header_cart_label', myHeader);
                var myHeaderHandlers = {
                    cartOpen: function () {
                        myHeaderCart.addClass('is-active');
                        $(document).on('click.ntrHeaderCart', function (e) {
                            if (!$(e.target).closest(myHeaderCart).length) {
                                myHeaderHandlers.cartClose();
                            }
                        });
                        $(document).on('keyup.ntrHeaderCart', function (e) {
                            if (e.keyCode === 27) {
                                myHeaderHandlers.cartClose();
                            }
                        });
                    },
                    cartClose: function () {
                        myHeaderCart.removeClass('is-active');
                        $(document).off('click.ntrHeaderCart');
                        $(document).off('keyup.ntrHeaderCart');
                    },
                };
                // Conditional Handlers
                var myMedia = window.matchMedia('(max-width: 1199px)');
                var myMediaHandler = function (m) {
                    if (m.matches) {
                        myHeaderCartLabel.on('click.ntrHeaderCartLabel', function (e) {
                            //e.preventDefault();
                            if (myHeaderCart.hasClass('is-active')) {
                                myHeaderHandlers.cartClose();
                            } else {
                                myHeaderHandlers.cartOpen();
                            }
                        });
                    } else {
                        // Remove Cart Events
                        $(document).off('click.ntrHeaderCart');
                        $(document).off('keyup.ntrHeaderCart');
                        myHeaderCartLabel.off('click.ntrHeaderCartLabel');
                    }
                };
                myMedia.addListener(myMediaHandler);
                myMediaHandler(myMedia);
            }
        });
    }
    // ntrHeaderSearchForm
    function ntrTemplateHeaderSearchForm() {
        $('body:not(.elementor-page) .naturally_header_search').each(function () {
            var myHeader = $(this);
            if (myHeader.length) {
                var myHeaderSearch = $('.naturally_header_search_form', myHeader);
                var myHeaderSearchForm = $('.header_search_form', myHeader);
                var myHeaderSearchInput = $('.header_search_input', myHeader);
                var myHeaderSearchOpen = $('.header_search_open', myHeader);
                var myHeaderSearchClose = $('.header_search_close', myHeader);
                $('.naturally_header_search_form.header_search').prependTo('body');
                var myHeaderHandlers = {
                    searchOpen: function () {
                        myHeaderSearch.addClass('is-active');
                        myHeaderSearchInput.focus();
                        $(document).on('click.ntrHeaderSearch', function (e) {
                            if (!$(e.target).closest(myHeaderSearchOpen).length) {
                                if (!$(e.target).closest(myHeaderSearch).length) {
                                    myHeaderHandlers.searchClose();
                                }
                            }
                        });
                        $(document).on('keyup.ntrHeaderSearch', function (e) {
                            if (e.keyCode === 27) {
                                myHeaderHandlers.searchClose();
                            }
                        });
                    },
                    searchClose: function () {
                        myHeaderSearch.removeClass('is-active');
                        myHeaderSearchForm[0].reset();
                        $(document).off('click.ntrHeaderSearch');
                        $(document).off('keyup.ntrHeaderSearch');
                    },
                };

                // Handlers
                myHeaderSearchOpen.on('click', function (e) {
                    e.preventDefault();
                    if (myHeaderSearch.hasClass('is-active')) {
                        myHeaderHandlers.searchClose();
                    } else {
                        myHeaderHandlers.searchOpen();
                    }
                });
                myHeaderSearchClose.on('click', function (e) {
                    e.preventDefault();
                    myHeaderHandlers.searchClose();
                });
            }
        });
    }
    // ntrHeaderLangs
    function ntrTemplateHeaderLangs() {
        $('body:not(.elementor-page) .naturally_langs_wrapper').each(function () {
            var myHeader = $(this);
            if (myHeader.length) {
                var myHeaderLang = $('.header_lang', myHeader);
                var myHeaderLangLabel = $('.header_lang_label', myHeader);
                var myHeaderHandlers = {
                    langOpen: function () {
                        myHeaderLang.addClass('is-active');
                        $(document).on('click.ntrHeaderLang', function (e) {
                            if (!$(e.target).closest(myHeaderLang).length) {
                                myHeaderHandlers.langClose();
                            }
                        });
                        $(document).on('keyup.ntrHeaderLang', function (e) {
                            if (e.keyCode === 27) {
                                myHeaderHandlers.langClose();
                            }
                        });
                    },
                    langClose: function () {
                        myHeaderLang.removeClass('is-active');
                        $(document).off('click.ntrHeaderLang');
                        $(document).off('keyup.ntrHeaderLang');
                    },
                };

                // Conditional Handlers
                var myMedia = window.matchMedia('(max-width: 1199px)');
                var myMediaHandler = function (m) {
                    if (m.matches) {
                        myHeaderLangLabel.on('click.ntrHeaderLangLabel', function (e) {
                            //e.preventDefault();
                            if (myHeaderLang.hasClass('is-active')) {
                                myHeaderHandlers.langClose();
                            } else {
                                myHeaderHandlers.langOpen();
                            }
                        });

                    } else {
                        // Remove Lang Events
                        $(document).off('click.ntrHeaderLang');
                        $(document).off('keyup.ntrHeaderLang');
                        myHeaderLangLabel.off('click.ntrHeaderLangLabel');
                    }
                };
            }
        });
    }
    // ntrIsotope
    function ntrTemplateIsotope() {
        $('body:not(.elementor-page) [data-ntr-isotope]').each(function () {
            var myIsotopes = $(this);
            if (myIsotopes.length) {
                myIsotopes.each(function (i, el) {
                    var myIsotope = $(el);
                    var myData = myIsotope.data('ntrIsotope');
                    if (!myData.itemSelector) {
                        return true; // next iteration
                    }
                    myIsotope.imagesLoaded(function() {
                        // Isotope Options
                        var myIsotopeOptions = {
                            percentPosition: true,
                            layoutMode: myData.layoutMode || 'masonry',
                            itemSelector: myData.itemSelector,
                            masonry: {
                                columnWidth: '.grid_sizer'
                            }
                        };
                        // Isotope Init
                        myIsotope.isotope(myIsotopeOptions);
                        // Isotope Filter
                        if ($('[data-ntr-isotope-filter]').length) {
                            var myFilters = $('[data-ntr-isotope-filter]').filter(function (i, el) {
                                var myFilter = $(el);
                                var myFilterData = myFilter.data('ntrIsotopeFilter');
                                return myFilterData.name === myData.name && myFilterData.selector;
                            });
                            if (myFilters.length) {
                                myFilters.on('click', function (e) {
                                    e.preventDefault();
                                    var myFilter = $(this);
                                    var myFilterData = myFilter.data('ntrIsotopeFilter');
                                    var myFilterSelector = myFilterData.selector;
                                    var myFilterParent = myFilter.parent();
                                    myFilterParent.siblings().removeClass('is-active');
                                    myFilterParent.addClass('is-active');
                                    myIsotope.isotope({filter: myFilterSelector});
                                });
                            }
                        }
                    });
                });
            }
        });
    }
    // ntrAlert
    function ntrTemplateAlert() {
        $('body:not(.elementor-page) [data-ntr-alert]').each(function () {
            var myAlerts = $(this);
            if (myAlerts.length) {
                myAlerts.each(function (i, el) {
                    var myAlert = $(el);
                    var myAlertClose = $('.alert_close', myAlert);
                    myAlertClose.on('click', function (e) {
                        e.preventDefault();
                        myAlert.hide();
                    });
                });
            }
        });
    }
    // ntrAccordion
    function ntrTemplateAccordion() {
        $('body:not(.elementor-page) .accordion').each(function () {
            var myAccordions = $(this);
            if (myAccordions.length) {
                myAccordions.each(function (i, el) {
                    var myAccordion = $(el);
                    var myMode = myAccordion.data('ntr-accordion') === 'multiple' ? 'multiple' : 'single';
                    var myItems = $('.accordion_item', myAccordion);
                    var myIcons = $('.accordion_item_icon', myAccordion);
                    // If Active
                    myItems.filter('.is-active').find('.accordion_item_icon').toggleClass('is-arrow-right2 is-arrow-down2');
                    // Click
                    $('.accordion_item_header', myAccordion).on('click', function (e) {
                        e.preventDefault();
                        var self = $(this);
                        var selfItem = self.parent('.accordion_item');
                        var selfIcon = $('.accordion_item_icon', self);
                        selfItem.toggleClass('is-active');
                        selfIcon.toggleClass('is-arrow-right2 is-arrow-down2');
                        if (myMode === 'single') {
                            myItems.not(selfItem).removeClass('is-active');
                            myIcons.not(selfIcon).removeClass('is-arrow-down2').addClass('is-arrow-right2');
                        }
                    });
                });
            }
        });
    }
    // ntrAccordion
    function ntrTemplateTabs() {
        $('body:not(.elementor-page) [data-ntr-tab]').each(function () {
            var myTabs = $('[data-ntr-tab]');
            if (myTabs.length) {
                myTabs.each(function (i, el) {
                    var myTab = $(el);
                    var myTabItems = $('> .tab_nav .tab_nav_item', myTab);
                    var myTabPages = $('> .tab_page', myTab);
                    var myActiveTab = myTabItems.first();
                    if (myTabItems.filter('.is-active').length) {
                        myActiveTab = myTabItems.filter('.is-active').first();
                    }
                    var myActiveTabId = myActiveTab.data('id');
                    myTabItems.filter('[data-id="'+ myActiveTabId +'"]').addClass('is-active');
                    myTabPages.filter('[data-id="'+ myActiveTabId +'"]').addClass('is-active');
                    myTabItems.on('click', function (e) {
                        e.preventDefault();
                        var self = $(this);
                        var selfId = self.data('id');
                        myTabItems.removeClass('is-active');
                        myTabPages.removeClass('is-active');
                        self.addClass('is-active');
                        myTabPages.filter('[data-id="'+ selfId +'"]').addClass('is-active');
                    });
                });
            }
        });
    }
    // ntrCounter
    function ntrTemplateCounter() {
        $('body:not(.elementor-page) [data-ntr-counter]').each(function () {
            var myCounters = $(this);
            if (myCounters.length) {
                myCounters.each(function (i, el) {
                    var myCounter = $(el);
                    var myData = myCounter.data('ntrCounter');
                    new Waypoint({
                        element: myCounter,
                        handler: function(direction) {
                            var self = this;
                            if (direction === 'down') {
                                $('.counter_number', myCounter).countTo({
                                    from: myData.from || 0,
                                    to: myData.to || 100,
                                    speed: myData.speed || 5000,
                                    refreshInterval: myData.refreshInterval || 100,
                                });
                                self.destroy();
                            }
                        },
                        offset: '95%'
                    });
                });
            }
        });
    }
    // ntrSliderCategories2
    function ntrTemplateSliderCategories2() {
        $('body:not(.elementor-page) [data-ntr-shop-categories2]').each(function () {
            var myContainer = $(this);
            if (myContainer.length) {
                var mySlick = $('.slick-slider', myContainer);
                mySlick.not('.slick-initialized').slick({
                    autoplay: true,
                    slidesToShow: 4,
                    speed: 300,
                    prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                    nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                    responsive: [
                        {
                            breakpoint: 576,
                            settings: {
                                slidesToShow: 1,
                            }
                        },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 2,
                            }
                        },
                        {
                            breakpoint: 992,
                            settings: {
                                slidesToShow: 3,
                            }
                        },
                        {
                            breakpoint: 1200,
                            settings: {
                                slidesToShow: 4,
                            }
                        }
                    ]
                });
            }
        });
    }
    // ntrSliderPhotos
    function ntrTemplateSliderPhotos() {
        $('body:not(.elementor-page) .slider-photos .slick-slider').each(function () {
            var ntrSliderPhotos = $( this );
            if(!ntrSliderPhotos.length) return;
            ntrSliderPhotos.not('.slick-initialized').slick({
                arrows: false,
                dots: true,
                infinite: false,
                speed: 300,
                slidesToShow: 3,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                        }
                    },
                ]
            });
        });
    }
    // ntrSliderLogos
    function ntrTemplateSliderLogos() {
        $('body:not(.elementor-page) .slider-logos .slick-slider').each(function () {
            var ntrSliderLogos = $( this );
            if(!ntrSliderLogos.length) return;
            ntrSliderLogos.not('.slick-initialized').slick({
                arrows: false,
                dots: true,
                autoplay: true,
                speed: 300,
                slidesToShow: 5,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 3,
                        }
                    },
                ]
            });
        });
    }
    // ntrSliderBlog
    function ntrTemplateSliderBlog() {
        $('body:not(.elementor-page) [data-ntr-slider-blog]').each(function () {
            var myContainer = $(this);
            if(!myContainer.length) return;
            var mySlick = $('.slick-slider', myContainer);
            mySlick.slick({
                arrows: false,
                dots: true,
                speed: 300,
                slidesToShow: 3,
                slidesToScroll: 1,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 2,
                        }
                    }
                ]
            });
        });
        $('body:not(.elementor-page) .slider-blog3 .slick-slider').each(function () {
            var ntrSliderBlog3 = $( this );
            if(!ntrSliderBlog3.length) return;
            ntrSliderBlog3.not('.slick-initialized').slick({
                arrows: false,
                dots: true,
                centerMode: true,
                adaptiveHeight: true,
                slidesToShow: 1,
                centerPadding: '25%',
                speed: 300,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 768,
                        settings: {
                            centerPadding: '30px',
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            centerPadding: '60px',
                        }
                    },
                    {
                        breakpoint: 1200,
                        settings: {
                            centerPadding: '120px',
                        }
                    }
                ]
            });
        });
    }
    // ntrSliderBlog2
    function ntrTemplateSliderBlog2() {
        $('body:not(.elementor-page) .slider-blog2 .slick-slider').each(function () {
            var ntrSliderBlog2 = $( this );
            if(!ntrSliderBlog2.length) return;
            ntrSliderBlog2.not('.slick-initialized').slick({
                arrows: false,
                dots: true,
                speed: 300,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
            });
        });
    }
    // ntrSliderTestimonials
    function ntrTemplateSliderTestimonials() {
        $('body:not(.elementor-page) .slider-testimonials .slick-slider').each(function () {
            var ntrSliderTestimonials = $( this );
            if(!ntrSliderTestimonials.length) return;
            ntrSliderTestimonials.not('.slick-initialized').slick({
                arrows: false,
                dots: true,
                speed: 300,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
            });
        });
    }
    // ntrSliderTestimonials2
    function ntrTemplateSliderTestimonials2() {
        $('body:not(.elementor-page) .slider-testimonials2 .slick-slider').each(function () {
            var ntrSliderTestimonials2 = $( this );
            if(!ntrSliderTestimonials2.length) return;
            ntrSliderTestimonials2.not('.slick-initialized').slick({
                speed: 300,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 768,
                        settings: {
                            arrows: false,
                            dots: true
                        }
                    },
                ]
            });
        });
    }
    // ntrSliderTestimonials3
    function ntrTemplateSliderTestimonials3() {
        $('body:not(.elementor-page) .slider-testimonials3 .slick-slider').each(function () {
            var ntrSliderTestimonials3 = $( this );
            if(!ntrSliderTestimonials3.length) return;
            ntrSliderTestimonials3.not('.slick-initialized').slick({
                arrows: false,
                dots: true,
                speed: 300,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
            });
        });
    }
    // ntrSliderDeals
    function ntrTemplateSliderDeals() {
        $('body:not(.elementor-page) .slider-deals .slick-slider').each(function () {
            var ntrSliderDeals = $( this );
            if(!ntrSliderDeals.length) return;
            ntrSliderDeals.not('.slick-initialized').slick({
                autoplay: true,
                slidesToShow: 1,
                speed: 300,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 3,
                        }
                    },
                ]
            });
        });
    }
    // categoriesSlider
    function ntrTemplateCategoriesSlider() {
        if( !$( 'body' ).hasClass('archive') ) {
            $('body:not(.elementor-page) .slider-categories .slick-slider').each(function () {
                var categoriesSlider = $( this );
                if(!categoriesSlider.length) return;
                categoriesSlider.not('.slick-initialized').slick({
                    autoplay: true,
                    slidesToShow: 5,
                    speed: 300,
                    prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                    nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                    responsive: [
                        {
                            breakpoint: 576,
                            settings: {
                                slidesToShow: 1,
                            }
                        },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 2,
                            }
                        },
                        {
                            breakpoint: 992,
                            settings: {
                                slidesToShow: 3,
                            }
                        },
                        {
                            breakpoint: 1200,
                            settings: {
                                slidesToShow: 4,
                            }
                        }
                    ]
                });
            });
        }
    }
    function ntrTemplateSliderHero() {
        $('body:not(.elementor-page) .slider-hero .slick-slider').each(function () {
            var ntrSliderHero = $( this );
            var ntrSliderData = ntrSliderHero.data('slider-options');
            var myHeight = ntrSliderData.height;
            if(!ntrSliderHero.length) return;
            ntrSliderHero.not('.slick-initialized').slick({
                dots: false,
                fade: true,
                adaptiveHeight: myHeight,
                cssEase: 'linear',
                speed: 300,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 1200,
                        settings: {
                            arrows: false,
                            dots: true
                        }
                    },
                ]
            });
        });
        $('body:not(.elementor-page) .slider-hero2 .slick-slider').each(function () {
            var ntrSliderHero2 = $( this );
            if(!ntrSliderHero2.length) return;
            var ntrSliderData = ntrSliderHero2.data('slider-options');
            var myHeight = ntrSliderData.height;
            ntrSliderHero2.not('.slick-initialized').slick({
                arrows: false,
                dots: true,
                fade: true,
                adaptiveHeight: myHeight,
                cssEase: 'linear',
                speed: 300,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
            });
        });
    }

    function ntrMegaMenu2(){

        //if you change this breakpoint in the style.css file (or _layout.scss if you use SASS), don't forget to update this value as well
        var $Scope = $('body');
        var MqL = 992;
        //move nav element position according to window width
        var myheader = $Scope.find('.nt-main-header');
        var mynav = $Scope.find('.nt-nav');
        var goback = $Scope.find('.nt-nav').data('goback');
        var megacontent = $Scope.find('.nt-secondary-nav');
        var mysearch = $Scope.find('.nt-search');

        myheader.parents('.elementor-column').addClass( 'header-parent-col' );

        if ( myheader.parents('.elementor-column').hasClass( 'elementor-col-100' ) ) {
             myheader.parents('.elementor-column').addClass( 'header-col-full' );
        } else {
            myheader.parents('.elementor-column').addClass( 'header-col-no-full' );
        }

        if ( $(window).width() < MqL ) {
            mynav.removeClass( 'nt-desktop' ).addClass( 'nt-mobile' );
            myheader.removeClass( 'nt-desktop' ).addClass( 'nt-mobile' );
            mysearch.removeClass( 'nt-desktop' ).addClass( 'nt-mobile' );
        } else {
            mynav.removeClass( 'nt-mobile' ).addClass( 'nt-desktop' );
            myheader.removeClass( 'nt-mobile' ).addClass( 'nt-desktop' );
            mysearch.removeClass( 'nt-mobile' ).addClass( 'nt-desktop' );
        }


        var left = $( ".header-parent-col" ).position().left;

        if ( $(window).width() >= MqL ) {
            if ( mynav.hasClass('align-flex-end') ) {
                megacontent.removeAttr( 'style' );
            } else {
                megacontent.css( 'left',-left );
            }
        }

        $Scope.parents('.elementor-top-section').css('z-index','1000');

        $Scope.find('.nt-primary-nav > li.has-children').each(function(){
            var submenu = $(this);
            var submenusize = submenu.find('> .nt-secondary-nav.content-type-menu > li.depth_0').size();
            var megamenuu = submenu.find('> .nt-secondary-nav.content-type-menu');
            if ( submenusize > 1 ) {
                megamenuu.parent('.has-children').addClass( 'nt-has-more-col' );
            } else {
                megamenuu.parent('.has-children').addClass( 'nt-has-one-col' );
            }
        });


        $( '<a href="#0"><i aria-hidden="true" class="fas fa-angle-left go-back-left"></i>'+goback+'</a>' ).replaceAll( '.go-back-link' );

        moveNavigation();

        $(window).on('resize', function(){

            (!window.requestAnimationFrame) ? setTimeout(moveNavigation, 300) : window.requestAnimationFrame(moveNavigation);
            if ( $(window).width() < MqL ) {
                mynav.removeClass( 'nt-desktop' ).addClass( 'nt-mobile' );
                myheader.removeClass( 'nt-desktop' ).addClass( 'nt-mobile' );
                mysearch.removeClass( 'nt-desktop' ).addClass( 'nt-mobile' );
            } else {
                mynav.removeClass( 'nt-mobile' ).addClass( 'nt-desktop' );
                myheader.removeClass( 'nt-mobile' ).addClass( 'nt-desktop' );
                mysearch.removeClass( 'nt-mobile' ).addClass( 'nt-desktop' );
            }

            var leftres = $( ".header-parent-col" ).position().left;

            if ( mynav.hasClass('align-flex-end') ) {
                megacontent.removeAttr( 'style' );
            } else {
                if ( mynav.hasClass('nt-desktop') ) {
                    megacontent.css( 'left',-leftres );
                } else {
                    megacontent.removeAttr( 'style' );
                }
            }
        });

        //mobile - open lateral menu clicking on the menu icon
        $Scope.find('.nt-nav-trigger').on('click', function(event){
            event.preventDefault();
            if( $Scope.find('.nt-main-content').hasClass('nav-is-visible') ) {
                closeNav();
                $Scope.find('.nt-overlay').removeClass('is-visible');
            } else {
                $(this).addClass('nav-is-visible');
                $Scope.find('.nt-primary-nav').addClass('nav-is-visible');
                $Scope.find('.nt-main-header').addClass('nav-is-visible');
                $Scope.find('.nt-main-content').addClass('nav-is-visible').one('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function(){
                    $('body').addClass('overflow-hidden');
                });
                toggleSearch('close');
                $Scope.find('.nt-overlay').addClass('is-visible');
            }
        });

        //open search form
        $Scope.find('.nt-search-trigger').on('click', function(event){
            event.preventDefault();
            toggleSearch();
            closeNav();
        });

        //close lateral menu on mobile
        $Scope.find('.nt-overlay').on('swiperight', function(){
            if($Scope.find('.nt-primary-nav').hasClass('nav-is-visible')) {
                closeNav();
                //$Scope.find('.nt-overlay').removeClass('is-visible');
            }
        });
        $Scope.find('.nav-on-left .nt-overlay').on('swipeleft', function(){
            if($Scope.find('.nt-primary-nav').hasClass('nav-is-visible')) {
                closeNav();
                //$('.nt-overlay').removeClass('is-visible');
            }
        });
        $Scope.find('.nt-overlay').on('click', function(){
            closeNav();
            toggleSearch('close')
            //$('.nt-overlay').removeClass('is-visible');
        });

        //prevent default clicking on direct children of .nt-primary-nav
        $Scope.find('.nt-primary-nav').children('.has-children').children('a').on('click', function(event){
            event.preventDefault();
        });
        //open submenu
        $Scope.find('.has-children').children('a').on('click', function(event){

            if( !checkWindowWidth() ) event.preventDefault();
            var selected = $(this);

            if( selected.next('ul').hasClass('is-hidden') ) {
                //desktop version only

                selected.addClass('selected').next('ul').removeClass('is-hidden').end().parent('.has-children').parent('ul').addClass('moves-out');
                selected.parent('.has-children').siblings('.has-children').children('ul').addClass('is-hidden').end().children('a').removeClass('selected');
                $Scope.find('.nt-overlay').addClass('is-visible');

            } else {

                selected.removeClass('selected').next('ul').addClass('is-hidden').end().parent('.has-children').parent('ul').removeClass('moves-out');
                $Scope.find('.nt-overlay').removeClass('is-visible');
            }
            toggleSearch('close');
        });

        //submenu items - go back link
        $Scope.find('.go-back').on('click', function(){
            $(this).parent('ul').addClass('is-hidden').parent('.has-children').parent('ul').removeClass('moves-out');
        });

        function closeNav() {
            $Scope.find('.nt-nav-trigger').removeClass('nav-is-visible');
            $Scope.find('.nt-main-header').removeClass('nav-is-visible');
            $Scope.find('.nt-primary-nav').removeClass('nav-is-visible');
            $Scope.find('.has-children ul').addClass('is-hidden');
            $Scope.find('.has-children a').removeClass('selected');
            $Scope.find('.moves-out').removeClass('moves-out');
            $Scope.find('.nt-main-content').removeClass('nav-is-visible').one('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function(){
                $('body').removeClass('overflow-hidden');
            });
        }

        function toggleSearch(type) {
            if(type=="close") {
                //close serach
                $Scope.find('.nt-search').removeClass('is-visible');
                $Scope.find('.nt-search-trigger').removeClass('search-is-visible');
                $Scope.find('.nt-overlay').removeClass('search-is-visible');
            } else {
                //toggle search visibility
                $Scope.find('.nt-search').toggleClass('is-visible');
                $Scope.find('.nt-search-trigger').toggleClass('search-is-visible');
                $Scope.find('.nt-overlay').toggleClass('search-is-visible');
                if($(window).width() > MqL && $Scope.find('.nt-search').hasClass('is-visible')) $Scope.find('.nt-search').find('input[type="search"]').focus();
                ($Scope.find('.nt-search').hasClass('is-visible')) ? $Scope.find('.nt-overlay').addClass('is-visible') : $Scope.find('.nt-overlay').removeClass('is-visible') ;
            }
        }

        function checkWindowWidth() {
            //check window width (scrollbar included)
            var e = window,
            a = 'inner';
            if (!('innerWidth' in window )) {
                a = 'client';
                e = document.documentElement || document.body;
            }
            if ( e[ a+'Width' ] >= MqL ) {
                return true;
            } else {
                return false;
            }
        }

        function moveNavigation(){

            var navigation = $Scope.find('.nt-nav');
            var desktop = checkWindowWidth();
            if ( desktop ) {
                navigation.detach();
                navigation.insertBefore('.nt-header-buttons');
            } else {
                navigation.detach();
                navigation.insertAfter('.nt-main-content');
            }
        }
    }

    jQuery(window).on('load', function() {
        setTimeout(function() {
            jQuery('.loading').removeClass('is-active');
            AOS.init();
        }, 300);
    });

    $(document).ready(function() {
        ntrBacktop();
        ntrBackground();
        ntrMap();
        ntrUISlider();
        ntrUISpinner();
        ntrUITooltip();
        ntrLightbox();
        ntrRatingSelect();
        ntrHeader();
        ntrNav();
        ntrNav2();
        ntrSliderProducts();
        ntrShopSidebar();
        ntrBlogSingle();
        ntrElementsSidebar();
        ntrShopHeader();
        ntrSliderRelated();
        ntrTemplateHeaderMiniCart();
        ntrTemplateHeaderSearchForm();
        ntrTemplateHeaderLangs();
        ntrTemplateIsotope();
        ntrTemplateAlert();
        ntrTemplateAccordion();
        ntrTemplateTabs();
        ntrTemplateCounter();
        ntrTemplateSliderCategories2();
        ntrTemplateSliderPhotos();
        ntrTemplateSliderLogos();
        ntrTemplateSliderBlog();
        ntrTemplateSliderBlog2();
        ntrTemplateSliderTestimonials();
        ntrTemplateSliderTestimonials2();
        ntrTemplateSliderTestimonials3();
        ntrTemplateSliderDeals();
        ntrTemplateCategoriesSlider();
        ntrTemplateSliderHero();
        if( $('body:not(.elementor-page) [data-widget_type="naturally-mega-menu.default"]').size() ) {
            ntrMegaMenu2();
        }

        $('.bottom-mobile-nav .search-open').on('click', function(){
            if ( $(this).hasClass('active') ) {
                $(this).removeClass('active');
                $('.header_search').removeClass('is-active');
            } else {
                $(this).addClass('active');
                $('.header_search').addClass('is-active');
            }
        });
        $('.header_search_close').on('click', function(){
            $('.bottom-mobile-nav .search-open').removeClass('active');
        });

        jQuery(window).on("scroll", function () {
            var bodyScroll = jQuery(window).scrollTop();

            if ( bodyScroll > 0 ) {
                jQuery('body').addClass("scroll-start");
            } else {
                jQuery('body').removeClass("scroll-start");
            }
        });
    });
})(window, document, jQuery);
