<?php
/**
* The template for displaying search results pages
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
*
* @package WordPress
* @subpackage Naturally
* @since 1.0.0
*/

get_header();

// Elementor `archive` location
if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'archive' ) ) {
    // you can use this action for add any content before container element
    do_action( 'naturally_before_search' );

    $search_layout = naturally_settings( 'search_layout', 'full-width' );
    $search_sidebar = naturally_sidebar( 'naturally-search-sidebar' );
    $search_column = $search_sidebar ? ' is-xl-8' : ' is-xl-10';

    ?>
    <!-- search page general div -->
    <div id="nt-search" class="nt-search">

        <?php naturally_hero_section(); ?>

        <div class="nt-theme-inner-container section">
            <div class="container">
                <div class="grid">
                    <div class="grid_row justify-center">

                        <!-- Left sidebar -->
                        <?php if ( $search_sidebar && 'left-sidebar' == $search_layout ) { ?>
                            <div id="nt-sidebar" class="nt-sidebar grid_col is-12 is-xl-4" data-aos="ntr-fade-up" data-aos-once="true">
                                <div class="blog-sidebar nt-sidebar-inner">
                                    <?php dynamic_sidebar( $search_sidebar ); ?>
                                </div>
                            </div>
                        <?php } ?>

                        <!-- Content Column-->
                        <div class="grid_col is-12 is-xl-8" data-aos="ntr-fade-up" data-aos-once="true">

                            <?php if ( have_posts() ) { ?>

                                <div class="grid">
                                    <div class="grid_row is-60">
                                        <?php
                                        while ( have_posts() ) : the_post();

                                        naturally_post_style_two();

                                        endwhile;

                                        // this function working with wp reading settins + posts
                                        naturally_index_loop_pagination();
                                        ?>
                                    </div>
                                </div>

                            <?php } else {
                                // if there are no posts, read content none function
                                naturally_content_none();
                            }
                            ?>

                        </div>
                        <!-- End content -->

                        <!-- Right sidebar -->
                        <?php if ( $search_sidebar && 'right-sidebar' == $search_layout ) { ?>
                            <div id="nt-sidebar" class="nt-sidebar grid_col is-12 is-xl-4" data-aos="ntr-fade-up" data-aos-once="true">
                                <div class="blog-sidebar nt-sidebar-inner">
                                    <?php dynamic_sidebar( $search_sidebar ); ?>
                                </div>
                            </div>
                        <?php } ?>

                    </div><!-- End row -->
                </div><!-- End row -->
            </div><!-- End container -->
        </div><!-- End #blog-post -->
    </div>
    <!--End search page general div -->
    <?php
    // you can use this action to add any content after search page
    do_action( 'naturally_after_search' );

}

get_footer();
?>
