<?php

/**
* The template for displaying all single posts
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
*
* @package WordPress
* @subpackage Naturally
* @since 1.0.0
*/

get_header();

// Elementor `single` location
if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'single' ) ) {

// you can use this action to add any content before single page
do_action( 'naturally_before_post_single' );
$naturally_layout = naturally_settings( 'single_layout', 'right-sidebar' );
$naturally_sidebar = naturally_sidebar('naturally-single-sidebar', 'sidebar-1');
$naturally_column = naturally_sidebar('naturally-single-sidebar', 'sidebar-1') ? ' is-xl-8' : '';
?>
    <!-- Single page general div -->
    <div id="nt-single" class="nt-single">

        <div class="section" data-ntr-blog-single>
            <div class="container">

                <?php
                /**
                * Hook: naturally_single_post_header_content_action.
                *
                * naturally_single_post_header_content 10
                */
                do_action( 'naturally_single_post_header_content_action' );
                ?>

                <?php if ( 'full-width' != $naturally_layout ) { ?>

                    <div class="grid">
                        <div class="grid_row is-60 justify-center">

                            <?php if ( $naturally_sidebar && 'left-sidebar' == $naturally_layout ) { ?>
                                <div id="nt-sidebar" class="nt-sidebar grid_col is-12 is-xl-4" data-aos="ntr-fade-up" data-aos-once="true">
                                    <div class="blog-sidebar nt-sidebar-inner">
                                        <?php dynamic_sidebar( $naturally_sidebar ); ?>
                                    </div>
                                </div>
                            <?php } ?>

                            <div class="grid_col is-12<?php echo esc_attr( $naturally_column ); ?>">
                                <?php
                                while ( have_posts() ) :
                                    the_post();

                                    if ( naturally_check_is_elementor() && naturally_check_is_post() ) {

                                        naturally_single_post_formats_content();

                                        the_content();

                                        naturally_single_post_footer_content();
                                        naturally_single_post_comment_template();

                                    } else {
                                        /**
                                        * Hook: naturally_single_post_action.
                                        *
                                        * naturally_single_post_formats_content 20
                                        * naturally_single_post_content 30
                                        * naturally_single_post_footer_content 40
                                        * naturally_single_post_before_comments_template 50
                                        * naturally_single_post_comment_template 60
                                        */
                                        do_action( 'naturally_single_post_action' );

                                    }

                                endwhile; // End of the loop.
                                ?>
                            </div>

                            <?php if( $naturally_sidebar && 'right-sidebar' == $naturally_layout ) { ?>
                                <div id="nt-sidebar"  class="nt-sidebar grid_col is-12 is-xl-4" data-aos="ntr-fade-up" data-aos-once="true">
                                    <div class="blog-sidebar nt-sidebar-inner">
                                        <?php dynamic_sidebar($naturally_sidebar); ?>
                                    </div>
                                </div>
                            <?php } ?>

                        </div>
                    </div>

                <?php } else {

                    while ( have_posts() ) :
                        the_post();

                        if ( naturally_check_is_elementor() && naturally_check_is_post() ) {

                            naturally_single_post_formats_content();

                            the_content();

                            naturally_single_post_footer_content();
                            naturally_single_post_comment_template();

                        } else {
                            /**
                            * Hook: naturally_single_post_action.
                            *
                            * naturally_single_post_formats_content 20
                            * naturally_single_post_content 30
                            * naturally_single_post_footer_content 40
                            * naturally_single_post_before_comments_template 50
                            * naturally_single_post_comment_template 60
                            */
                            do_action( 'naturally_single_post_action' );

                        }

                    endwhile; // End of the loop.
                }
                ?>

            </div>
        </div>
        <?php naturally_single_post_related(); ?>
    </div>
    <!--End single page general div -->

<?php

do_action( 'naturally_after_post_single' );

}
get_footer();
?>
