<?php
/**
* The Template for displaying product archives, including the main shop page which is a post type archive
*
* This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
*
* HOWEVER, on occasion WooCommerce will need to update template files and you
* (the theme developer) will need to copy the new files to your theme to
* maintain compatibility. We try to do this as little as possible, but it does
* happen. When this occurs the version of the template file will be bumped and
* the readme will list any important changes.
*
*/

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );
$shop_display_mode = woocommerce_get_loop_display_mode();
$shop_layout = naturally_settings( 'shop_layout', 'right-sidebar' );
$shop_page_subtitle = naturally_settings( 'shop_hero_visibility', '1' );
$shop_page_subtitle = naturally_settings( 'shop_page_subtitle' );
$shop_product_style = naturally_settings( 'product_style', '1' );
$shop_column = 'full-width' != $shop_layout && is_active_sidebar( 'shop-page-sidebar' ) ? ' is-lg-8 is-xl-9' : '';

if ( '0' == naturally_settings( 'breadcrumbs_visibility', '1' ) ) {
    remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
}
?>

<?php do_action( 'naturally_shop_before_headline' ); ?>

<?php if ( '0' != naturally_settings( 'shop_hero_visibility', '1' ) ) { ?>
    <div class="section text-center shop-hero">
        <div class="container">
            <!-- Headline -->
            <div class="headline">
                <?php if ( is_product_category() ) { ?>

                    <h1 class="headline_title"><?php the_archive_title(); ?></h1>

                <?php } elseif ( is_search() ) { ?>

                    <h1 class="headline_title"><?php printf( esc_html__( 'Search Results for: %s', 'naturally' ), get_search_query() ); ?></h1>

                    <?php } else { ?>

                        <?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) { ?>

                            <h1 class="headline_title"><?php woocommerce_page_title(); ?></h1>

                        <?php } ?>
                    <?php } ?>

                    <?php if ( $shop_page_subtitle ) { ?>
                        <p class="headline_summary"><?php echo esc_html( $shop_page_subtitle ); ?></p>
                    <?php } ?>

                    <?php
                    /**
                    * Hook: woocommerce_archive_description.
                    *
                    * @hooked woocommerce_taxonomy_archive_description - 10
                    * @hooked woocommerce_product_archive_description - 10
                    */
                    do_action( 'woocommerce_archive_description' );
                    ?>

            </div>
            <!-- Headline End -->
            <!-- Breadcrumb -->
            <div class="breadcrumb">
                <?php
                /**
                * Hook: woocommerce_before_main_content.
                *
                * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
                * @hooked woocommerce_breadcrumb - 20
                * @hooked WC_Structured_Data::generate_website_data() - 30
                */
                do_action( 'woocommerce_before_main_content' );
                ?>
            </div>
            <!-- Breadcrumb End -->
        </div>
    </div>
<?php } ?>

<?php do_action( 'naturally_shop_before_main_content' ); ?>

<div class="section">
    <div class="container">
        <div class="grid">
            <div class="grid_row is-40">
                <div class="grid_col is-12 mt-0 woo-message">
                    <?php woocommerce_output_all_notices(); ?>
                </div>
                <?php if ( 'subcategories' == $shop_display_mode || 'both' == $shop_display_mode ) : ?>
                    <div class="grid_col is-12 mb-0 <?php echo esc_attr( $shop_display_mode ); ?>">
                        <div class="section section-shop-categories mt-0" data-ntr-shop-categories>
                            <div class="slider-categories">
                                <div class="slick-slider">
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if ( 'subcategories' != $shop_display_mode ) : ?>
                    <div class="grid_col is-12">
                        <!-- Header -->
                        <div class="shop-header" data-ntr-shop-header>
                            <div class="shop-header_views">
                                <div class="shop-header_layout">
                                    <div class="shop-header_layout_item is-active" data-layout="grid-<?php echo naturally_settings( 'shop_column', '3' ); ?>">
                                        <span class="shop-header_layout_item_icon icon is-grid"></span>
                                        <span class="shop-header_layout_item_text"><?php esc_html_e( 'Grid View', 'naturally' ); ?></span>
                                    </div>
                                    <div class="shop-header_layout_item" data-layout="list">
                                        <span class="shop-header_layout_item_icon icon is-list"></span>
                                        <span class="shop-header_layout_item_text"><?php esc_html_e( 'List View', 'naturally' ); ?></span>
                                    </div>
                                </div>
                                <div class="shop-header_result">
                                    <?php woocommerce_result_count(); ?>
                                </div>
                            </div>
                            <div class="shop-header_selects">
                                <?php
                                /**
                                * Hook: woocommerce_before_shop_loop.
                                *
                                * @hooked woocommerce_output_all_notices - 10
                                * @hooked woocommerce_result_count - 20
                                * @hooked woocommerce_catalog_ordering - 30
                                */
                                do_action( 'woocommerce_before_shop_loop' );

                                ?>
                            </div>
                        </div>
                        <!-- Header End -->
                    </div>
                <?php endif; ?>

                <?php if ( 'left-sidebar' == $shop_layout && is_active_sidebar( 'shop-page-sidebar' ) && 'subcategories' != $shop_display_mode ) : ?>
                    <div class="grid_col is-12 is-lg-4 is-xl-3">
                        <div class="shop-sidebar">
                            <div class="shop-sidebar_inner">
                                <?php dynamic_sidebar( 'shop-page-sidebar' ); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="grid_col is-12<?php echo esc_attr( $shop_column );?>">
                    <?php
                    if ( woocommerce_product_loop() ) {

                        woocommerce_product_loop_start();

                        if ( wc_get_loop_prop( 'total' ) ) {
                            while ( have_posts() ) {
                                the_post();

                                /**
                                * Hook: woocommerce_shop_loop.
                                */
                                do_action( 'woocommerce_shop_loop' );
                                if ( '2' == $shop_product_style ) {

                                    wc_get_template_part( 'product-style/content-product', 'style_two' );

                                } else {

                                    echo '<div class="grid_col" data-ntr-animation=\'{"name":"fadein-up"}\'>';

                                    wc_get_template_part( 'content', 'product' );

                                    echo '</div>';
                                }
                            }
                        }

                        woocommerce_product_loop_end();

                        /**
                        * Hook: woocommerce_after_shop_loop.
                        *
                        * @hooked woocommerce_pagination - 10
                        */
                        do_action( 'woocommerce_after_shop_loop' );

                    } else {
                        /**
                        * Hook: woocommerce_no_products_found.
                        *
                        * @hooked wc_no_products_found - 10
                        */
                        do_action( 'woocommerce_no_products_found' );
                    }
                    ?>
                </div>

                <?php if ( 'right-sidebar' == $shop_layout && is_active_sidebar( 'shop-page-sidebar' ) && 'subcategories' != $shop_display_mode ) : ?>
                    <div class="grid_col is-12 is-lg-4 is-xl-3">
                        <div class="shop-sidebar">
                            <div class="shop-sidebar_inner">
                                <?php dynamic_sidebar( 'shop-page-sidebar' ); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>
<?php
/**
* Hook: woocommerce_after_main_content.
*
* @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
*/
do_action( 'woocommerce_after_main_content' );

get_footer( 'shop' );
