<?php
/**
* The Template for displaying all single products
*
* This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
*
* HOWEVER, on occasion WooCommerce will need to update template files and you
* (the theme developer) will need to copy the new files to your theme to
* maintain compatibility. We try to do this as little as possible, but it does
* happen. When this occurs the version of the template file will be bumped and
* the readme will list any important changes.
*
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
$shop_display_mode = woocommerce_get_loop_display_mode();
$shop_layout       = naturally_settings( 'single_shop_layout', 'full-width' );
$shop_column       = 'full-width' != $shop_layout && is_active_sidebar( 'single-shop-page-sidebar' ) ? ' is-lg-8 is-xl-9' : '';

if ( '0' == naturally_settings( 'breadcrumbs_visibility', '1' ) ) {
    remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
}
get_header();

?>
<div class="section section-custom-8">
    <div class="container">
        <div class="breadcrumb">
            <?php woocommerce_breadcrumb(); ?>
        </div>
    </div>
</div>
<div class="section nt-single-product" data-ntr-shop-single>
    <div class="container">
        <div class="grid">
            <div class="grid_row is-40">

                <?php if ( 'left-sidebar' == $shop_layout && is_active_sidebar( 'single-shop-page-sidebar' ) ) : ?>
                    <div class="grid_col is-12 is-lg-4 is-xl-3">
                        <div class="shop-sidebar">
                            <div class="shop-sidebar_inner">
                                <?php dynamic_sidebar( 'single-shop-page-sidebar' ); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="grid_col is-12<?php echo esc_attr( $shop_column );?>">
                    <?php woocommerce_content(); ?>
                </div>

                <?php if ( 'right-sidebar' == $shop_layout && is_active_sidebar( 'single-shop-page-sidebar' ) ) : ?>
                    <div class="grid_col is-12 is-lg-4 is-xl-3">
                        <div class="shop-sidebar">
                            <div class="shop-sidebar_inner">
                                <?php dynamic_sidebar( 'single-shop-page-sidebar' ); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>
