<?php
/**
* Cart Page
*
* This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
*
* HOWEVER, on occasion WooCommerce will need to update template files and you
* (the theme developer) will need to copy the new files to your theme to
* maintain compatibility. We try to do this as little as possible, but it does
* happen. When this occurs the version of the template file will be bumped and
* the readme will list any important changes.
*
* @see     https://docs.woocommerce.com/document/template-structure/
* @package WooCommerce\Templates
* @version 10.1.0
*/

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_cart' ); ?>

<form class="woocommerce-cart-form" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
    <?php do_action( 'woocommerce_before_cart_table' ); ?>

    <table class="shop_table shop_table_responsive cart woocommerce-cart-form__contents" cellspacing="0">
        <thead>
            <tr>
                <th class="product-thumbnail"><?php esc_html_e( 'Thumb', 'naturally' ); ?></th>
                <th class="product-name"><?php esc_html_e( 'Product', 'naturally' ); ?></th>
                <th class="product-price"><?php esc_html_e( 'Price', 'naturally' ); ?></th>
                <th class="product-quantity"><?php esc_html_e( 'Quantity', 'naturally' ); ?></th>
                <th class="product-subtotal"><?php esc_html_e( 'Subtotal', 'naturally' ); ?></th>
                <th class="product-remove"><?php esc_html_e( 'Remove', 'naturally' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php
            do_action( 'woocommerce_before_cart_contents' );

            foreach ( WC()->cart->get_cart() as $key => $item ) {
                $p     = apply_filters( 'woocommerce_cart_item_product', $item['data'], $item, $key );
                $pid   = apply_filters( 'woocommerce_cart_item_product_id', $item['product_id'], $item, $key );
                $qty   = apply_filters( 'woocommerce_cart_item_quantity', $item['quantity'], $item, $key );
                $thumb = apply_filters( 'woocommerce_cart_item_thumbnail', $p->get_image(), $item, $key );
                $link  = apply_filters( 'woocommerce_cart_item_permalink', $p->is_visible() ? $p->get_permalink( $item ) : '', $item, $key );
                $name  = apply_filters( 'woocommerce_cart_item_name', $p->get_name(), $item, $key );
                $price = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $p ), $item, $key );
                $vis   = apply_filters( 'woocommerce_cart_item_visible', true, $item, $key );
                $class = apply_filters( 'woocommerce_cart_item_class', 'cart_item', $item, $key );

                if ( $p && $p->exists() && $qty > 0 && $vis ) {
                    ?>
                    <tr class="woocommerce-cart-form__cart-item <?php echo esc_attr( $class ); ?>">

                        <td class="product-thumbnail">
                            <?php
                            if ( ! $link ) {
                                printf( '%s',$thumb );
                            } else {
                                printf( '<a href="%s">%s</a>', esc_url( $link ), $thumb );
                            }
                            ?>
                        </td>

                        <td class="product-name" data-title="<?php esc_attr_e( 'Product', 'naturally' ); ?>">
                            <?php
                            if ( ! $link ) {
                                echo wp_kses_post( $name . '&nbsp;' );
                            } else {
                                echo wp_kses_post( sprintf( '<a href="%s">%s</a>', esc_url( $link ), $name ));
                            }

                            do_action( 'woocommerce_after_cart_item_name', $item, $key );

                            // Meta data.
                            echo wc_get_formatted_cart_item_data( $item );

                            // Backorder notification.
                            if ( $p->backorders_require_notification() && $p->is_on_backorder( $qty ) ) {
                                echo wp_kses_post( apply_filters( 'woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__( 'Available on backorder', 'naturally' ) . '</p>', $pid ) );
                            }
                            ?>
                        </td>

                        <td class="product-price" data-title="<?php esc_attr_e( 'Price', 'naturally' ); ?>">
                            <?php printf( '%s',$price ); ?>
                        </td>

                        <td class="product-quantity" data-title="<?php esc_attr_e( 'Quantity', 'naturally' ); ?>">
                            <?php
                            if ( $p->is_sold_individually() ) {
                                $min = 1;
                                $max = 1;
                            } else {
                                $min = 0;
                                $max = $p->get_max_purchase_quantity();
                            }
                            $product_quantity = woocommerce_quantity_input(
                                array(
                                    'input_name'   => "cart[{$key}][qty]",
                                    'input_value'  => $qty,
                                    'max_value'    => $max,
                                    'min_value'    => $min,
                                    'product_name' => $name
                                ),
                                $p,
                                false
                            );
                            echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $key, $item );
                            ?>
                        </td>

                        <td class="product-subtotal" data-title="<?php esc_attr_e( 'Subtotal', 'naturally' ); ?>">
                            <?php echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $p, $qty ), $item, $key ); ?>
                        </td>

                        <td class="product-remove">
                            <?php
                            echo apply_filters(
                                'woocommerce_cart_item_remove_link',
                                sprintf(
                                    '<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s"><span class="icon is-close"></span></a>',
                                    esc_url( wc_get_cart_remove_url( $key ) ),
                                    esc_html__( 'Remove this item', 'naturally' ),
                                    esc_attr( $pid ),
                                    esc_attr( $p->get_sku() )
                                ),
                                $key
                            );
                            ?>
                        </td>
                    </tr>
                    <?php
                }
            }
            ?>

            <?php do_action( 'woocommerce_cart_contents' ); ?>

            <tr class="table-coupon">
                <td colspan="6" class="actions">

                    <?php if ( wc_coupons_enabled() ) { ?>
                        <div class="coupon">
                            <label for="coupon_code"><?php esc_html_e( 'Coupon:', 'naturally' ); ?></label>
                            <input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php esc_attr_e( 'Coupon code', 'naturally' ); ?>" />

                            <button type="submit" class="button" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'naturally' ); ?>">
                                <?php esc_html_e( 'Apply coupon', 'naturally' ); ?>
                            </button>

                            <?php do_action( 'woocommerce_cart_coupon' ); ?>
                        </div>
                    <?php } ?>

                    <button type="submit" class="button" name="update_cart" value="<?php esc_attr_e( 'Update cart', 'naturally' ); ?>"><?php esc_html_e( 'Update cart', 'naturally' ); ?></button>

                    <?php do_action( 'woocommerce_cart_actions' ); ?>

                    <?php wp_nonce_field( 'woocommerce-cart', 'woocommerce-cart-nonce' ); ?>
                </td>
            </tr>

            <?php do_action( 'woocommerce_after_cart_contents' ); ?>
        </tbody>
    </table>
    <?php do_action( 'woocommerce_after_cart_table' ); ?>
</form>

<?php do_action( 'woocommerce_before_cart_collaterals' ); ?>

<div class="cart-collaterals">
    <?php
    /**
    * Cart collaterals hook.
    *
    * @hooked woocommerce_cross_sell_display
    * @hooked woocommerce_cart_totals - 10
    */
    do_action( 'woocommerce_cart_collaterals' );
    ?>
</div>

<?php do_action( 'woocommerce_after_cart' ); ?>
