<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 9.4.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Check if the product is a valid WooCommerce product and ensure its visibility before proceeding.
if ( ! is_a( $product, WC_Product::class ) || ! $product->is_visible() ) {
    return;
}

$badge = get_post_meta( $product->get_id(), 'naturally_badge', true );
$badge_custom = get_post_meta( $product->get_id(), 'naturally_custom_badge', true );
$attr = get_post_meta( $product->get_id(), 'naturally_product_single_attr', true );
$attr_custom = get_post_meta( $product->get_id(), 'naturally_product_custom_attr', true );
$show_discount = get_post_meta( $product->get_id(), 'naturally_product_discount', true );
$custom_classes = '';
$custom_classes .= $badge || $badge_custom ? ' has-custom-badge' : '';
$custom_classes .= $attr || $attr_custom ? ' has-custom-attr' : '';
$custom_classes .= $show_discount == 'yes' ? ' has-custom-discount' : '';

?>
<?php if ( !is_shop() && !is_product() && !is_search() && !is_archive()) { ?>
<div class="grid_col">
<?php } ?>
	<div <?php wc_product_class( 'shop-product hover-border'.$custom_classes, $product ); ?>>

		<?php
		/**
		 * Hook: woocommerce_before_shop_loop_item.
		 *
		 * @hooked woocommerce_template_loop_product_link_open - 10
		 */
		do_action( 'woocommerce_before_shop_loop_item' );
		?>

		<?php
		/**
		 * Hook: woocommerce_before_shop_loop_item_title.
		 *
		 * @hooked woocommerce_show_product_loop_sale_flash - 10
		 * @hooked woocommerce_template_loop_product_thumbnail - 10
		 */
		 do_action( 'woocommerce_before_shop_loop_item_title' );
		?>

		<?php
		/**
		 * Hook: woocommerce_shop_loop_item_title.
		 *
		 * @hooked woocommerce_template_loop_product_title - 10
		 */
		do_action( 'woocommerce_shop_loop_item_title' );
		?>
		<div class="shop-product_content">
			<div class="shop-product_body">
				<?php
				/**
				* Hook: woocommerce_after_shop_loop_item_title.
				*
				* @hooked woocommerce_template_loop_rating - 5
				* @hooked woocommerce_template_loop_price - 10
				*/
				do_action( 'woocommerce_after_shop_loop_item_title' );
				?>
			</div>
			<div class="shop-product_footer">
				<?php
				/**
				 * Hook: woocommerce_after_shop_loop_item.
				 *
				 * @hooked woocommerce_template_loop_product_link_close - 5
				 * @hooked woocommerce_template_loop_add_to_cart - 10
				 */
				do_action( 'woocommerce_after_shop_loop_item' );
				?>
			</div>
		</div>
	</div>
<?php if ( !is_shop() && !is_product() && !is_search() && !is_archive()) { ?>
</div>
<?php } ?>
