<?php
/**
 * Shop breadcrumb
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/breadcrumb.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version  2.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! empty( $breadcrumb ) ) {

	echo wp_kses( $wrap_before, naturally_allowed_html() );

	foreach ( $breadcrumb as $key => $crumb ) {

		echo wp_kses( $before, naturally_allowed_html() );

		if ( ! empty( $crumb[1] ) && sizeof( $breadcrumb ) !== $key + 1 ) {
			echo '<a class="breadcrumb_link" href="' . esc_url( $crumb[1] ) . '"><span class="breadcrumb_link_text">' . esc_html( $crumb[0] ) . '</span></a>';
		} else {
			echo '<span class="breadcrumb_active">'.esc_html( $crumb[0] ).'</span>';
		}

		echo wp_kses( $after, naturally_allowed_html() );

		if ( sizeof( $breadcrumb ) !== $key + 1 ) {
			echo '<span class="breadcrumb_link_icon icon is-arrow-right2"></span>';
		}
	}

	echo wp_kses( $wrap_after, naturally_allowed_html() );

}
