<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

if ( class_exists( 'WooCommerce' ) ) {


    /*************************************************
    ## ADD CUSTOM CSS FOR WOOCOMMERCE
    *************************************************/

    if ( !function_exists( 'naturally_woo_scripts' ) ) {
        function naturally_woo_scripts()
        {
            wp_enqueue_style( 'naturally-woo-general', get_template_directory_uri() . '/woocommerce/woo-general.css',false, '1.0' );
            wp_enqueue_style( 'naturally-woo-single', get_template_directory_uri() . '/woocommerce/woo-single.css',false, '1.0' );
            wp_enqueue_style( 'naturally-woo-update', get_template_directory_uri() . '/woocommerce/woo-update.css',false, '1.0' );
            wp_enqueue_script( 'naturally-woo-custom', get_template_directory_uri() . '/woocommerce/woo-custom.js', array('jquery'), '1.0', true );
        }
        add_action( 'wp_enqueue_scripts', 'naturally_woo_scripts' );
    }

    /*********************************************************
    ## WOOCOMMERCE HOOKS
    **********************************************************/
    // Shop page hooks
    remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
    remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
    remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
    remove_action( 'woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10 );

    // romove product related
    if( '0' == naturally_settings('single_shop_related_visibility', '0') ) {
        //remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
    }

    // Product page remove link open and link close
    remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
    remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );

    remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
    add_action( 'woocommerce_before_shop_loop_item_title', 'naturally_product_thumbs', 10 );
    add_action( 'woocommerce_shop_loop_item_title', 'naturally_product_brand', 5 );

    // Single page button actions
    add_action( 'woocommerce_single_product_summary', 'naturally_single_button_actions', 35 );
    function naturally_single_button_actions()
    {
        if ( defined( 'YITH_WCWL' ) ) {

            echo'<div class="shop-product_actions btns"></div>';

        }
    }

    /* wishlist content via ajax */
    if ( defined( 'YITH_WCWL' ) && ! function_exists( 'yith_wcwl_ajax_update_count' ) ) {
        function yith_wcwl_ajax_update_count() {
            wp_send_json( array(
                'count' => yith_wcwl_count_all_products()
            ) );
        }
        add_action( 'wp_ajax_yith_wcwl_update_wishlist_count', 'yith_wcwl_ajax_update_count' );
        add_action( 'wp_ajax_nopriv_yith_wcwl_update_wishlist_count', 'yith_wcwl_ajax_update_count' );
        add_action('naturally_after_main_footer', 'naturally_wishlist_label_count' );

        function naturally_wishlist_label_count()
        {
            if ( '0' != naturally_settings( 'wishlist_btn_visibility', '1' ) ) {
                ?>
                <a class="wishlist--count is-active" href="#0">
                    <span class="naturally-wishlist--icon icon is-heart"></span>
                    <span class="wishlist_label_count"></span>
                </a>
                <div class="wishlist--content">
                    <div class="header_cart_close"><span class="icon is-close"></span></div>
                    <div class="container">
                        <div class="row">
                            <div class="col-12">
                                <?php echo do_shortcode( '[yith_wcwl_wishlist]' ); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            }
        }
    }

    if ( defined( 'YITH_WCWL' ) && ! function_exists( 'yith_wcwl_enqueue_custom_script' ) ) {
        function yith_wcwl_enqueue_custom_script() {
            if ( '0' != naturally_settings( 'wishlist_btn_visibility', '1' ) ) {
                wp_add_inline_script('jquery-yith-wcwl',
                "jQuery( function( $ ) {
                    var wl = $('#yith-wcwl-form'),
                    wl_data = $('#yith-wcwl-form').data('fragment-options'),
                    wl_count;

                    if ( wl && wl_data ) {
                        wl_count = wl_data.count;
                        if ( wl_count != 0 ) {

                            $( '.wishlist_label_count' ).html( wl_count );
                        }

                        $('.wishlist--count').on( 'click', function (e) {
                            e.preventDefault();
                            $('.wishlist--content').addClass('open');
                        });
                        $('.wishlist--content .header_cart_close').on( 'click', function (e) {
                            e.preventDefault();
                            $('.wishlist--content').removeClass('open');
                        });
                    }
                    jQuery( document ).on( 'yith_wcwl_ajax_update', function( e, data ) {
                        $.get( yith_wcwl_l10n.ajax_url, {
                            action: 'yith_wcwl_update_wishlist_count'
                        }, function( data ) {
						
                            if ( data.count == 0 ) {
                                $('.wishlist--count .wishlist_label_count').html();
                            } else {
                                $('.wishlist--count .wishlist_label_count').html( data.count );
                            }
                        });
                    });

                });"
                );
            }
        }
        add_action( 'wp_enqueue_scripts', 'yith_wcwl_enqueue_custom_script', 20 );
    }


if ( ! function_exists( 'naturally_product_brand' ) ) {
    
    function naturally_product_brand(){
        
        global $product;
        $tax = defined( 'YITH_WCBR' ) ? 'yith_product_brand' : 'product_brand';
        $terms = get_the_terms( $product->get_id(), $tax );
        if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
            echo '<ul class="brands-list">';
            foreach ( $terms as $term ){
                if ( is_object($term) && $term->parent == 0 ) {
                    echo sprintf( '<li><a class="naturally-brands" href="%s"><span itemprop="brand" class="badge is-grey %s">%s</span></a></li>',
                    get_term_link( $term ),
                    $term->slug,
                    $term->name
                    );
                }
            }
            echo '</ul>';
        }
    }
}

if ( ! function_exists( 'naturally_product_thumbs' ) ) {
    function naturally_product_thumbs()
    {
        global $product;
        ?>
        <div class="shop-product_photo">
            <a href="<?php echo get_permalink();?>">
                <?php woocommerce_template_loop_product_thumbnail(); ?>
            </a>
        </div>

        <?php
        do_action( 'naturally_after_thumbnail' );
    }
}


remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
add_action( 'woocommerce_after_shop_loop_item_title', 'naturally_product_title', 10 );

if ( ! function_exists( 'naturally_product_title' ) ) {
    function naturally_product_title(){ ?>
        <div class="shop-product_title">
            <a href="<?php echo get_permalink();?>">
                <?php the_title();?>
            </a>
        </div>
        <?php
    }
}

remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
add_action( 'woocommerce_after_shop_loop_item_title', 'naturally_product_rating', 10 );

if ( ! function_exists( 'naturally_product_rating' ) ) {
    function naturally_product_rating()
    {
        global $product;
        if( $product->get_average_rating() ){
            ?>
            <div class="shop-product_rating">
                <div class="rating">
                    <?php woocommerce_template_loop_rating();?>
                </div>
            </div>
            <?php
        }
    }
}

remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
add_action( 'woocommerce_after_shop_loop_item', 'naturally_before_product_buttons', 9 );
add_action( 'woocommerce_after_shop_loop_item', 'naturally_after_product_buttons', 25 );
add_action( 'woocommerce_after_shop_loop_item', 'naturally_product_price', 5 );

if ( ! function_exists( 'naturally_product_price' ) ) {
    function naturally_product_price()
    {
        global $product;
        if( $product->get_price_html() ){
            ?>
            <div class="shop-product_prices">
                <?php woocommerce_template_loop_price();?>
            </div>
        <?php } ?>

        <?php
    }
}
if ( ! function_exists( 'naturally_before_product_buttons' ) ) {
    function naturally_before_product_buttons()
    { ?>
        <div class="shop-product_actions">
            <?php
        }
    }
    if ( ! function_exists( 'naturally_after_product_buttons' ) ) {
        function naturally_after_product_buttons()
        { ?>
        </div>
        <?php
    }
}
add_action( 'woocommerce_after_shop_loop_item_title', 'naturally_product_excerpt', 15 );
if ( ! function_exists( 'naturally_product_excerpt' ) ) {
    function naturally_product_excerpt()
    { ?>
        <div class="shop-product_description">
            <?php the_excerpt();?>
        </div>
        <?php
    }
}

add_action('naturally_before_shop_orderby_action','naturally_before_shop_orderby',10);
if ( ! function_exists( 'naturally_before_shop_orderby' ) ) {
    function naturally_before_shop_orderby()
    {
        if ( !is_shop() && !is_product_category() ) { ?>
            <div class="shop-header-select">
                <div class="grid">
                    <div class="grid_row mb-40">
                        <div class="grid_col is-12">
                            <div class="shop-header">
                                <div class="shop-header_selects header_orderby">
                                    <?php
                                }
                            }
                        }

                        add_action('naturally_after_shop_orderby_action','naturally_after_shop_orderby',10);
                        if ( ! function_exists( 'naturally_after_shop_orderby' ) ) {
                            function naturally_after_shop_orderby()
                            {
                                if ( !is_shop() && !is_product_category() ) { ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }
    }
}

remove_action( 'woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_title', 10 );
add_action( 'woocommerce_shop_loop_subcategory_title', 'naturally_shop_loop_subcategory_title', 10 );
if(!function_exists('naturally_shop_loop_subcategory_title')){
    function naturally_shop_loop_subcategory_title($category)
    { ?>
        <?php if ($category->name) { ?>
            <span class="slider-categories_item_name"><?php echo esc_html( $category->name );?></span>
        <?php } ?>
        <?php if ( $category->count > 0 ) { ?>
            <span class="slider-categories_item_count"><?php echo sprintf(_n('%d Product', '%d Products', $category->count, 'naturally'),$category->count); ?></span>
        <?php } ?>
        <?php
    }
}

/*********************************************************
## get stock
**********************************************************/
if(!function_exists('naturally_get_stock')){
    function naturally_get_stock()
    {
        global $product;
        $status = $product->get_stock_status();
        $stock  = $product->get_stock_quantity();

        $statusText  = $status == 'instock' ? esc_html__('In Stock', 'naturally') : esc_html__('Out of stock', 'naturally');
        $statusClass = $status == 'instock' ? 'is-green-light in-stock' : 'is-red-light out-of-stock';
        ?>
        <?php if ( $status != 'onbackorder' ) { ?>
            <div class="shop-product_labels"><span class="label <?php echo esc_attr($statusClass); ?>"><?php echo esc_html($statusText); ?></span></div>
        <?php } ?>
        <?php
    }
}

if ( ! function_exists( 'naturally_product_all_labels' ) ) {
    add_action( 'woocommerce_before_shop_loop_item_title', 'naturally_product_all_labels', 10 );
    function naturally_product_all_labels() {
            echo '<span class="nt-labels-wrapper">';
            naturally_get_stock();
            naturally_product_badge();
            naturally_show_product_attr();
            naturally_product_save_price();
            echo '</span>';
    }
}

if ( ! function_exists( 'naturally_product_save_price' ) ) {
    add_action( 'woocommerce_before_single_product_summary', 'naturally_product_save_price', 15 );
    function naturally_product_save_price() {
        global $product;
        $price = '';
        $show_discount = get_post_meta( $product->get_id(), 'naturally_product_discount', true );

        if( $show_discount == 'yes' && $product->is_on_sale() && ! $product->is_type('variable')){
            $regular_price = (float) $product->get_regular_price();
            $sale_price = (float) $product->get_price();
            $precision = 1; // Max number of decimals
            $saving_percentage = $sale_price && $regular_price ? round( 100 - ( $sale_price / $regular_price * 100 ), 1 ) . '%' : '';

            if ( $saving_percentage ) {
                echo '<div class="nt-labels shop-save_labels"><span class="label is-red">'.$saving_percentage.'</span></div>';
            }

        }
    }
}


/*********************************************************
## 1. CUSTOM BADGE LABEL
**********************************************************/
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
add_action( 'woocommerce_before_single_product_summary', 'naturally_product_badge', 10 );

if ( ! function_exists( 'naturally_product_badge' ) ) {

    function naturally_product_badge()
    {
        global $product;
        $badge = get_post_meta( $product->get_id(), 'naturally_badge', true );
        $badge_color = get_post_meta( $product->get_id(), 'naturally_badge_color', true );
        $badge_custom = get_post_meta( $product->get_id(), 'naturally_custom_badge', true );
        $show_badge = get_post_meta( $product->get_id(), 'naturally_show_badge_on_product', true );
        $badge_color = $badge_color ? $badge_color : 'is-green-light';
        $title = '';
        switch ($badge) {
            case 'new':
            $title = esc_html__('New','naturally');
            break;
            case 'hot':
            $title = esc_html__('Hot','naturally');
            break;
            case 'best':
            $title = esc_html__('Best','naturally');
            break;
            case 'featured':
            $title = esc_html__('Featured','naturally');
            break;
            case 'free':
            $title = esc_html__('Free','naturally');
            break;
            case 'custom':
            $title = $badge_custom;
            break;
            default:
            $title = '';
            break;
        }
        if ( '' != $title ) {
            if ( 'yes' == $show_badge ) {
                echo '<div class="nt-labels shop-product_labels"><span class="label '.esc_attr($badge_color).'">'.esc_html($title).'</span></div>';
            } else {
                if ( $product->is_on_sale() ) {
                    echo '<div class="nt-labels shop-product_labels"><span class="label '.esc_attr($badge_color).'">'.esc_html($title).'</span></div>';
                }
            }
        } else {
            if( $product->is_on_sale() ) {
                echo '<div class="nt-labels shop-product_labels"><span class="def-labels label '.esc_attr($badge_color).'">'.esc_html__( 'Sale!', 'naturally' ).'</span></div>';
            }
        }
    }
}



if ( ! function_exists( 'naturally_show_product_attr' ) ) {

    function naturally_show_product_attr()
    {
        global $product;
        $attr = get_post_meta( $product->get_id(), 'naturally_product_single_attr', true );
        $attr_custom = get_post_meta( $product->get_id(), 'naturally_product_custom_attr', true );
        $badge_color = get_post_meta( $product->get_id(), 'naturally_product_single_attr_color', true );

        if ( '' != $attr ) {
            if( 'custom' == $attr && $attr_custom ) {
                echo '<div class="nt-labels shop-product_attr_labels"><span class="label '.esc_attr($badge_color).'">'.esc_html($attr_custom).'</span></div>';
            } else {
                echo '<div class="nt-labels shop-product_attr_labels"><span class="label '.esc_attr( $badge_color ).'">'.esc_html($attr).'</span></div>';
            }
        }
    }
}

if ( ! function_exists( 'naturally_show_product_attr_on_single' ) ) {
    add_action('woocommerce_single_product_summary', 'naturally_show_product_attr_on_single', 45 );
    function naturally_show_product_attr_on_single()
    {
        global $product;

        $show_product_attr = get_post_meta( $product->get_id(), 'naturally_show_product_attr_on_single', true );

        if ( $show_product_attr && $show_product_attr == 'yes' ) {
            echo '<div class="product_meta naturally-product_attributes">';
                $product->list_attributes();
            echo '</div>';
        }
    }
}

/**
* Get WooCommerce Attributes Taxonomies
* @return array
*/
if ( ! function_exists( 'naturally_get_product_attributes' ) ) {
    function naturally_get_product_attributes()
    {

        if ( class_exists( 'WooCommerce' ) ) {
            $options = array(
                '' => esc_html__( 'Select a attribute', 'naturally' ),
                'custom' => esc_html__( 'Custom', 'naturally' ),
            );
            global $post;
            $product = wc_get_product( $post->ID );
            $attributes = $product->get_attributes();
            if ( !empty($attributes) ) {
                foreach ( $attributes as $attribute ) {
                    $options[$attribute["name"]] = $attribute["name"];
                }

                return $options;
            }
            return false;
        }
    }
}



/**
* @snippet Move & Change Number of Cross-Sells @ WooCommerce Cart
* @how-to Get CustomizeWoo.com FREE
* @sourcecode https://businessbloomer.com/?p=20449
* @author Rodolfo Melogli
* @testedwith WooCommerce 2.6.2
*/


// ---------------------------------------------
// Remove Cross Sells From Default Position

remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );


// ---------------------------------------------
// Add them back UNDER the Cart Table

add_action( 'woocommerce_after_cart', 'woocommerce_cross_sell_display' );



/*********************************************************
## 1. ADD NEW CHECKBOX TO PRODUCT EDIT PAGE (GENERAL TAB)
**********************************************************/

if ( ! function_exists( 'naturally_add_badge_checkbox_to_products' ) ) {

    add_action( 'woocommerce_product_options_general_product_data', 'naturally_add_badge_checkbox_to_products' );
    function naturally_add_badge_checkbox_to_products()
    {
        woocommerce_wp_select(
            array(
                'id' => 'naturally_badge',
                'label' => esc_html__( 'Naturally Badge?', 'naturally' ),
                'options' => array(
                    '' => 'Select a badge',
                    'new' => esc_html__( 'New', 'naturally' ),
                    'hot' => esc_html__( 'Hot', 'naturally' ),
                    'best' => esc_html__( 'Best', 'naturally' ),
                    'featured' => esc_html__( 'Featured', 'naturally' ),
                    'free' => esc_html__( 'Free', 'naturally' ),
                    'custom' => esc_html__( 'Custom', 'naturally' ),
                ),
                'desc_tip'    => false,
            )
        );
        woocommerce_wp_text_input(
            array(
                'id' => 'naturally_custom_badge',
                'label' => esc_html__( 'Custom Badge Label', 'naturally' ),
                'description' => esc_html__( 'Add your custom badge label here', 'naturally' ),
            )
        );
        woocommerce_wp_select(
            array(
                'id' => 'naturally_badge_color',
                'label' => esc_html__( 'Naturally Badge Color?', 'naturally' ),
                'options' => array(
                    '' => 'Select a badge',
                    'is-primary' => esc_html__( 'primary', 'naturally' ),
                    'is-secondary' => esc_html__( 'secondary', 'naturally' ),
                    'is-black' => esc_html__( 'black', 'naturally' ),
                    'is-grey' => esc_html__( 'grey', 'naturally' ),
                    'is-white' => esc_html__( 'white', 'naturally' ),
                    'is-blue' => esc_html__( 'blue', 'naturally' ),
                    'is-green' => esc_html__( 'green', 'naturally' ),
                    'is-orange' => esc_html__( 'orange', 'naturally' ),
                    'is-red' => esc_html__( 'red', 'naturally' ),
                    'is-purple' => esc_html__( 'purple', 'naturally' ),
                    'is-blue-light' => esc_html__( 'blue-light', 'naturally' ),
                    'is-green-light' => esc_html__( 'green-light', 'naturally' ),
                    'is-orange-light' => esc_html__( 'orange-light', 'naturally' ),
                    'is-red-light' => esc_html__( 'red-light', 'naturally' ),
                    'is-purple-light' => esc_html__( 'purple-light', 'naturally' ),
                ),
                'desc_tip'    => false,
            )
        );
        woocommerce_wp_checkbox(
            array(
                'id' => 'naturally_show_badge_on_product',
                'label' => esc_html__( 'Display this Badge on the products which are not on sale too?', 'naturally' ),
                'desc_tip' => false,
            )
        );
        if ( false != naturally_get_product_attributes() ) {
            woocommerce_wp_select(
                array(
                    'id' => 'naturally_product_single_attr',
                    'label' => esc_html__( 'Show This Attribute On Elementor Widget', 'naturally' ),
                    'options' => naturally_get_product_attributes(),
                    'desc_tip' => false,
                )
            );
            woocommerce_wp_text_input(
                array(
                    'id' => 'naturally_product_custom_attr',
                    'label' => esc_html__( 'Custom Attribute Label', 'naturally' ),
                    'description' => esc_html__( 'Add your custom attribute label here', 'naturally' ),
                )
            );
            woocommerce_wp_checkbox(
                array(
                    'id' => 'naturally_show_product_attr_on_single',
                    'label' => esc_html__( 'Show Product Attributes On Single Page?', 'naturally' ),
                    'description' => esc_html__( 'The attributes of this product will be displayed on the single page after the product meta information.', 'naturally' ),
                    'desc_tip' => false,
                )
            );
            woocommerce_wp_select(
                array(
                    'id' => 'naturally_product_single_attr_color',
                    'label' => esc_html__( 'Naturally Attribute Color?', 'naturally' ),
                    'options' => array(
                        '' => esc_html__( 'Select attribute label color', 'naturally' ),
                        'is-primary' => esc_html__( 'primary', 'naturally' ),
                        'is-secondary' => esc_html__( 'secondary', 'naturally' ),
                        'is-black' => esc_html__( 'black', 'naturally' ),
                        'is-grey' => esc_html__( 'grey', 'naturally' ),
                        'is-white' => esc_html__( 'white', 'naturally' ),
                        'is-blue' => esc_html__( 'blue', 'naturally' ),
                        'is-green' => esc_html__( 'green', 'naturally' ),
                        'is-orange' => esc_html__( 'orange', 'naturally' ),
                        'is-red' => esc_html__( 'red', 'naturally' ),
                        'is-purple' => esc_html__( 'purple', 'naturally' ),
                        'is-blue-light' => esc_html__( 'blue-light', 'naturally' ),
                        'is-green-light' => esc_html__( 'green-light', 'naturally' ),
                        'is-orange-light' => esc_html__( 'orange-light', 'naturally' ),
                        'is-red-light' => esc_html__( 'red-light', 'naturally' ),
                        'is-purple-light' => esc_html__( 'purple-light', 'naturally' ),
                    ),
                    'desc_tip'    => false,
                )
            );
            woocommerce_wp_checkbox(
                array(
                    'id' => 'naturally_product_discount',
                    'label' => esc_html__( 'Show Product Discount?', 'naturally' ),
                    'wrapper_class' => 'hide_if_variable',
                    'desc_tip' => false,
                )
            );
        }
    }
}

/*********************************************************
## 2. SAVE CHECKBOX VIA CUSTOM FIELD
**********************************************************/

if ( ! function_exists( 'naturally_save_badge_checkbox_to_post_meta' ) ) {

    add_action( 'save_post', 'naturally_save_badge_checkbox_to_post_meta' );
    function naturally_save_badge_checkbox_to_post_meta( $product_id )
    {
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ){
            return;
        }
        if ( isset( $_POST['naturally_badge'] ) ) {
            update_post_meta( $product_id, 'naturally_badge', $_POST['naturally_badge'] );
        } else {
            delete_post_meta( $product_id, 'naturally_badge' );
        }
        if ( isset( $_POST['naturally_badge_color'] ) ) {
            update_post_meta( $product_id, 'naturally_badge_color', $_POST['naturally_badge_color'] );
        } else {
            delete_post_meta( $product_id, 'naturally_badge_color' );
        }
        if ( isset( $_POST['naturally_custom_badge'] ) ) {
            update_post_meta( $product_id, 'naturally_custom_badge', $_POST['naturally_custom_badge'] );
        } else {
            delete_post_meta( $product_id, 'naturally_custom_badge' );
        }
        if ( isset( $_POST['naturally_show_badge_on_product'] ) ) {
            update_post_meta( $product_id, 'naturally_show_badge_on_product', $_POST['naturally_show_badge_on_product'] );
        } else {
            delete_post_meta( $product_id, 'naturally_show_badge_on_product' );
        }
        if ( isset( $_POST['naturally_product_single_attr'] ) ) {
            update_post_meta( $product_id, 'naturally_product_single_attr', $_POST['naturally_product_single_attr'] );
        } else {
            delete_post_meta( $product_id, 'naturally_product_single_attr' );
        }
        if ( isset( $_POST['naturally_product_single_attr_color'] ) ) {
            update_post_meta( $product_id, 'naturally_product_single_attr_color', $_POST['naturally_product_single_attr_color'] );
        } else {
            delete_post_meta( $product_id, 'naturally_product_single_attr_color' );
        }
        if ( isset( $_POST['naturally_product_custom_attr'] ) ) {
            update_post_meta( $product_id, 'naturally_product_custom_attr', $_POST['naturally_product_custom_attr'] );
        } else {
            delete_post_meta( $product_id, 'naturally_product_custom_attr' );
        }
        if ( isset( $_POST['naturally_product_discount'] ) ) {
            update_post_meta( $product_id, 'naturally_product_discount', $_POST['naturally_product_discount'] );
        } else {
            delete_post_meta( $product_id, 'naturally_product_discount' );
        }
        if ( isset( $_POST['naturally_show_product_attr_on_single'] ) ) {
            update_post_meta( $product_id, 'naturally_show_product_attr_on_single', $_POST['naturally_show_product_attr_on_single'] );
        } else {
            delete_post_meta( $product_id, 'naturally_show_product_attr_on_single' );
        }
    }
}

/*************************************************
## WOO CART AJAX
*************************************************/

if ( ! function_exists( 'naturally_header_woo_myaccount' ) ) {
    add_action( 'naturally_header_woo_myaccount_action', 'naturally_header_woo_myaccount', 10 );
    function naturally_header_woo_myaccount()
    {
        if ( '0' != naturally_settings('header_account_visibility', '1')  ) {
            $currentUser = wp_get_current_user(); ?>
            <div class="header_menu_item">
                <a class="header_menu_link account-item" href="<?php echo get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ); ?>">
                    <span class="header_menu_link_icon icon is-avatar"></span>
                    <span class="header_menu_link_text"><?php echo esc_html_e('My Account', 'naturally'); ?></span>
                    <span class="screen-reader-text"><?php echo sprintf( esc_html__( 'Hi, %s', 'naturally' ), $currentUser->display_name ); ?></span>
                </a>
            </div>
            <?php
        }
    }
}

if ( ! function_exists( 'naturally_header_mini_cart' ) ) {
    add_action( 'naturally_header_mini_cart_action', 'naturally_header_mini_cart', 10 );
    function naturally_header_mini_cart()
    {
        global $woocommerce;
        ?>
        <div class="header_cart">
            <div class="header_cart_label">
                <span class="header_cart_label_icon icon is-bag"></span>
                <span class="header_cart_label_text"><?php printf( '%s', $woocommerce->cart->get_cart_subtotal() ); ?> / <?php echo sprintf(_n('%d item', '%d items', WC()->cart->cart_contents_count, 'naturally'), WC()->cart->cart_contents_count); ?></span>
                <?php if ( WC()->cart->cart_contents_count ) { ?>
                    <span class="header_cart_mobile_label_text"><?php printf( '%s', WC()->cart->cart_contents_count );?></span>
                <?php } ?>
            </div>
            <?php get_template_part('woocommerce/header', 'minicart'); ?>
        </div>
        <?php
    }
}

if (!function_exists('naturally_add_to_cart_fragments')) {
    add_filter('woocommerce_add_to_cart_fragments', 'naturally_add_to_cart_fragments');
    function naturally_add_to_cart_fragments($fragments) {
        global $woocommerce;

        // Fragment 1: header_cart_label_text
        ob_start();
        ?>
        <span class="header_cart_label_text"><?php printf('%s', $woocommerce->cart->get_cart_subtotal()); ?> / <?php echo sprintf(_n('%d item', '%d items', WC()->cart->cart_contents_count, 'naturally'), WC()->cart->cart_contents_count); ?></span>
        <?php if (WC()->cart->cart_contents_count) { ?>
            <span class="header_cart_mobile_label_text"><?php printf('%s', WC()->cart->cart_contents_count); ?></span>
        <?php }
        $fragments['span.header_cart_label_text'] = ob_get_clean();

        // Fragment 2: wc-count
        ob_start();
        ?>
        <span class="wc-count"><?php printf('%s', WC()->cart->cart_contents_count); ?></span>
        <?php
        $fragments['span.wc-count'] = ob_get_clean();

        // Fragment 3: header_cart_detail
        ob_start();
        get_template_part('woocommerce/header', 'minicart');
        $fragments['div.header_cart_detail'] = ob_get_clean();

        return $fragments;
    }
}

/*************************************************
## WOO SHOP PER PAGE VIA SELECT BOX
*************************************************/

if ( !function_exists( 'naturally_post_perpage_selectbox' ) ) {
    add_action( 'woocommerce_before_shop_loop', 'naturally_post_perpage_selectbox', 35 );
    function naturally_post_perpage_selectbox()
    {
        if ( is_shop() ) {
            $p_pp = naturally_settings('shop_perpage','12');
            $pp_rate_of_increase = naturally_settings('shop_rate_of_increase','5');
            $per_page = filter_input(INPUT_GET, 'perpage', FILTER_SANITIZE_NUMBER_INT);
            $total_products = count( get_posts( array('post_type' => 'product', 'post_status' => 'publish', 'fields' => 'ids', 'posts_per_page' => '-1') ) );

            //$orderby = array();
            for ($i=$p_pp; $i < $total_products; $i++) {
                $orderby_options[$i] = $i;
                $i=$i+$pp_rate_of_increase;
            }
            $orderby_options[$total_products] = $total_products;
            ?>

            <div class="shop-header_select">
                <span><?php esc_html_e('Show','naturally'); ?></span>
                <form class="woocommerce-ordering product-filter products-per-page" method="get">
                    <select class="form_control_select" name="perpage" onchange="this.form.submit()">
                        <?php
                        foreach( $orderby_options as $value => $label ) { ?>
                            <option value="<?php echo esc_attr($value); ?>" <?php echo esc_attr($per_page == $value ? 'selected="selected"' : ''); ?>><?php echo esc_html($label);?></option>
                        <?php } ?>
                    </select>
                    <?php wc_query_string_form_fields( null, array( 'perpage', 'submit', 'paged', 'product-page' ) ); ?>
                </form>
            </div>
            <?php
        }
    }
}

if ( !function_exists( 'naturally_pre_get_products_query' ) ) {
    add_action( 'pre_get_posts', 'naturally_pre_get_products_query' );
    function naturally_pre_get_products_query( $query )
    {

        $per_page = filter_input(INPUT_GET, 'perpage', FILTER_SANITIZE_NUMBER_INT);
        if( $query->is_main_query() && !is_admin() && is_post_type_archive( 'product' ) ) {
            if( $per_page == null ) {
                $query->set( 'posts_per_page', naturally_settings('shop_perpage','12') );
            } else {
                $query->set( 'posts_per_page', $per_page );
            }
        }
    }
}


/*************************************************
## CHANGE NUMBER OF RELATED PRODUCTS OUTPUT
*************************************************/

if ( !function_exists( 'naturally_woo_related_products_limit' ) ) {

    add_filter( 'woocommerce_output_related_products_args', 'naturally_woo_related_products_limit', 20 );
    function naturally_woo_related_products_limit( $args ) {
        $args['posts_per_page'] = naturally_settings('single_shop_related_count', '6'); // 4 related products // arranged in 2 columns
        return $args;
    }
}

/*************************************************
## CHANGE NUMBER OF RELATED PRODUCTS OUTPUT
*************************************************/
add_action( 'naturally_shop_before_headline', 'naturally_shop_banner', 10 );
if ( !function_exists( 'naturally_shop_banner' ) ) {

    function naturally_shop_banner() {

        if (class_exists('\Elementor\Frontend')) {

            if (!empty(naturally_settings('shop_banner_templates'))) {

                wp_enqueue_style('naturally-elementor');
                $template_id = naturally_settings('shop_banner_templates');
                $frontend = new \Elementor\Frontend;
                printf( '%1$s', $frontend->get_builder_content( $template_id, true ) );

            }
        }
    }
}

add_action( 'naturally_shop_before_main_content', 'naturally_shop_before_content', 10 );
if ( !function_exists( 'naturally_shop_before_content' ) ) {

    function naturally_shop_before_content() {

        if (class_exists('\Elementor\Frontend')) {

            if (!empty(naturally_settings('shop_before_content_templates'))) {

                wp_enqueue_style('naturally-elementor');
                $template_id = naturally_settings('shop_before_content_templates');
                $frontend = new \Elementor\Frontend;
                printf( '%1$s', $frontend->get_builder_content( $template_id, true ) );

            }
        }
    }
}

add_action( 'woocommerce_after_main_content', 'naturally_shop_after_content', 10 );
if ( !function_exists( 'naturally_shop_after_content' ) ) {

    function naturally_shop_after_content() {

        if (class_exists('\Elementor\Frontend')) {

            if (!empty(naturally_settings('shop_after_content_templates'))) {

                wp_enqueue_style('naturally-elementor');
                $template_id = naturally_settings('shop_after_content_templates');
                $frontend = new \Elementor\Frontend;
                printf( '%1$s', $frontend->get_builder_content( $template_id, true ) );

            }
        }
    }
}


/*************************************************
## REGISTER SIDEBAR FOR WOOCOMMERCE
*************************************************/

if ( !function_exists( 'naturally_woo_widgets_init' ) ) {

    function naturally_woo_widgets_init()
    {
        //Shop page sidebar
        register_sidebar( array(
            'name' => esc_html__( 'Shop Page Sidebar', 'naturally' ),
            'id' => 'shop-page-sidebar',
            'description' => esc_html__( 'These widgets for the Shop page.','naturally' ),
            'before_widget' => '<div class="nt-sidebar-inner-widget nt-shop-widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h4 class="nt-sidebar-widget-title title">',
            'after_title' => '</h4>'
        ) );
        register_sidebar( array(
            'name' => esc_html__( 'Single Shop Page Sidebar', 'naturally' ),
            'id' => 'single-shop-page-sidebar',
            'description' => esc_html__( 'These widgets for the single Shop page.','naturally' ),
            'before_widget' => '<div class="nt-sidebar-inner-widget nt-shop-widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h4 class="nt-sidebar-widget-title title">',
            'after_title' => '</h4>'
        ) );
    }
    add_action( 'widgets_init', 'naturally_woo_widgets_init' );
}


/*************************************************
## ADD SECTION TO THEME OPTIONS FOR WOOCOMMERCE
*************************************************/

if ( class_exists( 'Redux' ) ) {

    if ( ! function_exists( 'naturally_dynamic_section' ) ) {

        function naturally_dynamic_section( $sections )
        {
            global $naturally_pre;

            /*************************************************
            ## SHOP PAGE SECTION
            *************************************************/
            $sections[] = array(
                'title' => esc_html__('Shop Page', 'naturally'),
                'id' => 'shopsection',
                'icon' => 'el el-shopping-cart-sign',
                'fields' => array()
            );
            $sections[] = array(
                'title' => esc_html__( 'Shop Page Layout', 'naturally' ),
                'id' => 'shoplayoutsection',
                'subsection'=> true,
                'icon' => 'el el-website',
                'fields' => array(
                    array(
                        'title' => esc_html__( 'Shop Page Layout', 'naturally' ),
                        'subtitle' => esc_html__( 'Choose the shop page layout.', 'naturally' ),
                        'id' => 'shop_layout',
                        'type' => 'image_select',
                        'options' => array(
                            'left-sidebar' => array(
                                'alt' => 'Left Sidebar',
                                'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                            ),
                            'full-width' => array(
                                'alt' => 'Full Width',
                                'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                            ),
                            'right-sidebar' => array(
                                'alt' => 'Right Sidebar',
                                'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                            ),
                        ),
                        'default' => 'full-width'
                    ),
                    array(
                        'title' => esc_html__('Shop Post Column', 'naturally'),
                        'subtitle' => esc_html__('You can control post column with this option.', 'naturally'),
                        'id' => 'shop_column',
                        'type' => 'slider',
                        'default' => 3,
                        'min' => 2,
                        'step' => 1,
                        'max' => 4,
                        'display_value' => 'text',
                    ),
                    array(
                        'title' => esc_html__('Shop Post Count', 'naturally'),
                        'subtitle' => esc_html__('You can control show post count with this option.', 'naturally'),
                        'id' => 'shop_perpage',
                        'type' => 'slider',
                        'default' => 12,
                        'min' => 1,
                        'step' => 1,
                        'max' => count( get_posts( array('post_type' => 'product', 'post_status' => 'publish', 'fields' => 'ids', 'posts_per_page' => '-1') ) ),
                        'display_value' => 'text'
                    ),
                    array(
                        'title' => esc_html__('Rate of Increase for the Show Select Box', 'naturally'),
                        'id' => 'shop_rate_of_increase',
                        'type' => 'slider',
                        'default' => 5,
                        'min' => 1,
                        'step' => 1,
                        'max' => count( get_posts( array('post_type' => 'product', 'post_status' => 'publish', 'fields' => 'ids', 'posts_per_page' => '-1') ) ),
                        'display_value' => 'text'
                    ),
                    array(
                        'title' => esc_html__('Elementor Templates ( for Shop Before Hero )', 'naturally'),
                        'subtitle' => esc_html__('Select a template from elementor templates.', 'naturally'),
                        'id' => 'shop_banner_templates',
                        'type' => 'select',
                        'customizer' => true,
                        'options' => naturally_get_elementorTemplates()
                    ),
                    array(
                        'title' => esc_html__('Elementor Templates ( for Before Shop Content )', 'naturally'),
                        'subtitle' => esc_html__('Select a template from elementor templates.', 'naturally'),
                        'id' => 'shop_before_content_templates',
                        'type' => 'select',
                        'customizer' => true,
                        'options' => naturally_get_elementorTemplates()
                    ),
                    array(
                        'title' => esc_html__('Elementor Templates ( for After Shop Content )', 'naturally'),
                        'subtitle' => esc_html__('Select a template from elementor templates.', 'naturally'),
                        'id' => 'shop_after_content_templates',
                        'type' => 'select',
                        'customizer' => true,
                        'options' => naturally_get_elementorTemplates()
                    ),
                    array(
                        'title' => esc_html__('Price Color', 'naturally'),
                        'id' => 'shop_price_color',
                        'type' => 'color',
                        'default' => '',
                        'output' => array('.woocommerce div.product p.price, .woocommerce div.product span.price,.woocommerce div.product.shop-product p.price, .woocommerce div.product.shop-product span.price, .woocommerce div.product.shop-product2 p.price, .woocommerce div.product.shop-product2 span.price,.woocommerce div.product p.price ins, .woocommerce div.product span.price ins, table td ins')
                    ),
                    array(
                        'title' => esc_html__('Price Color 2', 'naturally'),
                        'id' => 'shop_price_color2',
                        'type' => 'color',
                        'default' => '',
                        'output' => array('.woocommerce .price del')
                    ),
                    array(
                        'title' => esc_html__('Wishlist Counter Scroll Button Display', 'naturally'),
                        'id' => 'wishlist_btn_visibility',
                        'type' => 'switch',
                        'default' => 1,
                        'on' => 'On',
                        'off' => 'Off'
                    ),
                )
            );
            $sections[] = array(
                'title' => esc_html__( 'Shop Hero', 'naturally' ),
                'id' => 'shopherosection',
                'subsection'=> true,
                'icon' => 'el el-website',
                'fields' => array(
                    array(
                        'title' => esc_html__('Shop Hero Section Display', 'naturally'),
                        'subtitle' => esc_html__('You can enable or disable the shop page headline section with this option.', 'naturally'),
                        'id' => 'shop_hero_visibility',
                        'type' => 'switch',
                        'default' => 1,
                        'on' => 'On',
                        'off' => 'Off'
                    ),
                    array(
                        'title' => esc_html__('Shop Page Subtitle', 'naturally'),
                        'subtitle' => esc_html__('Add your shop page sub-title here.', 'naturally'),
                        'id' => 'shop_page_subtitle',
                        'type' => 'text',
                        'default' => '',
                        'required' => array( 'shop_hero_visibility', '=', '1' )
                    ),
                    array(
                        'title' => esc_html__('Shop Page Title Typography', 'naturally'),
                        'id' => 'shop_hero_title_typo',
                        'type' => 'typography',
                        'font-backup' => false,
                        'letter-spacing' => true,
                        'text-transform' => true,
                        'all_styles' => true,
                        'output' => array( '.archive .shop-hero .headline_title' ),
                        'default' => array(
                            'color' => '',
                            'font-style' => '',
                            'font-family' => '',
                            'google' => true,
                            'font-size' => '',
                            'line-height' => ''
                        ),
                        'required' => array( 'shop_hero_visibility', '=', '1' )
                    ),
                    array(
                        'title' => esc_html__('Shop Page Title Color', 'naturally'),
                        'id' => 'shop_hero_title_color',
                        'type' => 'color',
                        'output' => array( '.archive .shop-hero .headline_title' ),
                        'required' => array( 'shop_hero_visibility', '=', '1' ),
                    ),
                    array(
                        'title' => esc_html__('Shop Page Subtitle Color', 'naturally'),
                        'id' => 'shop_hero_subtitle_color',
                        'type' => 'color',
                        'output' => array( '.archive .shop-hero .headline_summary' ),
                        'required' => array( 'shop_hero_visibility', '=', '1' ),
                    ),
                    array(
                        'title' => esc_html__('Shop Page Breadcrumbs Color', 'naturally'),
                        'id' => 'shop_hero_bread_color',
                        'type' => 'color',
                        'output' => array( '.archive .shop-hero .breadcrumb,.archive .shop-hero .breadcrumb a' ),
                        'required' => array( 'shop_hero_visibility', '=', '1' ),
                    ),
                    array(
                        'title' => esc_html__('Shop Page Breadcrumbs Current Color', 'naturally'),
                        'id' => 'shop_hero_bread_current_color',
                        'type' => 'color',
                        'output' => array( '.archive .shop-hero .breadcrumb,.archive .shop-hero .breadcrumb .breadcrumb_active' ),
                        'required' => array( 'shop_hero_visibility', '=', '1' ),
                    ),
                    array(
                        'title' => esc_html__('Hero Background', 'naturally'),
                        'id' => 'shop_hero_bg',
                        'type' => 'background',
                        'output' => array( '.archive .shop-hero' ),
                        'required' => array( 'shop_hero_visibility', '=', '1' ),
                    ),
                    array(
                        'title' => esc_html__('Hero Margin', 'naturally'),
                        'id' => 'shop_hero_margin',
                        'type' => 'spacing',
                        'output' => array('body.archive .shop-hero.section'),
                        'mode' => 'margin',
                        'units' => array('em', 'px'),
                        'units_extended' => 'false',
                        'default' => array(
                            'padding-top' => '',
                            'padding-right' => '',
                            'padding-bottom' => '',
                            'padding-left' => '',
                            'units' => 'px'
                        ),
                        'required' => array( 'shop_hero_visibility', '=', '1' ),
                    ),
                    array(
                        'title' => esc_html__('Hero Padding', 'naturally'),
                        'id' => 'shop_hero_padding',
                        'type' => 'spacing',
                        'output' => array('body.archive .shop-hero.section'),
                        'mode' => 'padding',
                        'units' => array('em', 'px'),
                        'units_extended' => 'false',
                        'default' => array(
                            'padding-top' => '',
                            'padding-right' => '',
                            'padding-bottom' => '',
                            'padding-left' => '',
                            'units' => 'px'
                        ),
                        'required' => array( 'shop_hero_visibility', '=', '1' ),
                    ),
                )
            );

            /*************************************************
            ## SINGLE PAGE SECTION
            *************************************************/
            $sections[] = array(
                'title' => esc_html__('Shop Single Page', 'naturally'),
                'id' => 'singleshopsection',
                'icon' => 'el el-shopping-cart-sign',
                'fields' => array()
            );
            $sections[] = array(
                'title' => esc_html__('General', 'naturally'),
                'id' => 'singleshopgeneral',
                'subsection' => true,
                'icon' => 'el el-brush',
                'fields' => array(
                    array(
                        'title' => esc_html__( 'Single Shop Page Layout', 'naturally' ),
                        'subtitle' => esc_html__( 'Choose the single shop page layout.', 'naturally' ),
                        'id' => 'single_shop_layout',
                        'type' => 'image_select',
                        'options' => array(
                            'left-sidebar' => array(
                                'alt' => 'Left Sidebar',
                                'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                            ),
                            'full-width' => array(
                                'alt' => 'Full Width',
                                'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                            ),
                            'right-sidebar' => array(
                                'alt' => 'Right Sidebar',
                                'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                            ),
                        ),
                        'default' => 'full-width'
                    ),
                    array(
                        'title' => esc_html__('Single Related', 'naturally'),
                        'subtitle' => esc_html__('If enabled, shows related post at single page.', 'naturally'),
                        'id' => 'single_shop_related_visibility',
                        'type' => 'switch',
                        'default' => true
                    ),
                    array(
                        'title' => esc_html__('Single Related Title', 'naturally'),
                        'subtitle' => esc_html__('Add your single shop page related section title here.', 'naturally'),
                        'id' => 'single_shop_related_title',
                        'type' => 'textarea',
                        'default' => '',
                        'required' => array( 'single_shop_related_visibility', '=', '1' )
                    ),
                    array(
                        'title' => esc_html__('Related Post Count', 'naturally'),
                        'subtitle' => esc_html__('You can control show related post count with this option.', 'naturally'),
                        'id' => 'single_shop_related_count',
                        'type' => 'slider',
                        'default' => 6,
                        'min' => 1,
                        'step' => 1,
                        'max' => 100,
                        'display_value' => 'text',
                        'required' => array( 'single_shop_related_visibility', '=', '1' )
                    )
                )
            );
            // SHOP PAGE SECTION
            $sections[] = array(
                'title' => esc_html__('Estimated Delivery', 'naturally'),
                'id' => 'product_estimated_delivery_subsection',
                'subsection' => true,
                'icon' => 'fa fa-cog',
                'fields' => array(
                    array(
                        'title' => esc_html__('Estimated Delivery', 'naturally'),
                        'customizer' => true,
                        'id' => 'estimated_delivery_visibility',
                        'type' => 'switch',
                        'default' => 0
                    ),
                    array(
                        'title' => esc_html__('Estimated Delivery ( Min )', 'naturally'),
                        'customizer' => true,
                        'id' => 'min_estimated_delivery',
                        'type' => 'spinner',
                        'default' => '3',
                        'min' => '1',
                        'step' => '1',
                        'max' => '31',
                        'required' => array( 'estimated_delivery_visibility', '=', '1' )
                    ),
                    array(
                        'title' => esc_html__('Estimated Delivery ( Max )', 'naturally'),
                        'customizer' => true,
                        'id' => 'max_estimated_delivery',
                        'type' => 'spinner',
                        'default' => '7',
                        'min' => '1',
                        'step' => '1',
                        'max' => '31',
                        'required' => array( 'estimated_delivery_visibility', '=', '1' )
                    ),
                    array(
                        'title' => esc_html__( 'Custom Text', 'naturally' ),
                        'desc' => esc_html__( 'Text entered here will be used for Estimated Delivery area', 'naturally' ),
                        'customizer' => true,
                        'id' => 'estimated_delivery_text',
                        'type' => 'text',
                        'required' => array( 'estimated_delivery_visibility', '=', '1' )
                    ),
                    array(
                        'title' => esc_html__( 'Custom SVG Icon HTML', 'naturally' ),
                        'desc' => esc_html__( 'Icon entered here will be used for Estimated Delivery area', 'naturally' ),
                        'customizer' => true,
                        'id' => 'estimated_delivery_icon',
                        'type' => 'textarea',
                        'required' => array( 'estimated_delivery_visibility', '=', '1' )
                    ),
                    array(
                        'title' => esc_html__('Text Color', 'naturally'),
                        'customizer' => true,
                        'id' => 'product_estimated_delivery_text_color',
                        'type' => 'color',
                        'output' => array( '.naturally-estimated-delivery span' ),
                        'required' => array( 'estimated_delivery_visibility', '=', '1' )
                    ),
                    array(
                        'title' => esc_html__('Date Color', 'naturally'),
                        'customizer' => true,
                        'id' => 'product_estimated_delivery_date_color',
                        'type' => 'color',
                        'output' => array( '.naturally-estimated-delivery' ),
                        'required' => array( 'estimated_delivery_visibility', '=', '1' )
                    ),
                    array(
                        'title' => esc_html__('Icon Color', 'naturally'),
                        'customizer' => true,
                        'id' => 'product_estimated_delivery_svg_color',
                        'type' => 'color',
                        'mode' => 'fill',
                        'output' => array( '.naturally-estimated-delivery svg' ),
                        'required' => array( 'estimated_delivery_visibility', '=', '1' )
                    ),
                )
            );
            return $sections;
        }
        add_filter('redux/options/'.$naturally_pre.'/sections', 'naturally_dynamic_section');
    }
}


/************************************************************
## ADD THEME CSS SETTINGS TO WOOCOMMERCE AND WP INLINE STYLE
*************************************************************/

if ( !function_exists( 'naturally_woo_theme_css_options' ) ) {
    function naturally_woo_theme_css_options() {

        /* CSS to output */

        $theCSS = '';

        $shop_theme_color = naturally_settings('theme_color');

        // css color
        $theCSS .= '';

        /* Add CSS to naturally-custom-style.css */
        wp_register_style( 'naturally-woo-style', false );
        wp_enqueue_style( 'naturally-woo-style' );
        wp_add_inline_style( 'naturally-woo-style', $theCSS );

    }
    add_action( 'wp_enqueue_scripts', 'naturally_woo_theme_css_options' );
}

if ( ! function_exists( 'naturally_product_estimated_delivery' ) ) {
    add_action( 'woocommerce_single_product_summary', 'naturally_product_estimated_delivery', 35 );
    function naturally_product_estimated_delivery() {

        if ( '0' == naturally_settings('estimated_delivery_visibility', '1' ) ) {
            return;
        }

        $min_ed = naturally_settings('min_estimated_delivery');
        $max_ed = naturally_settings('max_estimated_delivery');

        $min   = $min_ed ? $min_ed : 3;
        $from  = '+' . $min;
        $from .= ' ' . ( $min = 1 ? 'day' : 'days' );

        $max = $max_ed ? (int) $max_ed : 7;
        $to  = '+' . $max;
        $to .= ' ' . ( $max = 1 ? 'day' : 'days' );

        $now      = get_date_from_gmt( date('Y-m-d H:i:s'), 'Y-m-d' );
        $est_days = array();

        $format     = esc_html__( 'M d', 'naturally' );
        $est_days[] = date_i18n( $format, strtotime( $now . $from ), true );
        $est_days[] = date_i18n( $format, strtotime( $now . $to ), true );

        if ( !empty( $est_days ) ) {
            ?>
            <div class="naturally-estimated-delivery">
                <?php
                if ( '' != naturally_settings('estimated_delivery_icon', '') ) {
                    echo naturally_settings('estimated_delivery_icon', '');
                } else {
                    echo '<svg class="svgShipping" width="40.124px" height="40.124px" enable-background="new 0 0 512 512" version="1.1" viewBox="0 0 512 512" xml:space="preserve"><circle cx="386" cy="210" r="20"/><path d="m432 40h-26v-20c0-11.046-8.954-20-20-20s-20 8.954-20 20v20h-91v-20c0-11.046-8.954-20-20-20s-20 8.954-20 20v20h-90v-20c0-11.046-8.954-20-20-20s-20 8.954-20 20v20h-25c-44.112 0-80 35.888-80 80v312c0 44.112 35.888 80 80 80h153c11.046 0 20-8.954 20-20s-8.954-20-20-20h-153c-22.056 0-40-17.944-40-40v-312c0-22.056 17.944-40 40-40h25v20c0 11.046 8.954 20 20 20s20-8.954 20-20v-20h90v20c0 11.046 8.954 20 20 20s20-8.954 20-20v-20h91v20c0 11.046 8.954 20 20 20s20-8.954 20-20v-20h26c22.056 0 40 17.944 40 40v114c0 11.046 8.954 20 20 20s20-8.954 20-20v-114c0-44.112-35.888-80-80-80z"/><path d="m391 270c-66.72 0-121 54.28-121 121s54.28 121 121 121 121-54.28 121-121-54.28-121-121-121zm0 202c-44.663 0-81-36.336-81-81s36.337-81 81-81 81 36.336 81 81-36.337 81-81 81z"/><path d="m420 371h-9v-21c0-11.046-8.954-20-20-20s-20 8.954-20 20v41c0 11.046 8.954 20 20 20h29c11.046 0 20-8.954 20-20s-8.954-20-20-20z"/><circle cx="299" cy="210" r="20"/><circle cx="212" cy="297" r="20"/><circle cx="125" cy="210" r="20"/><circle cx="125" cy="297" r="20"/><circle cx="125" cy="384" r="20"/><circle cx="212" cy="384" r="20"/><circle cx="212" cy="210" r="20"/></svg>';
                }
                ?>&nbsp;
                <span><?php
                if ( '' != naturally_settings('estimated_delivery_text', '') ) {
                    echo naturally_settings('estimated_delivery_text', '');
                } else {
                    esc_html_e( 'Estimated Delivery:', 'naturally' );
                }
                ?>&nbsp;</span>
                <?php echo implode( ' - ', $est_days ); ?>
            </div>
            <?php
        }
    }
}

}// end if class_exists (WooCommerce)
