<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
$naturally_shop_column = 6;
$naturally_shop_column = apply_filters( 'naturally_shop_column', naturally_settings('shop_column', $naturally_shop_column) );
?>

<div class="grid_col is-12 is-sm-6 is-lg-4 is-xl-6" data-ntr-animation='{"name":"fadein-up"}'>
	<div <?php wc_product_class( 'shop-product2 hover-shadow', $product ); ?>>
		<?php
		/**
		 * Hook: woocommerce_before_shop_loop_item.
		 *
		 * @hooked woocommerce_template_loop_product_link_open - 10
		 */
		do_action( 'woocommerce_before_shop_loop_item' );
		?>
		<?php
		/**
		 * Hook: woocommerce_before_shop_loop_item_title.
		 *
		 * @hooked woocommerce_show_product_loop_sale_flash - 10
		 * @hooked woocommerce_template_loop_product_thumbnail - 10
		 */
		 do_action( 'woocommerce_before_shop_loop_item_title' );
		?>
		<div class="shop-product2_body">
			<?php
			/**
			 * Hook: woocommerce_shop_loop_item_title.
			 *
			 * @hooked woocommerce_template_loop_product_title - 10
			 */
			do_action( 'woocommerce_shop_loop_item_title' );
			?>
			<?php
			/**
			* Hook: woocommerce_after_shop_loop_item_title.
			*
			* @hooked woocommerce_template_loop_rating - 5
			* @hooked woocommerce_template_loop_price - 10
			*/
			do_action( 'woocommerce_after_shop_loop_item_title' );
			?>
		</div>
		<?php
		/**
		 * Hook: woocommerce_after_shop_loop_item.
		 *
		 * @hooked woocommerce_template_loop_product_link_close - 5
		 * @hooked woocommerce_template_loop_add_to_cart - 10
		 */
		do_action( 'woocommerce_after_shop_loop_item' );
		?>
	</div>
</div>
