<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


$section_title = naturally_settings('single_shop_related_title');
$section_title = $section_title ? $section_title : esc_html__( 'Related products', 'naturally' );
if ( $related_products ) : ?>

<div class="section related-slider-section mb-0">
	<div class="container-off">
		<!-- Slider Products -->
		<div class="slider-products" data-ntr-slider-products>
			<h2 class="slider-products_title"><?php echo wp_kses( $section_title, naturally_allowed_html()); ?></h2>
			<div class="slick-slider">

				<?php foreach ( $related_products as $related_product ) : ?>
					<div class="slick-slide">
					<?php
					 	$post_object = get_post( $related_product->get_id() );

						setup_postdata( $GLOBALS['post'] = $post_object );

						wc_get_template_part( 'content', 'product' ); ?>
					</div>
				<?php endforeach; ?>

			</div>
		</div>
	</div>
</div>

<?php endif;

wp_reset_postdata();
