<?php
/**
 * Single Product Up-Sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/up-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $upsells ) : ?>

	<section class="section up-sells upsells products mb-0">

		<h3 class="slider-products_title"><?php esc_html_e( 'You may also like&hellip;', 'naturally' ); ?></h3>

		<div class="shop-products is-grid-4">
			<div class="grid">
				<div class="grid_row is-40">

					<?php foreach ( $upsells as $upsell ) : ?>
						<div class="grid_col" data-ntr-animation='{"name":"fadein-up"}'>

							<?php
								$post_object = get_post( $upsell->get_id() );

								setup_postdata( $GLOBALS['post'] = $post_object );

								wc_get_template_part( 'content', 'product' );
							?>
						</div>
					<?php endforeach; ?>

				</div>
			</div>
		</div>

	</section>

<?php endif;

wp_reset_postdata();
