<?php
/**
 * YITH WooCommerce Ajax Search template
 *
 * @author YITH
 * @package YITH WooCommerce Ajax Search
 * @version 1.1.1
 */

if ( ! defined( 'YITH_WCAS' ) ) {
	exit; } // Exit if accessed directly
wp_enqueue_script( 'yith_wcas_frontend' );

?>

<div class="header_search yith-ajaxsearchform-container">
    <div class="container">
    	<form role="search" method="get" class="header_search_form " id="yith-ajaxsearchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
    		<div>
                <input class="yith-s header_search_input" type="search" value="<?php echo esc_attr( get_search_query() ); ?>" placeholder="<?php echo esc_attr__('Search...', 'naturally'); ?>" name="s" id="yith-s" data-loader-icon="<?php echo esc_attr( str_replace( '"', '', apply_filters( 'yith_wcas_ajax_search_icon', '' ) ) ); ?>" data-min-chars="<?php echo esc_attr( get_option( 'yith_wcas_min_chars' ) ); ?>">
                <button class="header_search_button" id="yith-searchsubmit" type="submit"><span class="icon is-search"></span></button>
                <button class="header_search_close" type="button"><span class="icon is-close"></span></button>
    			<input type="hidden" name="post_type" value="product" />
    			<?php do_action( 'wpml_add_language_form_field' ); ?>
    		</div>
    	</form>
    </div>
</div>
