/* NT Addons for Elementor v1.0 */

!(function ($) {
    // ntrSliderHero
    // ntrSliderHero
    function ntrSliderHero($scope, $) {
        $scope.find('.slider-hero .slick-slider').each(function () {
            var ntrSliderHero = $( this );
            var ntrSliderData = ntrSliderHero.data('slider-options');
            var myHeight = ntrSliderData.height;
            var myAutoplay = ntrSliderData.autoplay;
            var mySpeed = ntrSliderData.speed;
            if(!ntrSliderHero.length) return;
            ntrSliderHero.not('.slick-initialized').slick({
                dots: false,
                fade: true,
                adaptiveHeight: myHeight,
                autoplay: myAutoplay,
                speed: mySpeed,
                cssEase: 'linear',
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 1200,
                        settings: {
                            arrows: false,
                            dots: true
                        }
                    },
                ]
            });
        });
        $scope.find('.slider-hero2 .slick-slider').each(function () {
            var ntrSliderHero2 = $( this );
            if(!ntrSliderHero2.length) return;
            var ntrSliderData = ntrSliderHero2.data('slider-options');
            var myHeight = ntrSliderData.height;
            var myAutoplay = ntrSliderData.autoplay;
            var mySpeed = ntrSliderData.speed;
            ntrSliderHero2.not('.slick-initialized').slick({
                arrows: false,
                dots: true,
                fade: true,
                adaptiveHeight: myHeight,
                autoplay: myAutoplay,
                speed: mySpeed,
                cssEase: 'linear',
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
            });
        });
    }
    // categoriesSlider
    function categoriesSlider($scope, $) {
        $scope.find('.slider-categories .slick-slider').each(function () {
            var categoriesSlider = $( this );
            if(!categoriesSlider.length) return;
            categoriesSlider.not('.slick-initialized').slick({
                autoplay: true,
                slidesToShow: 5,
                speed: 300,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 3,
                        }
                    },
                    {
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 4,
                        }
                    }
                ]
            });
        });
    }
    // ntrSliderDeals
    function ntrSliderDeals($scope, $) {
        $scope.find('.slider-deals .slick-slider').each(function () {
            var ntrSliderDeals = $( this );
            if(!ntrSliderDeals.length) return;
            ntrSliderDeals.not('.slick-initialized').slick({
                autoplay: true,
                slidesToShow: 1,
                speed: 300,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 3,
                        }
                    },
                ]
            });
        });
    }
    // ntrSliderTestimonials
    function ntrSliderTestimonials($scope, $) {
        $scope.find('.slider-testimonials .slick-slider').each(function () {
            var ntrSliderTestimonials = $( this );
            if(!ntrSliderTestimonials.length) return;
            ntrSliderTestimonials.not('.slick-initialized').slick({
                arrows: false,
                dots: true,
                speed: 300,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
            });
        });
    }
    // ntrSliderTestimonials2
    function ntrSliderTestimonials2($scope, $) {
        $scope.find('.slider-testimonials2 .slick-slider').each(function () {
            var ntrSliderTestimonials2 = $( this );
            if(!ntrSliderTestimonials2.length) return;
            ntrSliderTestimonials2.not('.slick-initialized').slick({
                speed: 300,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 768,
                        settings: {
                            arrows: false,
                            dots: true
                        }
                    },
                ]
            });
        });
    }
    // ntrSliderTestimonials3
    function ntrSliderTestimonials3($scope, $) {
        $scope.find('.slider-testimonials3 .slick-slider').each(function () {
            var ntrSliderTestimonials3 = $( this );
            var data = ntrSliderTestimonials3.data('slider-options');
            if(!ntrSliderTestimonials3.length) return;
            var autoplay = data.autoplay;
            var speed = data.speed;
            ntrSliderTestimonials3.not('.slick-initialized').slick({
                arrows: false,
                dots: true,
                speed: speed,
                autoplay: autoplay,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
            });
        });
    }
    // ntrSliderBlog2
    function ntrSliderBlog2($scope, $) {
        $scope.find('.slider-blog2 .slick-slider').each(function () {
            var ntrSliderBlog2 = $( this );
            if(!ntrSliderBlog2.length) return;
            var data = ntrSliderBlog2.data('slider-options');
            var autoplay = data.autoplay;
            var speed = data.speed;
            ntrSliderBlog2.not('.slick-initialized').slick({
                arrows: false,
                dots: true,
                speed: speed,
                autoplay: autoplay,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
            });
        });
    }
    // ntrSliderBlog
    function ntrSliderBlog($scope, $) {
        $scope.find('[data-ntr-slider-blog]').each(function () {
            var myContainer = $('[data-ntr-slider-blog]');
            if(!myContainer.length) return;
            var mySlick = $('.slick-slider', myContainer);
            mySlick.slick({
                arrows: false,
                dots: true,
                speed: 300,
                slidesToShow: 3,
                slidesToScroll: 1,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 2,
                        }
                    }
                ]
            });
        });
        $scope.find('.slider-blog3 .slick-slider').each(function () {
            var ntrSliderBlog3 = $( this );
            if(!ntrSliderBlog3.length) return;
            ntrSliderBlog3.not('.slick-initialized').slick({
                arrows: false,
                dots: true,
                centerMode: true,
                adaptiveHeight: true,
                slidesToShow: 1,
                centerPadding: '25%',
                speed: 300,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 768,
                        settings: {
                            centerPadding: '30px',
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            centerPadding: '60px',
                        }
                    },
                    {
                        breakpoint: 1200,
                        settings: {
                            centerPadding: '120px',
                        }
                    }
                ]
            });
        });
    }
    // ntrSliderLogos
    function ntrSliderLogos($scope, $) {
        $scope.find('.slider-logos .slick-slider').each(function () {
            var ntrSliderLogos = $( this );
            if(!ntrSliderLogos.length) return;
            ntrSliderLogos.not('.slick-initialized').slick({
                arrows: false,
                dots: true,
                autoplay: true,
                speed: 300,
                slidesToShow: 5,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 3,
                        }
                    },
                ]
            });
        });
    }
    // ntrSliderPhotos
    function ntrSliderPhotos($scope, $) {
        $scope.find('.slider-photos .slick-slider').each(function () {
            var ntrSliderPhotos = $( this );
            if(!ntrSliderPhotos.length) return;
            ntrSliderPhotos.not('.slick-initialized').slick({
                arrows: false,
                dots: true,
                infinite: false,
                speed: 300,
                slidesToShow: 3,
                prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                responsive: [
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                        }
                    },
                ]
            });
        });
    }
    // ntrSliderCategories2
    function ntrSliderCategories2($scope, $) {
        $scope.find('[data-ntr-shop-categories2]').each(function () {
            var myContainer = $('[data-ntr-shop-categories2]');
            if (myContainer.length) {
                var mySlick = $('.slick-slider', myContainer);
                mySlick.not('.slick-initialized').slick({
                    autoplay: true,
                    slidesToShow: 4,
                    speed: 300,
                    prevArrow: '<span class="slick-prev"><span class="icon is-back"></span></span>',
                    nextArrow: '<span class="slick-next"><span class="icon is-next"></span></span>',
                    responsive: [
                        {
                            breakpoint: 576,
                            settings: {
                                slidesToShow: 1,
                            }
                        },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 2,
                            }
                        },
                        {
                            breakpoint: 992,
                            settings: {
                                slidesToShow: 3,
                            }
                        },
                        {
                            breakpoint: 1200,
                            settings: {
                                slidesToShow: 4,
                            }
                        }
                    ]
                });
            }
        });
    }
    // ntrCounter
    function ntrCounter($scope, $) {
        $scope.find('[data-ntr-counter]').each(function () {
            var myCounters = $('[data-ntr-counter]');
            if (myCounters.length) {
                myCounters.each(function (i, el) {
                    var myCounter = $(el);
                    var myData = myCounter.data('ntrCounter');
                    new Waypoint({
                        element: myCounter,
                        handler: function(direction) {
                            var self = this;
                            if (direction === 'down') {
                                $('.counter_number', myCounter).countTo({
                                    from: myData.from || 0,
                                    to: myData.to || 100,
                                    speed: myData.speed || 5000,
                                    refreshInterval: myData.refreshInterval || 100,
                                });
                                self.destroy();
                            }
                        },
                        offset: '95%'
                    });
                });
            }
        });
    }
    // ntrAccordion
    function ntrAccordion($scope, $) {
        $scope.find('.accordion').each(function () {
            var myAccordions = $(this);
            if (myAccordions.length) {
                myAccordions.each(function (i, el) {
                    var myAccordion = $(el);
                    var myMode = myAccordion.data('ntr-accordion') === 'multiple' ? 'multiple' : 'single';
                    var myItems = $('.accordion_item', myAccordion);
                    var myIcons = $('.accordion_item_icon', myAccordion);
                    // If Active
                    myItems.filter('.is-active').find('.accordion_item_icon').toggleClass('is-arrow-right2 is-arrow-down2');
                    // Click
                    $('.accordion_item_header', myAccordion).on('click', function (e) {
                        e.preventDefault();
                        var self = $(this);
                        var selfItem = self.parent('.accordion_item');
                        var selfIcon = $('.accordion_item_icon', self);
                        selfItem.toggleClass('is-active');
                        selfIcon.toggleClass('is-arrow-right2 is-arrow-down2');
                        if (myMode === 'single') {
                            myItems.not(selfItem).removeClass('is-active');
                            myIcons.not(selfIcon).removeClass('is-arrow-down2').addClass('is-arrow-right2');
                        }
                    });
                });
            }
        });
    }
    // ntrAccordion
    function ntrTabs($scope, $) {
        $scope.find('[data-ntr-tab]').each(function () {
            var myTabs = $('[data-ntr-tab]');
            if (myTabs.length) {
                myTabs.each(function (i, el) {
                    var myTab = $(el);
                    var myTabItems = $('> .tab_nav .tab_nav_item', myTab);
                    var myTabPages = $('> .tab_page', myTab);
                    var myActiveTab = myTabItems.first();
                    if (myTabItems.filter('.is-active').length) {
                        myActiveTab = myTabItems.filter('.is-active').first();
                    }
                    var myActiveTabId = myActiveTab.data('id');
                    myTabItems.filter('[data-id="'+ myActiveTabId +'"]').addClass('is-active');
                    myTabPages.filter('[data-id="'+ myActiveTabId +'"]').addClass('is-active');
                    myTabItems.on('click', function (e) {
                        e.preventDefault();
                        var self = $(this);
                        var selfId = self.data('id');
                        myTabItems.removeClass('is-active');
                        myTabPages.removeClass('is-active');
                        self.addClass('is-active');
                        myTabPages.filter('[data-id="'+ selfId +'"]').addClass('is-active');
                    });
                });
            }
        });
    }
    // ntrAlert
    function ntrAlert($scope, $) {
        $scope.find('[data-ntr-alert]').each(function () {
            var myAlerts = $('[data-ntr-alert]');
            if (myAlerts.length) {
                myAlerts.each(function (i, el) {
                    var myAlert = $(el);
                    var myAlertClose = $('.alert_close', myAlert);
                    myAlertClose.on('click', function (e) {
                        e.preventDefault();
                        myAlert.hide();
                    });
                });
            }
        });
    }
    // ntrBackground2
    function ntrBackground2($scope, $) {
        $scope.find('[data-ntr-background]').each(function () {
            var myElements = $('[data-ntr-background]');
            if (myElements.length) {
                myElements.each(function (i, el) {
                    var myElement = $(el);
                    var myBackground = myElement.data('ntrBackground');
                    if (!myBackground) {
                        return true; // next iteration
                    }
                    myElement.css({'background-image': 'url("'+ myBackground +'")'});
                    myElement.removeAttr('data-ntr-background');
                });
            }
        });
    }

    // ntrIsotope
    function ntrIsotope($scope, $) {
        $scope.find('[data-ntr-isotope]').each(function () {
            var myIsotopes = $('[data-ntr-isotope]');
            if (myIsotopes.length) {
                myIsotopes.each(function (i, el) {
                    var myIsotope = $(el);
                    var myData = myIsotope.data('ntrIsotope');
                    if (!myData.itemSelector) {
                        return true; // next iteration
                    }
                    myIsotope.imagesLoaded(function() {
                        // Isotope Options
                        var myIsotopeOptions = {
                            percentPosition: true,
                            layoutMode: myData.layoutMode || 'masonry',
                            itemSelector: myData.itemSelector,
                            masonry: {
                                columnWidth: '.grid_sizer'
                            }
                        };
                        // Isotope Init
                        myIsotope.isotope(myIsotopeOptions);
                        // Isotope Filter
                        if ($('[data-ntr-isotope-filter]').length) {
                            var myFilters = $('[data-ntr-isotope-filter]').filter(function (i, el) {
                                var myFilter = $(el);
                                var myFilterData = myFilter.data('ntrIsotopeFilter');
                                return myFilterData.name === myData.name && myFilterData.selector;
                            });
                            if (myFilters.length) {
                                myFilters.on('click', function (e) {
                                    e.preventDefault();
                                    var myFilter = $(this);
                                    var myFilterData = myFilter.data('ntrIsotopeFilter');
                                    var myFilterSelector = myFilterData.selector;
                                    var myFilterParent = myFilter.parent();
                                    myFilterParent.siblings().removeClass('is-active');
                                    myFilterParent.addClass('is-active');
                                    myIsotope.isotope({filter: myFilterSelector});
                                });
                            }
                        }
                    });
                });
            }
        });
    }
    // ntrUITooltip2
    function ntrUITooltip2($scope, $) {
        $scope.find('[data-ntr-ui-tooltip]').each(function () {
            var myTooltips = $('[data-ntr-ui-tooltip]');
            if (myTooltips.length) {
                myTooltips.each(function (i, el) {
                    var myTooltip = $(el);
                    var myData = myTooltip.data('ntrUiTooltip');
                    if (!myData) {
                        return true; // next iteration
                    }
                    var myPosition = {};
                    var myClasses = {
                        'ui-tooltip': 'ui-corner-all ui-widget-shadow'
                    };
                    if (myData.position === 'top') {
                        myPosition.my = 'center bottom-25';
                        myPosition.at = 'center top';
                        myClasses = {
                            'ui-tooltip': 'ui-corner-all ui-widget-shadow is-top'
                        };
                    }
                    if (myData.position === 'left') {
                        myPosition.my = 'right-25 center';
                        myPosition.at = 'left center';
                        myClasses = {
                            'ui-tooltip': 'ui-corner-all ui-widget-shadow is-left'
                        };
                    }
                    if (myData.position === 'right') {
                        myPosition.my = 'left+25 center';
                        myPosition.at = 'right center';
                        myClasses = {
                            'ui-tooltip': 'ui-corner-all ui-widget-shadow is-right'
                        };
                    }
                    if (myData.position === 'bottom') {
                        myPosition.my = 'center top+25';
                        myPosition.at = 'center bottom';
                        myClasses = {
                            'ui-tooltip': 'ui-corner-all ui-widget-shadow is-bottom'
                        };
                    }
                    myTooltip.tooltip({
                        classes: myClasses,
                        position: myPosition,
                        items: myTooltip,
                        content: function () {
                            return myData.content;
                        }
                    });
                });
            }
        });
    }
    // ntrNavMenus
    function ntrNavMenus($scope, $) {
        var myHeader = $('[data-ntr-custom-header]');
        if (myHeader.length) {
            var myHeaderNav = $('.header_nav');
            var myHeaderNavArrows = $('.header_nav_arrow', myHeaderNav);
            var myHeaderNavToggle = $('.header_nav_toggle', myHeader);
            var myHeaderNavClose = $('.header_nav_close', myHeader);
            var myHeaderHandlers = {
                navOpen: function () {
                    myHeaderNav.addClass('is-active');
                    $(document).on('click.ntrHeaderNav', function (e) {
                        if (!$(e.target).closest(myHeaderNavToggle).length) {
                            if (!$(e.target).closest(myHeaderNav).length) {
                                myHeaderHandlers.navClose();
                            }
                        }
                    });
                    $(document).on('keyup.ntrHeaderNav', function (e) {
                        if (e.keyCode === 27) {
                            myHeaderHandlers.navClose();
                        }
                    });
                },
                navClose: function () {
                    myHeaderNav.removeClass('is-active');
                    $(document).off('click.ntrHeaderNav');
                    $(document).off('keyup.ntrHeaderNav');
                },
            };

            // Conditional Handlers
            var myMedia = window.matchMedia('(max-width: 1199px)');
            var myMediaHandler = function (m) {
                if (m.matches) {
                    myHeaderNavToggle.on('click.ntrHeaderNavToggle', function (e) {
                        e.preventDefault();
                        if (myHeaderNav.hasClass('is-active')) {
                            myHeaderHandlers.navClose();
                        } else {
                            myHeaderHandlers.navOpen();
                        }
                    });
                    myHeaderNavClose.on('click.ntrHeaderNavClose', function (e) {
                        e.preventDefault();
                        myHeaderHandlers.navClose();
                    });
                    myHeaderNavArrows.on('click.ntrHeaderNavArrows', function (e) {
                        e.preventDefault();
                        var myArrow = $(this);
                        var myParent = myArrow.parent('li');
                        if (myParent.hasClass('is-active')) {
                            myParent.removeClass('is-active');
                            $('.icon', myArrow).toggleClass('is-arrow-up2 is-arrow-down2');
                        } else {
                            myParent.addClass('is-active');
                            $('.icon', myArrow).toggleClass('is-arrow-down2 is-arrow-up2');
                        }
                    });
                } else {
                    // Remove Nav Events
                    $(document).off('click.ntrHeaderNav');
                    $(document).off('keyup.ntrHeaderNav');
                    myHeaderNavToggle.off('click.ntrHeaderNavToggle');
                    myHeaderNavClose.off('click.ntrHeaderNavClose');
                    myHeaderNavArrows.off('click.ntrHeaderNavArrows');
                }
            };
            myMedia.addListener(myMediaHandler);
            myMediaHandler(myMedia);

            // Sticky
            if (myHeader.hasClass('is-sticky')) {
                var myWindow = $(window);
                var myHeaderHolder = $('.header_holder', myHeader);
                var myHeaderContainer = $('.header_container', myHeader);
                var mystickyOffset = myHeader.attr('data-ntr-sticky-offset');
                var myHeaderHeight = myHeaderContainer.outerHeight();
                var mystickyOffset = myHeaderContainer.offset().top;
                var mystickyOffsetone = mystickyOffset ? mystickyOffset : myHeaderHeight;
                var mystickyOffsetTwo = mystickyOffset ? mystickyOffset+myHeaderHeight : 1;
                var myHeaderTimer;
                if (!myHeader.hasClass('is-overlay')) {
                    myHeaderHolder.css({'height': myHeaderHeight});
                }
                myWindow.on('scroll', function() {
                    if (myHeaderTimer) {
                        clearTimeout(myHeaderTimer);
                    }
                    //myHeaderTimer = setTimeout(function() {
                    if (myWindow.scrollTop() > mystickyOffsetone) {
                        myHeader.addClass('is-sticky-active');
                    } else if (myWindow.scrollTop() < mystickyOffsetTwo ) {
                        myHeader.removeClass('is-sticky-active');
                    }
                    //}, 200);

                });
            }
        }
    }
    // ntrHeaderMiniCart
    function ntrHeaderMiniCart($scope, $) {

        if ($('body').hasClass('elementor-page')) {
            $scope.find('.naturally_mini_cart').each(function () {
                var myHeader = $(this);
                if (myHeader.length) {
                    var myHeaderCart = $('.header_cart', myHeader);
                    var myHeaderCartLabel = $('.header_cart_label', myHeader);
                    var myHeaderHandlers = {
                        cartOpen: function () {
                            myHeaderCart.addClass('is-active');
                            $(document).on('click.ntrHeaderCart', function (e) {
                                if (!$(e.target).closest(myHeaderCart).length) {
                                    myHeaderHandlers.cartClose();
                                }
                            });
                            $(document).on('keyup.ntrHeaderCart', function (e) {
                                if (e.keyCode === 27) {
                                    myHeaderHandlers.cartClose();
                                }
                            });
                        },
                        cartClose: function () {
                            myHeaderCart.removeClass('is-active');
                            $(document).off('click.ntrHeaderCart');
                            $(document).off('keyup.ntrHeaderCart');
                        },
                    };
                    // Conditional Handlers
                    var myMedia = window.matchMedia('(max-width: 1199px)');
                    var myMediaHandler = function (m) {
                        if (m.matches) {
                            myHeaderCartLabel.on('click.ntrHeaderCartLabel', function (e) {
                                //e.preventDefault();
                                if (myHeaderCart.hasClass('is-active')) {
                                    myHeaderHandlers.cartClose();
                                } else {
                                    myHeaderHandlers.cartOpen();
                                }
                            });
                        } else {
                            // Remove Cart Events
                            $(document).off('click.ntrHeaderCart');
                            $(document).off('keyup.ntrHeaderCart');
                            myHeaderCartLabel.off('click.ntrHeaderCartLabel');
                        }
                    };
                    myMedia.addListener(myMediaHandler);
                    myMediaHandler(myMedia);
                }
            });
        } else {
            var myMedia = window.matchMedia('(max-width: 1199px)');
            var myHeaderCart = $('.header_cart');
            var myHeaderCartLabel = $('.header_cart_label' );
            var myMediaHandler = function (m) {
                if (m.matches) {
                    myHeaderCartLabel.on('click', function (e) {
                        //e.preventDefault();
                        if (myHeaderCart.hasClass('is-active')) {
                            myHeaderCart.removeClass('is-active');
                        } else {
                            myHeaderCart.addClass('is-active');
                        }
                    });
                }
            };
        }
    }
    // ntrHeaderSearchForm
    function ntrHeaderSearchForm($scope, $) {
        $scope.find('.naturally_header_search').each(function () {
            var myHeader = $('[data-ntr-header-search]');
            if (myHeader.length) {
                var myHeaderSearch = $('.naturally_header_search_form', myHeader);
                var myHeaderSearchForm = $('.header_search_form', myHeader);
                var myHeaderSearchInput = $('.header_search_input', myHeader);
                var myHeaderSearchOpen = $('.header_search_open', myHeader);
                var myHeaderSearchClose = $('.header_search_close', myHeader);
                $('.naturally_header_search_form.header_search').prependTo('body');
                var myHeaderHandlers = {
                    searchOpen: function () {
                        myHeaderSearch.addClass('is-active');
                        myHeaderSearchInput.focus();
                        $(document).on('click.ntrHeaderSearch', function (e) {
                            if (!$(e.target).closest(myHeaderSearchOpen).length) {
                                if (!$(e.target).closest(myHeaderSearch).length) {
                                    myHeaderHandlers.searchClose();
                                }
                            }
                        });
                        $(document).on('keyup.ntrHeaderSearch', function (e) {
                            if (e.keyCode === 27) {
                                myHeaderHandlers.searchClose();
                            }
                        });
                    },
                    searchClose: function () {
                        myHeaderSearch.removeClass('is-active');
                        myHeaderSearchForm[0].reset();
                        $(document).off('click.ntrHeaderSearch');
                        $(document).off('keyup.ntrHeaderSearch');
                    },
                };

                // Handlers
                myHeaderSearchOpen.on('click', function (e) {
                    e.preventDefault();
                    if (myHeaderSearch.hasClass('is-active')) {
                        myHeaderHandlers.searchClose();
                    } else {
                        myHeaderHandlers.searchOpen();
                    }
                });
                myHeaderSearchClose.on('click', function (e) {
                    e.preventDefault();
                    myHeaderHandlers.searchClose();
                });
            }
        });
    }
    // ntrHeaderLangs
    function ntrHeaderLangs($scope, $) {
        $scope.find('.naturally_langs_wrapper').each(function () {
            var myHeader = $('[data-ntr-header-langs]');
            if (myHeader.length) {
                var myHeaderLang = $('.header_lang', myHeader);
                var myHeaderLangLabel = $('.header_lang_label', myHeader);
                var myHeaderHandlers = {
                    langOpen: function () {
                        myHeaderLang.addClass('is-active');
                        $(document).on('click.ntrHeaderLang', function (e) {
                            if (!$(e.target).closest(myHeaderLang).length) {
                                myHeaderHandlers.langClose();
                            }
                        });
                        $(document).on('keyup.ntrHeaderLang', function (e) {
                            if (e.keyCode === 27) {
                                myHeaderHandlers.langClose();
                            }
                        });
                    },
                    langClose: function () {
                        myHeaderLang.removeClass('is-active');
                        $(document).off('click.ntrHeaderLang');
                        $(document).off('keyup.ntrHeaderLang');
                    },
                };

                // Conditional Handlers
                var myMedia = window.matchMedia('(max-width: 1199px)');
                var myMediaHandler = function (m) {
                    if (m.matches) {
                        myHeaderLangLabel.on('click.ntrHeaderLangLabel', function (e) {
                            //e.preventDefault();
                            if (myHeaderLang.hasClass('is-active')) {
                                myHeaderHandlers.langClose();
                            } else {
                                myHeaderHandlers.langOpen();
                            }
                        });

                    } else {
                        // Remove Lang Events
                        $(document).off('click.ntrHeaderLang');
                        $(document).off('keyup.ntrHeaderLang');
                        myHeaderLangLabel.off('click.ntrHeaderLangLabel');
                    }
                };
            }
        });
    }

    // ntrJarallax
    function ntrJarallax() {

        //console.log('merhaba');
        var myParallaxs = $('.naturally-parallax');
        var myParallaxVideo = $('[data-jarallax-video]');

        if( !(myParallaxs.is('[data-jarallax]')) ) {
            myParallaxs.each(function (i, el) {
                var myParallax = $(el);
                var myData = myParallax.data('ntrParallax');

                if (!myData) {
                    return true; // next iteration
                }

                myParallax.jarallax({
                    type            : myData.type,
                    speed           : myData.speed,
                    imgSize         : myData.imgsize,
                    imgSrc          : myData.imgsrc,
                    disableParallax : myData.mobile ? /iPad|iPhone|iPod|Android/ : null,
                    keepImg         : true,
                });
            });
        }
    }

    var parentBody = window.parent.document.getElementsByClassName("elementor-editor-wp-page");
    var parentBod = $(parentBody);


    function updatePageSettings(newValue) {
        var settings = false,
            editMode = elementorFrontend.isEditMode();
        if (!editMode ) {
            return false;
        }
        //console.log(newValue);
        if (editMode) {
            var is_overlay = elementor.settings.page.model.attributes.naturally_elementor_page_header_type;
            var hide_page_header = elementor.settings.page.model.attributes.naturally_elementor_hide_page_header;
            var hide_page_header_topbar = elementor.settings.page.model.attributes.naturally_elementor_hide_page_header_topbar;
            var hide_page_footer = elementor.settings.page.model.attributes.naturally_elementor_hide_page_footer;
            var hide_footer_widget_area = elementor.settings.page.model.attributes.naturally_elementor_hide_page_footer_widget_area;
            var hide_footer_copyright = elementor.settings.page.model.attributes.naturally_elementor_hide_page_footer_copyright;
            if ( is_overlay && 'is-overlay' === is_overlay ) {
                $('body .header[data-ntr-header]').addClass('is-overlay');
            } else {
                $('body .header[data-ntr-header]').removeClass('is-overlay');
            }
            if ( hide_page_header && 'yes' === hide_page_header ) {
                $('body .naturally-main-header.header').hide();
            } else {
                $('body .naturally-main-header.header').show();
            }
            if ( hide_page_header_topbar && 'yes' === hide_page_header_topbar ) {
                $('body .naturally_header_topbar.header_top').hide();
                $('body .naturally-main-header.header').css('margin-top','0');
            } else {
                $('body .naturally_header_topbar.header_top').show();
                $('body .naturally-main-header.header').removeAttr('style');
            }
            if ( hide_page_footer && 'yes' === hide_page_footer ) {
                $('body [data-elementor-type="section"]').hide();
            } else {
                $('body [data-elementor-type="section"]').show();
            }
            if ( hide_footer_widget_area && 'yes' === hide_footer_widget_area ) {
                $('body #nt-footer.footer_top.nt-footer-sidebar').hide();
            } else {
                $('body #nt-footer.footer_top.nt-footer-sidebar').show();
            }
            if ( hide_footer_copyright && 'yes' === hide_footer_copyright ) {
                $('body #nt-footer.footer_bottom').hide();
            } else {
                $('body #nt-footer.footer_bottom').show();
            }
        }
    }


    jQuery(window).on('elementor/frontend/init', function () {

        if ( typeof elementor != "undefined" && typeof elementor.settings.page != "undefined") {

            elementor.settings.page.addChangeCallback( 'naturally_elementor_hide_page_header', updatePageSettings );
            elementor.settings.page.addChangeCallback( 'naturally_elementor_page_header_type', updatePageSettings );
            elementor.settings.page.addChangeCallback( 'naturally_elementor_hide_page_header_topbar', updatePageSettings );
            elementor.settings.page.addChangeCallback( 'naturally_elementor_hide_page_footer', updatePageSettings );
            elementor.settings.page.addChangeCallback( 'naturally_elementor_hide_page_footer_widget_area', updatePageSettings );
            elementor.settings.page.addChangeCallback( 'naturally_elementor_hide_page_footer_copyright', updatePageSettings );
        }
        elementorFrontend.hooks.addAction('frontend/element_ready/global', ntrJarallax);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-menu.default', ntrNavMenus);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-woo-mini-cart.default', ntrHeaderMiniCart);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-header-search.default', ntrHeaderSearchForm);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-header-langs.default', ntrHeaderLangs);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-home-slider.default', ntrSliderHero);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-home-slider.default', ntrBackground2);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-woo-category-slider.default', categoriesSlider);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-woo-page.default', ntrSliderCategories2);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-woo-product-slider.default', ntrSliderDeals);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-testimonials.default', ntrSliderTestimonials);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-testimonials.default', ntrSliderTestimonials2);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-blog-slider.default', ntrUITooltip2);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-blog-slider.default', ntrSliderBlog);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-split-slider.default', ntrSliderBlog2);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-split-slider.default', ntrSliderTestimonials3);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-partners-slider.default', ntrSliderLogos);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-photo-slider.default', ntrSliderPhotos);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-counterup.default', ntrCounter);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-accordion-tabs.default', ntrAccordion);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-tabs.default', ntrTabs);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-alert.default', ntrAlert);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-gallery-grid.default', ntrIsotope);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-woo-products-gallery.default', ntrIsotope);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-woo-products-gallery.default', ntrUITooltip2);
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-gallery-banner.default', ntrIsotope);
    });

})(jQuery);
