/*=================================*/
/* Section Parallax
/*=================================*/
var NtParallaxHandler = function ($scope, $) {
    var target = $scope,
        sectionId = target.data("id"),
        settings = false,
        editMode = elementorFrontend.isEditMode();

    if (editMode) {
        settings = generateEditorSettings(sectionId);
    }

    if (!editMode || !settings) {
        //return false;
    }

    if (settings[0] == "yes") {
        
        generateJarallax();
    }

    function generateEditorSettings(targetId) {
        var editorElements = null,
            sectionData = {},
            sectionMultiData = {},
            settings = [];

        if (!window.elementor.hasOwnProperty("elements")) {
            return false;
        }

        editorElements = window.elementor.elements;

        if (!editorElements.models) {
            return false;
        }

        $.each(editorElements.models, function(index, elem) {

            if (targetId == elem.id) {

                sectionData = elem.attributes.settings.attributes;
            } else if ( elem.id == target.closest(".elementor-top-section").data("id") ) {

                $.each(elem.attributes.elements.models, function(index, col) {
                    $.each(col.attributes.elements.models, function(index,subSec) {
                        sectionData = subSec.attributes.settings.attributes;
                    });
                });
            }
        });

        if (!sectionData.hasOwnProperty("naturally_parallax_type") || "" == sectionData["naturally_parallax_type"]) {
            return false;
        }

        settings.push(sectionData["naturally_parallax_switcher"]);                          // settings[0]
        settings.push(sectionData["naturally_parallax_type"]);                              // settings[1]
        settings.push(sectionData["naturally_parallax_speed"]);                             // settings[2]
        settings.push(sectionData["naturally_parallax_bg_size"]);                           // settings[3]
        settings.push("yes" == sectionData["naturally_parallax_mobile_support"] ? 0 : 1);   // settings[4]
        settings.push("yes" == sectionData["naturally_add_parallax_video"] ? 1 : 0);        // settings[5]
        settings.push(sectionData["naturally_local_video_format"]);                         // settings[6]
        settings.push(sectionData["naturally_parallax_video_url"]);                         // settings[7]
        settings.push(sectionData["naturally_parallax_video_start_time"]);                  // settings[8]
        settings.push(sectionData["naturally_parallax_video_end_time"]);                    // settings[9]
        settings.push(sectionData["naturally_parallax_video_volume"]);                      // settings[10]


        if (0 !== settings.length) {
            return settings;
        }

        return false;
    }

    function responsiveParallax(android, ios) {
        switch (true || 1) {
            case android && ios:
                return /iPad|iPhone|iPod|Android/;
                break;
            case android && !ios:
                return /Android/;
                break;
            case !android && ios:
                return /iPad|iPhone|iPod/;
                break;
            case !android && !ios:
                return null;
        }
    }

    function generateJarallax() {
        //target.removeAttr('style');
        var $type     = settings[1] ? settings[1] : 'scroll';
        var $speed    = settings[2] ? settings[2] : '0.4';
        var $imgsize  = settings[3] ? settings[3] : 'cover';
    
        setTimeout(function() {

            target.jarallax({
                type            : $type,
                speed           : $speed,
                imgSize         : $imgsize,
                disableParallax : responsiveParallax(1 == settings[4])
            });
            
        }, 500);

    }
}

jQuery(window).on("elementor/frontend/init", function() {
    elementorFrontend.hooks.addAction('frontend/element_ready/global', NtParallaxHandler);
});
