<?php

if( !defined( 'ABSPATH' ) ) exit;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Element_Base;
use Elementor\Elementor_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Responsive\Responsive;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;

class Naturally_Section_Parallax {

    private static $instance = null;

    public function __construct(){
        // section register settings
        add_action('elementor/element/section/section_structure/after_section_end',array($this,'register_change_section_structure'), 10 );
        add_action('elementor/element/section/section_structure/after_section_end',array($this,'section_parallax_controls'), 10 );
        add_action('elementor/element/section/section_layout/before_section_end',array($this,'register_change_section_indent_structure'), 10 );
        add_action('elementor/element/section/section_background_overlay/before_section_end',array($this,'register_add_section_overlay_width'), 10 );
        add_action('elementor/frontend/section/before_render',array($this,'naturally_custom_attr_to_section'), 10);
        //add_action('elementor/frontend/section/before_render',array($this,'before_render'), 10);

        // column register settings and before render column functions
        add_action('elementor/element/column/layout/after_section_end',array($this,'register_change_column_width'), 10 );
    }
    /*****   START PARALLAX CONTROLS   ******/
    public function section_parallax_controls( $element ) {
        $element->start_controls_section( 'naturally_parallax_section',
            [
                'label'        => esc_html__( 'Naturally Parallax', 'naturally' ),
                'tab'          => Controls_Manager::TAB_LAYOUT
            ]
        );
        $element->add_control( 'naturally_parallax_switcher',
            [
                'label'        => esc_html__( 'Enable Parallax', 'naturally' ),
                'type'         => Controls_Manager::SWITCHER,
                'prefix_class' => 'naturally-parallax jarallax parallax-',
            ]
        );
        $element->add_control( 'naturally_parallax_update',
            [
                'label'       => '<div class="elementor-update-preview" style="background-color: #fff;display: block;"><div class="elementor-update-preview-button-wrapper" style="display:block;"><button class="elementor-update-preview-button elementor-button elementor-button-success" style="background: #d30c5c; margin: 0 auto; display:block;">Apply Changes</button></div><div class="elementor-update-preview-title" style="display:block;text-align:center;margin-top: 10px;">Update changes to pages</div></div>',
                'type'        => Controls_Manager::RAW_HTML,
                'condition'   => ['naturally_parallax_switcher' => 'yes'],
            ]
        );
        $element->add_control( 'naturally_parallax_type',
            [
                'label'       => esc_html__( 'Type', 'naturally' ),
                'type'        => Controls_Manager::SELECT,
                'label_block' => 'true',
                'condition'   => ['naturally_parallax_switcher' => 'yes'],
                'default'     => 'scroll',
                'options'     => [
                    'scroll'         => esc_html__( 'Scroll', 'naturally' ),
                    'scroll-opacity' => esc_html__( 'Scroll with Opacity', 'naturally' ),
                    'opacity'        => esc_html__( 'Fade', 'naturally' ),
                    'scale'          => esc_html__( 'Zoom', 'naturally' ),
                    'scale-opacity'  => esc_html__( 'Zoom with Fade', 'naturally' )
                ]
            ]
        );
        $element->add_control( 'naturally_parallax_bg_size',
            [
                'label'       => esc_html__( 'Image Size', 'naturally' ),
                'type'        => Controls_Manager::SELECT,
                'default'     => 'auto',
                'condition'   => ['naturally_parallax_switcher' => 'yes'],
                'options'     => [
                    'auto'        => esc_html__( 'Auto', 'naturally' ),
                    'cover'       => esc_html__( 'Cover', 'naturally' ),
                    'contain'     => esc_html__( 'Contain', 'naturally' )
                ]
            ]
        );
        $element->add_control( 'naturally_parallax_speed',
            [
                'label'      => esc_html__( 'Parallax Speed', 'naturally' ),
                'type'       => Controls_Manager::NUMBER,
                'min'        => -1,
                'max'        => 2,
                'step'       => 0.1,
                'default'    => 0.2,
                'condition'  => ['naturally_parallax_switcher' => 'yes']
            ]
        );
        $element->add_control( 'naturally_parallax_mobile_support',
            [
                'label'      => esc_html__( 'Parallax on Mobile Devices', 'naturally' ),
                'type'       => Controls_Manager::SWITCHER,
                'prefix_class' => 'naturally-mobile-parallax-',
                'condition'  => ['naturally_parallax_switcher' => 'yes']
            ]
        );
        $element->add_control( 'naturally_add_parallax_video',
            [
                'label' => esc_html__( 'Use Background Video', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'prefix_class' => 'naturally-parallax-video-',
                'condition'  => ['naturally_parallax_switcher' => 'yes']
            ]
        );
        $element->add_control( 'naturally_local_video_format',
            [
                'label' => esc_html__( 'Video Format', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => 'external',
                'options' => [
                    'external' => esc_html__( 'External (Youtube,Vimeo)', 'naturally' ),
                    'mp4' => esc_html__( 'Local MP4', 'naturally' ),
                    'webm' => esc_html__( 'Local Webm', 'naturally' ),
                    'ogv' => esc_html__( 'Local Ogv', 'naturally' ),
                ],
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'naturally_parallax_switcher',
                            'operator' => '==',
                            'value' => 'yes'
                        ],
                        [
                            'name' => 'naturally_add_parallax_video',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'yes'
                        ]
                    ]
                ]
            ]
        );
        $element->add_control( 'naturally_parallax_video_url',
            [
                'label' => esc_html__( 'Video URL', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => 'https://www.youtube.com/watch?v=AeeE6PyU-dQ',
                'description' => esc_html__( 'YouTube/Vimeo link, or link to video file (mp4 is recommended).', 'naturally' ),
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'naturally_parallax_switcher',
                            'operator' => '==',
                            'value' => 'yes'
                        ],
                        [
                            'name' => 'naturally_add_parallax_video',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'yes'
                        ]
                    ]
                ]
            ]
        );
        $element->add_control( 'naturally_parallax_video_start_time',
            [
                'label' => esc_html__( 'Start Time', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'placeholder' => '10',
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'naturally_parallax_switcher',
                            'operator' => '==',
                            'value' => 'yes'
                        ],
                        [
                            'name' => 'naturally_add_parallax_video',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'yes'
                        ]
                    ]
                ]
            ]
        );
        $element->add_control( 'naturally_parallax_video_end_time',
            [
                'label' => esc_html__( 'End Time', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'placeholder' => '70',
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'naturally_parallax_switcher',
                            'operator' => '==',
                            'value' => 'yes'
                        ],
                        [
                            'name' => 'naturally_add_parallax_video',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'yes'
                        ]
                    ]
                ]
            ]
        );
        $element->add_control( 'naturally_parallax_video_volume',
            [
                'label' => esc_html__( 'Video Volume', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'placeholder' => '0',
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'naturally_parallax_switcher',
                            'operator' => '==',
                            'value' => 'yes'
                        ],
                        [
                            'name' => 'naturally_add_parallax_video',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'yes'
                        ]
                    ]
                ]
            ]
        );
        $element->add_control( 'naturally_parallax_video_play_once',
            [
                'label' => esc_html__( 'Play Once', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no',
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'naturally_parallax_switcher',
                            'operator' => '==',
                            'value' => 'yes'
                        ],
                        [
                            'name' => 'naturally_add_parallax_video',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'yes'
                        ]
                    ]
                ]
            ]
        );
        $element->end_controls_section();
    }

    /*****   START COLUMN CONTROLS   ******/
    public function register_change_column_width( $element ) {
        $element->start_controls_section('naturally_section_column_width_settings',
            [
                'label' => esc_html__( 'Naturally Custom Column', 'naturally' ),
                'tab' => Controls_Manager::TAB_LAYOUT
            ]
        );
        $element->add_responsive_control( 'naturally_column_width',
            [
                'label' => esc_html__( 'Change Column Width', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'selectors' => ['{{WRAPPER}}' => 'width: {{VALUE}}%!important;'],
            ]
        );
        $element->end_controls_section();
    }
    /*****   END COLUMN CONTROLS   ******/

    /*****   START CONTROLS SECTION   ******/
    public function register_change_section_structure( $element ) {
        $element->start_controls_section('naturally_section_structure_settings',
            [
                'label' => esc_html__( 'Naturally Structure', 'naturally' ),
                'tab' => Controls_Manager::TAB_LAYOUT
            ]
        );
        $element->add_control('naturally_section_structure_switcher',
            [
                'label' => esc_html__( 'Enable Naturally Structure', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'prefix_class' => 'nt-structure nt-structure-',
            ]
        );
        $element->end_controls_section();
    }
    /*****   END COLUMN CONTROLS   ******/

    /*****   START CONTROLS SECTION   ******/
    public function register_change_section_indent_structure( $element ) {
        $element->add_control( 'naturally_section_indent',
            [
                'label' => esc_html__( 'Section Indent', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block'  => 'true',
                'default' => '',
                'prefix_class' => 'nt-section ',
                'separator' => 'before',
                'options' => [
                    '' => esc_html__( 'Default', 'naturally' ),
                    'section' => esc_html__( 'Outdent Top and Bottom', 'naturally' ),
                    'section mt-0' => esc_html__( 'Outdent Bottom No Top', 'naturally' ),
                    'section mb-0' => esc_html__( 'Outdent Top No Bottom', 'naturally' ),
                ]
            ]
        );
    }
    /*****   END COLUMN CONTROLS   ******/

    /*****   START CONTROLS SECTION   ******/
    public function register_add_section_overlay_width( $element ) {
        $element->add_responsive_control( 'naturally_section_overlay_width',
            [
                'label' => esc_html__( 'Naturally Overlay Width', 'naturally' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 4000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-background-overlay' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'separator'     => 'before'
            ]
        );
        $element->add_responsive_control( 'naturally_section_overlay_height',
            [
                'label' => esc_html__( 'Naturally Overlay Height', 'naturally' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 4000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-background-overlay' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'separator'     => 'before'
            ]
        );
    }

    public function naturally_custom_attr_to_section( $element ) {
        $data     = $element->get_data();
        $type     = $data['elType'];
        $settings = $data['settings'];
        $isInner  = $data['isInner'];// inner section

        if( 'section' === $element->get_name() && 'yes' === $element->get_settings('naturally_parallax_switcher') ) {

            $element->add_render_attribute( 'wrapper', 'class', $element->get_settings('naturally_section_indent') );
            $element->add_render_attribute( 'wrapper', 'class', $element->get_settings('naturally_section_outdent') );
            
            // Parallax attr
            $type = $element->get_settings('naturally_parallax_type');
            $speed = $element->get_settings('naturally_parallax_speed');
            $bgsize = $element->get_settings('naturally_parallax_bg_size');
            $mobile = $element->get_settings('naturally_parallax_mobile_support');
            $bgimg = $element->get_settings('background_image');
            $bgimg = $bgimg['url'];

            if ( 'yes' === $element->get_settings('naturally_add_parallax_video') && $element->get_settings('naturally_parallax_video_url') ) {

                if ( 'mp4' === $element->get_settings('naturally_local_video_format')) {

                    $videosrc = 'mp4:'.$element->get_settings('naturally_parallax_video_url');

                } elseif ( 'webm' === $element->get_settings('naturally_local_video_format')) {

                    $videosrc = 'webm:'.$element->get_settings('naturally_parallax_video_url');

                } elseif ( 'ogv' === $element->get_settings('naturally_local_video_format')) {

                    $videosrc = 'ogv:'.$element->get_settings('naturally_parallax_video_url');

                } else {

                    $videosrc = $element->get_settings('naturally_parallax_video_url');
                }

                $element->add_render_attribute( '_wrapper', 'data-jarallax data-jarallax-video', $videosrc);

                if ( $element->get_settings('naturally_parallax_video_start_time') ) {

                    $element->add_render_attribute( '_wrapper', 'data-video-start-time', $element->get_settings('naturally_parallax_video_start_time'));
                }

                if ( $element->get_settings('naturally_parallax_video_end_time') ) {
                    $element->add_render_attribute( '_wrapper', 'data-video-end-time', $element->get_settings('naturally_parallax_video_end_time'));
                }

                if ( 'yes' === $element->get_settings('naturally_parallax_video_play_once') ) {
                    $element->add_render_attribute( '_wrapper', 'data-jarallax-video-loop', 'false' );
                }

                if ( $element->get_settings('naturally_parallax_video_volume') ) {
                    $element->add_render_attribute( '_wrapper', 'data-video-volume', $element->get_settings('naturally_parallax_video_volume') );
                }

            } else {

                $parallaxattr = '{"type":"'.$type.'","speed":"'.$speed.'","imgsize":"'.$bgsize.'","imgsrc":"'.$bgimg.'","mobile":"'.$mobile.'"}';
                $element->add_render_attribute( '_wrapper', 'data-ntr-parallax', $parallaxattr);
            }

            if( '0' !== $element->get_settings('naturally_section_column_structure_switcher') ) {
                $element->add_render_attribute( 'wrapper', 'class', $element->get_settings('naturally_section_change_column_structure') );
            }
        }
    }

    public static function get_instance() {
        if ( null == self::$instance ) {
            self::$instance = new self;
        }
        return self::$instance;
    }
}
Naturally_Section_Parallax::get_instance();