<?php
/*
* naturally_add_transform_to_heading
*/

add_action( 'elementor/element/heading/section_title_style/after_section_end', 'naturally_add_transform_to_heading' );
function naturally_add_transform_to_heading( $widget )
{
    $widget->start_controls_section( 'heading_css_transform_controls_section',
        [
            'label' => esc_html__( 'Naturally CSS Transform', 'naturally' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE
        ]
    );
    $widget->add_control( 'heading_css_transform_type',
        [
            'label' => esc_html__( 'Transform Type', 'naturally' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'translate',
            'options' => [
                'translate' => esc_html__( 'translate', 'naturally' ),
                'scale' => esc_html__( 'scale', 'naturally' ),
                'rotate' => esc_html__( 'rotate', 'naturally' ),
                'skew' => esc_html__( 'skew', 'naturally' ),
                'custom' => esc_html__( 'custom', 'naturally' ),
            ],
            'prefix_class' => 'naturally-transform transform-type-',
        ]
    );
    $widget->add_control( 'heading_css_transform_translate_heading',
        [
            'label' => esc_html__( 'Translate', 'naturally' ),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
            'condition' => [ 'heading_css_transform_type' => 'translate' ]
        ]
    );
    $widget->add_responsive_control( 'heading_css_transform_translate_xy',
        [
            'label' => esc_html__( 'Translate 2D ( X,Y )', 'naturally' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => 'Xpx,Ypx',
            'selectors' => [ '{{WRAPPER}}.naturally-transform.transform-type-translate .elementor-heading-title' => 'transform:translate( {{VALUE}} );'],
            'condition' => [ 'heading_css_transform_type' => 'translate' ]
        ]
    );
    $widget->add_responsive_control( 'heading_css_transform_translate_xyz',
        [
            'label' => esc_html__( 'Translate 3D ( X,Y,Z )', 'naturally' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => 'Xpx,Ypx,Zpx',
            'selectors' => [ '{{WRAPPER}}.naturally-transform.transform-type-translate.has-translate-xyz .elementor-heading-title' => 'transform:translate3d( {{VALUE}} );'],
            'prefix_class' => 'has-translate-xyz translate-xyz-',
            'condition' => [ 'heading_css_transform_type' => 'translate' ]
        ]
    );
    // Scale
    $widget->add_control( 'heading_css_transform_scale_heading',
        [
            'label' => esc_html__( 'Scale', 'naturally' ),
            'type' => \Elementor\Controls_Manager::HEADING,
            'condition' => [ 'heading_css_transform_type' => 'scale' ],
            'separator' => 'before'
        ]
    );
    $widget->add_responsive_control( 'heading_css_transform_scale_xy',
        [
            'label' => esc_html__( 'Scale 2D ( X,Y )', 'naturally' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => 'Xpx,Ypx',
            'selectors' => [ '{{WRAPPER}}.naturally-transform.transform-type-translate .elementor-heading-title' => 'transform:scale( {{VALUE}} );'],
            'condition' => [ 'heading_css_transform_type' => 'scale' ]
        ]
    );
    $widget->add_responsive_control( 'heading_css_transform_scale_xyz',
        [
            'label' => esc_html__( 'Scale 3D ( X,Y,Z )', 'naturally' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => 'Xpx,Ypx,Zpx',
            'selectors' => [ '{{WRAPPER}}.naturally-transform.transform-type-scale.has-scale-xyz .elementor-heading-title' => 'transform:scale3d( {{VALUE}} );'],
            'prefix_class' => 'has-scale-xyz scale-xyz-',
            'condition' => [ 'heading_css_transform_type' => 'scale' ]
        ]
    );
    // Rotate
    $widget->add_control( 'heading_css_transform_rotate_heading',
        [
            'label' => esc_html__( 'Rotate', 'naturally' ),
            'type' => \Elementor\Controls_Manager::HEADING,
            'condition' => [ 'heading_css_transform_type' => 'scale' ],
            'separator' => 'before'
        ]
    );
    $widget->add_responsive_control( 'heading_css_transform_rotate_xy',
        [
            'label' => esc_html__( 'Rotate 2D ( X,Y )', 'naturally' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => 'Xdeg,Ydeg',
            'selectors' => [ '{{WRAPPER}}.naturally-transform.transform-type-rotate .elementor-heading-title' => 'transform:rotate( {{VALUE}} );'],
            'condition' => [ 'heading_css_transform_type' => 'rotate' ]
        ]
    );
    $widget->add_responsive_control( 'heading_css_transform_rotate_xyz',
        [
            'label' => esc_html__( 'Rotate 3D ( X,Y,Z )', 'naturally' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => '0,0,0',
            'selectors' => [ '{{WRAPPER}}.naturally-transform.transform-type-rotate.has-rotate-xyz .elementor-heading-title' => 'transform:translate3d( {{VALUE}}deg );'],
            'prefix_class' => 'has-rotate-xyz rotate-xyz-',
            'condition' => [ 'heading_css_transform_type' => 'rotate' ]
        ]
    );
    // Skew
    $widget->add_control( 'heading_css_transform_skew_heading',
        [
            'label' => esc_html__( 'Skew', 'naturally' ),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
            'condition' => [ 'heading_css_transform_type' => 'skew' ]
        ]
    );
    $widget->add_responsive_control( 'heading_css_transform_skew_xy',
        [
            'label' => esc_html__( 'Skew 2D ( X,Y )', 'naturally' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => 'Xdeg,Ydeg',
            'selectors' => [ '{{WRAPPER}}.naturally-transform.transform-type-skew .elementor-heading-title' => 'transform:skew( {{VALUE}} );'],
            'condition' => [ 'heading_css_transform_type' => 'skew' ]
        ]
    );
    // Custom
    $widget->add_control( 'heading_css_transform_custom_heading',
        [
            'label' => esc_html__( 'Custom Transform', 'naturally' ),
            'type' => \Elementor\Controls_Manager::HEADING,
            'separator' => 'before',
            'condition' => [ 'heading_css_transform_type' => 'custom' ]
        ]
    );
    $widget->add_responsive_control( 'heading_css_transform_custom_xy',
        [
            'label' => esc_html__( 'Transform', 'naturally' ),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'label_block' => true,
            'placeholder' => 'rotate(Xdeg,Ydeg) translate(Xpx,Ypx) scale(X,Y)',
            'selectors' => [ '{{WRAPPER}}.naturally-transform.transform-type-custom .elementor-heading-title' => 'transform:( {{VALUE}} );'],
            'condition' => [ 'heading_css_transform_type' => 'custom' ]
        ]
    );
    $widget->end_controls_section();
}
