<?php
/*
* page settings
*/
function naturally_page_registered_nav_menus()
{
    $menus = wp_get_nav_menus();
    $options = array();
    if ( ! empty( $menus ) && ! is_wp_error( $menus ) ) {
        foreach ( $menus as $menu ) {
            $options[ $menu->slug ] = $menu->name;
        }
    }
    return $options;
}

add_action( 'elementor/documents/register_controls', 'naturally_add_custom_settings_to_page_settings' );
function naturally_add_custom_settings_to_page_settings( $document )
{
    if ( ! $document instanceof \Elementor\Core\DocumentTypes\PageBase || ! $document::get_property( 'has_elements' ) ) {
        return;
    }
    $document->start_controls_section( 'page_settings_controls_section',
        [
            'label'        => esc_html__( 'Page Settings', 'naturally' ),
            'tab'          => \Elementor\Controls_Manager::TAB_SETTINGS
        ]
    );
    $document->add_control( 'naturally_elementor_hide_page_header',
        [
            'label'         => esc_html__( 'Hide Header', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::SWITCHER,
            'label_on'      => esc_html__( 'Yes', 'naturally' ),
            'label_off'     => esc_html__( 'No', 'naturally' ),
            'return_value'  => 'yes',
            'default'       => 'no',
            'condition'     => [ 'template'   => 'naturally-elementor-page.php' ]
        ]
    );
    $document->add_control( 'naturally_elementor_page_header_type',
        [
            'label'         => esc_html__( 'Header Type', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::SELECT,
            'default'       => '',
            'options'       => [
                ''              => esc_html__( 'Slect a type', 'naturally' ),
                'default'       => esc_html__( 'Default', 'naturally' ),
                'is-overlay'    => esc_html__( 'Transparent', 'naturally' ),
            ],
            'condition'     => [ 'template' => 'naturally-elementor-page.php' ]
        ]
    );
    $document->add_control( 'naturally_elementor_page_header_menu',
        [
            'label'         => esc_html__( 'Header Menu', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::SELECT,
            'default'       => '',
            'options'       => naturally_page_registered_nav_menus(),
            'condition'     => [ 'template' => 'naturally-elementor-page.php' ]
        ]
    );
    $document->add_control( 'naturally_elementor_hide_page_header_topbar',
        [
            'label'         => esc_html__( 'Hide Header Topbar', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::SWITCHER,
            'label_on'      => esc_html__( 'Yes', 'naturally' ),
            'label_off'     => esc_html__( 'No', 'naturally' ),
            'return_value'  => 'yes',
            'default'       => 'no',
            'condition'     => [ 'template' => 'naturally-elementor-page.php' ]
        ]
    );
    $document->add_control( 'naturally_elementor_hide_page_footer',
        [
            'label'         => esc_html__( 'Hide Footer', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::SWITCHER,
            'label_on'      => esc_html__( 'Yes', 'naturally' ),
            'label_off'     => esc_html__( 'No', 'naturally' ),
            'return_value'  => 'yes',
            'default'       => 'no',
            'condition'     => [ 'template' => 'naturally-elementor-page.php' ]
        ]
    );
    if ( class_exists('Redux') && function_exists('naturally_settings') && 'default' == naturally_settings('footer_type', 'default') ) {
        $document->add_control( 'naturally_elementor_hide_page_footer_widget_area',
            [
                'label'         => esc_html__( 'Hide Footer Widgetize', 'naturally' ),
                'type'          => \Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'naturally' ),
                'label_off'     => esc_html__( 'No', 'naturally' ),
                'return_value'  => 'yes',
                'default'       => 'no',
                'condition'     => [ 'template' => 'naturally-elementor-page.php' ]
            ]
        );
        $document->add_control( 'naturally_elementor_hide_page_footer_copyright',
            [
                'label'         => esc_html__( 'Hide Footer Copyright', 'naturally' ),
                'type'          => \Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'naturally' ),
                'label_off'     => esc_html__( 'No', 'naturally' ),
                'return_value'  => 'yes',
                'default'       => 'no',
                'condition'     => [ 'template' => 'naturally-elementor-page.php' ]
            ]
        );
    }
    $document->end_controls_section();

    $document->start_controls_section( 'header_style_controls_section',
        [
            'label'        => esc_html__( 'Page Header Style', 'naturally' ),
            'tab'          => \Elementor\Controls_Manager::TAB_STYLE,
            'condition'    => [ 'naturally_elementor_hide_page_header!'   => 'yes' ]
        ]
    );
    $document->add_control( 'header_background_heading',
        [
            'label'         => esc_html__( 'Background Style', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::HEADING
        ]
    );
    $document->add_control( 'logo_brightness',
        [
            'label'         => esc_html__( 'Logo Brightness', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::SLIDER,
            'range'         => [ '%'   => [ 'max' => 100 ] ],
            'selectors'     => [ '{{WRAPPER}} .header .header_logo img' => '-webkit-filter: brightness({{SIZE}}); filter: brightness({{SIZE}});' ],
            'separator'     => 'after'
        ]
    );
    $document->add_responsive_control( 'header_padding',
        [
            'label'         => esc_html__( 'Padding', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units'    => [ 'px', 'em', '%' ],
            'selectors'     => ['{{WRAPPER}} .header .header_container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;'],
            'default'       => [
                'top'          => '',
                'right'        => '',
                'bottom'       => '',
                'left'         => '',
            ],
            'separator'     => 'after'
        ]
    );
    $document->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name'          => 'header_background',
            'label'         => esc_html__( 'Background', 'naturally' ),
            'types'         => [ 'classic', 'gradient' ],
            'selector'      => '{{WRAPPER}} .header',
            'separator'     => 'before'
        ]
    );

    $document->add_control( 'header_background_hr', [ 'type' => \Elementor\Controls_Manager::DIVIDER ] );

    $document->add_control( 'header_menu_heading',
        [
            'label'         => esc_html__( 'Menu Style', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::HEADING
        ]
    );
    $document->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'name'          => 'header_menu_item_typo',
            'label'         => esc_html__( 'Typography', 'naturally' ),
            'selector'      => '{{WRAPPER}} .navbar-nav>li>a, {{WRAPPER}} .header_nav_sub a'
        ]
    );
    $document->start_controls_tabs('header_menu_item_normal_tabs');
    $document->start_controls_tab( 'header_menu_item_normal_tab',
        [ 'label'           => esc_html__( 'Normal', 'naturally' ) ]
    );
    $document->add_control( 'header_menu_item_normal_color',
        [
            'label'         => esc_html__( 'Menu Item Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['@media(min-width:1200px){ .header_nav > ul:not(.sub_menu) > li > a' => 'color: {{{VALUE}}};']
        ]
    );
    $document->end_controls_tab();

    $document->start_controls_tab('header_menu_item_hover_tab',
        [ 'label'           => esc_html__( 'Hover', 'naturally' ) ]
    );
    $document->add_control( 'header_menu_item_hover_color',
        [
            'label'         => esc_html__( 'Menu Item Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['@media(min-width:1200px){ .header_nav > ul:not(.sub_menu) > li > a:hover' => 'color: {{{VALUE}}};']
        ]
    );
    $document->end_controls_tab();
    $document->end_controls_tabs();

    $document->end_controls_section();

    /* STICKY HEADER SETTINGS */
    if ( class_exists('Redux') && function_exists('naturally_settings') && '1' == naturally_settings('nav_sticky_visibility', '0') ) {

        $document->start_controls_section( 'sticky_header_style_controls_section',
            [
                'label'         => esc_html__( 'Sticky Header Style', 'naturally' ),
                'tab'           => \Elementor\Controls_Manager::TAB_STYLE,
                'condition'     => [
                    'naturally_elementor_hide_page_header!'   => 'yes'
                ]
            ]
        );
        $document->add_control( 'sticky_header_background_heading',
            [
                'label'         => esc_html__( 'Background Style', 'naturally' ),
                'type'          => \Elementor\Controls_Manager::HEADING
            ]
        );
        $document->add_responsive_control( 'sticky_header_height',
            [
                'label'         => esc_html__( 'Height', 'naturally' ),
                'type'          => \Elementor\Controls_Manager::SLIDER,
                'range'         => [ 'px'   => [ 'max' => 500 ] ],
                'selectors'     => [ '{{WRAPPER}} .header.is-sticky-active .header_container' => 'height: {{SIZE}}px!important;' ],
                'separator'     => 'after'
            ]
        );
        $document->add_responsive_control( 'sticky_header_padding',
            [
                'label'         => esc_html__( 'Padding', 'naturally' ),
                'type'          => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px' ],
                'selectors'     => ['{{WRAPPER}} .header.is-sticky-active .header_container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ],
                'separator'     => 'after'
            ]
        );
        $document->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'          => 'sticky_header_background',
                'label'         => esc_html__( 'Background', 'naturally' ),
                'types'         => [ 'classic', 'gradient' ],
                'selector'      => '{{WRAPPER}} .header.is-sticky.is-sticky-active',
                'separator'     => 'before'
            ]
        );
        $document->add_control( 'sticky_header_background_hr', [ 'type' => \Elementor\Controls_Manager::DIVIDER ] );
        $document->add_control( 'sticky_header_menu_heading',
            [
                'label'         => esc_html__( 'Menu Style', 'naturally' ),
                'type'          => \Elementor\Controls_Manager::HEADING
            ]
        );
        $document->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'          => 'sticky_header_menu_item_typo',
                'label'         => esc_html__( 'Typography', 'naturally' ),
                'selector'      => '{{WRAPPER}} .header.is-sticky.is-sticky-active .header_nav > ul > li > a, {{WRAPPER}} .header.is-sticky.is-sticky-active .header_nav_sub a'
            ]
        );
        $document->start_controls_tabs('sticky_header_menu_item_normal_tabs');
        $document->start_controls_tab( 'sticky_header_menu_item_normal_tab',
            [ 'label'           => esc_html__( 'Normal', 'naturally' ) ]
        );
        $document->add_control( 'sticky_header_menu_item_normal_color',
            [
                'label'         => esc_html__( 'Menu Item Color', 'naturally' ),
                'type'          => \Elementor\Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => [ '{{WRAPPER}} .header.is-sticky.is-sticky-active .header_nav > ul > li > a, {{WRAPPER}} .header.is-sticky.is-sticky-active .header_nav_sub a' => 'color: {{VALUE}};' ]
            ]
        );
        $document->end_controls_tab();

        $document->start_controls_tab('sticky_header_menu_item_hover_tab',
            [ 'label'           => esc_html__( 'Hover', 'naturally' ) ]
        );
        $document->add_control( 'sticky_header_menu_item_hover_color',
            [
                'label'         => esc_html__( 'Menu Item Color', 'naturally' ),
                'type'          => \Elementor\Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => [ '{{WRAPPER}} .header.is-sticky.is-sticky-active .header_nav > ul > li > a:hover, {{WRAPPER}} .header.is-sticky.is-sticky-active .header_nav_sub a:hover' => 'color: {{VALUE}};']
            ]
        );
        $document->end_controls_tab();
        $document->end_controls_tabs();
        $document->end_controls_section();
    }
    /* END STICKY HEADER SETTINGS */

    /* MOBILE HEADER SETTINGS */
    $document->start_controls_section( 'header_mobile_style_controls_section',
        [
            'label'        => esc_html__( 'Page Header Mobile Style', 'naturally' ),
            'tab'          => \Elementor\Controls_Manager::TAB_STYLE,
            'condition'    => [
                'naturally_elementor_hide_page_header!'   => 'yes',
            ]
        ]
    );

    $document->add_control( 'more_options',
        [
            'label'         => esc_html__( 'Mobile Menu Background', 'plugin-name' ),
            'type'          => \Elementor\Controls_Manager::HEADING,
            'separator'     => 'before',
        ]
    );
    $document->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name'          => 'header_mobile_background',
            'label'         => esc_html__( 'Mobile Menu Background', 'naturally' ),
            'types'         => [ 'classic', 'gradient' ],
            'selector'      => '{{WRAPPER}} .header_nav.is-active',
        ]
    );
    $document->add_control( 'header_mobile_inner_background_hr', [ 'type' => \Elementor\Controls_Manager::DIVIDER ] );

    $document->add_control( 'header_mobile_menu_heading',
        [
            'label'         => esc_html__( 'Mobile Menu Style', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::HEADING
        ]
    );
    $document->add_control( 'header_mobile_menu_bar_color',
        [
            'label'         => esc_html__( 'Menu Toggle Bar Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header_nav_toggle' => 'color: {{VALUE}};']
        ]
    );
    $document->add_control( 'header_mobile_menu_bar_hvrcolor',
        [
            'label'         => esc_html__( 'Menu Toggle Bar Hover', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header_nav_toggle:hover' => 'color: {{VALUE}};']
        ]
    );
    $document->add_control( 'header_mobile_menu_bar_brdcolor',
        [
            'label'         => esc_html__( 'Menu Toggle Bar Border Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header_nav_toggle' => 'border-color: {{VALUE}};']
        ]
    );
    $document->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'name'          => 'header_mobile_menu_item_typo',
            'label'         => esc_html__( 'Typography', 'naturally' ),
            'selector'      => '{{WRAPPER}} .header_nav.is-active li > a'
        ]
    );
    $document->start_controls_tabs('header_mobile_menu_normal_tabs');
    $document->start_controls_tab( 'header_mobile_menu_normal_tab',
        [ 'label'           => esc_html__( 'Normal', 'naturally' ) ]
    );
    $document->add_control( 'header_mobile_menu_normal_color',
        [
            'label'         => esc_html__( 'Menu Item Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header_nav.is-active li > a' => 'color: {{VALUE}};']
        ]
    );
    $document->add_control( 'header_mobile_menu_item_normal_bgcolor',
        [
            'label'         => esc_html__( 'Menu Item Background Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header_nav.is-active li > a' => 'background-color: {{VALUE}};']
        ]
    );
    $document->add_control( 'header_mobile_menu_arrow_normal_color',
        [
            'label'         => esc_html__( 'Menu Arrow Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header_nav_arrow' => 'color: {{VALUE}};']
        ]
    );
    $document->add_control( 'header_mobile_menu_arrow_normal_bgcolor',
        [
            'label'         => esc_html__( 'Menu Arrow Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header_nav_arrow' => 'background-color: {{VALUE}};']
        ]
    );
    $document->end_controls_tab();

    $document->start_controls_tab('header_mobile_menu_hover_tab',
        [ 'label'           => esc_html__( 'Hover', 'naturally' ) ]
    );
    $document->add_control( 'header_mobile_menu_hover_color',
        [
            'label'         => esc_html__( 'Menu Item Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header_nav.is-active li > a:hover' => 'color: {{VALUE}};']
        ]
    );
    $document->add_control( 'header_mobile_menu_item_hover_bgcolor',
        [
            'label'         => esc_html__( 'Menu Item Background Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header_nav.is-active li > a:hover,{{WRAPPER}} .header_nav.is-active li.is-active > a' => 'background-color: {{VALUE}};']
        ]
    );
    $document->add_control( 'header_mobile_menu_arrow_hover_color',
        [
            'label'         => esc_html__( 'Menu Arrow Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header_nav_arrow:hover' => 'color: {{VALUE}};']
        ]
    );
    $document->add_control( 'header_mobile_menu_arrow_hover_bgcolor',
        [
            'label'         => esc_html__( 'Menu Arrow Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header_nav_arrow:hover' => 'background-color: {{VALUE}};']
        ]
    );
    $document->end_controls_tab();
    $document->end_controls_tabs();
    $document->end_controls_section();
    /* END MOBILE HEADER SETTINGS */

    /* HEADER MINICART SETTINGS */
    $document->start_controls_section( 'header_minicart_style_controls_section',
        [
            'label'        => esc_html__( 'Header Minicart Style', 'naturally' ),
            'tab'          => \Elementor\Controls_Manager::TAB_STYLE,
            'condition'    => [ 'naturally_elementor_hide_page_header!'   => 'yes' ]
        ]
    );
    $document->start_controls_tabs('header_minicart_normal_tabs');
    $document->start_controls_tab( 'header_minicart_normal_tab',
        [ 'label'           => esc_html__( 'Normal', 'naturally' ) ]
    );
    $document->add_control( 'header_minicart_normal_color',
        [
            'label'         => esc_html__( 'Button Text Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header .header_cart .header_cart_label' => 'color: {{VALUE}};']
        ]
    );
    $document->add_control( 'header_minicart_normal_brdcolor',
        [
            'label'         => esc_html__( 'Button Border Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header .header_cart .header_cart_label' => 'border-color: {{VALUE}};']
        ]
    );
    $document->end_controls_tab();

    $document->start_controls_tab('header_minicart_hover_tab',
        [ 'label'           => esc_html__( 'Hover', 'naturally' ) ]
    );
    $document->add_control( 'header_minicart_hover_color',
        [
            'label'         => esc_html__( 'Button Text Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header .header_cart .header_cart_label:hover, {{WRAPPER}} .header .header_cart.is-active .header_cart_label' => 'color: {{VALUE}};']
        ]
    );
    $document->add_control( 'header_minicart_hover_hvrbrdcolor',
        [
            'label'         => esc_html__( 'Button Border Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header .header_cart .header_cart_label, {{WRAPPER}} .header .header_cart.is-active .header_cart_label' => 'border-color: {{VALUE}};']
        ]
    );
    $document->end_controls_tab();
    $document->end_controls_tabs();

    $document->end_controls_section();
    /* HEADER TOPBAR SETTINGS */

    /* HEADER TOPBAR SETTINGS */
    $document->start_controls_section( 'header_topbar_style_controls_section',
        [
            'label'        => esc_html__( 'Page Header Topbar Style', 'naturally' ),
            'tab'          => \Elementor\Controls_Manager::TAB_STYLE,
            'condition'    => [ 'naturally_elementor_hide_page_header!'   => 'yes' ]
        ]
    );
    $document->add_control( 'header_topbar_item_color',
        [
            'label'         => esc_html__( 'Item Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header .header_top,{{WRAPPER}} .header .header_top .header_menu_link' => 'color: {{VALUE}};']
        ]
    );
    $document->add_control( 'header_topbar_item_hvrcolor',
        [
            'label'         => esc_html__( 'Item Link Hover Color', 'naturally' ),
            'type'          => \Elementor\Controls_Manager::COLOR,
            'default'       => '',
            'selectors'     => ['{{WRAPPER}} .header .header_top .header_menu_link:hover,{{WRAPPER}} .header_lang:hover .header_lang_label' => 'color: {{VALUE}};']
        ]
    );
    $document->end_controls_section();
    /* END HEADER TOPBAR SETTINGS */

    /* FOOTER SETTINGS */
    if ( class_exists('Redux') && function_exists('naturally_settings') && '1' == naturally_settings( 'footer_visibility', '1' )  && 'default' == naturally_settings( 'footer_type' )) {
        $document->start_controls_section( 'page_footer_controls_section',
            [
                'label'        => esc_html__( 'Page Footer Style', 'naturally' ),
                'tab'          => \Elementor\Controls_Manager::TAB_STYLE,
                'condition'     => [ 'naturally_elementor_hide_page_footer!' => 'yes' ]
            ]
        );
        $document->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'          => 'page_footer_background',
                'label'         => esc_html__( 'Background', 'naturally' ),
                'types'         => [ 'classic', 'gradient' ],
                'selector'      => '{{WRAPPER}} .footer'
            ]
        );
        $document->add_responsive_control( 'page_footer_padding',
            [
                'label'         => esc_html__( 'Padding', 'naturally' ),
                'type'          => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', 'em', '%' ],
                'selectors'     => [ '{{WRAPPER}} .footer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => ''
                ],
                'separator'     => 'before'
            ]
        );
        $document->end_controls_section();
    }
    /* END FOOTER SETTINGS */

    $document->start_controls_section( 'header_custom_css_controls_section',
        [
            'label'        => esc_html__( 'Page Custom CSS', 'naturally' ),
            'tab'          => \Elementor\Controls_Manager::TAB_STYLE,
        ]
    );
    // Custom CSS
	$document->add_control( 'naturally_page_custom_css',
		[
			'label' => __( 'Custom CSS', 'naturally' ),
			'type' => \Elementor\Controls_Manager::CODE,
			'language' => 'css',
			'rows' => 20,
		]
	);
    $document->end_controls_section();
}
