<?php

// register Naturally_Footer_Collapsed_Widget
add_action( 'widgets_init', function(){
    register_widget( 'Naturally_Footer_Widget' );
});

// Creating the widget
class Naturally_Footer_Widget extends WP_Widget {
    // class constructor
    public function __construct()
    {
        $widget_ops = array(
            'classname' => 'naturally_footer_widget',
            'description' => esc_html__( 'Naturally Footer Widget', 'naturally' ) );
        parent::__construct( 'naturally_footer_widget', 'Naturally Footer Widget', $widget_ops );
    }

    public function widget( $args, $instance )
    {
        extract( $args );
        $title = apply_filters( 'widget_title', $instance[ 'title' ] );
        $text = $instance[ 'text' ];
        $menu = $instance[ 'c_link' ];
        $collg = $instance[ 'c_lgcol' ] != '' ? ' '.esc_attr($instance[ 'c_lgcol' ]) : '';
        $colmd = $instance[ 'c_mdcol' ] != '' ? ' '.esc_attr($instance[ 'c_mdcol' ]) : '';
        $colsm = $instance[ 'c_smcol' ] != '' ? ' '.esc_attr($instance[ 'c_smcol' ]) : '';
        $colxs = $instance[ 'c_xscol' ] != '' ? ' '.esc_attr($instance[ 'c_xscol' ]) : '';
        $class = $instance[ 'c_class' ] != '' ? ' '.esc_attr($instance[ 'c_class' ]) : '';

        // The following variable is for a checkbox option type
        $c_html = $instance[ 'c_html' ] ? 'true' : 'false';

        echo '<div class="is-nt'.$colxs.$colsm.$colmd.$collg.$class.'">';

        echo wp_kses( $before_widget, naturally_allowed_html() );

            if ( $title ) {
                echo wp_kses( $before_title . $title . $after_title, naturally_allowed_html() );
            }
            // Retrieve the checkbox
            if( 'true' == $c_html ) {
                echo wp_kses( $text, naturally_allowed_html() );
            }

            if( 'false' == $c_html ) {
                if ( has_nav_menu($menu) ) {
                    echo'<ul class="nav-list">';
                        // default wp menu
                        wp_nav_menu(
                            array(
                                'theme_location' => $menu,
                                'container' => '', // menu wrapper element
                                'container_class' => '',
                                'container_id' => '', // default: none
                                'menu_class' => '', // ul class
                                'menu_id' => '', // ul id
                                'items_wrap' => '%3$s',
                                'before' => '', // before <a>
                                'after' => '', // after <a>
                                'link_before' => '', // inside <a>, before text
                                'link_after' => '', // inside <a>, after text
                                'depth' => 1, // '0' to display all depths
                                'echo' => true,
                                'fallback_cb' => 'Naturally_Wp_Bootstrap_Navwalker::fallback',
                                'walker' => new Naturally_Wp_Bootstrap_Navwalker()
                            )
                        );
                    echo'</ul>';
                }
            }
        echo wp_kses( $after_widget, naturally_allowed_html() );
        echo '</div>';
    }

    public function update( $new_instance, $old_instance )
    {
        $instance = $old_instance;
        $instance[ 'title' ] = strip_tags($new_instance[ 'title' ]);
        $instance['text'] = wp_kses($new_instance['text'], naturally_allowed_html());
        // The update for the variable of the checkbox
        $instance[ 'c_html' ] = $new_instance[ 'c_html' ];
        $instance[ 'c_link' ] = $new_instance[ 'c_link' ];
        $instance[ 'c_lgcol' ] = $new_instance[ 'c_lgcol' ];
        $instance[ 'c_mdcol' ] = $new_instance[ 'c_mdcol' ];
        $instance[ 'c_smcol' ] = $new_instance[ 'c_smcol' ];
        $instance[ 'c_xscol' ] = $new_instance[ 'c_xscol' ];
        $instance[ 'c_class' ] = $new_instance[ 'c_class' ];
        return $instance;
    }

    public function form( $instance )
    {
        $defaults = array(
            'title' => esc_html__( 'Useful Links', 'naturally' ),
            'c_html' => 'off',
            'c_lgcol' => '',
            'c_mdcol' => '',
            'c_smcol' => '',
            'c_xscol' => '',
            'c_link' => '',
            'c_class' => ''
        );
        $instance = wp_parse_args( ( array ) $instance, $defaults );
        $registered_menus = get_registered_nav_menus();
        $collg = array(
            '' => esc_html__( 'Select column width', 'naturally' ),
            'is-lg-auto' => esc_html__( 'Auto column', 'naturally' ),
            'is-lg-1' => esc_html__( '1 column', 'naturally' ),
            'is-lg-2' => esc_html__( '2 column', 'naturally' ),
            'is-lg-3' => esc_html__( '3 column', 'naturally' ),
            'is-lg-4' => esc_html__( '4 column', 'naturally' ),
            'is-lg-5' => esc_html__( '5 column', 'naturally' ),
            'is-lg-6' => esc_html__( '6 column', 'naturally' ),
            'is-lg-7' => esc_html__( '7 column', 'naturally' ),
            'is-lg-8' => esc_html__( '8 column', 'naturally' ),
            'is-lg-9' => esc_html__( '9 column', 'naturally' ),
            'is-lg-10' => esc_html__( '10 column', 'naturally' ),
            'is-lg-11' => esc_html__( '11 column', 'naturally' ),
            'is-lg-12' => esc_html__( '12 column', 'naturally' )
        );
        $colmd = array(
            '' => esc_html__( 'Select column width', 'naturally' ),
            'is-md-auto' => esc_html__( 'Auto column', 'naturally' ),
            'is-md-1' => esc_html__( '1 column', 'naturally' ),
            'is-md-2' => esc_html__( '2 column', 'naturally' ),
            'is-md-3' => esc_html__( '3 column', 'naturally' ),
            'is-md-4' => esc_html__( '4 column', 'naturally' ),
            'is-md-5' => esc_html__( '5 column', 'naturally' ),
            'is-md-6' => esc_html__( '6 column', 'naturally' ),
            'is-md-7' => esc_html__( '7 column', 'naturally' ),
            'is-md-8' => esc_html__( '8 column', 'naturally' ),
            'is-md-9' => esc_html__( '9 column', 'naturally' ),
            'is-md-10' => esc_html__( '10 column', 'naturally' ),
            'is-md-11' => esc_html__( '11 column', 'naturally' ),
            'is-md-12' => esc_html__( '12 column', 'naturally' )
        );
        $colsm = array(
            '' => esc_html__( 'Select column width', 'naturally' ),
            'is-sm-auto' => esc_html__( 'Auto column', 'naturally' ),
            'is-sm-1' => esc_html__( '1 column', 'naturally' ),
            'is-sm-2' => esc_html__( '2 column', 'naturally' ),
            'is-sm-3' => esc_html__( '3 column', 'naturally' ),
            'is-sm-4' => esc_html__( '4 column', 'naturally' ),
            'is-sm-5' => esc_html__( '5 column', 'naturally' ),
            'is-sm-6' => esc_html__( '6 column', 'naturally' ),
            'is-sm-7' => esc_html__( '7 column', 'naturally' ),
            'is-sm-8' => esc_html__( '8 column', 'naturally' ),
            'is-sm-9' => esc_html__( '9 column', 'naturally' ),
            'is-sm-10' => esc_html__( '10 column', 'naturally' ),
            'is-sm-11' => esc_html__( '11 column', 'naturally' ),
            'is-sm-12' => esc_html__( '12 column', 'naturally' )
        );
        $colxs = array(
            '' => esc_html__( 'Select column width', 'naturally' ),
            'is-xs-auto' => esc_html__( 'Auto column', 'naturally' ),
            'is-1' => esc_html__( '1 column', 'naturally' ),
            'is-2' => esc_html__( '2 column', 'naturally' ),
            'is-3' => esc_html__( '3 column', 'naturally' ),
            'is-4' => esc_html__( '4 column', 'naturally' ),
            'is-5' => esc_html__( '5 column', 'naturally' ),
            'is-6' => esc_html__( '6 column', 'naturally' ),
            'is-7' => esc_html__( '7 column', 'naturally' ),
            'is-8' => esc_html__( '8 column', 'naturally' ),
            'is-9' => esc_html__( '9 column', 'naturally' ),
            'is-10' => esc_html__( '10 column', 'naturally' ),
            'is-11' => esc_html__( '11 column', 'naturally' ),
            'is-12' => esc_html__( '12 column', 'naturally' )
        );
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php echo esc_html__( 'Title', 'naturally' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $instance[ 'title' ] ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_name( 'c_lgcol' ) ); ?>"><?php echo esc_html__( 'Responsive Column ( Large Device )', 'naturally' ); ?></label>
        </p>
        <p>
            <select class="is-lg" name="<?php echo esc_attr( $this->get_field_name( 'c_lgcol' ) ); ?>">
                <?php foreach ( $collg as $col => $desc) { ?>
                    <option <?php selected( $instance[ 'c_lgcol' ], $col ); ?> value="<?php echo esc_attr( $col ); ?>"><?php echo esc_attr( $desc ); ?></option>
                <?php } ?>
            </select>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_name( 'c_mdcol' ) ); ?>"><?php echo esc_html__( 'Responsive Column ( Desktop / Tablet-Landscape )', 'naturally' ); ?></label>
        </p>
        <p>
            <select class="is-md" name="<?php echo esc_attr( $this->get_field_name( 'c_mdcol' ) ); ?>">
                <?php foreach ( $colmd as $col => $desc) { ?>
                    <option <?php selected( $instance[ 'c_mdcol' ], $col ); ?> value="<?php echo esc_attr( $col ); ?>"><?php echo esc_attr( $desc ); ?></option>
                <?php } ?>
            </select>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_name( 'c_smcol' ) ); ?>"><?php echo esc_html__( 'Responsive Column ( Tablet-Portrait )', 'naturally' ); ?></label>
        </p>
        <p>
            <select class="is-sm" name="<?php echo esc_attr( $this->get_field_name( 'c_smcol' ) ); ?>">
                <?php foreach ( $colsm as $col => $desc) { ?>
                    <option <?php selected( $instance[ 'c_smcol' ], $col ); ?> value="<?php echo esc_attr( $col ); ?>"><?php echo esc_attr( $desc ); ?></option>
                <?php } ?>
            </select>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_name( 'c_xscol' ) ); ?>"><?php echo esc_html__( 'Responsive Column ( Phone )', 'naturally' ); ?></label>
        </p>
        <p>
            <select class="is-sm" name="<?php echo esc_attr( $this->get_field_name( 'c_xscol' ) ); ?>">
                <?php foreach ( $colxs as $col => $desc) { ?>
                    <option <?php selected( $instance[ 'c_xscol' ], $col ); ?> value="<?php echo esc_attr( $col ); ?>"><?php echo esc_attr( $desc ); ?></option>
                <?php } ?>
            </select>
        </p>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance[ 'c_html' ], 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'c_html' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'c_html' ) ); ?>" />
            <label for="<?php echo esc_attr( $this->get_field_id( 'c_html' ) ); ?>"><?php echo esc_html__( 'Use Custom HTML instead of Link (click the save button after checking)', 'naturally' ); ?></label>
        </p>
        <?php if ( 'on' == $instance[ 'c_html' ] ) { ?>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'text' ) ); ?>"><?php echo esc_html__( 'Custom HTML Area', 'naturally' ); ?></label>
                <textarea class="widefat content" id="<?php echo esc_attr( $this->get_field_id( 'text' ) ); ?>" rows="10" cols="10" name="<?php echo esc_attr( $this->get_field_name( 'text' ) ); ?>"><?php echo wp_kses( $instance[ 'text' ], naturally_allowed_html()); ?></textarea>
            </p>
        <?php } else { ?>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_name( 'c_link' ) ); ?>"><?php echo esc_html__( 'Select Menu:', 'naturally' ); ?></label>
                <select name="<?php echo esc_attr( $this->get_field_name( 'c_link' ) ); ?>">
                    <?php foreach ( $registered_menus as $location => $description ) { ?>
                        <option <?php selected( $instance[ 'c_link' ], $location ); ?> value="<?php echo esc_attr( $location ); ?>"><?php echo esc_attr( $description ); ?></option>
                    <?php } ?>
                </select>
            </p>
        <?php } ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'c_class' ) ); ?>"><?php echo esc_html__( 'Custom Class', 'naturally' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'c_class' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'c_class' ) ); ?>" type="text" value="<?php echo esc_attr( $instance[ 'c_class' ] ); ?>" />
        </p>
    <?php
    }
}
