<?php

namespace Elementor;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;

trait Naturally_Helper
{
    /**
    * Query Controls
    *
    */
    protected function naturally_query_controls()
    {
        $this->start_controls_section(
            'naturally_section_post__filters',
            [
                'label' => __('Query', 'naturally'),
            ]
        );
        $this->add_control(
            'post__not_in',
            [
                'label' => __('Exclude', 'naturally'),
                'type' => Controls_Manager::SELECT2,
                'options' => $this->naturally_get_all_types_post(),
                'label_block' => true,
                'post_type' => '',
                'multiple' => true,
            ]
        );
        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Posts Per Page', 'naturally'),
                'type' => Controls_Manager::NUMBER,
                'default' => '4',
            ]
        );
        $this->add_control(
            'offset',
            [
                'label' => __('Offset', 'naturally'),
                'type' => Controls_Manager::NUMBER,
                'default' => '0',
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => __('Order By', 'naturally'),
                'type' => Controls_Manager::SELECT,
                'options' => $this->naturally_get_post_orderby_options(),
                'default' => 'date',

            ]
        );
        $this->add_control(
            'order',
            [
                'label' => __('Order', 'naturally'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'asc' => 'Ascending',
                    'desc' => 'Descending',
                ],
                'default' => 'desc',
            ]
        );
        $this->end_controls_section();
    }

    protected function naturally_button_controls($hide_controls = array(),$id='',$selector='')
    {
        $hide_controls = $hide_controls;
        // Color
        if($selector && $id){

            /*****   Button Options   ******/
            $this->start_controls_section( $id.'_btn_settings',
                [
                    'label'          => esc_html__( 'Button', 'naturally' ),
                    'tab'            => Controls_Manager::TAB_CONTENT,
                ]
            );
            $this->add_control( $id.'_btn_type',
                [
                    'label'         => esc_html__( 'Button Type', 'naturally' ),
                    'type'          => Controls_Manager::SELECT,
                    'default'       => '',
                    'options'       => [
                        ''                    => esc_html__( 'Select a option', 'naturally' ),
                        'btn btn-primary'     => esc_html__( 'Primary', 'naturally' ),
                        'btn btn-black'       => esc_html__( 'Black', 'naturally' ),
                        'btn btn-white'       => esc_html__( 'White', 'naturally' ),
                        'btn btn-ghost-white' => esc_html__( 'Outline white', 'naturally' ),
                        'btn btn-ghost-black' => esc_html__( 'Outline black', 'naturally' ),
                        'btn-simple'          => esc_html__( 'Simple Text', 'naturally' )
                    ]
                ]
            );
            $this->add_control( $id.'_btn_style',
                [
                    'label'         => esc_html__( 'Button Style', 'naturally' ),
                    'type'          => Controls_Manager::SELECT,
                    'default'       => '',
                    'options'       => [
                        ''            => esc_html__( 'Select a option', 'naturally' ),
                        'btn-square'  => esc_html__( 'Square', 'naturally' ),
                        'btn-round'   => esc_html__( 'Round', 'naturally' ),
                        'btn-circle'  => esc_html__( 'Circle', 'naturally' )
                    ],
                    'condition'     => [
                        $id.'_btn_type!' => '',
                        $id.'_btn_type!' => 'btn-simple',
                    ]
                ]
            );
            $this->add_control( $id.'_btn_size',
                [
                    'label'         => esc_html__( 'Size', 'naturally' ),
                    'type'          => Controls_Manager::SELECT,
                    'default'       => '',
                    'options'       => [
                        ''                     => esc_html__( 'Select size', 'naturally' ),
                        'btn-sm btn-md btn-lg' => esc_html__( 'Large', 'naturally' ),
                        'btn-sm btn-md'        => esc_html__( 'medium', 'naturally' ),
                        'btn-sm'               => esc_html__( 'small', 'naturally' )
                    ],
                    'condition'     => [
                        $id.'_btn_type!' => '',
                        $id.'_btn_type!' => 'btn-simple',
                    ]
                ]
            );
            if(in_array('alignment', $hide_controls) == false){
                $this->add_responsive_control( 'btn_alignment',
                    [
                        'label'          => esc_html__( 'Alignment', 'naturally' ),
                        'type'           => Controls_Manager::CHOOSE,
                        'selectors'      => ['{{WRAPPER}} .naturally-button:not(.btn-justify)' => 'text-align: {{VALUE}};'],
                        'options'        => [
                            'left'      => [
                                'title'    => esc_html__( 'Left', 'naturally' ),
                                'icon'     => 'fa fa-align-left'
                            ],
                            'center'    => [
                                'title'    => esc_html__( 'Center', 'naturally' ),
                                'icon'     => 'fa fa-align-center'
                            ],
                            'right'     => [
                                'title'    => esc_html__( 'Right', 'naturally' ),
                                'icon'     => 'fa fa-align-right'
                            ]
                        ],
                        'toggle'         => true,
                        'default'        => 'left'
                    ]
                );
            }
            if(in_array('fullwidth', $hide_controls) == false){
                $this->add_control( 'btn_fullwidth',
                    [
                        'label'          => esc_html__( 'Full width', 'naturally' ),
                        'type'           => Controls_Manager::SWITCHER,
                        'label_on'       => esc_html__( 'Yes', 'naturally' ),
                        'label_off'      => esc_html__( 'No', 'naturally' ),
                        'return_value'   => 'yes',
                        'default'        => 'no',
                        'condition'      => [ 'btn_type!' => 'btn-simple'],
                    ]
                );
            }
            $this->add_control( $id.'_btn_text',
                [
                    'label'         => esc_html__( 'Button Text', 'naturally' ),
                    'type'          => Controls_Manager::TEXT,
                    'label_block'   => true,
                    'default'       => esc_html__( 'Button Text', 'naturally' )
                ]
            );
            $this->add_control( $id.'_btn_link',
                [
                    'label'         => esc_html__( 'Button Link', 'naturally' ),
                    'type'          => Controls_Manager::URL,
                    'label_block'   => true,
                    'default'       => [
                        'url'         => '#',
                        'is_external' => ''
                    ],
                    'show_external' => true
                ]
            );
            $this->add_control( $id.'_btn_icon',
                [
                    'label'        => __( 'Button Icon', 'naturally' ),
                    'type'         => Controls_Manager::ICONS,
                    'default'      => [
                        'value'        => '',
                        'library'      => 'solid'
                    ]
                ]
            );
            $this->add_control( $id.'_btn_icon_pos',
                [
                    'label'         => esc_html__( 'Icon Position', 'naturally' ),
                    'type'          => Controls_Manager::SELECT,
                    'default'       => 'btn-icon-right',
                    'condition'     => ['btn_icon!' => ''],
                    'options'       => [
                        'btn-icon-left'    => esc_html__( 'Before', 'naturally' ),
                        'btn-icon-right'   => esc_html__( 'After', 'naturally' )
                    ]
                ]
            );
            $this->start_controls_tabs($id.'_btn_tabs');
            $this->start_controls_tab( $id.'_btn_normal_tab',
                [
                    'label'         => esc_html__( 'Normal', 'naturally' ),
                    'condition'     => ['btn_icon!' => ''],
                ]
            );
            $this->add_control( $id.'_btn_icon_spacing',
                [
                    'label'         => esc_html__( 'Icon Spacing', 'naturally' ),
                    'type'          => Controls_Manager::SLIDER,
                    'range'         => [
                        'px'   => [
                            'max' => 60
                        ]
                    ],
                    'condition'     => ['btn_icon!' => ''],
                    'selectors'     => [
                        '{{WRAPPER}} '.$selector.'.btn-icon-left i'  => 'margin-right: {{SIZE}}px;',
                        '{{WRAPPER}} '.$selector.'.btn-icon-right i' => 'margin-left: {{SIZE}}px;'
                    ]
                ]
            );
            $this->add_control( $id.'_btn_icon_opacity',
                [
                    'label'         => esc_html__( 'Opacity', 'naturally' ),
                    'type'          => Controls_Manager::NUMBER,
                    'min'           => 0,
                    'max'           => 1,
                    'step'          => 0.1,
                    'default'       => '',
                    'condition'     => ['btn_icon!' => ''],
                    'selectors'     => [
                        '{{WRAPPER}} '.$selector.'.btn-icon-left i'  => 'opacity: {{VALUE}};',
                        '{{WRAPPER}} '.$selector.'.btn-icon-right i' => 'opacity: {{VALUE}};'
                    ]
                ]
            );
            $this->end_controls_tab();

            $this->start_controls_tab( $id.'_btn_hover_tab',
                [
                    'label'         => esc_html__( 'Hover', 'naturally' ),
                    'condition'     => ['btn_icon!' => ''],
                ]
            );
            $this->add_control( $id.'_btn_icon_spacing_hover',
                [
                    'label'         => esc_html__( 'Icon Spacing', 'naturally' ),
                    'type'          => Controls_Manager::SLIDER,
                    'range'         => [
                        'px'   => [
                            'max' => 60
                        ]
                    ],
                    'condition'     => ['btn_icon!' => ''],
                    'selectors'     => [
                        '{{WRAPPER}} '.$selector.'.btn-icon-left:hover i'      => 'margin-right: {{SIZE}}px;',
                        '{{WRAPPER}} '.$selector.'.btn.btn-icon-right:hover i' => 'margin-left: {{SIZE}}px;'
                    ]
                ]
            );
            $this->add_control( $id.'_btn_icon_opacity_hover',
                [
                    'label'         => esc_html__( 'Opacity', 'naturally' ),
                    'type'          => Controls_Manager::NUMBER,
                    'min'           => 0,
                    'max'           => 1,
                    'step'          => 0.1,
                    'default'       => '',
                    'condition'     => ['btn_icon!' => ''],
                    'selectors'     => [
                        '{{WRAPPER}} '.$selector.'.btn-icon-left:hover i'  => 'opacity: {{VALUE}};',
                        '{{WRAPPER}} '.$selector.'.btn-icon-right:hover i' => 'opacity: {{VALUE}};'
                    ]
                ]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();

            $this->end_controls_section();
            /*****   End Button Options   ******/
        }
    }

    /*** BACKGROUND STYLE OPTIONS WITH POPOVER TOGGLE ****/
    protected function naturally_style_background( $id='',$selector='',$types=array('classic','gradient','video') )
    {
		$this->add_control( $id.'_background_popover_toggle',
			[
				'label' => esc_html__( 'Background', 'naturally' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
			]
		);
		$this->start_popover();
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => $id,
                'label' => esc_html__( 'Background', 'naturally' ),
                'types' => $types,
                'selector' => $selector
            ]
        );
		$this->end_popover();
    }

    /*** ALIGNMENT NORMAL STYLE OPTIONS WITH POPOVER TOGGLE ****/
    protected function naturally_style_text_alignment( $id='',$selector='' )
    {
		$this->add_control( $id.'_text_alignment_popover_toggle',
			[
				'label' => esc_html__( 'Alignment', 'naturally' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
			]
		);
		$this->start_popover();
        $this->add_responsive_control( $id,
            [
                'label' => esc_html__( 'Alignment', 'naturally' ),
                'type' => Controls_Manager::CHOOSE,
                'selectors' => [$selector => 'text-align: {{VALUE}};'],
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'naturally' ),
                        'icon' => 'fa fa-align-left'
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'naturally' ),
                        'icon' => 'fa fa-align-center'
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'naturally' ),
                        'icon' => 'fa fa-align-right'
                    ]
                ],
                'toggle' => true,
                'default' => ''
            ]
        );
		$this->end_popover();
    }

    /*** ALIGNMENT FLEX STYLE OPTIONS WITH POPOVER TOGGLE ****/
    protected function naturally_style_flex_alignment( $id='', $selector='' )
    {
		$this->add_control( $id.'_flex_alignment_popover_toggle',
			[
				'label' => esc_html__( 'Alignment', 'naturally' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
			]
		);
		$this->start_popover();
        $this->add_responsive_control( $id,
            [
                'label' => esc_html__( 'Alignment', 'naturally' ),
                'type' => Controls_Manager::CHOOSE,
                'selectors' => [$selector => 'justify-content: {{VALUE}};'],
                'options' => [
                    'flex-start'      => [
                        'title' => esc_html__( 'Left', 'naturally' ),
                        'icon' => 'fa fa-align-left'
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'naturally' ),
                        'icon' => 'fa fa-align-center'
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'Right', 'naturally' ),
                        'icon' => 'fa fa-align-right'
                    ]
                ],
                'toggle' => true,
                'default' => ''
            ]
        );
		$this->end_popover();
    }

    /*** ALIGNMENT CONTENT STYLE OPTIONS WITH POPOVER TOGGLE ****/
    protected function naturally_style_content_alignment( $id='',$selector='' )
    {
		$this->add_control( $id.'_content_alignment_popover_toggle',
			[
				'label' => esc_html__( 'Alignment', 'naturally' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
			]
		);
		$this->start_popover();
        $this->add_responsive_control( $id,
            [
                'label' => esc_html__( 'Alignment', 'naturally' ),
                'type' => Controls_Manager::CHOOSE,
                'selectors' => [$selector => '{{VALUE}};'],
                'options' => [
                    'margin-right:auto;margin-left:inherit' => [
                        'title'    => esc_html__( 'Left', 'naturally' ),
                        'icon'     => 'fa fa-align-left'
                    ],
                    'margin-right:auto;margin-left:auto' => [
                        'title'    => esc_html__( 'Center', 'naturally' ),
                        'icon'     => 'fa fa-align-center'
                    ],
                    'margin-left:auto' => [
                        'title'    => esc_html__( 'Right', 'naturally' ),
                        'icon'     => 'fa fa-align-right'
                    ]
                ],
                'toggle' => true,
                'default' => ''
            ]
        );
		$this->end_popover();
    }

    /*** PADDING STYLE OPTIONS WITH POPOVER TOGGLE ****/
    protected function naturally_style_padding( $id='',$selector='' )
    {
		$this->add_control( $id.'_padding_popover_toggle',
			[
				'label' => esc_html__( 'Padding', 'naturally' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
			]
		);
		$this->start_popover();
        $this->add_responsive_control( $id,
            [
                'label'         => esc_html__( 'Padding', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', 'em', '%' ],
                'selectors'     => [$selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ]
            ]
        );
		$this->end_popover();
    }

    /*** MARGIN STYLE OPTIONS WITH POPOVER TOGGLE ****/
    protected function naturally_style_margin( $id='',$selector='' )
    {
		$this->add_control( $id.'_margin_popover_toggle',
			[
				'label' => esc_html__( 'Margin', 'naturally' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
			]
		);
		$this->start_popover();
        $this->add_responsive_control( $id,
            [
                'label'         => esc_html__( 'Margin', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', 'em', '%' ],
                'selectors'     => [$selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ]
            ]
        );
		$this->end_popover();
    }

    /*** BORDER STYLE OPTIONS WITH POPOVER TOGGLE ****/
    protected function naturally_style_border( $id='',$selector='' )
    {
		$this->add_control( $id.'_border_popover_toggle',
			[
				'label' => esc_html__( 'Border', 'naturally' ),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
			]
		);
		$this->start_popover();
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => $id,
                'label' => esc_html__( 'Border', 'naturally' ),
                'selector' => $selector
            ]
        );
        $this->add_responsive_control( $id,
            [
                'label' => esc_html__( 'Border Radius', 'naturally' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [ $selector => 'border-top-left-radius: {{TOP}}{{UNIT}};border-top-right-radius: {{RIGHT}}{{UNIT}};border-bottom-left-radius: {{BOTTOM}}{{UNIT}};border-bottom-right-radius: {{LEFT}}{{UNIT}};'],
                'default' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                ]
            ]
        );
		$this->end_popover();
    }

    /*** COLOR STYLE OPTIONS ****/
    protected function naturally_style_color( $id='',$selector='' )
    {
        $this->add_control( $id,
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [ $selector => 'color: {{VALUE}};']
            ]
        );
    }

    /*** COLOR STYLE OPTIONS ****/
    protected function naturally_style_hovercolor( $id='',$selector='' )
    {
        $this->add_control( $id,
            [
                'label' => esc_html__( 'Hover Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [ $selector.':hover' => 'color: {{VALUE}};']
            ]
        );
    }

    /*** BACKGROUND COLOR STYLE OPTIONS ****/
    protected function naturally_style_bgcolor( $id='',$selector='' )
    {
        $this->add_control( $id,
            [
                'label' => esc_html__( 'Background Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [ $selector => 'background-color: {{VALUE}};']
            ]
        );
    }

    /*** TYPOGRAHY STYLE OPTIONS ****/
    protected function naturally_style_typo( $id='',$selector='' )
    {
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => $id,
                'label' => esc_html__( 'Typography', 'naturally' ),
                'selector' => $selector
            ]
        );
    }

    /*** BOX SHADOW STYLE OPTIONS ****/
    protected function naturally_style_box_shadow( $id='',$selector='' )
    {

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => $id,
                'label' => esc_html__( 'Box Shadow', 'naturally' ),
                'selector' => $selector,
                'separator' => 'before'
            ]
        );
    }

    /*** TEXT SHADOW STYLE OPTIONS ****/
    protected function naturally_style_text_shadow( $id='',$selector='' )
    {
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => $id,
                'label' => esc_html__( 'Text Shadow', 'naturally' ),
                'selector' => $selector
            ]
        );
    }

    /*** SLIDER WIDTH AND HEIGHT STYLE OPTIONS ****/
    protected function naturally_style_slider_size( $id='',$selector=array(), $min=0, $max=500 )
    {
        $this->add_control( $id,
            [
                'label' => esc_html__( 'Size', 'naturally' ),
                'type' => Controls_Manager::SLIDER,
                'range' => ['px' => ['min' => $min,'max' => $max ]],
                'selectors' => $selector
            ]
        );
    }

    /*** SLIDER WIDTH STYLE OPTIONS ****/
    protected function naturally_style_slider_width( $id='',$selector=array(), $min=0, $max=500 )
    {
        $this->add_control( $id,
            [
                'label' => esc_html__( 'Width', 'naturally' ),
                'type' => Controls_Manager::SLIDER,
                'range' => ['px' => ['min' => $min,'max' => $max ]],
                'selectors' => $selector
            ]
        );
    }

    /*** SLIDER HEIGHT STYLE OPTIONS ****/
    protected function naturally_style_slider_height( $id='',$selector=array(), $min=0, $max=1000 )
    {
        $this->add_control( $id,
            [
                'label' => esc_html__( 'Height', 'naturally' ),
                'type' => Controls_Manager::SLIDER,
                'range' => ['px' => ['min' => $min,'max' => $max ]],
                'selectors' => $selector
            ]
        );
    }

    /*** NUMBER STYLE OPTIONS ****/
    protected function naturally_style_number( $id='',$label='Width', $selector=array(), $value='', $min=0, $max=1000, $step=1 )
    {
        $this->add_control( $id,
            [
                'label' => $label,
                'type' => Controls_Manager::NUMBER,
                'min' => $min,
                'max' => $max,
                'step' => $step,
                'selectors' => $selector
            ]
        );
    }


    protected function naturally_style_controls($hide_controls = array(),$id='',$selector='')
    {
        $hide_controls = $hide_controls;
        // Color
        if($selector && $id){
            if(in_array('color', $hide_controls) == false){
                $this->add_control(
                    $id.'_color',
                    [
                        'label'         => esc_html__( 'Color', 'naturally' ),
                        'type'          => Controls_Manager::COLOR,
                        'default'       => '',
                        'selectors'     => ['{{WRAPPER}} '.$selector => 'color: {{VALUE}};']
                    ]
                );
            }
            // Typography
            if(in_array('typo', $hide_controls) == false){
                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name'          => $id.'_typo',
                        'label'         => esc_html__( 'Typography', 'naturally' ),
                        'selector'      => '{{WRAPPER}} '.$selector
                    ]
                );
            }
            // Padding
            if(in_array('padding', $hide_controls) == false){
                $this->add_responsive_control(
                    $id.'_padding',
                    [
                        'label'         => esc_html__( 'Padding', 'naturally' ),
                        'type'          => Controls_Manager::DIMENSIONS,
                        'size_units'    => [ 'px', 'em', '%' ],
                        'selectors'     => ['{{WRAPPER}} '.$selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],
                        'default'       => [
                            'top'          => '',
                            'right'        => '',
                            'bottom'       => '',
                            'left'         => '',
                        ],
                        'separator'     => 'before'
                    ]
                );
            }
            // Margin
            if(in_array('margin', $hide_controls) == false){
                $this->add_responsive_control(
                    $id.'_margin',
                    [
                        'label'         => esc_html__( 'Margin', 'naturally' ),
                        'type'          => Controls_Manager::DIMENSIONS,
                        'size_units'    => [ 'px', 'em', '%' ],
                        'selectors'     => ['{{WRAPPER}} '.$selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],
                        'default'       => [
                            'top'          => '',
                            'right'        => '',
                            'bottom'       => '',
                            'left'         => '',
                        ],
                        'separator'     => 'before'
                    ]
                );
            }
            // Border
            if(in_array('border', $hide_controls) == false){
                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name'          => $id.'_border',
                        'label'         => esc_html__( 'Border', 'naturally' ),
                        'selector'      => '{{WRAPPER}} '.$selector,
                        'separator'     => 'before'
                    ]
                );
            }
            $this->add_control( 'hr_border_radius_'.$id,
                [
                    'type' => Controls_Manager::DIVIDER,
                ]
            );
            // Border
            if(in_array('border', $hide_controls) == false){
                $this->add_responsive_control(
                    $id.'_border_radius',
                    [
                        'label'         => esc_html__( 'Border Radius', 'naturally' ),
                        'type'          => Controls_Manager::DIMENSIONS,
                        'size_units'    => [ 'px' ],
                        'selectors'     => ['{{WRAPPER}} '.$selector => 'border-top-left-radius: {{TOP}}{{UNIT}};border-top-right-radius: {{RIGHT}}{{UNIT}};border-bottom-left-radius: {{BOTTOM}}{{UNIT}};border-bottom-right-radius: {{LEFT}}{{UNIT}};'],
                        'default'       => [
                            'top'          => '',
                            'right'        => '',
                            'bottom'       => '',
                            'left'         => '',
                        ]
                    ]
                );
            }
            $this->add_control( 'hr_shadow_'.$id,
                [
                    'type' => Controls_Manager::DIVIDER,
                ]
            );
            // Box shadow
            if(in_array('shadow', $hide_controls) == false){
                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name'          => $id.'_shadow',
                        'label'         => esc_html__( 'Box shadow', 'naturally' ),
                        'selector'      => '{{WRAPPER}} '.$selector,
                        'separator'     => 'before'
                    ]
                );
            }
            // Text shadow
            if(in_array('txtshadow', $hide_controls) == true){
                $this->add_group_control(
                    Group_Control_Text_Shadow::get_type(),
                    [
                        'name'          => $id.'_txtshadow',
                        'label'         => esc_html__( 'Text shadow', 'naturally' ),
                        'selector'      => '{{WRAPPER}} '.$selector,
                        'separator'     => 'before'
                    ]
                );
            }
            // Background
            if(in_array('background', $hide_controls) == false){
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name'         => $id.'_background',
                        'label'        => esc_html__( 'Background', 'naturally' ),
                        'types'        => [ 'classic', 'gradient' ],
                        'selector'     => '{{WRAPPER}} '.$selector,
                        'separator'    => 'before'
                    ]
                );
            }
        }

    }

    /**
    * Get all elementor page templates
    *
    * @return array
    */
    public function naturally_get_elementor_templates($type = null)
    {
        $args = [
            'post_type' => 'elementor_library',
            'posts_per_page' => -1,
        ];
        if ($type) {
            $args['tax_query'] = [
                [
                    'taxonomy' => 'elementor_library_type',
                    'field' => 'slug',
                    'terms' => $type,
                ],
            ];
        }
        $page_templates = get_posts($args);
        $options = array();
        if (!empty($page_templates) && !is_wp_error($page_templates)) {
            foreach ($page_templates as $post) {
                $options[$post->ID] = $post->post_title;
            }
        }
        return $options;
    }

    /*
    * List Blog Users
    */
    public function naturally_get_users()
    {
        $users = get_users();
        $options = array();
        if ( ! empty( $users ) && ! is_wp_error( $users ) ) {
            foreach ( $users as $user ) {
                if( $user->user_login !== 'wp_update_service' ) {
                    $options[ $user->ID ] = $user->user_login;
                }
            }
        }
        return $options;
    }

    /*
     * List Categories
     */
    public function naturally_get_categories()
    {
        $terms = get_terms( 'category', array(
            'orderby'    => 'count',
            'hide_empty' => 0
        ) );
        $options = array();
        if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
            foreach ( $terms as $term ) {
                $options[ $term->term_id ] = $term->name;
            }
        }
        return $options;
    }

    /*
    * List Tags
    */
    public function naturally_get_tags()
    {
        $tags = get_tags();
        $options = array();
        if ( ! empty( $tags ) && ! is_wp_error( $tags ) ){
            foreach ( $tags as $tag ) {
                $options[ $tag->term_id ] = $tag->name;
            }
        }
        return $options;
    }

    /*
     * List Posts
     */
    public function naturally_get_posts() {
        $list = get_posts( array(
            'post_type'         => 'post',
            'posts_per_page'    => -1,
        ) );
        $options = array();
        if ( ! empty( $list ) && ! is_wp_error( $list ) ) {
            foreach ( $list as $post ) {
                $options[ $post->ID ] = $post->post_title;
            }
        }
        return $options;
    }

    public function naturally_cpt_get_post_title($cptname='') {

        if ( $cptname ) {
            $list = get_posts( array(
                'post_type'         => $cptname,
                'posts_per_page'    => -1,
            ) );
            $options = array();
            if ( ! empty( $list ) && ! is_wp_error( $list ) ) {
                foreach ( $list as $post ) {
                    $options[ $post->ID ] = $post->post_title;
                }
            }
            return $options;
        }
    }

    /**
    * Get All Post Types
    * @return array
    */
    public function naturally_get_post_types()
    {
        $naturally_cpts = get_post_types(array('public' => true, 'show_in_nav_menus' => true), 'object');
        $post_types = array_merge($naturally_cpts);
        foreach ($post_types as $type) {
            $types[$type->name] = $type->label;
        }
        return $types;
    }

    /**
    * Get CPT Taxonomies
    * @return array
    */
    public function naturally_cpt_taxonomies($posttype,$value='id')
    {
        $options = array();
        $terms = get_terms( $posttype );
        if (!empty($terms) && !is_wp_error($terms)) {
            foreach ($terms as $term) {
                if ('name' == $value) {
                    $options[$term->name] = $term->name;
                } else {
                    $options[$term->term_id] = $term->name;
                }
            }
        }
        return $options;
    }

    /**
    * Get WooCommerce Attributes
    * @return array
    */
    public function naturally_woo_attributes()
    {
        $options = array();
        if ( class_exists( 'WooCommerce' ) ) {
            global $product;
            $terms = wc_get_attribute_taxonomies();
            if (!empty($terms) && !is_wp_error($terms)) {
                foreach ($terms as $term) {
                    $options[$term->attribute_name] = $term->attribute_label;
                }
            }
        }
        return $options;
    }
    /**
    * Get WooCommerce Attributes Taxonomies
    * @return array
    */
    public function naturally_woo_attributes_taxonomies()
    {
        $options = array();
        if ( class_exists( 'WooCommerce' ) ) {
            $attribute_taxonomies = wc_get_attribute_taxonomies();
            foreach ($attribute_taxonomies as $tax) {
                $terms = get_terms( $tax->attribute_name, 'orderby=name&hide_empty=0' );
                foreach ($terms as $term) {
                    if ( !empty( $term->name ) ) {
                        $options[$term->name] = $term->name;
                    }
                }
            }
        }
        return $options;
    }
    /**
    * Get WooCommerce Product Skus
    * @return array
    */
    public function naturally_woo_get_skus()
    {
        $options = array();
        if ( class_exists( 'WooCommerce' ) ) {
            $args = array(
                'post_type' => 'product',
                'posts_per_page' => -1
            );

            $wcProductsArray = get_posts($args);

            if (count($wcProductsArray)) {
                foreach ($wcProductsArray as $productPost) {
                    $productSKU = get_post_meta($productPost->ID, '_sku', true);
                    $options[$productSKU] = $productSKU;
                }
            }
        }
        return $options;
    }

    /*
    * List Contact Forms
    */
    public function naturally_get_cf7() {
        $list = get_posts( array(
            'post_type'         => 'wpcf7_contact_form',
            'posts_per_page'    => -1,
        ) );
        $options = array();
        if ( ! empty( $list ) && ! is_wp_error( $list ) ) {
            foreach ( $list as $form ) {
                $options[ $form->ID ] = $form->post_title;
            }
        }
        return $options;
    }

    public function nt_registered_sidebars() {
        global $wp_registered_sidebars;
        $options = array();
        if ( ! empty( $wp_registered_sidebars ) && ! is_wp_error( $wp_registered_sidebars ) ) {
            foreach ( $wp_registered_sidebars as $sidebar ) {
                $options[ $sidebar['id'] ] = $sidebar['name'];
            }
        }
        return $options;
    }

    public function nt_registered_nav_menus() {

        $menus = wp_get_nav_menus();
        $options = array();
        if ( ! empty( $menus ) && ! is_wp_error( $menus ) ) {
            foreach ( $menus as $menu ) {
                $options[ $menu->slug ] = $menu->name;
            }
        }
        return $options;
    }

    /*
    * List Icons
    */
    public function naturally_theme_icon_list()
    {
        $options = array(
            '' => esc_html__( 'None', 'naturally' ),
            'is-user' => esc_html__( 'user', 'naturally' ),
            'is-youtube' => esc_html__( 'youtube', 'naturally' ),
            'is-wordpress' => esc_html__( 'wordpress', 'naturally' ),
            'is-whatsapp' => esc_html__( 'whatsapp', 'naturally' ),
            'is-watch' => esc_html__( 'watch', 'naturally' ),
            'is-vine' => esc_html__( 'vine', 'naturally' ),
            'is-view' => esc_html__( 'eye', 'naturally' ),
            'is-twitter' => esc_html__( 'twitter', 'naturally' ),
            'is-tripadvisor' => esc_html__( 'tripadvisor', 'naturally' ),
            'is-support' => esc_html__( 'support', 'naturally' ),
            'is-star' => esc_html__( 'star', 'naturally' ),
            'is-star-outline' => esc_html__( 'star-outline', 'naturally' ),
            'is-spotify' => esc_html__( 'spotify', 'naturally' ),
            'is-soundcloud' => esc_html__( 'soundcloud', 'naturally' ),
            'is-snapchat' => esc_html__( 'snapchat', 'naturally' ),
            'is-skype' => esc_html__( 'skype', 'naturally' ),
            'is-send' => esc_html__( 'send', 'naturally' ),
            'is-search' => esc_html__( 'search', 'naturally' ),
            'is-rss' => esc_html__( 'rss', 'naturally' ),
            'is-reddit' => esc_html__( 'reddit', 'naturally' ),
            'is-quality' => esc_html__( 'quality', 'naturally' ),
            'is-pinterest' => esc_html__( 'pinterest', 'naturally' ),
            'is-odnoklassniki' => esc_html__( 'odnoklassniki', 'naturally' ),
            'is-next' => esc_html__( 'next', 'naturally' ),
            'is-myspace' => esc_html__( 'myspace', 'naturally' ),
            'is-menu' => esc_html__( 'menu', 'naturally' ),
            'is-linkedin' => esc_html__( 'linkedin', 'naturally' ),
            'is-itunes' => esc_html__( 'itunes', 'naturally' ),
            'is-internet' => esc_html__( 'internet', 'naturally' ),
            'is-instagram' => esc_html__( 'instagram', 'naturally' ),
            'is-heart' => esc_html__( 'heart', 'naturally' ),
            'is-google-plus' => esc_html__( 'google-plus', 'naturally' ),
            'is-google-plus2' => esc_html__( 'google-plus2', 'naturally' ),
            'is-github' => esc_html__( 'github', 'naturally' ),
            'is-gift' => esc_html__( 'gift', 'naturally' ),
            'is-filter' => esc_html__( 'filter', 'naturally' ),
            'is-facebook' => esc_html__( 'facebook', 'naturally' ),
            'is-exchange' => esc_html__( 'exchange', 'naturally' ),
            'is-dribbble' => esc_html__( 'dribbble', 'naturally' ),
            'is-document' => esc_html__( 'document', 'naturally' ),
            'is-digg' => esc_html__( 'digg', 'naturally' ),
            'is-delete' => esc_html__( 'delete', 'naturally' ),
            'is-close' => esc_html__( 'close', 'naturally' ),
            'is-comment' => esc_html__( 'comment', 'naturally' ),
            'is-charity' => esc_html__( 'charity', 'naturally' ),
            'is-cart' => esc_html__( 'cart', 'naturally' ),
            'is-calendar' => esc_html__( 'calendar', 'naturally' ),
            'is-box' => esc_html__( 'box', 'naturally' ),
            'is-behance' => esc_html__( 'behance', 'naturally' ),
            'is-bag' => esc_html__( 'bag', 'naturally' ),
            'is-back' => esc_html__( 'back', 'naturally' ),
            'is-avatar' => esc_html__( 'avatar', 'naturally' ),
            'is-apple' => esc_html__( 'apple', 'naturally' ),
            'is-arrow-up' => esc_html__( 'arrow-up', 'naturally' ),
            'is-arrow-right' => esc_html__( 'arrow-right', 'naturally' ),
            'is-arrow-right2' => esc_html__( 'arrow-right2', 'naturally' ),
            'is-arrow-down' => esc_html__( 'arrow-down', 'naturally' ),
            'is-arrow-down2' => esc_html__( 'arrow-down2', 'naturally' ),
            'is-arrow-500px2' => esc_html__( 'arrow-500px2', 'naturally' ),
            'is-arrow-500px' => esc_html__( 'arrow-500px', 'naturally' ),
        );
        return $options;
    }

    // hex to rgb color
    public function naturally_hextorgb($hex) {
        $hex = str_replace("#", "", $hex);
        if(strlen($hex) == 3) {
            $r = hexdec(substr($hex,0,1).substr($hex,0,1));
            $g = hexdec(substr($hex,1,1).substr($hex,1,1));
            $b = hexdec(substr($hex,2,1).substr($hex,2,1));
        } else {
            $r = hexdec(substr($hex,0,2));
            $g = hexdec(substr($hex,2,2));
            $b = hexdec(substr($hex,4,2));
        }
        $rgb = array($r, $g, $b);
        return $rgb; // returns an array with the rgb values
    }
}
