<?php
/**
* Plugin Name: Naturally Elementor Addons
* Description: Premium & Advanced Essential Elements for Elementor
* Plugin URI:  http://themeforest.net/user/Ninetheme
* Version:     1.3.9
* Author:      Ninetheme
* Author URI:  http://themeforest.net/user/Ninetheme
*/

/*
* Exit if accessed directly.
*/

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'NATURALLY_PLUGIN_FILE', __FILE__ );
define( 'NATURALLY_PLUGIN_BASENAME', plugin_basename(__FILE__) );
define( 'NATURALLY_PLUGIN_PATH', plugin_dir_path(__FILE__) );
define( 'NATURALLY_PLUGIN_URL', plugins_url('/', __FILE__) );

final class Naturally_Elementor_Addons
{

    /**
    * Plugin Version
    *
    * @since 1.0
    *
    * @var string The plugin version.
    */
    const VERSION = '1.3.9';

    /**
    * Minimum Elementor Version
    *
    * @since 1.0
    *
    * @var string Minimum Elementor version required to run the plugin.
    */
    const MINIMUM_ELEMENTOR_VERSION = '2.0.0';

    /**
    * Minimum PHP Version
    *
    * @since 1.0
    *
    * @var string Minimum PHP version required to run the plugin.
    */
    const MINIMUM_PHP_VERSION = '5.6';

    /**
    * Instance
    *
    * @since 1.0
    *
    * @access private
    * @static
    *
    * @var Naturally_Elementor_Addons The single instance of the class.
    */
    private static $_instance = null;

    /**
    * Instance
    *
    * Ensures only one instance of the class is loaded or can be loaded.
    *
    * @since 1.0
    *
    * @access public
    * @static
    *
    * @return Naturally_Elementor_Addons An instance of the class.
    */
    public static function instance()
    {

        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    /**
    * Constructor
    *
    * @since 1.0
    *
    * @access public
    */
    public function __construct()
    {
        add_action( 'init', [ $this, 'i18n' ] );
        add_action( 'plugins_loaded', [ $this, 'init' ] );
    }

    /**
    * Load Textdomain
    *
    * Load plugin localization files.
    *
    * Fired by `init` action hook.
    *
    * @since 1.0
    *
    * @access public
    */
    public function i18n()
    {
        load_plugin_textdomain( 'naturally' );
    }

    /**
    * Initialize the plugin
    *
    * Load the plugin only after Elementor (and other plugins) are loaded.
    * Checks for basic plugin requirements, if one check fail don't continue,
    * if all check have passed load the files required to run the plugin.
    *
    * Fired by `plugins_loaded` action hook.
    *
    * @since 1.0
    *
    * @access public
    */
    public function init()
    {

        // Check if Elementor is installed and activated
        if ( ! did_action( 'elementor/loaded' ) ) {
            add_action( 'admin_notices', [ $this, 'naturally_admin_notice_missing_main_plugin' ] );
            return;
        }
        // Check for required Elementor version
        if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
            add_action( 'admin_notices', [ $this, 'naturally_admin_notice_minimum_elementor_version' ] );
            return;
        }
        // Check for required PHP version
        if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
            add_action( 'admin_notices', [ $this, 'naturally_admin_notice_minimum_php_version' ] );
            return;
        }
        // register template name for the elementor saved templates
        add_filter( 'elementor/editor/localize_settings', [ $this,'naturally_register_template'],10,2 );

        /* Custom plugin helper functions */
        require_once( NATURALLY_PLUGIN_PATH . '/classes/class-helpers-functions.php' );
        /* Elementor section parallax */
        require_once( NATURALLY_PLUGIN_PATH . '/classes/class-custom-elementor-section.php' );
        /* Add custom controls to default widgets */
        require_once( NATURALLY_PLUGIN_PATH . '/classes/class-customizing-default-widgets.php' );
        /* Add custom controls to page settings */
        require_once( NATURALLY_PLUGIN_PATH . '/classes/class-customizing-page-settings.php' );
        /* Image resizer */
        require_once( NATURALLY_PLUGIN_PATH . '/classes/class-image-resizer.php' );
        /* Naturally Elementor template */
        require_once( NATURALLY_PLUGIN_PATH . '/classes/class-templater.php' );
        /* Custom metaboxes for gallery post type */
        require_once( NATURALLY_PLUGIN_PATH . '/classes/class-metaboxes-gallery.php' );
        /* Custom widget for footer widget area */
        require_once( NATURALLY_PLUGIN_PATH . '/classes/class-footer-widget.php' );
        /* includes/shortcodes/elementor */
        if ( ! get_option( 'disable_naturally_list_shortcodes' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/classes/class-list-shortcodes.php' );
        }
        /* Admin template */
        require_once( NATURALLY_PLUGIN_PATH . '/templates/admin/admin.php' );
        // Categories registered
        add_action( 'elementor/elements/categories_registered', [ $this, 'naturally_add_widget_category' ] );
        // Widgets registered
        add_action( 'elementor/widgets/widgets_registered', [ $this, 'init_widgets' ] );
        // Register Widget Styles
        add_action( 'elementor/frontend/after_enqueue_styles', [ $this, 'widget_styles' ] );
        // Register Widget Editor Styles
        add_action('elementor/editor/after_enqueue_scripts', [ $this, 'admin_custom_scripts' ]);
        // Register Widget Scripts
        add_action( 'elementor/frontend/after_enqueue_scripts', [ $this, 'widget_scripts' ] );
        // Register Widget Scripts
        add_action( 'wp_print_styles', [ $this, 'naturally_elementor_addons_dequeue_style' ], 100 );

        // add share icon to single post footer section
        add_action( 'single_post_after_tags_action', [ $this, 'naturally_single_post_share' ], 10 );
    }

    public function naturally_register_template($localized_settings,$config)
    {
        $localized_settings = [
            'i18n' => [
                'my_templates' => esc_html__( 'Naturally Templates', 'naturally' )
            ]
        ];
        return $localized_settings;
    }


    public function naturally_elementor_addons_dequeue_style()
    {
        if ( is_page_template( 'naturally-elementor-page.php' ) ){
            wp_dequeue_style( 'naturally-framework-style' );
        }
    }

    /*************************************************
    ##  SINLGE POST/CPT SHARE
    *************************************************/
    public function naturally_single_post_share()
    {
        if ( function_exists( 'naturally_settings' ) && '0' != naturally_settings( 'single_post_share_visibility', '1' ) ) { ?>

            <div class="grid_col is-12 is-lg-auto">
                <div class="blog-single_share">
                    <h3 class="blog-single_share_title"><?php esc_html_e( 'Share Article','naturally' ); ?></h3>
                    <div class="social-icons is-white">
                        <?php if ('0' != naturally_settings( 'single_post_share_facebook_visibility', '1' ) ) { ?>
                            <a class="social-icons_link" href="http://www.facebook.com/sharer.php?u=<?php echo esc_url( get_permalink() ); ?>" target="_blank"><span class="icon is-facebook"></span></a>
                        <?php } ?>
                        <?php if ('0' != naturally_settings( 'single_post_share_twitter_visibility', '1' ) ) { ?>
                            <a class="social-icons_link" href="http://twitter.com/share?url=<?php echo esc_url( get_permalink() ); ?>" target="_blank"><span class="icon is-twitter"></span></a>
                        <?php } ?>
                        <?php if ( '0' != naturally_settings( 'single_post_share_google_visibility', '1' ) ) { ?>
                            <a class="social-icons_link" href="https://plus.google.com/share?url=<?php echo esc_url( get_permalink() ); ?>" target="_blank"><span class="icon is-google-plus2"></span></a>
                        <?php } ?>
                        <?php if ('0' != naturally_settings( 'single_post_share_pinterest_visibility', '1' ) ) { ?>
                            <a class="social-icons_link" href="javascript:void((function()%7Bvar%20e=document.createElement('script');e.setAttribute('type','text/javascript');e.setAttribute('charset','UTF-8');e.setAttribute('src','http://assets.pinterest.com/js/pinmarklet.js?r='+Math.random()*99999999);document.body.appendChild(e)%7D)());"><span class="icon is-pinterest"></span></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <?php
        }
    }

    public function admin_custom_scripts()
    {
        // Plugin editor css
        wp_enqueue_style( 'naturally-editor', NATURALLY_PLUGIN_URL. 'assets/front/css/plugin-editor.css' );
    }

    public function widget_styles()
    {
        // Plugin custom css
        wp_enqueue_style( 'naturally-slick', NATURALLY_PLUGIN_URL. 'assets/front/js/slick/slick.css' );
        wp_enqueue_style( 'naturally-addons-plugin-custom', NATURALLY_PLUGIN_URL. 'assets/front/css/custom.css' );
    }

    public function widget_scripts()
    {
        // Plugin custom scripts
        wp_enqueue_script( 'naturally-js-slick', NATURALLY_PLUGIN_URL. 'assets/front/js/slick/slick.min.js', [ 'jquery' ], self::VERSION, true);
        wp_enqueue_script( 'naturally-isotope', NATURALLY_PLUGIN_URL. 'assets/front/js/isotope/isotope.min.js', [ 'jquery' ], self::VERSION, true );
        // Parallax background and html elenments
        wp_enqueue_script( 'naturally-jarallax-video', NATURALLY_PLUGIN_URL. 'assets/front/js/jarallax/jarallax-video.min.js', [ 'jquery' ], self::VERSION, true );
        wp_enqueue_script( 'naturally-jarallax', NATURALLY_PLUGIN_URL. 'assets/front/js/jarallax/jarallax.min.js', [ 'jquery' ], self::VERSION, true );
        wp_enqueue_script( 'naturally-jarallax-fronted', NATURALLY_PLUGIN_URL. 'assets/front/js/jarallax/jarallax-fronted.js', [ 'jquery' ], self::VERSION, true );
        // custom-scripts
        wp_enqueue_script( 'naturally-addons-custom-scripts', NATURALLY_PLUGIN_URL. 'assets/front/js/custom-scripts.js', [ 'jquery' ], self::VERSION, true );
    }

    /**
    * Admin notice
    *
    * Warning when the site doesn't have Elementor installed or activated.
    *
    * @since 1.0
    *
    * @access public
    */
    public function naturally_admin_notice_missing_main_plugin()
    {
        if ( isset( $_GET['activate'] ) ) {
            unset( $_GET['activate'] );
        }
        $message = sprintf(
            /* translators: 1: Plugin name 2: Elementor */
            esc_html__( '%1$s requires %2$s to be installed and activated.', 'naturally' ),
            '<strong>' . esc_html__( 'Naturally Elementor Addons', 'naturally' ) . '</strong>',
            '<strong>' . esc_html__( 'Elementor', 'naturally' ) . '</strong>'
        );
        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
    }

    /**
    * Admin notice
    *
    * Warning when the site doesn't have a minimum required Elementor version.
    *
    * @since 1.0
    *
    * @access public
    */
    public function naturally_admin_notice_minimum_elementor_version()
    {
        if ( isset( $_GET['activate'] ) ) {
            unset( $_GET['activate'] );
        }
        $message = sprintf(
            /* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
            esc_html__( '%1$s requires %2$s version %3$s or greater.', 'naturally' ),
            '<strong>' . esc_html__( 'Naturally Elementor Addons', 'naturally' ) . '</strong>',
            '<strong>' . esc_html__( 'Elementor', 'naturally' ) . '</strong>',
             self::MINIMUM_ELEMENTOR_VERSION
        );
        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
    }

    /**
    * Admin notice
    *
    * Warning when the site doesn't have a minimum required PHP version.
    *
    * @since 1.0
    *
    * @access public
    */
    public function naturally_admin_notice_minimum_php_version()
    {
        if ( isset( $_GET['activate'] ) ) {
            unset( $_GET['activate'] );
        }
        $message = sprintf(
            /* translators: 1: Plugin name 2: PHP 3: Required PHP version */
            esc_html__( '%1$s requires %2$s version %3$s or greater.', 'naturally' ),
            '<strong>' . esc_html__( 'Naturally Elementor Addons', 'naturally' ) . '</strong>',
            '<strong>' . esc_html__( 'PHP', 'naturally' ) . '</strong>',
             self::MINIMUM_PHP_VERSION
        );
        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
    }

    /**
    * Register Widgets Category
    *
    */
    public function naturally_add_widget_category( $elements_manager )
    {
        $elements_manager->add_category( 'naturally', ['title' => esc_html__( 'Naturally Addons', 'naturally' )]);
        $elements_manager->add_category( 'naturally-woo', ['title' => esc_html__( 'Naturally WooCommerce', 'naturally' )]);
    }

    /**
    * Init Widgets
    *
    * Include widgets files and register them
    *
    * @since 1.0
    *
    * @access public
    */
    public function init_widgets()
    {
        // Naturally_Onepage_Menu_Widget
        if ( ! get_option( 'disable_naturally_onepage_menu' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-onepage-menu.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Onepage_Menu_Widget() );
        }
        // Naturally_Onepage_Menu_Widget
        if ( ! get_option( 'disable_naturally_magamenu_menu' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/mega-menu/mega-menu.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Mega_Menu_Widget() );
        }
        // Naturally_Onepage_Menu_Widget
        if ( ! get_option( 'disable_naturally_magamenu_menu' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/mega-menu2/mega-menu2.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Mega_Menu2_Widget() );
        }
        // Naturally_Page_Hero_Widget
        if ( ! get_option( 'disable_naturally_page_hero' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-page-hero.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Page_Hero_Widget() );
        }
        // Naturally_Home_Slider_One_Widget
        if ( ! get_option( 'disable_naturally_home_slider' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-home-slider.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Home_Slider_Widget() );
        }
        // Naturally_Home_Hero_Widget
        if ( ! get_option( 'disable_naturally_home_hero' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-home-hero.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Home_Hero_Widget() );
        }
        // Naturally_Product_Banner_Item_Widget
        if ( ! get_option( 'disable_naturally_products_banner' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-product-banner.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Product_Banner_Widget() );
        }
        // Naturally_Gallery_Banner_Widget
        if ( ! get_option( 'disable_naturally_gallery_banner' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-gallery-banner.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Gallery_Banner_Widget() );
        }
        // Naturally_Features_One_Section_Widget
        if ( ! get_option( 'disable_naturally_features' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-features.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Features_Widget() );
        }
        // Naturally_Testimonials_One_Section_Widget
        if ( ! get_option( 'disable_naturally_testimonials' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-testimonials.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Testimonials_Widget() );
        }
        // Naturally_Blog_Slider_Section_Widget
        if ( ! get_option( 'disable_naturally_blog_slider' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-blog-slider.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Blog_Slider_Widget() );
        }
        // Naturally_Split_Slider_Section_Widget
        if ( ! get_option( 'disable_naturally_split_slider' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-split-slider.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Split_Slider_Widget() );
        }
        // Naturally_Photo_Slider_Section_Widget
        if ( ! get_option( 'disable_naturally_photo_slider' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-photo-slider.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Photo_Slider_Widget() );
        }
        // Naturally_Partners_Slider_Section_Widget
        if ( ! get_option( 'disable_naturally_partners_slider' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-partners-slider.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Partners_Slider_Widget() );
        }
        // Naturally_Counter_Up_Widget
        if ( ! get_option( 'disable_naturally_counterup' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-counterup.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_CounteUp_Widget() );
        }
        // Naturally_Team_Member_Item_Widget
        if ( ! get_option( 'disable_naturally_team_member' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-team-member.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Team_Member_Widget() );
        }
        // Naturally_Gallery_Grid_Section_Widget
        if ( ! get_option( 'disable_naturally_gallery_grid' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-gallery-grid.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Gallery_Grid_Widget() );
        }
        // Naturally_Gallery_Masonry_Section_Widget
        if ( ! get_option( 'disable_naturally_gallery_masonry' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-gallery-masonry.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Gallery_Masonry_Widget() );
        }
        // Naturally_Alert_Widget
        if ( ! get_option( 'disable_naturally_breadcrumbs' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-breadcrumbs.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Breadcrumbs_Widget() );
        }
        // Naturally_Alert_Widget
        if ( ! get_option( 'disable_naturally_alert' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-alert.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Alert_Widget() );
        }
        // Naturally_Badge_Label_Widget
        if ( ! get_option( 'disable_naturally_badge_label' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-badge-label.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Badge_Label_Widget() );
        }
        // Naturally_Blockquote_Widget
        if ( ! get_option( 'disable_naturally_blockquote' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-blockquote.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Blockquote_Widget() );
        }
        // Naturally_Accordion_Tabs_Widget
        if ( ! get_option( 'disable_naturally_accordion_tabs' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-accordion-tabs.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Accordion_Tabs_Widget() );
        }
        // Naturally_Tabs_Widget
        if ( ! get_option( 'disable_naturally_tabs' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-tabs.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Tabs_Widget() );
        }
        // Naturally_Button_Widget
        if ( ! get_option( 'disable_naturally_button' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-button.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Button_Widget() );
        }
        // Naturally_Button_Widget
        if ( ! get_option( 'disable_naturally_social_icons' ) == 1 ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-social-icons.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Social_Icons_Widget() );
        }
        // Naturally_Header_Search_Widget
        if ( ! get_option( 'disable_naturally_header_search' ) == 1  ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-header-search.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Header_Search_Widget() );
        }
        // Naturally_Header_Langs_Widget
        if ( ! get_option( 'disable_naturally_header_langs' ) == 1  ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-header-langs.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Header_Langs_Widget() );
        }
        // Naturally_Contact_Form_7_Widget
        if ( ! get_option( 'disable_naturally_contact_form7' ) == 1 && class_exists( 'WPCF7' ) ) {
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-contact-form-7.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Contact_Form_7_Widget() );
        }
        // Naturally_Product_Slider_Section_Widget
        if ( ! get_option( 'disable_naturally_woo' ) == 1 && class_exists( 'WooCommerce' ) ) {
            // Naturally_Woo_Product_Item_Widget
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/woocommerce/naturally-woo-product-item.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Woo_Product_Item_Widget() );
            // Naturally_Woo_Product_Slider_Widget
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/woocommerce/naturally-woo-product-slider.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Woo_Product_Slider_Widget() );
            // Naturally_Woo_Category_Slider_Widget
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/woocommerce/naturally-woo-category-slider.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Woo_Category_Slider_Widget() );
            // Naturally_Woo_Products_Grid_Widget
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/woocommerce/naturally-woo-products-grid.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Woo_Products_Grid_Widget() );
            // Naturally_Woo_Products_Grid_Two_Widget
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/woocommerce/naturally-woo-products-grid-two.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Woo_Products_Grid_Two_Widget() );
            // Naturally_Woo_Products_Gallery_Widget
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/woocommerce/naturally-woo-products-gallery.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Woo_Products_Gallery_Widget() );
            // Naturally_Woo_My_Account_Widget
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/woocommerce/naturally-woo-page.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Woo_Page_Widget() );
            // Naturally_Woo_My_Account_Widget
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/woocommerce/naturally-woo-my-account.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Woo_My_Account_Widget() );
            // Naturally_Woo_Checkout_Form_Widget
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/woocommerce/naturally-woo-checkout-form.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Woo_Checkout_Form_Widget() );
            // Naturally_Minicart_Widget
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/woocommerce/naturally-woo-mini-cart.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Woo_Minicart_Widget() );
            // Naturally_Woo_Flash_Deals_Slider
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/woocommerce/naturally-woo-flash-deals.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Woo_Flash_Deals_Slider() );
            // Naturally_Woo_Category_Grid_Widget
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/woocommerce/naturally-woo-category-grid.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Naturally_Woo_Category_Grid_Widget() );
        }
        // Naturally_Product_Slider_Section_Widget
        if ( ! get_option( 'disable_naturally_rev_slider' ) == 1 && class_exists( 'RevSlider' ) ) {
            // Naturally_Woo_Product_Slider_Widget
            require_once( NATURALLY_PLUGIN_PATH . '/widgets/naturally-rev-sliders.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Naturally_Rev_Slider_Widget() );
        }
    }
}
Naturally_Elementor_Addons::instance();
