<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Mega_Menu_Widget extends Widget_Base {
    use Naturally_Helper;

    public function get_name() {
        return 'naturally-mega-menu';
    }
    public function get_title() {
        return 'Header Mega Menu (N)';
    }
    public function get_icon() {
        return 'eicon-nav-menu';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);
        wp_register_style( 'naturally-mega-menu', NATURALLY_PLUGIN_URL. 'widgets/mega-menu/style.css');
        wp_register_script( 'modernizr', NATURALLY_PLUGIN_URL. 'widgets/mega-menu/modernizr.js', '', '1.0.0', false );
        wp_register_script( 'jquery-mobile-custom', NATURALLY_PLUGIN_URL. 'widgets/mega-menu/jquery.mobile.custom.min.js', [ 'jquery' ], '1.0.0', true);
        wp_register_script( 'naturally-mega-menu', NATURALLY_PLUGIN_URL. 'widgets/mega-menu/script.js', [ 'elementor-frontend' ], '1.0.0', true);

    }
    public function get_style_depends() {
        return [ 'naturally-mega-menu' ];
    }
    public function get_script_depends() {
        return [ 'modernizr','jquery-mobile-custom','naturally-mega-menu' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'header_logo_section',
            [
                'label' => esc_html__( 'Logo', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'logotext',
            [
                'label' => esc_html__( 'Text Logo', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_attr(get_bloginfo('name')),
                'label_block' => true
            ]
        );
        $this->add_control( 'logo',
            [
                'label' => esc_html__( 'Logo Image', 'naturally' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => '']
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'full',
                'condition' => [ 'logo[url]!' => '' ]
            ]
        );
        $this->add_control( 'mlogo',
            [
                'label' => esc_html__( 'Mobile Logo Image', 'naturally' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => '']
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail_m',
                'default' => 'full',
                'condition' => [ 'mlogo[url]!' => '' ]
            ]
        );
        $this->add_control( 'logolink',
            [
                'label' => esc_html__( 'Logo Link', 'naturally' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'default' => [
                    'url' => esc_url(home_url('/')),
                    'is_external' => ''
                ],
                'show_external' => true,
            ]
        );
        $this->add_responsive_control( 'logo_max_width',
            [
                'label' => esc_html__( 'Max Width ( px )', 'naturally' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px'   => [
                        'max' => 1000
                    ]
                ],
                'selectors' => [ '{{WRAPPER}} .nt-logo' => 'max-width:{{SIZE}}px;' ]
            ]
        );
        $this->add_control( 'logo_padding',
            [
                'label'         => esc_html__( 'Padding', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', 'em', '%' ],
                'selectors'     => ['{{WRAPPER}} .nt-logo' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ]
            ]
        );
        $this->add_control( 'logo_margin',
            [
                'label'         => esc_html__( 'Margin', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', 'em', '%' ],
                'selectors'     => ['{{WRAPPER}} .nt-logo' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ]
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('megamenu_general_settings',
            [
                'label' => esc_html__( 'Mega Menu', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new Repeater();
        $repeater->add_control( 'name',
            [
                'label' => esc_html__( 'Name', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Home',
                'label_block' => true
            ]
        );
        $repeater->add_control( 'link',
            [
                'label' => esc_html__( 'Link', 'naturally' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'default' => [
                    'url' => '#sectionid',
                    'is_external' => 'true'
                ],
                'placeholder' => esc_html__( 'Place URL here', 'naturally' )
            ]
        );
        $repeater->add_control( 'mega_content_type',
            [
                'label' => esc_html__( 'Content Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'custom',
                'options' => [
                    'wp-menu' => esc_html__( 'Use Wp Menu', 'naturally' ),
                    'custom' => esc_html__( 'Custom Content', 'naturally' )
                ]
            ]
        );
        // Exclude Category
        $repeater->add_control( 'register_menus',
            [
                'label' => esc_html__( 'Select Menu', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => false,
                'label_block' => true,
                'options' => $this->nt_registered_nav_menus(),
                'condition' => [ 'mega_content_type' => 'wp-menu' ]
            ]
        );
        $repeater->add_control( 'megamenu_content',
            [
                'label' => esc_html__( 'Mega Menu Content', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'default' => '',
                'multiple' => false,
                'options' => $this->naturally_get_elementor_templates(),
                'condition' => [ 'mega_content_type' => 'custom' ]
            ]
        );
        $this->add_control( 'menus',
            [
                'label' => esc_html__( 'Items', 'naturally' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{name}}',
                'default' => [
                    [
                        'name' => 'Home',
                        'link' => '#',
                    ],
                    [
                        'name' => 'Home',
                        'link' => '#',
                    ],
                    [
                        'name' => 'Home',
                        'link' => '#',
                    ],
                ]
            ]
        );

        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'header_style_controls_section',
            [
                'label' => esc_html__( 'Desktop Header Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'header_heading',
            [
                'label' => esc_html__( 'HEADER CONTAINER', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        $this->add_responsive_control( 'alignment',
            [
                'label' => esc_html__( 'Alignment', 'betakit' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__( 'Left', 'betakit' ),
                        'icon' => 'fa fa-align-left'
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'betakit' ),
                        'icon' => 'fa fa-align-center'
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'Right', 'betakit' ),
                        'icon' => 'fa fa-align-right'
                    ]
                ],
                'toggle' => true,
                'default' => 'flex-end'
            ]
        );
        $this->add_control( 'background',
            [
                'label' => esc_html__( 'Background', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .nt-main-header.nt-desktop' => 'background:{{VALUE}};' ]
            ]
        );
        $this->add_control( 'height',
            [
                'label' => esc_html__( 'Height', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 200,
                'step' => 1,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .nt-desktop.nt-main-header' => 'height:{{VALUE}}px;',
                    '{{WRAPPER}} .nt-desktop .nt-primary-nav > li > a' => 'height:{{VALUE}}px;line-height:{{VALUE}}px;',
                    '{{WRAPPER}} .nt-desktop .nt-primary-nav .nt-secondary-nav' => 'top:{{VALUE}}px;'
                ]
            ]
        );
        $this->add_control( 'menu_heading',
            [
                'label' => esc_html__( 'MENU ITEMS', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator'     => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'menu_item_typo',
                'label' => esc_html__( 'Typography', 'naturally' ),
                'selector' => '{{WRAPPER}} .nt-desktop .nt-primary-nav > li > a'
            ]
        );
        $this->add_control( 'gap',
            [
                'label' => esc_html__( 'Gap', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .nt-desktop .nt-primary-nav > li:not(:first-child)' => 'margin-left:{{VALUE}}px;' ]
            ]
        );
        $this->add_control( 'menu_icon_color',
            [
                'label' => esc_html__( 'Menu Icon Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .nt-primary-nav > li > a > i' => 'color:{{VALUE}};' ]
            ]
        );
        $this->start_controls_tabs( 'menu_item_tabs');
        $this->start_controls_tab( 'menu_item_normal_tab',
            [ 'label'  => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->add_control( 'menu_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .nt-desktop .nt-primary-nav > li > a' => 'color:{{VALUE}};'
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'menu_item_hover_tab',
            [ 'label' => esc_html__( 'Hover / Active', 'naturally' ) ]
        );
        $this->add_control( 'menu_hvrcolor',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .nt-desktop .nt-primary-nav > li > a.selected, {{WRAPPER}} .nt-desktop .nt-primary-nav > li > a:hover' => 'color:{{VALUE}};',
                    '{{WRAPPER}} .nt-desktop .nt-primary-nav > li > a.selected' => 'border-bottom-color:{{VALUE}};'
                 ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control( 'submenu_heading',
            [
                'label' => esc_html__( 'DROPDOWN', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator'     => 'before'
            ]
        );
        $this->add_control( 'submenu_bg',
            [
                'label' => esc_html__( 'Background', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .nt-desktop .nt-primary-nav .nt-secondary-nav' => 'background:{{VALUE}};' ]
            ]
        );
        $this->add_control( 'submenu_padding',
            [
                'label'         => esc_html__( 'Padding', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', 'em', '%' ],
                'selectors'     => ['{{WRAPPER}} .nt-desktop .nt-primary-nav .nt-secondary-nav' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => ''
                ]
            ]
        );
        $this->add_control( 'submenu_width',
            [
                'label' => esc_html__( 'Submenu Column Width ( % )', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 2,
                'max' => 6,
                'step' => 1,
                'default' => 5
            ]
        );
        $this->add_control( 'submenu_brdcolor',
            [
                'label' => esc_html__( 'Border Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .nt-desktop .nt-primary-nav .nt-secondary-nav > li' => 'border-color:{{VALUE}};' ]
            ]
        );
        $this->add_control( 'submenu_fcolor',
            [
                'label' => esc_html__( 'Submenu First Item Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .nt-desktop .nt-primary-nav .nt-secondary-nav > li > a' => 'color:{{VALUE}};' ]
            ]
        );
        $this->add_control( 'submenu_color',
            [
                'label' => esc_html__( 'Submenu Item Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .nt-desktop .nt-primary-nav .nt-secondary-nav ul > li a' => 'color:{{VALUE}};'
                ]
            ]
        );
        $this->add_control( 'submenu_hvrcolor',
            [
                'label' => esc_html__( 'Hover Submenu Item Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .nt-desktop .nt-primary-nav .nt-secondary-nav ul > li a:hover' => 'color:{{VALUE}};',
                    '{{WRAPPER}} .nt-desktop .nt-primary-nav .nt-secondary-nav > li > a:hover' => 'color:{{VALUE}};'
                ]
            ]
        );

        $this->add_control( 'search_heading',
            [
                'label' => esc_html__( 'SEARCH', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );
        $this->add_control( 'hidesearch',
            [
                'label' => esc_html__( 'Hide Search', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no'
            ]
        );
        $this->add_control( 'search_title',
            [
                'label' => esc_html__( 'Search Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'condition' => [ 'hidesearch!' => 'yes' ],
                'default' => 'Search'
            ]
        );
        $this->add_control( 'search_bg',
            [
                'label' => esc_html__( 'Background', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .nt-search input' => 'background:{{VALUE}};' ]
            ]
        );
        $this->add_control( 'search_iconcolor',
            [
                'label' => esc_html__( 'Search Icon Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .nt-search-trigger::before' => 'border-color:{{VALUE}};',
                    '{{WRAPPER}} .nt-search-trigger::after' => 'background-color:{{VALUE}};',
                    '{{WRAPPER}} .nt-search-trigger span::before,{{WRAPPER}} .nt-search-trigger span::after' => 'background-color:{{VALUE}};'
                ]
            ]
        );
        $this->add_control( 'search_inputcolor',
            [
                'label' => esc_html__( 'Search Input Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} form input' => 'color:{{VALUE}};' ]
            ]
        );

        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'header_mobile_style_controls_section',
            [
                'label' => esc_html__( 'Mobile Header Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'menu_title',
            [
                'label' => esc_html__( 'Menu Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Menu'
            ]
        );
        $this->add_control( 'goback_title',
            [
                'label' => esc_html__( 'Go Back Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Go Back'
            ]
        );
        $this->add_control( 'header_mobile_heading',
            [
                'label' => esc_html__( 'HEADER CONTAINER', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        $this->add_control( 'mobile_header_bg',
            [
                'label' => esc_html__( 'Background', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .nt-mobile.nt-main-header, {{WRAPPER}} .nt-mobile .nt-primary-nav, {{WRAPPER}} .nt-mobile .nt-primary-nav ul' => 'background:{{VALUE}};' ]
            ]
        );
        $this->add_control( 'mobile_header_height',
            [
                'label' => esc_html__( 'Header Container Height ( px )', 'naturally' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px'   => [
                        'max' => 300
                    ]
                ],
                'selectors' => [ '{{WRAPPER}} .nt-mobile.nt-main-header' => 'height:{{SIZE}}px;' ]
            ]
        );
        $this->add_control( 'mobile_header_margin',
            [
                'label'         => esc_html__( 'Header Container Margin', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', 'em', '%' ],
                'selectors'     => ['{{WRAPPER}} .nt-mobile.nt-main-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => ''
                ]
            ]
        );
        $this->add_control( 'mobile_menu_heading',
            [
                'label' => esc_html__( 'MENU CONTAINER', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );
        $this->add_control( 'mobile_menu_padding',
            [
                'label'         => esc_html__( 'Menu Container Padding', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', 'em', '%' ],
                'selectors'     => ['{{WRAPPER}} .nt-mobile ul#nt-primary-nav, {{WRAPPER}} .nt-mobile ul.nt-secondary-nav, {{WRAPPER}} .nt-mobile ul.nt-secondary-nav li ul' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => ''
                ]
            ]
        );
        $this->add_control( 'mobile_menu_button_heading',
            [
                'label' => esc_html__( 'MENU BUTTON', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );
        $this->add_control( 'mobile_trigger_color',
            [
                'label' => esc_html__( 'Menu Button Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .nt-mobile .nt-nav-trigger span, {{WRAPPER}} .nt-mobile .nt-nav-trigger span::before, {{WRAPPER}} .nt-mobile .nt-nav-trigger span::after' => 'background:{{VALUE}};' ]
            ]
        );
        $this->add_control( 'mobile_trigger_active_color',
            [
                'label' => esc_html__( 'Menu Close Button Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .nav-is-visible.nt-mobile .nt-nav-trigger span::before, {{WRAPPER}} .nav-is-visible.nt-mobile .nt-nav-trigger span::after' => 'background:{{VALUE}};' ]
            ]
        );
        $this->add_control( 'mobile_menu_search_heading',
            [
                'label' => esc_html__( 'MENU SEARCH', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );
        $this->add_control( 'mobile_search_iconcolor',
            [
                'label' => esc_html__( 'Search Icon Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .nt-mobile .nt-search-trigger::before' => 'border-color:{{VALUE}};',
                    '{{WRAPPER}} .nt-mobile .nt-search-trigger::after' => 'background-color:{{VALUE}};',
                    '{{WRAPPER}} .nt-mobile .nt-search-trigger span::before,{{WRAPPER}} .nt-mobile .nt-search-trigger span::after' => 'background-color:{{VALUE}};'
                ]
            ]
        );
        $this->add_control( 'mobile_search_close_iconcolor',
            [
                'label' => esc_html__( 'Search Icon Color 2', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .nav-is-visible.nt-mobile .nt-search-trigger::before' => 'border-color:{{VALUE}};',
                    '{{WRAPPER}} .nav-is-visible.nt-mobile .nt-search-trigger::after' => 'background-color:{{VALUE}};',
                    '{{WRAPPER}} .nav-is-visible.nt-mobile .nt-search-trigger span::before,{{WRAPPER}} .nav-is-visible.nt-mobile .nt-search-trigger span::after' => 'background-color:{{VALUE}};'
                ]
            ]
        );
        $this->add_control( 'mobile_menu_item_heading',
            [
                'label' => esc_html__( 'MENU ITEM', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );
        $this->add_control( 'mobile_menu_color',
            [
                'label' => esc_html__( 'Menu Item Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .nt-mobile .nt-primary-nav > li > a, {{WRAPPER}} .nt-mobile .nt-primary-nav > li > a > i' => 'color:{{VALUE}};'
                ]
            ]
        );
        $this->add_control( 'mobile_menu_hvrcolor',
            [
                'label' => esc_html__( 'Hover Menu Item Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .nt-mobile .nt-primary-nav > li > a:hover, {{WRAPPER}} .nt-mobile .nt-primary-nav > li > a:hover > i' => 'color:{{VALUE}};' ]
            ]
        );
        $this->add_control( 'mobile_menu_brdcolor',
            [
                'label' => esc_html__( 'Hover Menu Item Border Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .nt-mobile .nt-primary-nav > li > a, .nt-mobile .nt-primary-nav ul > li > a' => 'border-bottom-color:{{VALUE}};' ]
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

    }

    protected function render()
    {
        $settings  = $this->get_settings_for_display();
        $id        = $this->get_id();
        $goback    = $settings['goback_title'] ? $settings['goback_title'] : esc_html__('Go Back','naturally');
        $hassearch = 'yes' != $settings['hidesearch'] ? ' has-search' : '';
        $hasmobilelogo = '' != $settings['mlogo']['url'] ? ' has-mobile-logo' : '';

        $image     = $this->get_settings( 'logo' );
        $image_url = Group_Control_Image_Size::get_attachment_image_src( $image['id'], 'thumbnail', $settings );
        $logo      = empty( $image_url ) ? $image['url'] : $image_url;

        $image_m     = $this->get_settings( 'mlogo' );
        $image_url_m = Group_Control_Image_Size::get_attachment_image_src( $image_m['id'], 'thumbnail_m', $settings );
        $logo_m      = empty( $image_url_m ) ? $image_m['url'] : $image_url_m;

        echo '<header class="nt-main-header'.$hasmobilelogo.'">';

            if ( '' != $settings['logo']['url'] ) {
                echo '<div class="nt-logo-wrapper">';
                echo '<a class="nt-logo" href="'.$settings['logolink']['url'].'"><img src="'.$logo.'" alt="'.esc_attr(get_bloginfo('name')).'"></a>';
                if ( '' != $settings['mlogo']['url'] ) {
                    echo '<a class="nt-logo mobile-logo" href="'.$settings['logolink']['url'].'"><img src="'.$logo_m.'" alt="'.esc_attr(get_bloginfo('name')).'"></a>';
                }
                echo '</div>';
            } else {
                if ( $settings['logotext'] ) {
                    echo '<a class="nt-logo" href="'.$settings['logolink']['url'].'">'.$settings['logotext'].'</a>';
                }
            }

            echo '<ul class="nt-header-buttons">';

                if ( 'yes' != $settings['hidesearch'] ) {
                    echo '<li><a class="nt-search-trigger" href="#nt-search">'.$settings['search_title'].'<span></span></a></li>';
                }

                echo '<li><a class="nt-nav-trigger" href="#nt-primary-nav">'.$settings['menu_title'].'<span></span></a></li>';
            echo '</ul>';
        echo '</header>';

        echo '<main class="nt-main-content">';
            echo '<div class="nt-overlay"></div>';
        echo '</main>';

        echo '<nav class="nt-nav align-'.$settings['alignment'].$hassearch.'" data-goback="'.esc_html($goback).'">';

            echo '<ul id="nt-primary-nav" class="nt-primary-nav is-fixed subcol-'.$settings['submenu_width'].'">';
                foreach ( $settings['menus'] as $item ) {

                    if ( !empty($item['megamenu_content'] ) || $item['register_menus'] ) {

                        $hasmega = $item['megamenu_content'] != '' ? 'has-mega' : 'header_nav_item';
                        $hasmenu = 'wp-menu' == $item['mega_content_type'] && $item['register_menus'] ? ' content-type-menu' : ' content-type-custom';
                        //$btnicon = $item['add_icon'] == 'yes' && $settings['icon']['value'] ? ' has-icon' : '';

                        echo '<li class="has-children '.$hasmega.'">';
                            $arrow = ' <span class="menu-arrow-wrapper"><i aria-hidden="true" class="fas fa-angle-down menu-arrow"></i></span>';
                            echo '<a href="'.$item['link']['url'].'">'.$item['name'].$arrow.'</a>';
                            //echo '<div class="nt-secondary-nav-wrapper">';
                            echo '<ul class="nt-secondary-nav is-hidden'.$hasmenu.'">';
                                echo '<li class="go-back"><a href="#0"><i aria-hidden="true" class="fas fa-angle-right go-back-arrow"></i> '.$settings['menu_title'].'</a></li>';

                                if ( 'custom' == $item['mega_content_type'] && !empty( $item['megamenu_content'] ) ) {
                                    $style = \Elementor\Plugin::$instance->editor->is_edit_mode() ? true : false;
                                    $template_id = $item['megamenu_content'];
                                    $mega_content = new Frontend;
                                    echo $mega_content->get_builder_content_for_display($template_id, $style );
                                }

                                if ( 'wp-menu' == $item['mega_content_type'] && $item['register_menus'] ) {
                                    echo wp_nav_menu(
                                        array(
                                            'menu' => $item['register_menus'],
                                            'theme_location' => '',
                                            'container' => '', // menu wrapper element
                                            'container_class' => '',
                                            'container_id' => '', // default: none
                                            'menu_class' => '', // ul class
                                            'menu_id' => '', // ul id
                                            'items_wrap' => '%3$s',
                                            'before' => '', // before <a>
                                            'after' => '', // after <a>
                                            'link_before' => '', // inside <a>, before text
                                            'link_after' => '', // inside <a>, after text
                                            'depth' => 4, // '0' to display all depths
                                            'echo' => true,
                                            'fallback_cb' => 'Naturally_Wp_Megamenu_Navwalker::fallback',
                                            'walker' => new \Naturally_Wp_Megamenu_Navwalker()
                                        )
                                    );
                                }
                            echo '</ul>';
                            //echo '</div>';
                        echo '</li>';
                    } else {
                        echo '<li class="menu-link"><a href="'.$item['link']['url'].'">'.$item['name'].'</a></li>';
                    }
                }
            echo '</ul>';
        echo '</nav>';

        if ( 'yes' != $settings['hidesearch'] && function_exists('naturally_megamenu_search_form') ) {
            echo '<div id="nt-search" class="nt-search">';
               if ( defined( 'YITH_WCAS' ) ) {
                    echo naturally_megamenu_search_form();
                } else {
                    echo naturally_megamenu_search_form();
                }
            echo '</div>';
        }
    }
}
