!(function ($) {

    'use strict';

    function ntrMegaMenu($Scope, $){
        //if you change this breakpoint in the style.css file (or _layout.scss if you use SASS), don't forget to update this value as well
        var MqL = 992;
        //move nav element position according to window width
        var myheader = $Scope.find('.nt-main-header');
        var mynav = $Scope.find('.nt-nav');
        var goback = $Scope.find('.nt-nav').data('goback');
        var megacontent = $Scope.find('.nt-secondary-nav');
        var mysearch = $Scope.find('.nt-search');

        myheader.parents('.elementor-column').addClass( 'header-parent-col' );

        if ( myheader.parents('.elementor-column').hasClass( 'elementor-col-100' ) ) {
             myheader.parents('.elementor-column').addClass( 'header-col-full' );
        } else {
            myheader.parents('.elementor-column').addClass( 'header-col-no-full' );
        }

        if ( $(window).width() < MqL ) {
            mynav.removeClass( 'nt-desktop' ).addClass( 'nt-mobile' );
            myheader.removeClass( 'nt-desktop' ).addClass( 'nt-mobile' );
            mysearch.removeClass( 'nt-desktop' ).addClass( 'nt-mobile' );
        } else {
            mynav.removeClass( 'nt-mobile' ).addClass( 'nt-desktop' );
            myheader.removeClass( 'nt-mobile' ).addClass( 'nt-desktop' );
            mysearch.removeClass( 'nt-mobile' ).addClass( 'nt-desktop' );
        }


        var left = $( ".header-parent-col" ).position().left;

        if ( $(window).width() >= MqL ) {
            if ( mynav.hasClass('align-flex-end') ) {
                megacontent.removeAttr( 'style' );
            } else {
                megacontent.css( 'left',-left );
            }
        }

        $Scope.parents('.elementor-top-section').css('z-index','1000');
        
        $Scope.find('.nt-primary-nav > li.has-children').each(function(){
            var submenu = $(this);
            var submenusize = submenu.find('> .nt-secondary-nav.content-type-menu > li.depth_0').size();
            var megamenuu = submenu.find('> .nt-secondary-nav.content-type-menu');
            if ( submenusize > 1 ) {
                megamenuu.parent('.has-children').addClass( 'nt-has-more-col' );
            } else {
                megamenuu.parent('.has-children').addClass( 'nt-has-one-col' );
            }
        });


        $( '<a href="#0"><i aria-hidden="true" class="fas fa-angle-left go-back-left"></i>'+goback+'</a>' ).replaceAll( '.go-back-link' );

        moveNavigation();

        $(window).on('resize', function(){

            (!window.requestAnimationFrame) ? setTimeout(moveNavigation, 300) : window.requestAnimationFrame(moveNavigation);
            if ( $(window).width() < MqL ) {
                mynav.removeClass( 'nt-desktop' ).addClass( 'nt-mobile' );
                myheader.removeClass( 'nt-desktop' ).addClass( 'nt-mobile' );
                mysearch.removeClass( 'nt-desktop' ).addClass( 'nt-mobile' );
            } else {
                mynav.removeClass( 'nt-mobile' ).addClass( 'nt-desktop' );
                myheader.removeClass( 'nt-mobile' ).addClass( 'nt-desktop' );
                mysearch.removeClass( 'nt-mobile' ).addClass( 'nt-desktop' );
            }

            var leftres = $( ".header-parent-col" ).position().left;

            if ( mynav.hasClass('align-flex-end') ) {
                megacontent.removeAttr( 'style' );
            } else {
                if ( mynav.hasClass('nt-desktop') ) {
                    megacontent.css( 'left',-leftres );
                } else {
                    megacontent.removeAttr( 'style' );
                }
            }
        });

        //mobile - open lateral menu clicking on the menu icon
        $Scope.find('.nt-nav-trigger').on('click', function(event){
            event.preventDefault();
            if( $Scope.find('.nt-main-content').hasClass('nav-is-visible') ) {
                closeNav();
                $Scope.find('.nt-overlay').removeClass('is-visible');
            } else {
                $(this).addClass('nav-is-visible');
                $Scope.find('.nt-primary-nav').addClass('nav-is-visible');
                $Scope.find('.nt-main-header').addClass('nav-is-visible');
                $Scope.find('.nt-main-content').addClass('nav-is-visible').one('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function(){
                    $('body').addClass('overflow-hidden');
                });
                toggleSearch('close');
                $Scope.find('.nt-overlay').addClass('is-visible');
            }
        });

        //open search form
        $Scope.find('.nt-search-trigger').on('click', function(event){
            event.preventDefault();
            toggleSearch();
            closeNav();
        });

        //close lateral menu on mobile
        $Scope.find('.nt-overlay').on('swiperight', function(){
            if($Scope.find('.nt-primary-nav').hasClass('nav-is-visible')) {
                closeNav();
                //$Scope.find('.nt-overlay').removeClass('is-visible');
            }
        });
        $Scope.find('.nav-on-left .nt-overlay').on('swipeleft', function(){
            if($Scope.find('.nt-primary-nav').hasClass('nav-is-visible')) {
                closeNav();
                //$('.nt-overlay').removeClass('is-visible');
            }
        });
        $Scope.find('.nt-overlay').on('click', function(){
            closeNav();
            toggleSearch('close')
            //$('.nt-overlay').removeClass('is-visible');
        });

        //prevent default clicking on direct children of .nt-primary-nav
        $Scope.find('.nt-primary-nav').children('.has-children').children('a').on('click', function(event){
            event.preventDefault();
        });
        //open submenu
        $Scope.find('.has-children').children('a').on('click', function(event){

            if( !checkWindowWidth() ) event.preventDefault();
            var selected = $(this);

            if( selected.next('ul').hasClass('is-hidden') ) {
                //desktop version only

                selected.addClass('selected').next('ul').removeClass('is-hidden').end().parent('.has-children').parent('ul').addClass('moves-out');
                selected.parent('.has-children').siblings('.has-children').children('ul').addClass('is-hidden').end().children('a').removeClass('selected');
                $Scope.find('.nt-overlay').addClass('is-visible');

            } else {

                selected.removeClass('selected').next('ul').addClass('is-hidden').end().parent('.has-children').parent('ul').removeClass('moves-out');
                $Scope.find('.nt-overlay').removeClass('is-visible');
            }
            toggleSearch('close');
        });

        //submenu items - go back link
        $Scope.find('.go-back').on('click', function(){
            $(this).parent('ul').addClass('is-hidden').parent('.has-children').parent('ul').removeClass('moves-out');
        });

        function closeNav() {
            $Scope.find('.nt-nav-trigger').removeClass('nav-is-visible');
            $Scope.find('.nt-main-header').removeClass('nav-is-visible');
            $Scope.find('.nt-primary-nav').removeClass('nav-is-visible');
            $Scope.find('.has-children ul').addClass('is-hidden');
            $Scope.find('.has-children a').removeClass('selected');
            $Scope.find('.moves-out').removeClass('moves-out');
            $Scope.find('.nt-main-content').removeClass('nav-is-visible').one('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function(){
                $('body').removeClass('overflow-hidden');
            });
        }

        function toggleSearch(type) {
            if(type=="close") {
                //close serach
                $Scope.find('.nt-search').removeClass('is-visible');
                $Scope.find('.nt-search-trigger').removeClass('search-is-visible');
                $Scope.find('.nt-overlay').removeClass('search-is-visible');
            } else {
                //toggle search visibility
                $Scope.find('.nt-search').toggleClass('is-visible');
                $Scope.find('.nt-search-trigger').toggleClass('search-is-visible');
                $Scope.find('.nt-overlay').toggleClass('search-is-visible');
                if($(window).width() > MqL && $Scope.find('.nt-search').hasClass('is-visible')) $Scope.find('.nt-search').find('input[type="search"]').focus();
                ($Scope.find('.nt-search').hasClass('is-visible')) ? $Scope.find('.nt-overlay').addClass('is-visible') : $Scope.find('.nt-overlay').removeClass('is-visible') ;
            }
        }

        function checkWindowWidth() {
            //check window width (scrollbar included)
            var e = window,
            a = 'inner';
            if (!('innerWidth' in window )) {
                a = 'client';
                e = document.documentElement || document.body;
            }
            if ( e[ a+'Width' ] >= MqL ) {
                return true;
            } else {
                return false;
            }
        }

        function moveNavigation(){

            var navigation = $Scope.find('.nt-nav');
            var desktop = checkWindowWidth();
            if ( desktop ) {
                navigation.detach();
                navigation.insertBefore('.nt-header-buttons');
            } else {
                navigation.detach();
                navigation.insertAfter('.nt-main-content');
            }
        }
    }

    jQuery(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/naturally-mega-menu.default', ntrMegaMenu);
    });

})(jQuery);
