<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Accordion_Tabs_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-accordion-tabs';
    }
    public function get_title() {
        return 'Accordeon Tabs';
    }
    public function get_icon() {
        return 'eicon-accordion';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_tabs_content_settings',
            [
                'label' => esc_html__( 'Content', 'naturally'),
            ]
        );
        $this->add_control( 'type',
            [
                'label' => esc_html__( 'Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => 'single',
                'options' => [
                    'single' => esc_html__( 'Single', 'naturally' ),
                    'multiple' => esc_html__( 'Multiple', 'naturally' ),
                ]
            ]
        );
        $this->add_control( 'naturally_tabs',
            [
                'type' => Controls_Manager::REPEATER,
                'seperator' => 'before',
                'default' => [
                    [
                        'tab_title' => 'How much does solar cost?',
                        'tab_content' => '<p>Pacific saury. Slickhead grunion lake trout. Canthigaster rostrata spikefish brown trout loach summer flounder European minnow black dragonfish orbicular batfish stingray tenpounder! Flying characin: herring, Moses sole sea snail grouper discus. European eel slender snipe eel. Gulper eel dealfish ocean sunfish; rohu yellow-and-black triplefin Atlantic saury swordfish southern sandfish</p>'
                    ],
                    [
                        'tab_title' => 'I would love to invest in solar, but I think my roof is too old. Am Iout of Luck?',
                        'tab_content' => '<p>Pacific saury. Slickhead grunion lake trout. Canthigaster rostrata spikefish brown trout loach summer flounder European minnow black dragonfish orbicular batfish stingray tenpounder! Flying characin: herring, Moses sole sea snail grouper discus. European eel slender snipe eel. Gulper eel dealfish ocean sunfish; rohu yellow-and-black triplefin Atlantic saury swordfish southern sandfish</p>'
                    ],
                    [
                        'tab_title' => 'What happens to solar panels when it rains or is cloudy?',
                        'tab_content' => '<p>Pacific saury. Slickhead grunion lake trout. Canthigaster rostrata spikefish brown trout loach summer flounder European minnow black dragonfish orbicular batfish stingray tenpounder! Flying characin: herring, Moses sole sea snail grouper discus. European eel slender snipe eel. Gulper eel dealfish ocean sunfish; rohu yellow-and-black triplefin Atlantic saury swordfish southern sandfish</p>'
                    ],
                    [
                        'tab_title' => 'What rebates are available for solar energy?',
                        'tab_content' => '<p>Pacific saury. Slickhead grunion lake trout. Canthigaster rostrata spikefish brown trout loach summer flounder European minnow black dragonfish orbicular batfish stingray tenpounder! Flying characin: herring, Moses sole sea snail grouper discus. European eel slender snipe eel. Gulper eel dealfish ocean sunfish; rohu yellow-and-black triplefin Atlantic saury swordfish southern sandfish</p>'
                    ],
                    [
                        'tab_title' => 'Would it make sense to go solar if we use most our energy at night?',
                        'tab_content' => '<p>Pacific saury. Slickhead grunion lake trout. Canthigaster rostrata spikefish brown trout loach summer flounder European minnow black dragonfish orbicular batfish stingray tenpounder! Flying characin: herring, Moses sole sea snail grouper discus. European eel slender snipe eel. Gulper eel dealfish ocean sunfish; rohu yellow-and-black triplefin Atlantic saury swordfish southern sandfish</p>'
                    ]
                ],
                'fields'       => [
                    [
                        'name' => 'tab_title',
                        'label' => esc_html__('Tab Title', 'naturally'),
                        'type' => Controls_Manager::TEXT,
                        'default' => esc_html__('Tab Title', 'naturally'),
                        'label_block' => true
                    ],
                    [
                        'name' => 'tab_content',
                        'label' => esc_html__('Tab Content', 'naturally'),
                        'type' => Controls_Manager::WYSIWYG,
                        'default' => '<p>Pacific saury. Slickhead grunion lake trout. Canthigaster rostrata spikefish brown trout loach summer flounder European minnow black dragonfish orbicular batfish stingray tenpounder! Flying characin: herring, Moses sole sea snail grouper discus. European eel slender snipe eel. Gulper eel dealfish ocean sunfish; rohu yellow-and-black triplefin Atlantic saury swordfish southern sandfish</p>',
                        'dynamic' => ['active' => true]
                    ]
                ],
                'title_field' => '{{tab_title}}'
            ]
        );
        $this->end_controls_section();
        /***** Page accordion Style ******/
        /***** TITLE ******/
        $this->start_controls_section('naturally_accordion_title_styling',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_title_accordion_tabs');
        $this->start_controls_tab( 'naturally_title_accordion_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='title_accordion',$selector='.accordion_item_title');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_title_accordion_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='title_accordion_hover',$selector='.accordion_item_title:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();

        /***** DESCRIPTION ******/
        $this->start_controls_section('naturally_desc_title_styling',
            [
                'label' => esc_html__( 'Description', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_desc_accordion_tabs');
        $this->start_controls_tab( 'naturally_desc_accordion_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='desc_accordion',$selector='.accordion_item_body p');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_desc_accordion_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='desc_accordion_hover',$selector='.accordion_item_body p:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();
    }

    protected function render() {
        $settings  = $this->get_settings_for_display();
        $elementid = $this->get_id();
        echo '<div class="accordion" data-ntr-accordion="'.$settings['type'].'">';
            foreach ($settings['naturally_tabs'] as $tab) {
                echo '<div class="accordion_item">';
                    echo '<div class="accordion_item_header">';
                        if ( $tab['tab_title'] ) {
                            echo '<div class="accordion_item_title">'.$tab['tab_title'].'</div>';
                        } else {
                            echo '<div class="accordion_item_title">Add Title</div>';
                        }
                        echo '<div class="accordion_item_icon icon is-arrow-right2"></div>';
                    echo '</div>';
                    echo '<div class="accordion_item_body">';
                        if ( $tab['tab_content'] ) {
                            echo $tab['tab_content'];
                        } else {
                            echo '<p>Add Some Content Here</p>';
                        }
                    echo '</div>';
                    echo '</div>';
            }
        echo '</div>';
    }
}
