<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Alert_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-alert';
    }
    public function get_title() {
        return 'Alert (N)';
    }
    public function get_icon() {
        return 'eicon-alert';
    }
    public function get_categories() {
        return [ 'naturally' ];

    }

    // Registering Controls
    protected function register_controls() {
        $this->start_controls_section('naturally_alert_settings',
            [
                'label' => esc_html__( 'Alert', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control( 'title',
            [
                'label' => esc_html__( 'Text', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'A simple orange alert. Here is an <a href="#0">example link.</a>'
            ]
        );
        $this->add_control( 'style',
            [
                'label' => esc_html__( 'Style', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'primary',
                'options' => [
                    'primary' => esc_html__( 'primary', 'naturally' ),
                    'secondary' => esc_html__( 'secondary', 'naturally' ),
                    'black' => esc_html__( 'black', 'naturally' ),
                    'white' => esc_html__( 'white', 'naturally' ),
                    'grey' => esc_html__( 'grey', 'naturally' ),
                    'dark' => esc_html__( 'dark', 'naturally' ),
                    'brown' => esc_html__( 'brown', 'naturally' ),
                    'blue' => esc_html__( 'blue', 'naturally' ),
                    'green' => esc_html__( 'green', 'naturally' ),
                    'orange' => esc_html__( 'orange', 'naturally' ),
                    'red' => esc_html__( 'red', 'naturally' ),
                    'purple' => esc_html__( 'purple', 'naturally' ),
                    'blue-light' => esc_html__( 'blue-light', 'naturally' ),
                    'green-light' => esc_html__( 'green-light', 'naturally' ),
                    'orange-light' => esc_html__( 'orange-light', 'naturally' ),
                    'red-light' => esc_html__( 'red-light', 'naturally' ),
                    'purple-light' => esc_html__( 'purple-light', 'naturally' ),
                ]
            ]
        );
        $this->add_control( 'dismiss',
            [
                'label' => esc_html__( 'Dismiss Button', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'show',
                'options' => [
                    'show' => esc_html__( 'Show', 'naturally' ),
                    'hide' => esc_html__( 'Hide', 'naturally' ),
                ]
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        if ( $settings['title'] || $settings['desc'] ) {
            echo '<div class="alert is-'.$settings['style'].'" data-ntr-alert="">';
                if ( $settings['dismiss'] == 'show' ) {
                    echo '<button class="alert_close" type="button"><span class="icon is-close"></span></button>';
                }
                if ( $settings['title'] ) {
                    echo '<p class="alert_title">'.$settings['title'].'</p>';
                }
            echo '</div>';
        }
    }
}
