<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Badge_Label_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-badge-label';
    }
    public function get_title() {
        return 'Badge and Label (N)';
    }
    public function get_icon() {
        return 'eicon-favorite';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_label_section',
            [
                'label' => esc_html__( 'Badge and Label', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'pleaceholder' => esc_html__( 'Enter label here', 'naturally' ),
                'default' => 'Primary',
                'label_block' => true,
            ]
        );
        $this->add_control( 'type',
            [
                'label' => esc_html__( 'Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'label',
                'options' => [
                    'badge' => esc_html__( 'Badge', 'naturally' ),
                    'label' => esc_html__( 'Label', 'naturally' ),
                ]
            ]
        );
        $this->add_control( 'style',
            [
                'label' => esc_html__( 'Color Style', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'primary',
                'options' => [
                    'primary' => esc_html__( 'primary', 'naturally' ),
                    'secondary' => esc_html__( 'secondary', 'naturally' ),
                    'black' => esc_html__( 'black', 'naturally' ),
                    'white' => esc_html__( 'white', 'naturally' ),
                    'grey' => esc_html__( 'grey', 'naturally' ),
                    'dark' => esc_html__( 'dark', 'naturally' ),
                    'brown' => esc_html__( 'brown', 'naturally' ),
                    'blue' => esc_html__( 'blue', 'naturally' ),
                    'green' => esc_html__( 'green', 'naturally' ),
                    'orange' => esc_html__( 'orange', 'naturally' ),
                    'red' => esc_html__( 'red', 'naturally' ),
                    'purple' => esc_html__( 'purple', 'naturally' ),
                    'blue-light' => esc_html__( 'blue-light', 'naturally' ),
                    'green-light' => esc_html__( 'green-light', 'naturally' ),
                    'orange-light' => esc_html__( 'orange-light', 'naturally' ),
                    'red-light' => esc_html__( 'red-light', 'naturally' ),
                    'purple-light' => esc_html__( 'purple-light', 'naturally' ),
                    'custom' => esc_html__( 'Custom', 'naturally' ),
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typo',
                'label' => esc_html__( 'Typography', 'naturally' ),
                'selector' => '{{WRAPPER}} .label.is-custom,{{WRAPPER}} .badge.is-custom'
            ]
        );
        $this->add_control( 'color',
            [
                'label' => esc_html__( 'Text Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .label.is-custom,{{WRAPPER}} .badge.is-custom' => 'color: {{VALUE}};'],
                'condition' => [ 'style' => 'custom' ]
            ]
        );
        $this->add_control( 'bgcolor',
            [
                'label' => esc_html__( 'Background Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .label.is-custom,{{WRAPPER}} .badge.is-custom' => 'background-color: {{VALUE}};'],
                'condition' => [ 'style' => 'custom' ]
            ]
        );
        $this->add_control( 'brdcolor',
            [
                'label' => esc_html__( 'Border Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .label.is-custom,{{WRAPPER}} .badge.is-custom' => 'border-color: {{VALUE}};'],
                'condition' => [ 'style' => 'custom' ]
            ]
        );
        $this->add_control( 'border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'naturally' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} .label.is-custom,{{WRAPPER}} .badge.is-custom' => 'border-top-left-radius: {{TOP}}{{UNIT}};border-top-right-radius: {{RIGHT}}{{UNIT}};border-bottom-left-radius: {{BOTTOM}}{{UNIT}};border-bottom-right-radius: {{LEFT}}{{UNIT}};'],
                'default' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                ],
                'condition' => [ 'style' => 'custom' ]
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
    }
    protected function render() {
        $settings   = $this->get_settings_for_display();

        if ( $settings['title'] ) {
            echo '<span class="'.$settings['type'].' is-'.$settings['style'].'">'.$settings['title'].'</span>';
        }
    }
}
