<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Blockquote_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-blockquote';
    }
    public function get_title() {
        return 'Blockquote (N)';
    }
    public function get_icon() {
        return 'eicon-testimonial';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_blockquote_settings',
            [
                'label' => esc_html__('Blockquote', 'naturally'),
            ]
        );
        $this->add_control( 'quote',
            [
                'label' => esc_html__( 'Quote', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris sodales mattis dui, a eleifend lacus convallis at. Sed sit amet massa eget ante blandit gravida sed sit amet risus. Praesent ut mi fermentum, auctor magna ac, ultrices dolor.'
            ]
        );
        $this->add_control( 'author',
            [
                'label' => esc_html__( 'Author', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Doctor Who'
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typo',
                'label' => esc_html__( 'Quote Typography', 'naturally' ),
                'selector' => '{{WRAPPER}} blockquote p'
            ]
        );
        $this->add_control( 'textcolor',
            [
                'label' => esc_html__( 'Quote Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} blockquote p' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'bgcolor',
            [
                'label' => esc_html__( 'Background Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} blockquote' => 'background-color: {{VALUE}};']
            ]
        );
        $this->add_control( 'brdcolor',
            [
                'label' => esc_html__( 'Border Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} blockquote' => 'border-left-color: {{VALUE}};']
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'author_typo',
                'label' => esc_html__( 'Author Typography', 'naturally' ),
                'selector' => '{{WRAPPER}} blockquote footer cite'
            ]
        );
        $this->add_control( 'author_color',
            [
                'label' => esc_html__( 'Author Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} blockquote footer cite' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'icon_color',
            [
                'label' => esc_html__( 'Icon Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} blockquote:before' => 'color: {{VALUE}};']
            ]
        );
        $this->add_control( 'icon_opacity',
            [
                'label' => esc_html__( 'Icon Opacity', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'condition' => ['icon_color!' => ''],
                'selectors' => ['{{WRAPPER}} blockquote:before'  => 'opacity: {{VALUE}};']
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
    }

    protected function render() {
        $settings  = $this->get_settings_for_display();
        $settingsid = $this->get_id();
        if ($settings['quote']) {
            echo '<blockquote>';
            	echo '<p>'.$settings['quote'].'</p>';
            	if ($settings['author']) {
            	    echo '<footer><cite title="'.$settings['author'].'">'.$settings['author'].'</cite></footer>';
            	}
            echo '</blockquote>';
        }
	}
}
