<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Blog_Slider_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-blog-slider';
    }
    public function get_title() {
        return 'Blog Posts (N)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('naturally_blog_text_settings',
            [
                'label' => esc_html__( 'General', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control( 'type',
            [
                'label' => esc_html__( 'Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__( 'Type 1 Slider', 'naturally' ),
                    '2' => esc_html__( 'Type 2 Slider', 'naturally' ),
                    '3' => esc_html__( 'Type 3 Grid', 'naturally' ),
                    '4' => esc_html__( 'Type 4 Grid', 'naturally' ),
                    '5' => esc_html__( 'Type 5 List', 'naturally' ),
                ]
            ]
        );
        $this->add_control( 'column',
            [
                'label' => esc_html__( 'Column', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '3' => esc_html__( '4 Column', 'naturally' ),
                    '4' => esc_html__( '3 Column', 'naturally' ),
                    '6' => esc_html__( '2 Column', 'naturally' ),
                ],
                'condition' => ['type' => '3']
            ]
        );
        $this->add_control( 'column2',
            [
                'label' => esc_html__( 'Column', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => '6',
                'options' => [
                    '12' => esc_html__( '1 Column', 'naturally' ),
                    '6' => esc_html__( '2 Column', 'naturally' ),
                ],
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'type',
                            'operator' => '==',
                            'value' => '4'
                        ],
                        [
                            'name' => 'type',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => '5'
                        ]
                    ]
                ]
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'post_filter_section',
            [
                'label' => esc_html__( 'Category Filters', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'type',
                            'operator' => '==',
                            'value' => '3'
                        ],
                        [
                            'name' => 'type',
                            'operator' => '==',
                            'value' => '4'
                        ],
                        [
                            'name' => 'type',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => '5'
                        ]
                    ]
                ]
            ]
        );
        $this->add_control( 'hide_catblock',
            [
                'label' => esc_html__( 'Hide Category Block', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        // Exclude Category
        $this->add_control( 'category_exclude_filter2',
            [
                'label' => esc_html__( 'Exclude Category from Filter', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'label_block' => true,
                'options' => $this->naturally_get_categories(),
                'description' => 'Select Category(s) to Exclude',
                'condition' => [ 'hide_catblock!' => 'yes' ]
            ]
        );
        $this->add_responsive_control( 'filter_spacing',
            [
                'label' => esc_html__( 'Filter Bottom Spacing', 'naturally' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 500
                    ]
                ],
                'selectors' => ['{{WRAPPER}} .section-custom-9' => 'margin-bottom: {{SIZE}}px;'],
                'condition' => [ 'hide_catblock!' => 'yes' ]
            ]
        );
        $this->add_control( 'filter_text',
            [
                'label' => esc_html__( 'Mobile Filter Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Categories',
                'label_block' => true,
                'condition' => [ 'hide_catblock!' => 'yes' ]
            ]
        );
        // tooltip Filter Heading
        $this->add_control( 'post_tooltip_heading',
            [
                'label' => esc_html__( 'Filter Tooltip', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [ 'hide_catblock!' => 'yes' ]
            ]
        );
        $this->add_control( 'hide_tooltip',
            [
                'label' => esc_html__( 'Hide Tooltip', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'return_value' => 'yes',
                'condition' => [ 'hide_catblock!' => 'yes' ]
            ]
        );
        $this->add_control( 'tooltip_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.ui-tooltip.is-top:after' => 'border-color: {{VALUE}} transparent transparent transparent;',
                    '.ui-tooltip.is-right:after' => 'border-color: transparent {{VALUE}} transparent transparent;',
                    '.ui-tooltip.is-left:after' => 'border-color: transparent transparent transparent {{VALUE}};',
                    '.ui-tooltip.is-bottom:after' => 'border-color: transparent transparent {{VALUE}} transparent;',
                    '.ui-tooltip.ui-widget-content' => 'background-color: {{VALUE}};',
                ],
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'hide_catblock',
                            'operator' => '!=',
                            'value' => 'yes'
                        ],
                        [
                            'name' => 'hide_tooltip',
                            'operator' => '!=', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'yes'
                        ]
                    ]
                ]
            ]
        );
        $this->add_control( 'tooltip_txtcolor',
            [
                'label' => esc_html__( 'Number Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['.ui-tooltip.ui-widget-content' => 'color: {{VALUE}};'],
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'hide_catblock',
                            'operator' => '!=',
                            'value' => 'yes'
                        ],
                        [
                            'name' => 'hide_tooltip',
                            'operator' => '!=', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'yes'
                        ]
                    ]
                ]
            ]
        );
        $this->add_responsive_control( 'tooltip_padding',
            [
                'label' => esc_html__( 'Padding', 'naturally' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['.ui-tooltip' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;'],
                'default' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                ],
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'hide_catblock',
                            'operator' => '!=',
                            'value' => 'yes'
                        ],
                        [
                            'name' => 'hide_tooltip',
                            'operator' => '!=', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'yes'
                        ]
                    ]
                ]
            ]
        );
        $this->add_control( 'tooltip_fontsize',
            [
                'label' => esc_html__( 'Font Size', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 10,
                'max' => 36,
                'step' => 1,
                'default' => '',
                'selectors' => ['.ui-tooltip.ui-widget'  => 'font-size: {{VALUE}}px;'],
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'hide_catblock',
                            'operator' => '!=',
                            'value' => 'yes'
                        ],
                        [
                            'name' => 'hide_tooltip',
                            'operator' => '!=', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'yes'
                        ]
                    ]
                ]
            ]
        );
        // tooltip Filter Heading
        $this->add_control( 'post_search_heading',
            [
                'label' => esc_html__( 'Search Form', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [ 'hide_catblock!' => 'yes' ]
            ]
        );
        $this->add_control( 'hide_search',
            [
                'label' => esc_html__( 'Hide Search', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'return_value' => 'yes',
                'condition' => [ 'hide_catblock!' => 'yes' ]
            ]
        );
        $this->add_control( 'search_text',
            [
                'label' => esc_html__( 'Mobile Search Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Search',
                'label_block' => true,
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'hide_catblock',
                            'operator' => '!=',
                            'value' => 'yes'
                        ],
                        [
                            'name' => 'hide_search',
                            'operator' => '!=', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'yes'
                        ]
                    ]
                ]
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'nt_post_query',
            [
                'label' => esc_html__( 'Query', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'btn_title',
            [
                'label' => esc_html__( 'Read More Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Read more',
                'label_block' => true,
            ]
        );
        if ( ! get_option( 'disable_naturally_author_filter_from_blog_widget' ) == 1 ) {
            $this->add_control( 'author_filter_heading',
                [
                    'label' => esc_html__( 'Author Filter', 'naturally' ),
                    'type' => Controls_Manager::HEADING
                ]
            );
            $this->add_control( 'author_filter',
                [
                    'label' => esc_html__( 'Author', 'naturally' ),
                    'type' => Controls_Manager::SELECT2,
                    'multiple' => true,
                    'options' => $this->naturally_get_users(),
                    'description' => 'Select Author(s)'
                ]
            );
            $this->add_control( 'author_exclude_filter',
                [
                    'label' => esc_html__( 'Exclude Author', 'naturally' ),
                    'type' => Controls_Manager::SELECT2,
                    'multiple' => true,
                    'options' => $this->naturally_get_users(),
                    'description' => 'Select Author(s) to Exclude',
                    'separator' => 'after'
                ]
            );
        }
        $this->add_control( 'category_filter_heading',
            [
                'label' => esc_html__( 'Category Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        $this->add_control( 'category_filter',
            [
                'label' => esc_html__( 'Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_get_categories(),
                'description' => 'Select Category(s)'
            ]
        );
        $this->add_control( 'category_exclude_filter',
            [
                'label' => esc_html__( 'Exclude Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_get_categories(),
                'description' => 'Select Category(s) to Exclude',
                'separator' => 'after'
            ]
        );
        if ( ! get_option( 'disable_naturally_tags_filter_from_blog_widget' ) == 1 ) {
            $this->add_control( 'tag_filter_heading',
                [
                    'label' => esc_html__( 'Tag Filter', 'naturally' ),
                    'type' => Controls_Manager::HEADING
                ]
            );
            $this->add_control( 'tag_filter',
                [
                    'label' => esc_html__( 'Tag', 'naturally' ),
                    'type' => Controls_Manager::SELECT2,
                    'multiple' => true,
                    'options' => $this->naturally_get_tags(),
                    'description' => 'Select Tag(s)'
                ]
            );

            $this->add_control( 'tag_exclude_filter',
                [
                    'label' => esc_html__( 'Exclude Tag', 'naturally' ),
                    'type' => Controls_Manager::SELECT2,
                    'multiple' => true,
                    'options' => $this->naturally_get_tags(),
                    'description' => 'Select Tag(s) to Exclude',
                    'separator' => 'after'
                ]
            );
        }
        if ( ! get_option( 'disable_naturally_post_filter_from_blog_widget' ) == 1 ) {
            $this->add_control( 'post_filter_heading',
                [
                    'label' => esc_html__( 'Post Filter', 'naturally' ),
                    'type' => Controls_Manager::HEADING
                ]
            );
            $this->add_control( 'post_filter',
                [
                    'label' => esc_html__( 'Specific Post(s)', 'naturally' ),
                    'type' => Controls_Manager::SELECT2,
                    'multiple' => true,
                    'options' => $this->naturally_get_posts(),
                    'description' => 'Select Specific Post(s)'
                ]
            );
            $this->add_control( 'post_exclude_filter',
                [
                    'label' => esc_html__( 'Exclude Post', 'naturally' ),
                    'type' => Controls_Manager::SELECT2,
                    'multiple' => true,
                    'options' => $this->naturally_get_posts(),
                    'description' => 'Select Post(s) to Exclude',
                    'separator' => 'after'
                ]
            );
        }
        $this->add_control( 'post_other_heading',
            [
                'label' => esc_html__( 'Other Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        $this->add_control('post_per_page',
            [
                'label' => esc_html__( 'Posts Per Page', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 1000,
                'default' => 2
            ]
        );
        $this->add_control('offset',
            [
                'label' => esc_html__( 'Offset', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1000
            ]
        );
        $this->add_control( 'order',
            [
                'label' => esc_html__( 'Select Order', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => 'Ascending',
                    'DESC' => 'Descending'
                ],
                'default' => 'ASC'
            ]
        );
        $this->add_control( 'orderby',
            [
                'label' => esc_html__( 'Order By', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'none' => 'None',
                    'ID' => 'Post ID',
                    'author' => 'Author',
                    'title' => 'Title',
                    'name' => 'Slug',
                    'date' => 'Date',
                    'modified' => 'Last Modified Date',
                    'parent' => 'Post Parent ID',
                    'rand' => 'Random',
                    'comment_count' => 'Number of Comments',
                ],
                'default' => 'none'
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_post_options',
            [
                'label' => esc_html__( 'Post Options', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'hidetitle',
            [
                'label' => esc_html__( 'Hide Title', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'hidemeta',
            [
                'label' => esc_html__( 'Hide Meta', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'hidedate',
            [
                'label' => esc_html__( 'Hide Date', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'hideauthor',
            [
                'label' => esc_html__( 'Hide Author', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'hideexcerpt',
            [
                'label' => esc_html__( 'Hide Excerpt', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'excerpt_limit',
            [
                'label' => esc_html__( 'Excerpt Word Limit', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'default' => 20
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $args = array(
            'post_type'        => 'post',
            'category__in'     => $settings['category_filter'],
            'category__not_in' => $settings['category_exclude_filter'],
            'posts_per_page'   => $settings['post_per_page'],
            'offset'           => $settings['offset'],
            'order'            => $settings['order'],
            'orderby'          => $settings['orderby'],
        );

        if ( ! get_option( 'disable_naturally_author_filter_from_blog_widget' ) == 1 ) {
            $args['author__in'] = $settings['author_filter'];
            $args['author__not_in'] = $settings['author_exclude_filter'];
        }
        if ( ! get_option( 'disable_naturally_tags_filter_from_blog_widget' ) == 1 ) {
            $args['tag__in'] = $settings['tag_filter'];
            $args['tag__not_in'] = $settings['tag_exclude_filter'];
        }
        if ( ! get_option( 'disable_naturally_post_filter_from_blog_widget' ) == 1 ) {
            $args['post__in'] = $settings['post_filter'];
            $args['post__not_in'] = $settings['post_exclude_filter'];
        }

        if('1' == $settings['type'] || '2' == $settings['type']){

            $type = $settings['type'] == '2' ? '3' : '';

            echo '<div class="slider-blog'.$type.'" data-ntr-slider-blog'.$type.'>';
            if('1' == $settings['type']){
                echo '<div class="container">';
            }
                    echo '<div class="slick-slider">';
                        $the_query = new \WP_Query( $args );
                        if( $the_query->have_posts() ) {
                            while ($the_query->have_posts()) {
                                $the_query->the_post();

                                $blankimg = get_template_directory_uri().'/images/blank.gif';
                                $srcset1 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 400, 300, true, true, true );
                                $srcset1 = $srcset1 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [400, 300] ) : $srcset1;
                                $srcset2 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 800, 600, true, true, true );
                                $srcset1 = $srcset2 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [800, 600] ) : $srcset2;
                                $imagealt = esc_attr(get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true));
                                $imagealt = $imagealt ? $imagealt : get_the_title();
                                echo '<div class="slick-slide">';
                                    if('1' == $settings['type']){
                                        echo '<div class="blog-post">';
                                            if(has_post_thumbnail()){
                                                echo '<a class="blog-post_photo" href="'.get_permalink().'">';
                                                    echo '<span class="aspect-ratio is-4x3">';
                                                        echo '<img class="aspect-ratio_object lazyload"
                                                        src="'.$blankimg.'"
                                                        data-srcset="'.esc_url( $srcset1 ).' 1x, '.esc_url( $srcset2 ).' 2x"
                                                        alt="'.esc_attr( $imagealt ).'">';
                                                    echo '</span>';
                                                echo '</a>';
                                            }
                                            if('yes' != $settings['hidetitle']){
                                                echo '<h4 class="blog-post_title"><a href="'.get_permalink().'">'.get_the_title().'</a></h4>';
                                            }
                                           if('yes' != $settings['hidemeta']){
                                               $post_author = get_author_posts_url( get_the_author_meta( 'ID' ) );
                                               $date = 'yes' != $settings['hidedate'] ? get_the_date() : '';
                                               $author = 'yes' != $settings['hideauthor'] ? ' By <a href="'.$post_author.'">'.get_the_author().'</a>': '';
                                               if( $date || $author ){
                                                echo '<p class="blog-post_meta">'.$date.$author.'</p>';
                                               }
                                            }
                                            if(has_excerpt() && 'yes' != $settings['hideexcerpt']){
                                                echo '<p class="blog-post_summary">'.wp_trim_words( get_the_excerpt(), $settings['excerpt_limit'] ).'</p>';
                                            }
                                            if($settings['btn_title']){
                                                echo '<p class="blog-post_readmore">';
                                                    echo '<a class="link is-color-secondary" href="'.get_permalink().'">';
                                                        echo '<span class="link_text">'.$settings['btn_title'].'</span>';
                                                        echo '<span class="link_icon icon is-next"></span>';
                                                    echo '</a>';
                                                echo '</p>';
                                            }
                                        echo '</div>';
                                    } else {
                                        echo '<div class="blog-post3">';
                                            if(has_post_thumbnail()){
                                                $blankimg = get_template_directory_uri().'/images/blank.gif';
                                                $srcset1 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 400, 400, true, true, true );
                                                $srcset1 = $srcset1 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [400, 400] ) : $srcset1;
                                                $srcset2 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 800, 800, true, true, true );
                                                $srcset2 = $srcset2 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [800, 800] ) : $srcset2;
                                                $imagealt = esc_attr(get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true));
                                                $imagealt = $imagealt ? $imagealt : get_the_title();
                                                echo '<a class="blog-post3_photo" href="'.get_post_permalink().'">';
                                                        echo '<img class="lazyload"
                                                        src="'.$blankimg.'"
                                                        data-srcset="'.esc_url( $srcset1 ).' 1x, '.esc_url( $srcset2 ).' 2x"
                                                        alt="'.esc_attr( $imagealt ).'">';
                                                echo '</a>';
                                            }
                                            echo '<div class="blog-post3_body">';
                                                if('yes' != $settings['hidetitle']){
                                                    echo '<h4 class="blog-post3_title"><a href="'.get_permalink().'">'.get_the_title().'</a></h4>';
                                                }
                                                if('yes' != $settings['hidemeta'] && 'yes' != $settings['hidedate'] ){
                                                    echo '<span class="blog-post3_date">'.get_the_date().'</span>';
                                                }
                                                if(has_excerpt() && 'yes' != $settings['hideexcerpt']){
                                                    echo '<span class="blog-post3_summary">'.wp_trim_words( get_the_excerpt(), $settings['excerpt_limit'] ).'</span>';
                                                }
                                                if('yes' != $settings['hidemeta'] && 'yes' != $settings['hideauthor'] ){
                                                    echo '<a class="blog-post3_author" href="'.get_permalink().'">';
                                                    echo '<span class="blog-post3_author_avatar">';
                                                            echo get_avatar( get_the_author_meta( 'ID' ), 32 );
                                                        echo '</span>';
                                                        echo '<span class="blog-post3_author_name">'.get_the_author().'</span>';
                                                        echo '</a>';
                                                }
                                            echo '</div>';
                                        echo '</div>';
                                    }
                                echo '</div>';
                            }
                        } else {
                                echo '<p class="text">No post found!</p>';
                        }
                        wp_reset_postdata();
                    echo '</div>';
                    if('1' == $settings['type']){
                echo '</div>';
                    }
            echo '</div>';
        }

        if('3' == $settings['type']){
            if('yes' != $settings['hide_catblock']){
                echo '<div class="section-custom-9">';
                    echo '<div class="container">';
                        echo '<div class="nav2" data-ntr-nav2="">';
                            echo '<div class="nav2_toggle is-left">';
                                echo '<div class="nav2_toggle_button">';
                                    echo '<span class="nav2_toggle_button_icon icon is-filter"></span>';
                                    $filter_text = $settings['filter_text'] ? $settings['filter_text'] : esc_html__( 'Categories', 'naturally' );
                                    echo '<span class="nav2_toggle_button_text">'.esc_html( $filter_text ).'</span>';
                                echo '</div>';
                                echo '<div class="nav2_toggle_inner">';
                                    echo '<nav class="nav2_menu">';
                                        echo '<ul class="nav2_menu_items">';
                                        $post_cat_args = array (
                                            'orderby' => 'name',
                                            'order' => 'ASC',
                                            'hide_empty' => true, //can be 1, '1' too
                                            'parent' => 0,
                                            'exclude' => $settings['category_exclude_filter2'] ? $settings['category_exclude_filter2'] : '',
                                        );
                                        $categories = get_categories($post_cat_args);
                                        $i = 0;
                                        foreach ($categories as $category) {
                                          $i++;
                                            $tooltip = 'yes' != $settings['hide_tooltip'] ? ' data-ntr-ui-tooltip=\'{"position":"top","content":"' . $category->category_count . '"}\'' : '';
                                            echo '<li class="nav2_menu_item">
                                            <a class="nav2_menu_link" href="' . get_category_link($category->term_id) . '"'.$tooltip.'>' . $category->name . '</a>
                                            </li>';
                                        }
                                        echo '</ul>';
                                    echo '</nav>';
                                echo '</div>';
                            echo '</div>';
                            if (function_exists('naturally_nav_custom_search_form') && 'yes' != $settings['hide_search'] ) {
                                echo '<div class="nav2_toggle is-right">';
                                    echo '<div class="nav2_toggle_button">';
                                        $search_text = $settings['search_text'] ? $settings['search_text'] : esc_html__( 'Search', 'naturally' );
                                        echo '<span class="nav2_toggle_button_icon icon is-search"></span>';
                                        echo '<span class="nav2_toggle_button_text">'.esc_html( $search_text ).'</span>';
                                    echo '</div>';
                                    echo '<div class="nav2_toggle_inner">';
                                        echo naturally_nav_custom_search_form();
                                    echo '</div>';
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            }
            echo '<div class="section">';
                echo '<div class="container">';
                    echo '<div class="grid">';
                        echo '<div class="grid_row is-40">';
                            $count_posts = wp_count_posts();
                            $count_posts = $count_posts ? $count_posts->publish : 0;
                            $counter = 0;
                            $the_query = new \WP_Query( $args );
                            if( $the_query->have_posts() ) {
                                while ($the_query->have_posts()) {
                                    $the_query->the_post();

                                    $blankimg = get_template_directory_uri().'/images/blank.gif';
                                    $srcset1 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 400, 300, true, true, true );
                                    $srcset1 = $srcset1 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [400, 300] ) : $srcset1;
                                    $srcset2 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 800, 600, true, true, true );
                                    $srcset2 = $srcset2 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [800, 600] ) : $srcset2;
                                    $imagealt = esc_attr(get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true));
                                    $imagealt = $imagealt ? $imagealt : get_the_title();
                                    $column = $settings['column'] ? $settings['column'] : 4;
                                    $delay = ( $counter % 3 ) == 1 || ( $counter % 3 ) == 2 ? $delay + 200 : 0;
                                    $aos = \Elementor\Plugin::$instance->editor->is_edit_mode() ? ' aos-init aos-animate' : '';
                                    echo '<div class="grid_col is-12 is-md-6 is-lg-'.$column.$aos.'" data-aos="ntr-fade-up" data-aos-once="true" data-aos-delay="'.$delay.'">';
                                        echo '<div class="blog-post">';
                                            if(has_post_thumbnail()){
                                                echo '<a class="blog-post_photo" href="'.get_post_permalink().'">';
                                                    echo '<span class="aspect-ratio is-4x3">';
                                                        echo '<img class="aspect-ratio_object lazyload"
                                                        src="'.$blankimg.'"
                                                        data-srcset="'.esc_url( $srcset1 ).' 1x, '.esc_url( $srcset2 ).' 2x"
                                                        alt="'.esc_attr( $imagealt ).'">';
                                                    echo '</span>';
                                                echo '</a>';
                                            }
                                            if('yes' != $settings['hidetitle']){
                                                echo '<h4 class="blog-post_title"><a href="'.get_permalink().'">'.get_the_title().'</a></h4>';
                                            }
                                           if('yes' != $settings['hidemeta']){
                                               $post_author = get_author_posts_url( get_the_author_meta( 'ID' ) );
                                               $date = 'yes' != $settings['hidedate'] ? get_the_date() : '';
                                               $author = 'yes' != $settings['hideauthor'] ? ' By <a href="'.$post_author.'">'.get_the_author().'</a>': '';
                                               if( $date || $author ){
                                                echo '<p class="blog-post_meta">'.$date.$author.'</a></p>';
                                               }
                                            }
                                            if(has_excerpt() && 'yes' != $settings['hideexcerpt']){
                                                echo '<p class="blog-post_summary">'.wp_trim_words( get_the_excerpt(), $settings['excerpt_limit'] ).'</p>';
                                            }
                                            if($settings['btn_title']){
                                                echo '<p class="blog-post_readmore">';
                                                    echo '<a class="link is-color-secondary" href="'.get_permalink().'">';
                                                        echo '<span class="link_text">'.$settings['btn_title'].'</span>';
                                                        echo '<span class="link_icon icon is-next"></span>';
                                                    echo '</a>';
                                                echo '</p>';
                                            }
                                        echo '</div>';
                                    echo '</div>';
                                    $delay = ( $counter % 3 ) == 0  ? 0 : $delay;
                                    $counter++;

                                }
                            } else {
                                    echo '<p class="text">No post found!</p>';
                            }
                            wp_reset_postdata();
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }
        if('4' == $settings['type']){
            if('yes' != $settings['hide_catblock']){
                echo '<div class="section-custom-9">';
                    echo '<div class="container">';
                        echo '<div class="nav2" data-ntr-nav2="">';
                            echo '<div class="nav2_toggle is-left">';
                                echo '<div class="nav2_toggle_button">';
                                    echo '<span class="nav2_toggle_button_icon icon is-filter"></span>';
                                    $filter_text = $settings['filter_text'] ? $settings['filter_text'] : esc_html__( 'Categories', 'naturally' );
                                    echo '<span class="nav2_toggle_button_text">'.esc_html( $filter_text ).'</span>';
                                echo '</div>';
                                echo '<div class="nav2_toggle_inner">';
                                    echo '<nav class="nav2_menu">';
                                        echo '<ul class="nav2_menu_items">';
                                        $post_cat_args = array (
                                            'orderby' => 'name',
                                            'order' => 'ASC',
                                            'hide_empty' => true, //can be 1, '1' too
                                            'parent' => 0,
                                            'exclude' => $settings['category_exclude_filter2'] ? $settings['category_exclude_filter2'] : '',
                                        );
                                        $categories = get_categories($post_cat_args);
                                        $i = 0;
                                        foreach ($categories as $category) {
                                            $i++;
                                            $tooltip = 'yes' != $settings['hide_tooltip'] ? ' data-ntr-ui-tooltip=\'{"position":"top","content":"' . $category->category_count . '"}\'' : '';
                                            echo '<li class="nav2_menu_item">
                                            <a class="nav2_menu_link" href="' . get_category_link($category->term_id) . '"'.$tooltip.'>' . $category->name . '</a>
                                            </li>';
                                        }
                                        echo '</ul>';
                                    echo '</nav>';
                                echo '</div>';
                            echo '</div>';
                            if (function_exists('naturally_nav_custom_search_form') && 'yes' != $settings['hide_search'] ) {
                                echo '<div class="nav2_toggle is-right">';
                                    echo '<div class="nav2_toggle_button">';
                                        $search_text = $settings['search_text'] ? $settings['search_text'] : esc_html__( 'Search', 'naturally' );
                                        echo '<span class="nav2_toggle_button_icon icon is-search"></span>';
                                        echo '<span class="nav2_toggle_button_text">'.esc_html( $search_text ).'</span>';
                                    echo '</div>';
                                    echo '<div class="nav2_toggle_inner">';
                                        echo naturally_nav_custom_search_form();
                                    echo '</div>';
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            }
            echo '<div class="section blog-grid-3">';
                echo '<div class="container">';
                    echo '<div class="grid">';
                        echo '<div class="grid_row is-40">';
                            $count_posts = wp_count_posts();
                            $count_posts = $count_posts ? $count_posts->publish : 0;
                            $counter = 0;
                            $the_query = new \WP_Query( $args );
                            if( $the_query->have_posts() ) {
                                while ($the_query->have_posts()) {
                                    $the_query->the_post();

                                    $blankimg = get_template_directory_uri().'/images/blank.gif';
                                    $srcset1 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 400, 400, true, true, true );
                                    $srcset1 = $srcset1 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [400, 400] ) : $srcset1;
                                    $srcset2 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 800, 800, true, true, true );
                                    $srcset2 = $srcset2 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [800, 800] ) : $srcset2;
                                    $imagealt = esc_attr(get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true));
                                    $imagealt = $imagealt ? $imagealt : get_the_title();
                                    $column = $settings['column2'] ? $settings['column2'] : 6;
                                    $delay = ( $counter % 2 ) == 1 ? $delay + 200 : 0;
                                    $aos = \Elementor\Plugin::$instance->editor->is_edit_mode() ? ' aos-init aos-animate' : '';
                                    echo '<div class="grid_col is-12 is-md-6 is-lg-'.$column.$aos.'" data-aos="ntr-fade-up" data-aos-once="true" data-aos-delay="'.$delay.'">';
                                         echo '<div class="blog-post3">';
                                            if(has_post_thumbnail()){
                                                echo '<a class="blog-post3_photo" href="'.get_permalink().'">';
                                                        echo '<img class="lazyload"
                                                        src="'.$blankimg.'"
                                                        data-srcset="'.esc_url( $srcset1 ).' 1x, '.esc_url( $srcset2 ).' 2x"
                                                        alt="'.esc_attr( $imagealt ).'">';
                                                echo '</a>';
                                            }
                                            echo '<div class="blog-post3_body">';
                                                if('yes' != $settings['hidetitle']){
                                                    echo '<h4 class="blog-post3_title"><a href="'.get_permalink().'">'.get_the_title().'</a></h4>';
                                                }
                                                if('yes' != $settings['hidemeta'] && 'yes' != $settings['hidedate'] ){
                                                    echo '<span class="blog-post3_date">'.get_the_date().'</span>';
                                                }
                                                if(has_excerpt() && 'yes' != $settings['hideexcerpt']){
                                                    echo '<span class="blog-post3_summary">'.wp_trim_words( get_the_excerpt(), $settings['excerpt_limit'] ).'</span>';
                                                }
                                                if('yes' != $settings['hidemeta'] && 'yes' != $settings['hideauthor']){
                                                    echo '<a class="blog-post3_author" href="'.get_permalink().'">';
                                                    echo '<span class="blog-post3_author_avatar">';
                                                            echo get_avatar( get_the_author_meta( 'ID' ), 32 );
                                                        echo '</span>';
                                                        echo '<span class="blog-post3_author_name">'.get_the_author().'</span>';
                                                        echo '</a>';
                                                }
                                            echo '</div>';
                                        echo '</div>';
                                    echo '</div>';
                                    $delay = ( $counter % 2 ) == 0  ? 0 : $delay;
                                    $counter++;
                                }

                            } else {

                                echo '<p class="text">No post found!</p>';
                            }
                            wp_reset_postdata();
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }
        if('5' == $settings['type']){

            echo '<div class="grid">';
                echo '<div class="grid_row is-40">';
                    $delay = 0;
                    $aos = \Elementor\Plugin::$instance->editor->is_edit_mode() ? ' aos-init aos-animate' : '';
                    $the_query = new \WP_Query( $args );
                    if( $the_query->have_posts() ) {
                        while ($the_query->have_posts()) {
                            $the_query->the_post();
                            $post_class = get_post_class( array( 'grid_col is-12 style-1'.$aos ) );
                            echo '<div id="post-'.get_the_ID().'" class="'.implode(' ',$post_class).'" data-aos="ntr-fade-up" data-aos-once="true" data-aos-delay="'.$delay.'">';

                                echo '<div class="blog-post2">';

                                    if ( is_sticky() ) {
                                        echo '<div class="nt-sticky-label"><span class="label is-green-light">'.esc_html__( 'Sticky', 'naturally' ).'</span></div>';
                                    }

                                    if ( has_post_thumbnail() ) {
                                        echo '<a class="blog-post2_photo" href="'.esc_url( get_permalink() ).'">';
                                        if ( !function_exists('icl_object_id') ) {
                                           if ( function_exists('naturally_aq_resize') ) {
                                                $blankimg = get_template_directory_uri().'/images/blank.gif';
                                                $srcset1 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 400, 400, true, true, true );
                                                $srcset1 = $srcset1 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [400, 400] ) : $srcset1;
                                                $srcset2 = naturally_aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ), 800, 800, true, true, true );
                                                $srcset2 = $srcset2 == false ? wp_get_attachment_url( get_post_thumbnail_id(), [800, 800] ) : $srcset2;
                                                $imagealt = esc_attr(get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true));
                                                echo '<span class="aspect-ratio is-1x1">';
                                                    echo '<img class="aspect-ratio_object lazyload"
                                                    src="'.esc_url( $blankimg ).'"
                                                    data-srcset="'.esc_url( $srcset1 ).' 1x, '.esc_url( $srcset2 ).' 2x"
                                                    alt="'.esc_attr( $imagealt ).'">';
                                                echo '</span>';

                                            } else {

                                                the_post_thumbnail( 'naturally-post', array( 'class' => 'img-responsive' ) );
                                            }

                                        } else {

                                            the_post_thumbnail( 'naturally-post', array( 'class' => 'img-responsive' ) );
                                        }
                                        echo '</a>';
                                    }

                                    echo '<div class="blog-post2_info">';

                                        if('yes' != $settings['hidetitle']){
                                            the_title( sprintf( '<h3 class="blog-post2_title"><a href="%s" rel="bookmark">',esc_url(get_permalink() ) ), '</a></h3>' );
                                            edit_post_link( esc_html__( 'Edit Post', 'naturally' ), '<div class="edit_post"><span class="label is-green-light">', '</span></div>' );
                                        }

                                        if('yes' != $settings['hidemeta']){

                                            if ( get_the_author_meta( 'url' ) ) {
                                                echo sprintf( '<p class="blog-post2_meta">%1$s %2$s %3$s</p>',
                                                    'yes' != $settings['hidedate'] ? apply_filters( 'naurally_post_date',get_the_date(), true ) : '',
                                                    'yes' != $settings['hideauthor'] ? esc_html__( 'By','naturally' ) : '',
                                                    'yes' != $settings['hideauthor'] ? get_the_author_link() : ''
                                                );
                                            } else {
                                                echo sprintf( '<p class="blog-post2_meta">%1$s %2$s <a href="%3$s" title="%4$s">%4$s</a></p>',
                                                    'yes' != $settings['hidedate'] ? apply_filters( 'naurally_post2_date', get_the_date(), true ) : '',
                                                    'yes' != $settings['hideauthor'] ? esc_html__( 'By', 'naturally' ) : '',
                                                    'yes' != $settings['hideauthor'] ? esc_url( get_permalink() ) : '',
                                                    'yes' != $settings['hideauthor'] ? get_the_author() : ''
                                                );
                                            }
                                        }
                                        if ( 'yes' != $settings['hideexcerpt']) {
                                            if ( has_excerpt() ) {

                                                echo '<div class="blog-post2_summary">';
                                                    echo wp_trim_words( strip_tags( get_the_excerpt() ), $settings['excerpt_limit'] );
                                                echo '</div>';

                                            } else {

                                               echo '<div class="blog-post2_summary">';
                                                    echo wp_trim_words( strip_tags( get_the_content() ), $settings['excerpt_limit'] );
                                                echo '</div>';
                                            }
                                        }
                                        naturally_wp_link_pages();

                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                            $delay = $delay + 200;
                        }
                    } else {
                        echo '<p class="text">No post found!</p>';
                    }
                    wp_reset_postdata();
                echo '</div>';
            echo '</div>';
        }
    }
}
