<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_CounteUp_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-counterup';
    }
    public function get_title() {
        return 'Counter Up (N)';
    }
    public function get_icon() {
        return 'eicon-counter';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_counters_item_settings',
            [
                'label' => esc_html__('Number and Title', 'naturally'),
            ]
        );
        $this->add_control( 'number',
            [
                'label' => esc_html__( 'Number', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Type your number here', 'naturally' ),
                'input_type' => 'number',
                'default' => '50'
            ]
        );
        $this->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Cities'
            ]
        );
        $this->add_control( 'speed',
            [
                'label' => esc_html__( 'Speed', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Type your speed here', 'naturally' ),
                'input_type' => 'number',
                'default' => '5000'
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('naturally_counter_box_styling',
            [
                'label' => esc_html__( 'Box Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        // Style function
        $this->naturally_style_controls($hide=array('color','typo','txtshadow'),$id='naturally_counter_box_css',$selector='.counter');

        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('naturally_number_styling',
            [
                'label' => esc_html__( 'Number Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        // Style function
        $this->naturally_style_controls($hide=array('border','shadow','background'),$id='naturally_number_css',$selector='.counter .counter_number');

        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('naturally_number_title_styling',
            [
                'label' => esc_html__( 'Title Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        // Style function
        $this->naturally_style_controls($hide=array('txtshadow'),$id='naturally_number_title_css',$selector='.counter .counter_title');

        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
    }

    protected function render() {
        $settings  = $this->get_settings_for_display();
        if ($settings['number']) {
            echo '<div class="counter" data-ntr-counter=\'{"from":0, "to":'.$settings['number'].', "speed":'.$settings['speed'].', "refreshInterval":100}\'>';
                echo '<div class="counter_number">'.$settings['number'].'</div>';
                if ($settings['title']) {
                    echo '<div class="counter_title">'.$settings['title'].'</div>';
                }
            echo '</div>';
        }
	}
}
