<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Features_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-features';
    }
    public function get_title() {
        return 'Features (N)';
    }
    public function get_icon() {
        return 'eicon-columns';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_features_one_items_settings',
            [
                'label' => esc_html__('Features Items', 'naturally')
            ]
        );
        $this->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Organic',
                'label_block' => true
            ]
        );
        $this->add_control( 'desc',
            [
                'label' => esc_html__( 'Description', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Lorem ipsum dolor sit amet, adipiscing elit. Cras nec ligula id ex malesuada consectetur volutpat.',
                'label_block' => true
            ]
        );
        $this->add_control( 'icon_type',
            [
                'label' => esc_html__( 'Icon Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'font',
                'options' => [
                    '' => esc_html__( 'None', 'naturally' ),
                    'theme' => esc_html__( 'Theme Icon', 'naturally' ),
                    'font' => esc_html__( 'From Library', 'naturally' ),
                ],
            ]
        );
        $this->add_control( 'theme_icon',
            [
                'label' => esc_html__( 'Icon', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'default' => 'theme',
                'multiple' => false,
                'options' => $this->naturally_theme_icon_list(),
                'condition' => ['icon_type' => 'theme']
            ]
        );
        $this->add_control( 'font_icon',
            [
                'label' => esc_html__('Icon', 'naturally'),
                'type' => Controls_Manager::ICONS,
                'default'   => [
                    'value' => 'fas fa-home',
                    'library' => 'fa-solid'
                ],
                'condition' => ['icon_type' => 'font']
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section( 'naturally_features_icon_style',
            [
                'label' => esc_html__( 'Icon', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->naturally_style_controls(array('shadow','background'),$id='features_icon',$selector='.feature_icon .icon');
        $this->end_controls_section();
        
        $this->start_controls_section( 'naturally_features_title_style',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['title!' => '']
            ]
        );
        $this->naturally_style_controls(array('shadow'),$id='features_title',$selector='.feature_title');
        $this->end_controls_section();
        
        $this->start_controls_section( 'naturally_features_desc_style',
            [
                'label' => esc_html__( 'Description', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['desc!' => '']
            ]
        );
        $this->naturally_style_controls(array('shadow'),$id='features_desc',$selector='.feature .feature_summary');
        $this->end_controls_section();
        
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        echo '<div class="feature">';
            if ($settings['icon_type'] == 'theme') {
                if ($settings['theme_icon']) {
                    echo '<div class="feature_icon"><div class="icon '.$settings['theme_icon'].'"></div></div>';
                }
            }
            if ($settings['icon_type'] == 'font') {
                if ( ! empty($settings['font_icon']['value']) ) {
                    echo '<div class="feature_icon"><div class="icon">';
                        Icons_Manager::render_icon( $settings['font_icon'], [ 'aria-hidden' => 'true' ] );
                    echo '</div></div>';
                }
            }
            echo '<div class="feature_info">';
                if ( $settings['title'] ) {
                    echo '<h3 class="feature_title">'.$settings['title'].'</h3>';
                }
                if ( $settings['desc'] ) {
                    echo '<p class="feature_summary">'.$settings['desc'].'</p>';
                }
            echo '</div>';
        echo '</div>';
    }
}
