<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Gallery_Banner_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-gallery-banner';
    }
    public function get_title() {
        return 'Banner Masonry (N)';
    }
    public function get_icon() {
        return 'eicon-gallery-grid';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_banner_image_settings',
            [
                'label' => esc_html__('Banner Images', 'naturally'),
            ]
        );
        $repeater = new Repeater();
        $def_image = plugins_url( 'assets/front/img/banner-3.jpg', __DIR__ );
        $repeater->add_control( 'image',
            [
                'label' => esc_html__( 'Image', 'naturally' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => $def_image],
            ]
        );
        $repeater->add_control( 'col_lg',
            [
                'label' => esc_html__( 'Column Desktop', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => '',
                'options' => [
                    '' => esc_html__( 'Select Column', 'naturally' ),
                    '3' => esc_html__( '4 Column', 'naturally' ),
                    '4' => esc_html__( '3 Column', 'naturally' ),
                    '6' => esc_html__( '2 Column', 'naturally' ),
                    '12' => esc_html__( '1 Column', 'naturally' )
                ]
            ]
        );
        $repeater->add_control( 'col_sm',
            [
                'label' => esc_html__( 'Column Tablet', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => '6',
                'options' => [
                    '6' => esc_html__( 'Default 2 Column', 'naturally' ),
                    '4' => esc_html__( '3 Column', 'naturally' ),
                    '12' => esc_html__( '1 Column', 'naturally' )
                ]
            ]
        );
        $repeater->add_control( 'link',
            [
                'label' => esc_html__( 'Link', 'naturally' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'default' => [
                    'url' => '#0',
                    'is_external' => ''
                ],
                'show_external' => true
            ]
        );
        $this->add_control( 'gallery',
            [
                'label' => esc_html__( 'Items', 'naturally' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '#Image',
                'default' => [
                    [
                        'col_lg' => '',
                        'col_sm' => '6',
                        'link' => '#0',
                        'image' => ['url' => $def_image],
                    ],
                ]
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings  = $this->get_settings_for_display();
        $elementid = $this->get_id();
        $count = 0;
		echo '<div class="container">';
			echo '<div class="grid">';
				echo '<div class="grid_row is-30 is-md-40" data-ntr-isotope=\'{"name":"banners_'.$elementid.'", "itemSelector":".grid_col", "layoutMode":"masonry"}\'>';
				    echo '<div class="grid_sizer"></div>';
                    foreach ($settings['gallery'] as $item) {
                        $imagealt  = esc_attr(get_post_meta($item['image']['id'], '_wp_attachment_image_alt', true));
                        $imagealt  = $imagealt ? $imagealt : basename ( get_attached_file( $item['image']['id'] ) );
                        $colxl     = $item['col_lg'] ? ' is-lg-'.$item['col_lg'] : '';
                        $colsm     = $item['col_sm'] ? $item['col_sm'] : '6';
                        $target     = $item['link']['is_external'] ? ' target="_blank"' : '';
                        $nofollow   = $item['link']['nofollow'] ? ' rel="nofollow"' : '';
                        $delay   = $count == 0 ? '' : ' data-aos-delay="'.$count.'"';
                        if ( $item['image']['url'] ) {
                            if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
        					    echo '<div class="grid_col is-12 is-sm-'.$colsm.$colxl.'">';
                            } else {
        					    echo '<div class="grid_col is-12 is-sm-'.$colsm.$colxl.'" data-aos="ntr-fade-up" data-aos-once="true"'.$delay.'>';
                            }
        					    echo '<a class="block hover-up" href="'.$item['link']['url'].'"'.$target .$nofollow.'><img class="img-fluid" src="'.$item['image']['url'].'" alt="'.$imagealt.'"></a>';
        					echo '</div>';
                        }
                        $count = $count+200;
                    }
                echo '</div>';
			echo '</div>';
		echo '</div>';
        // Not in edit mode
        if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
            <script>jQuery(document).ready(function ($) {function ntrIsotope() {var myIsotopes = $('[data-ntr-isotope]');if (myIsotopes.length) {myIsotopes.each(function (i, el) {var myIsotope = $(el);var myData = myIsotope.data('ntrIsotope');if (!myData.itemSelector) {return true;}myIsotope.imagesLoaded(function() {var myIsotopeOptions = {percentPosition: true,layoutMode: myData.layoutMode || 'masonry',itemSelector: myData.itemSelector,masonry: {columnWidth: '.grid_sizer'}};myIsotope.isotope(myIsotopeOptions);if ($('[data-ntr-isotope-filter]').length) {var myFilters = $('[data-ntr-isotope-filter]').filter(function (i, el) {var myFilter = $(el);var myFilterData = myFilter.data('ntrIsotopeFilter');return myFilterData.name === myData.name && myFilterData.selector;});if (myFilters.length) {myFilters.on('click', function (e) {e.preventDefault();var myFilter = $(this);var myFilterData = myFilter.data('ntrIsotopeFilter');var myFilterSelector = myFilterData.selector;var myFilterParent = myFilter.parent();myFilterParent.siblings().removeClass('is-active');myFilterParent.addClass('is-active');myIsotope.isotope({filter: myFilterSelector});});}}});});}}ntrIsotope();});</script>
            <?php
        }
    }
}
