<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Gallery_Grid_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-gallery-grid';
    }
    public function get_title() {
        return 'Gallery Grid (N)';
    }
    public function get_icon() {
        return 'eicon-gallery-grid';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_gallery_column_settings',
            [
                'label' => esc_html__( 'General', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control( 'show_filters',
            [
                'label' => esc_html__( 'Hide Filters', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'return_value' => 'yes',
            ]
        );
        $this->add_responsive_control( 'filter_spacing',
            [
                'label' => esc_html__( 'Filter Bottom Spacing', 'naturally' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 500
                    ]
                ],
                'selectors' => ['{{WRAPPER}} .section-custom-6' => 'margin-bottom: {{SIZE}}px;'],
                'condition' => ['show_filters!' => 'yes']
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_gallery_filters_settings',
            [
                'label' => esc_html__( 'Filters', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => ['show_filters!' => 'yes']
            ]
        );
        $this->add_control( 'all_text',
            [
                'label' => esc_html__( 'All Text', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'All Photos',
                'label_block' => true,
            ]
        );
        $this->add_control( 'filter_text',
            [
                'label' => esc_html__( 'Mobile Filter Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Filter',
                'label_block' => true,
            ]
        );
        $filters = new Repeater();
        $filters->add_control( 'item_filter',
            [
                'label' => esc_html__( 'Category', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Office',
                'label_block' => true,
            ]
        );
        $this->add_control( 'gallery_filters',
            [
                'label' => esc_html__( 'Items', 'naturally' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $filters->get_controls(),
                'title_field' => '{{item_filter}}',
                'default' => [
                    ['item_filter' =>'Office'],
                    ['item_filter' =>'Events'],
                    ['item_filter' =>'Team'],
                    ['item_filter' =>'Farm'],
                ]
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_gallery_image_settings',
            [
                'label' => esc_html__('Gallery Images', 'naturally'),
            ]
        );
        $repeater = new Repeater();
        $repeater->add_control( 'item_cat',
            [
                'label' => esc_html__( 'Category Name', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__( 'Type category name', 'naturally' )
            ]
        );
        $repeater->add_control( 'item_title',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Item Title',
                'label_block' => true,
            ]
        );
        $def_image = plugins_url( 'assets/front/img/gallery-farm.jpg', __DIR__ );
        $repeater->add_control( 'item_image',
            [
                'label' => esc_html__( 'Image', 'naturally' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => $def_image],
            ]
        );
        $repeater->add_control( 'item_big_image',
            [
                'label' => esc_html__( 'Lightbox Image', 'naturally' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => $def_image],
            ]
        );
        $repeater->add_control( 'col_xl',
            [
                'label' => esc_html__( 'Column', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => '3',
                'options' => [
                    '3' => esc_html__( 'Default 4 Column', 'naturally' ),
                    '4' => esc_html__( '3 Column', 'naturally' ),
                    '6' => esc_html__( '2 Column', 'naturally' )
                ]
            ]
        );
        $repeater->add_control( 'col_md',
            [
                'label' => esc_html__( 'Column Desktop', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => '4',
                'options' => [
                    '6' => esc_html__( 'Default 2 Column', 'naturally' ),
                    '4' => esc_html__( '3 Column', 'naturally' ),
                    '12' => esc_html__( '1 Column', 'naturally' )
                ]
            ]
        );
        $repeater->add_control( 'col_sm',
            [
                'label' => esc_html__( 'Column Tablet', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => '6',
                'options' => [
                    '6' => esc_html__( 'Default 2 Column', 'naturally' ),
                    '4' => esc_html__( '3 Column', 'naturally' ),
                    '12' => esc_html__( '1 Column', 'naturally' )
                ]
            ]
        );
        $this->add_control( 'gallery',
            [
                'label' => esc_html__( 'Items', 'naturally' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{item_title}}',
                'default' => [
                    [
                        'col_xl' => '3',
                        'col_md' => '4',
                        'col_sm' => '6',
                        'item_title' => 'Title',
                        'item_cat' => 'Office',
                        'item_image' => ['url' => $def_image],
                    ],
                    [
                        'col_xl' => '3',
                        'col_md' => '4',
                        'col_sm' => '6',
                        'item_title' => 'Title',
                        'item_cat' => 'Events',
                        'item_image' => ['url' => $def_image],
                    ],
                    [
                        'col_xl' => '3',
                        'col_md' => '4',
                        'col_sm' => '6',
                        'item_title' => 'Title',
                        'item_cat' => 'Team',
                        'item_image' => ['url' => $def_image],
                    ],
                    [
                        'col_xl' => '3',
                        'col_md' => '4',
                        'col_sm' => '6',
                        'item_title' => 'Title',
                        'item_cat' => 'Farm',
                        'item_image' => ['url' => $def_image],
                    ],
                    [
                        'col_xl' => '3',
                        'col_md' => '4',
                        'col_sm' => '6',
                        'item_title' => 'Title',
                        'item_cat' => 'Office',
                        'item_image' => ['url' => $def_image],
                    ],
                    [
                        'col_xl' => '3',
                        'col_md' => '4',
                        'col_sm' => '6',
                        'item_title' => 'Title',
                        'item_cat' => 'Events',
                        'item_image' => ['url' => $def_image],
                    ],
                    [
                        'col_xl' => '3',
                        'col_md' => '4',
                        'col_sm' => '6',
                        'item_title' => 'Title',
                        'item_cat' => 'Team',
                        'item_image' => ['url' => $def_image],
                    ],
                    [
                        'col_xl' => '3',
                        'col_md' => '4',
                        'col_sm' => '6',
                        'item_title' => 'Title',
                        'item_cat' => 'Farm',
                        'item_image' => ['url' => $def_image],
                    ],
                    [
                        'col_xl' => '3',
                        'col_md' => '4',
                        'col_sm' => '6',
                        'item_title' => 'Title',
                        'item_cat' => 'Office',
                        'item_image' => ['url' => $def_image],
                    ],
                    [
                        'col_xl' => '3',
                        'col_md' => '4',
                        'col_sm' => '6',
                        'item_title' => 'Title',
                        'item_cat' => 'Events',
                        'item_image' => ['url' => $def_image],
                    ],
                    [
                        'col_xl' => '3',
                        'col_md' => '4',
                        'col_sm' => '6',
                        'item_title' => 'Title',
                        'item_cat' => 'Team',
                        'item_image' => ['url' => $def_image],
                    ],
                    [
                        'col_xl' => '3',
                        'col_md' => '4',
                        'col_sm' => '6',
                        'item_title' => 'Title',
                        'item_cat' => 'Farm',
                        'item_image' => ['url' => $def_image],
                    ],
                ]
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {

        $settings  = $this->get_settings_for_display();
        $elementid = $this->get_id();
        if ( 'yes' != $settings['show_filters'] && $settings['gallery_filters'] ) {
            echo '<div class="section section-custom-6">';
                echo '<div class="container">';
                    echo '<div class="nav" data-ntr-nav>';
                        echo '<div class="nav_toggle">';
                            echo '<div class="nav_toggle_button">';
                                echo '<span class="nav_toggle_button_icon icon is-filter"></span>';
                                echo '<span class="nav_toggle_button_text">'.$settings['filter_text'].'</span>';
                            echo '</div>';
                            echo '<div class="nav_toggle_inner">';
                                echo '<nav class="nav_menu">';
                                    echo '<ul class="nav_menu_items">';
                                        echo '<li class="nav_menu_item is-active"><a class="nav_menu_link" href="#" data-ntr-isotope-filter=\'{"name":"gallery_'.$elementid.'", "selector":"*"}\'>'.$settings['all_text'].'</a></li>';
                                        foreach ($settings['gallery_filters'] as $items) {
                                            $filter_item = strtolower(str_replace(' ', '-', esc_attr($items['item_filter'])));
                                            echo '<li class="nav_menu_item"><a class="nav_menu_link" href="#" data-ntr-isotope-filter=\'{"name":"gallery_'.$elementid.'", "selector":".'.$filter_item.'"}\'>'.$items['item_filter'].'</a></li>';
                                        }
                                    echo '</ul>';
                                echo '</nav>';
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }
        echo '<div class="section-gallery">';
            echo '<div class="container">';
                echo '<div class="grid">';
                    echo '<div class="grid_row is-40" data-ntr-isotope=\'{"name":"gallery_'.$elementid.'", "itemSelector":".grid_col", "layoutMode":"fitRows"}\' data-ntr-lightbox=\'{"type":"gallery","selector":".gallery-photo"}\'>';
                        foreach ($settings['gallery'] as $item) {
                            $imagealt  = esc_attr(get_post_meta($item['item_image']['id'], '_wp_attachment_image_alt', true));
                            $imagealt  = $imagealt ? $imagealt : basename ( get_attached_file( $item['item_image']['id'] ) );
                            $colxl     = $item['col_xl'] ? $item['col_xl'] : '3';
                            $colmd     = $item['col_md'] ? $item['col_md'] : '4';
                            $colsm     = $item['col_sm'] ? $item['col_sm'] : '6';
                            $item_cat  = strtolower(str_replace(' ', '-', esc_attr($item['item_cat'])));
                            if ( $item['item_image']['url'] ) {
                                $big_img = $item['item_big_image']['url'] ? $item['item_big_image']['url'] : $item['item_image']['url'];
                                echo '<div class="grid_col is-12 is-sm-'.$colsm.' is-md-'.$colmd.' is-lg-'.$colxl.' '.$item_cat.'">';
                                    echo '<a class="gallery-photo hover-up" href="'.$big_img.'" title="'.$imagealt.'">';
                                    if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
                                        echo '<img class="gallery-photo_image" src="'.$item['item_image']['url'].'" alt="'.$imagealt.'">';
                                    } else {
                                                $blankimg = plugins_url( 'assets/front/img/blank.gif', __DIR__ );
                                                $srcset1 = naturally_aq_resize( $item['item_image']['url'], 400, 400, true, true, true );
                                                $srcset1 = $srcset1 == false ? wp_get_attachment_url( $item['item_image']['id'], [400, 400] ) : $srcset1;
                                                $srcset2 = naturally_aq_resize( $item['item_image']['url'], 800, 800, true, true, true );
                                                $srcset2 = $srcset2 == false ? wp_get_attachment_url( $item['item_image']['id'], [800, 800] ) : $srcset2;
                                                echo '<span class="aspect-ratio is-1x1">';
                                                echo '<img class="aspect-ratio_object lazyload"
                                                src="'.esc_url( $blankimg ).'"
                                                data-srcset="'.esc_url( $srcset1 ).' 1x, '.esc_url( $srcset2 ).' 2x"
                                                alt="'.esc_attr( $imagealt ).'">';
                                            echo '</span>';
                                    }
                                        if ( $item['item_title'] ) {
                                            echo '<span class="gallery-photo_caption">'.$item['item_title'].'</span>';
                                        }
                                    echo '</a>';

                                echo '</div>';
                            }
                        }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        echo '</div>';
        // Not in edit mode
        if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
            <script>jQuery(document).ready(function ($) {function ntrIsotope() {var myIsotopes = $('[data-ntr-isotope]');if (myIsotopes.length) {myIsotopes.each(function (i, el) {var myIsotope = $(el);var myData = myIsotope.data('ntrIsotope');if (!myData.itemSelector) {return true;}myIsotope.imagesLoaded(function() {myIsotope.isotope({percentPosition: true,itemSelector: myData.itemSelector,layoutMode: myData.layoutMode || 'fitRows',});if ($('[data-ntr-isotope-filter]').length) {var myFilters = $('[data-ntr-isotope-filter]').filter(function (i, el) {var myFilter = $(el);var myFilterData = myFilter.data('ntrIsotopeFilter');return myFilterData.name === myData.name && myFilterData.selector;});if (myFilters.length) {myFilters.on('click', function (e) {e.preventDefault();var myFilter = $(this);var myFilterData = myFilter.data('ntrIsotopeFilter');var myFilterSelector = myFilterData.selector;var myFilterParent = myFilter.parent();myFilterParent.siblings().removeClass('is-active');myFilterParent.addClass('is-active');myIsotope.isotope({filter: myFilterSelector});});}}});});}}ntrIsotope();});</script>
            <?php
        }
    }
}
