<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Header_Langs_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-header-langs';
    }
    public function get_title() {
        return 'Header Langs (N)';
    }
    public function get_icon() {
        return 'eicon-sitemap';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }

    // Registering Controls
    protected function register_controls() {

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_header_lang_settings',
            [
                'label' => esc_html__('Langs Switcher', 'naturally'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control( 'type',
            [
                'label' => esc_html__( 'Langs Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'custom',
                'options' => [
                    'polylang' => esc_html__( 'Polylang Plugin', 'naturally' ),
                    'custom' => esc_html__( 'Custom List', 'naturally' ),
                ]
            ]
        );
        $this->add_control( 'show_flags',
            [
                'label' => esc_html__( 'Show Flags', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [ 'type' => 'polylang' ],
            ]
        );
        $this->add_control( 'show_names',
            [
                'label' => esc_html__( 'Show Names', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [ 'type' => 'polylang' ],
            ]
        );
        $this->add_control( 'firstname',
            [
                'label' => esc_html__( 'First Lang Name', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'English',
                'condition' => [ 'type' => 'custom' ],
            ]
        );
        $repeater = new Repeater();
        $repeater->add_control( 'name',
            [
                'label' => esc_html__( 'Lang Name', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
            ]
        );
        $repeater->add_control( 'flag',
            [
                'label' => esc_html__( 'Flag', 'naturally' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src()],
            ]
        );
        $repeater->add_control( 'link',
            [
                'label' => esc_html__( 'Link', 'naturally' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'default' => [
                    'url' => '#0',
                    'is_external' => 'true'
                ],
                'placeholder' => esc_html__( 'Place URL here', 'naturally' )
            ]
        );
        $this->add_control( 'langs',
            [
                'label' => esc_html__( 'Langs', 'naturally' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{name}}',
                'condition' => [ 'type' => 'custom' ],
                'default' => [
                    [
                        'name' => 'English',
                        'link' => '#0',
                    ],
                    [
                        'name' => 'French',
                        'link' => '#0',
                    ],
                    [
                        'name' => 'German',
                        'link' => '#0',
                    ],
                    [
                        'name' => 'Spanish',
                        'link' => '#0',
                    ],
                    [
                        'name' => 'Rusian',
                        'link' => '#0',
                    ],
                ]
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /***** HEADER LANGS SETTINGS ******/
        $this->start_controls_section( 'header_lang_style_controls_section',
            [
                'label'        => esc_html__( 'Icon && Text', 'naturally' ),
                'tab'          => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control( 'header_lang_alignment',
            [
                'label'          => esc_html__( 'Alignment', 'naturally' ),
                'type'           => Controls_Manager::CHOOSE,
                'selectors'      => ['{{WRAPPER}} .naturally_langs_wrapper' => 'display: flex;align-items:center;justify-content:{{VALUE}};'],
                'options'        => [
                    'flex-start' => [
                        'title'    => esc_html__( 'Left', 'naturally' ),
                        'icon'     => 'fa fa-align-left'
                    ],
                    'center' => [
                        'title'    => esc_html__( 'Center', 'naturally' ),
                        'icon'     => 'fa fa-align-center'
                    ],
                    'flex-end' => [
                        'title'    => esc_html__( 'Right', 'naturally' ),
                        'icon'     => 'fa fa-align-right'
                    ]
                ],
                'toggle'         => true,
                'default'        => '',
                'separator'     => 'before'
            ]
        );
        $this->add_responsive_control( 'header_lang_content_zindex',
            [
                'label'         => esc_html__( 'Z-Index', 'naturally' ),
                'type'          => Controls_Manager::NUMBER,
                'selectors'     => [ '{{WRAPPER}} .naturally_header_langs.header_lang' => 'z-index: {{SIZE}};' ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'          => 'header_lang_typo',
                'label'         => esc_html__( 'Typography', 'naturally' ),
                'selector'      => '{{WRAPPER}} .naturally_header_langs .header_lang_label'
            ]
        );
        $this->add_responsive_control( 'header_lang_padding',
            [
                'label'         => esc_html__( 'Padding', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', 'em', '%' ],
                'selectors'     => ['{{WRAPPER}} .naturally_header_langs.header_lang' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ],
                'separator'     => 'before'
            ]
        );
        $this->add_responsive_control( 'header_lang_margin',
            [
                'label'         => esc_html__( 'Margin', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', 'em', '%' ],
                'selectors'     => ['{{WRAPPER}} .naturally_header_langs.header_lang' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ],
                'separator'     => 'before'
            ]
        );
        $this->start_controls_tabs('header_lang_normal_tabs');
        $this->start_controls_tab( 'header_lang_normal_tab',
            [ 'label'           => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'          => 'header_lang_background',
                'label'         => esc_html__( 'Background', 'naturally' ),
                'types'         => [ 'classic', 'gradient' ],
                'selector'      => '{{WRAPPER}} .naturally_header_langs.header_lang',
            ]
        );
        $this->add_control( 'header_lang_normal_color',
            [
                'label'         => esc_html__( 'Text Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .naturally_header_langs.header_lang .header_lang_label' => 'color: {{VALUE}};'],
                'separator'     => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'          => 'header_lang_border',
                'label'         => esc_html__( 'Border', 'naturally' ),
                'selector'      => '{{WRAPPER}} .naturally_header_langs.header_lang',
                'separator'     => 'before'
            ]
        );
        $this->add_responsive_control( 'header_lang_border_radius',
            [
                'label'         => esc_html__( 'Border Radius', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px' ],
                'selectors'     => ['{{WRAPPER}} .naturally_header_langs.header_lang' => 'border-top-left-radius: {{TOP}}{{UNIT}};border-top-right-radius: {{RIGHT}}{{UNIT}};border-bottom-left-radius: {{BOTTOM}}{{UNIT}};border-bottom-right-radius: {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ]
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab('header_lang_hover_tab',
            [ 'label'           => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'          => 'header_lang_hover_background',
                'label'         => esc_html__( 'Background', 'naturally' ),
                'types'         => [ 'classic', 'gradient' ],
                'selector'      => '{{WRAPPER}} .naturally_header_langs.header_lang:hover',
            ]
        );
        $this->add_control( 'header_lang_hover_color',
            [
                'label'         => esc_html__( 'Text Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .naturally_header_langs.header_lang:hover .header_lang_label' => 'color: {{VALUE}};'],
                'separator'     => 'before'
            ]
        );
       $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'          => 'header_lang_hover_border',
                'label'         => esc_html__( 'Border', 'naturally' ),
                'selector'      => '{{WRAPPER}} .naturally_header_langs.header_lang:hover',
                'separator'     => 'before'
            ]
        );
        $this->add_responsive_control( 'header_lang_hover_border_radius',
            [
                'label'         => esc_html__( 'Border Radius', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px' ],
                'selectors'     => ['{{WRAPPER}} .naturally_header_langs.header_lang:hover' => 'border-top-left-radius: {{TOP}}{{UNIT}};border-top-right-radius: {{RIGHT}}{{UNIT}};border-bottom-left-radius: {{BOTTOM}}{{UNIT}};border-bottom-right-radius: {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ]
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /***** HEADER LANGS SETTINGS *****/

        /***** HEADER LANGS SETTINGS *****/
        $this->start_controls_section( 'header_lang_content_style_controls_section',
            [
                'label'        => esc_html__( 'Lang Dropdown', 'naturally' ),
                'tab'          => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control( 'header_lang_content_width',
            [
                'label'         => esc_html__( 'Width', 'naturally' ),
                'type'          => Controls_Manager::SLIDER,
                'range'         => [ 'px' => [ 'max' => 500 ] ],
                'selectors'     => [ '{{WRAPPER}} .naturally_header_langs .header_lang_items' => 'width: {{SIZE}}px;min-width: {{SIZE}}px;' ],
            ]
        );
        $this->add_control( 'header_lang_content_text_color',
            [
                'label'         => esc_html__( 'Text Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .naturally_header_langs .header_lang_item .header_lang_link_text' => 'color: {{VALUE}};'],
                'separator'     => 'before'
            ]
        );
        $this->add_responsive_control( 'header_lang_content_padding',
            [
                'label'         => esc_html__( 'Padding', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px', 'em', '%' ],
                'selectors'     => ['{{WRAPPER}} .naturally_header_langs .header_lang_items' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ],
                'separator'     => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'          => 'header_lang_content_background',
                'label'         => esc_html__( 'Background', 'naturally' ),
                'types'         => [ 'classic', 'gradient' ],
                'selector'      => '{{WRAPPER}} .naturally_header_langs .header_lang_items',
                'separator'     => 'before'
            ]
        );
       $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'          => 'header_lang_content_border',
                'label'         => esc_html__( 'Border', 'naturally' ),
                'selector'      => '{{WRAPPER}} .naturally_header_langs .naturally_lang_list .header_lang_items',
                'separator'     => 'before'
            ]
        );
        $this->add_responsive_control( 'header_lang_content_border_radius',
            [
                'label'         => esc_html__( 'Border Radius', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px' ],
                'selectors'     => ['{{WRAPPER}} .naturally_header_langs .naturally_lang_list .header_lang_items' => 'border-top-left-radius: {{TOP}}{{UNIT}};border-top-right-radius: {{RIGHT}}{{UNIT}};border-bottom-left-radius: {{BOTTOM}}{{UNIT}};border-bottom-right-radius: {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ]
            ]
        );
        $this->end_controls_section();
        /***** HEADER LANGS SETTINGS ******/
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        echo'<div class="naturally_langs_wrapper" data-ntr-header-langs>';
            echo'<div class="naturally_header_langs header_lang">';
                echo'<div class="header_lang_label">';
                    echo'<span class="header_lang_label_icon icon is-internet"></span>';
                    if ('polylang' == $settings['type']) {
                        if (function_exists('pll_the_languages')) {
                            echo'<span class="header_lang_label_text">'.pll_current_language('name').'</span>';
                            echo'<div class="header_lang_list polylang">';
                                echo'<ul class="header_lang_items">';
                                    pll_the_languages(
                                        array(
                                            'show_flags'=>1,
                                            'show_names'=>1,
                                            'dropdown'=>0,
                                            'raw'=>0,
                                            'hide_current'=>1,
                                            'display_names_as'=>'name'
                                        )
                                    );
                                echo'</ul>';
                            echo'</div>';
                        }
                    } else {
                        if ( $settings['firstname'] ) {
                            echo'<span class="header_lang_label_text">'.esc_attr($settings['firstname']).'</span>';
                        }
                        echo' <div class="naturally_lang_list header_lang_list">';
                            echo'<ul class="header_lang_items">';
                                foreach ( $settings['langs'] as $lang ) {
                                    if ( $lang['flag'] || $lang['name'] ) {
                                        echo'<li class="header_lang_item">';
                                            echo'<a class="header_lang_link" href="'.$lang['link']['url'].'">';
                                                if ( $lang['flag']['url'] ) {
                                                    echo'<img class="header_lang_link_flag" src="'.$lang['flag']['url'].'" alt="'.$lang['name'].'">';
                                                }
                                                if ( $lang['name'] ) {
                                                    echo'<span class="header_lang_link_text">'.$lang['name'].'</span>';
                                                }
                                            echo'</a>';
                                        echo'</li>';
                                    }
                                }
                            echo'</ul>';
                        echo'</div>';
                    }
                echo'</div>';
            echo'</div>';
        echo'</div>';

    }
}
