<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Header_Search_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-header-search';
    }
    public function get_title() {
        return 'Header Search (N)';
    }
    public function get_icon() {
        return 'eicon-site-search';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }

    // Registering Controls
    protected function register_controls() {

        /* HEADER SEARCH SETTINGS */
        $this->start_controls_section( 'header_search_style_controls_section',
            [
                'label' => esc_html__( 'Icon && Text', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control( 'search_type',
            [
                'label' => esc_html__( 'Search Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default' => esc_html__( 'Default', 'naturally' ),
                    'product' => esc_html__( 'Product', 'naturally' ),
                ]
            ]
        );
        $this->add_control( 'header_search_alignment',
            [
                'label' => esc_html__( 'Alignment', 'naturally' ),
                'type' => Controls_Manager::CHOOSE,
                'selectors' => ['{{WRAPPER}} .naturally_header_search' => 'justify-content:{{VALUE}};'],
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__( 'Left', 'naturally' ),
                        'icon' => 'fa fa-align-left'
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'naturally' ),
                        'icon' => 'fa fa-align-center'
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'Right', 'naturally' ),
                        'icon' => 'fa fa-align-right'
                    ]
                ],
                'toggle' => true,
                'default' => '',
                'separator' => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'header_search_typo',
                'label' => esc_html__( 'Typography', 'naturally' ),
                'selector' => '{{WRAPPER}} .naturally_header_search .header_menu_link'
            ]
        );

        $this->start_controls_tabs('header_search_normal_tabs');
        $this->start_controls_tab( 'header_search_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'header_search_background',
                'label' => esc_html__( 'Background', 'naturally' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .naturally_header_search .header_menu_link',
            ]
        );
        $this->add_control( 'header_search_normal_color',
            [
                'label' => esc_html__( 'Text Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .naturally_header_search .header_menu_link' => 'color: {{VALUE}};'],
                'separator' => 'before'
            ]
        );
       $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'header_search_border',
                'label' => esc_html__( 'Border', 'naturally' ),
                'selector' => '{{WRAPPER}} .naturally_header_search .header_menu_link',
                'separator' => 'before'
            ]
        );
        $this->add_responsive_control( 'header_search_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'naturally' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} .naturally_header_search .header_menu_link' => 'border-top-left-radius: {{TOP}}{{UNIT}};border-top-right-radius: {{RIGHT}}{{UNIT}};border-bottom-left-radius: {{BOTTOM}}{{UNIT}};border-bottom-right-radius: {{LEFT}}{{UNIT}};'],
                'default' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                ]
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab('header_search_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'header_search_hover_background',
                'label' => esc_html__( 'Background', 'naturally' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .naturally_header_search .header_menu_link:hover',
            ]
        );
        $this->add_control( 'header_search_hover_color',
            [
                'label' => esc_html__( 'Button Text Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .naturally_header_search .header_menu_link:hover' => 'color: {{VALUE}};'],
                'separator' => 'before'
            ]
        );
       $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'header_search_hover_border',
                'label' => esc_html__( 'Border', 'naturally' ),
                'selector' => '{{WRAPPER}} .naturally_header_search .header_menu_link:hover',
                'separator' => 'before'
            ]
        );
        $this->add_responsive_control( 'header_search_hover_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'naturally' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} .naturally_header_search .header_menu_link:hover' => 'border-top-left-radius: {{TOP}}{{UNIT}};border-top-right-radius: {{RIGHT}}{{UNIT}};border-bottom-left-radius: {{BOTTOM}}{{UNIT}};border-bottom-right-radius: {{LEFT}}{{UNIT}};'],
                'default' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                ]
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /* HEADER SEARCH FORM SETTINGS */
        $this->start_controls_section( 'header_search_form_style_controls_section',
            [
                'label' => esc_html__( 'Form Container', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_responsive_control( 'header_search_pleaceholder_text',
            [
                'label' => esc_html__( 'Pleaceholder Text', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Search',
                'separator' => 'before'
            ]
        );
        $this->add_control( 'header_search_form_height',
            [
                'label' => esc_html__( 'Height', 'naturally' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [ '.naturally_header_search_form.header_search' => 'display:flex;align-items:center;justify-content:center;height: {{SIZE}}{{UNIT}};' ],
            ]
        );
        $this->add_responsive_control( 'header_search_form_zindex',
            [
                'label' => esc_html__( 'Z-Index', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'selectors' => [ '{{WRAPPER}} .naturally_header_search_form.header_search' => 'z-index: {{SIZE}};' ],
            ]
        );
        $this->add_responsive_control( 'header_search_form_padding',
            [
                'label' => esc_html__( 'Padding', 'naturally' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => ['.naturally_header_search_form.header_search' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;'],
                'default' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                ],
                'separator' => 'before'
            ]
        );
        $this->add_responsive_control( 'header_search_form_margin',
            [
                'label' => esc_html__( 'Margin', 'naturally' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => ['.naturally_header_search_form.header_search' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;'],
                'default' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                ],
                'separator' => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'header_search_form_background',
                'label' => esc_html__( 'Background', 'naturally' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '.naturally_header_search_form.header_search',
                'separator' => 'before'
            ]
        );
        $this->end_controls_section();

        /* HEADER SEARCH FORM SETTINGS */
        $this->start_controls_section( 'header_search_form_content_style_controls_section',
            [
                'label' => esc_html__( 'Form', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control( 'header_search_form_content_bgcolor',
            [
                'label' => esc_html__( 'Background Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['.naturally_header_search_form.header_search .header_search_form' => 'background-color: {{VALUE}};'],
                'separator' => 'before'
            ]
        );
        $this->add_responsive_control( 'header_search_form_content_padding',
            [
                'label' => esc_html__( 'Padding', 'naturally' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => ['.naturally_header_search_form.header_search .header_search_form' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;'],
                'default' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                ],
                'separator' => 'before'
            ]
        );
       $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'header_search_form_content_border',
                'label' => esc_html__( 'Border', 'naturally' ),
                'selector' => '.naturally_header_search_form.header_search .header_search_form',
                'separator' => 'before'
            ]
        );
        $this->add_responsive_control( 'header_search_form_content_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'naturally' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['.naturally_header_search_form.header_search .header_search_form' => 'border-top-left-radius: {{TOP}}{{UNIT}};border-top-right-radius: {{RIGHT}}{{UNIT}};border-bottom-left-radius: {{BOTTOM}}{{UNIT}};border-bottom-right-radius: {{LEFT}}{{UNIT}};'],
                'default' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                ]
            ]
        );
        $this->add_control( 'header_search_form_input_bgcolor',
            [
                'label' => esc_html__( 'Input Background Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['.naturally_header_search_form.header_search .header_search_input' => 'background-color: {{VALUE}};'],
                'separator' => 'before'
            ]
        );
        $this->add_control( 'header_search_form_input_text_color',
            [
                'label' => esc_html__( 'ınput Text Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['.naturally_header_search_form.header_search .header_search_input, .naturally_header_search_form.header_search .form_control_input::-webkit-input-placeholder,.naturally_header_search_form.header_search .form_control_input::-moz-placeholder, .naturally_header_search_form.header_search .form_control_input:-ms-input-placeholder,.naturally_header_search_form.header_search .form_control_textarea::-webkit-input-placeholder,.naturally_header_search_form.header_search .form_control_textarea:-ms-input-placeholder' => 'color: {{VALUE}};'],
                'separator' => 'before'
            ]
        );
        $this->add_control( 'header_search_form_icon_color',
            [
                'label' => esc_html__( 'Icon Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['.naturally_header_search_form.header_search .header_search_button' => 'color: {{VALUE}};'],
                'separator' => 'before'
            ]
        );
        $this->add_control( 'header_search_form_close_color',
            [
                'label' => esc_html__( 'Close Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['.naturally_header_search_form.header_search .header_search_close' => 'color: {{VALUE}};'],
                'separator' => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'header_search_close_typo',
                'label' => esc_html__( 'Typography', 'naturally' ),
                'selector' => '.naturally_header_search_form.header_search .header_search_button, .naturally_header_search_form.header_search .header_search_close, .naturally_header_search_form.header_search .header_search_input',
                'separator' => 'before'
            ]
        );
        $this->end_controls_section();

        /* HEADER SEARCH SETTINGS */
        $this->start_controls_section( 'header_search_before_after_controls_section',
            [
                'label' => esc_html__( 'Before && After Form', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control( 'header_search_form_before',
            [
                'label' => esc_html__( 'Before Form', 'plugin-domain' ),
                'type' => Controls_Manager::WYSIWYG,
                'default' => '',
                'separator' => 'before'
            ]
        );
        $this->add_control( 'header_search_form_after',
            [
                'label' => esc_html__( 'After Form', 'plugin-domain' ),
                'type' => Controls_Manager::WYSIWYG,
                'default' => '',
                'separator' => 'before'
            ]
        );
        $this->end_controls_section();
    }

    public function naturally_header_search_form_content()
    {
        $settings = $this->get_settings_for_display();
        $is_search_product = class_exists( 'WooCommerce' ) && 'product' == $settings['search_type'] ? '<input type="hidden" name="post_type" value="product" />' : '';
        $form = '<div class="naturally_header_search_form header_search">
                    <div class="container">';
                        $form .= $settings['header_search_form_before'];
                        $form .= '<form class="header_search_form" role="search" method="get" id="header-widget-searchform" action="' . esc_url(home_url('/')) . '" >
                            <input class="header_search_input" type="text" value="' . get_search_query() . '" placeholder="'. esc_attr($settings['header_search_pleaceholder_text']) .'" name="s" id="hws">
                            '.$is_search_product.'
                            <button class="header_search_button" id="headersearchsubmit" type="submit"><span class="icon is-search"></span></button>
                            <button class="header_search_close" type="button"><span class="icon is-close"></span></button>
                        </form>';
                        $form .= $settings['header_search_form_after'];
                    $form .= '</div>
                </div>';
        return $form;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        add_filter( 'get_search_form', [ $this, 'naturally_header_search_form_content' ] );

        echo'<div class="naturally_header_search" data-ntr-header-search>';
            echo $this->naturally_header_search_form_content();
            echo'<div class="header_menu_item">';
                echo'<a class="header_menu_link header_search_open" href="#">';
                    echo'<span class="header_menu_link_icon icon is-search"></span>';
                    if($settings['header_search_pleaceholder_text']){
                        echo'<span class="header_menu_link_text">'.esc_attr($settings['header_search_pleaceholder_text']).'</span>';
                    }
                echo'</a>';
            echo'</div>';
        echo'</div>';

    }
}
