<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Home_Hero_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-home-hero';
    }
    public function get_title() {
        return 'Home Hero (N)';
    }
    public function get_icon() {
        return 'eicon-columns';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        $this->start_controls_section( 'home_hero_text_section',
            [
                'label' => esc_html__( 'Content', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'text_animation',
            [
                'label' => esc_html__( 'Entrance Animation', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '' => esc_html__( 'None', 'naturally' ),
                    'fadein' => esc_html__( 'fadein', 'naturally' ),
                    'fadein-up' => esc_html__( 'fadein-up', 'naturally' ),
                    'fadein-down' => esc_html__( 'fadein-down', 'naturally' ),
                    'fadein-left' => esc_html__( 'fadein-left', 'naturally' ),
                    'fadein-right' => esc_html__( 'fadein-right', 'naturally' ),
                ],
                'default' => ''
            ]
        );
        $this->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'pleaceholder' => esc_html__( 'Place title here', 'naturally' ),
                'default' => 'Healthy foods',
                'label_block' => true,
            ]
        );
        $this->add_control( 'desc',
            [
                'label' => esc_html__( 'Details', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'pleaceholder' => esc_html__( 'Place details here', 'naturally' ),
                'default' => 'Your journey to a healthier life starts here.',
                'label_block' => true,
            ]
        );
        $this->add_control( 'hero_title',
            [
                'label' => esc_html__( 'Button Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Shop Now',
                'pleaceholder' => esc_html__( 'Enter button title here', 'naturally' )
            ]
        );
        $this->add_control( 'hero_link',
            [
                'label' => esc_html__( 'Button Link', 'naturally' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => 'true'
                ],
                'placeholder' => esc_html__( 'Place URL here', 'naturally' )
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => esc_html__( 'Background', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .section-hero',
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
        /***** Page home Style ******/
        /***** TITLE ******/
        $this->start_controls_section('naturally_home_title_styling',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_title_home_tabs');
        $this->start_controls_tab( 'naturally_title_home_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='title_home',$selector='.section-hero_heading_title');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_title_home_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='title_home_hover',$selector='.section-hero_heading_title:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();

        /***** DESCRIPTION ******/
        $this->start_controls_section('naturally_desc_title_styling',
            [
                'label' => esc_html__( 'Description', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_desc_home_tabs');
        $this->start_controls_tab( 'naturally_desc_home_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='desc_home',$selector='.section-hero_heading_text');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_desc_home_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='desc_home_hover',$selector='.section-hero_heading_text:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();
        /***** Button ******/
        $this->start_controls_section('naturally_btn_title_styling',
            [
                'label' => esc_html__( 'Button', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_btn_home_tabs');
        $this->start_controls_tab( 'naturally_btn_home_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='btn_home',$selector='.link.is-color-secondary');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_btn_home_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='btn_home_hover',$selector='.link.is-color-secondary:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();
    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        echo '<div class="section section-hero">';
            echo '<div class="container">';
                echo '<div class="section-hero_inner">';
                    echo '<div class="section-hero_heading" data-ntr-animation=\'{"name":"'.$settings['text_animation'].'"}\'>';
                        if($settings['title']){
                            echo '<h1 class="section-hero_heading_title">'.$settings['title'].'</h1>';
                        }
                        if($settings['desc']){
                            echo '<p class="section-hero_heading_text">'.$settings['desc'].'</p>';
                        }
                        if($settings['hero_title']){
                            $target = $settings['hero_link']['is_external'] ? ' target="_blank"' : '';
                            $nofollow = $settings['hero_link']['nofollow'] ? ' rel="nofollow"' : '';
                            echo '<a class="link is-color-secondary" href="'.$settings['hero_link']['url'].'"'.$target.$nofollow.'>';
                                echo '<span class="link_text">'.$settings['hero_title'].'</span>';
                                echo '<span class="link_icon icon is-next"></span>';
                            echo '</a>';
                        }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        echo '</div>';
    }
}
