<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Home_Slider_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-home-slider';
    }
    public function get_title() {
        return 'Home Slider (N)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        $this->start_controls_section( 'home_slider_section',
            [
                'label' => esc_html__( 'Slider Item', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'type',
            [
                'label' => esc_html__( 'Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__( 'Type 1', 'naturally' ),
                    '2' => esc_html__( 'Type 2', 'naturally' )
                ]
            ]
        );
        $this->add_control( 'adaptive_height',
            [
                'label' => esc_html__( 'Adaptive Height', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $def_image = plugins_url( 'assets/front/img/bg-8.jpg', __DIR__ );
        $repeater = new Repeater();
        $repeater->add_control( 'slider_image',
            [
                'label' => esc_html__( 'Image', 'naturally' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => $def_image]
            ]
        );
        $repeater->add_control( 'slider_title',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Slider Title',
                'pleaceholder' => esc_html__( 'Enter title here', 'naturally' )
            ]
        );
        $repeater->add_control( 'slider_desc',
            [
                'label' => esc_html__( 'Description', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'pleaceholder' => esc_html__( 'Enter description here', 'naturally' ),
                'default' => 'Add some text here',
            ]
        );
        $repeater->add_control( 'slider_btn_title',
            [
                'label' => esc_html__( 'Button Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Shop Now',
                'pleaceholder' => esc_html__( 'Enter button title here', 'naturally' )
            ]
        );
        $repeater->add_control( 'slider_btn_link',
            [
                'label' => esc_html__( 'Button Link', 'naturally' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'default' => [
                    'url' => '#0',
                    'is_external' => 'true'
                ],
                'placeholder' => esc_html__( 'Place URL here', 'naturally' )
            ]
        );
        $this->add_control( 'slider_items',
            [
                'label' => esc_html__( 'Slide Items', 'naturally' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{slider_title}}',
                'default' => [
                    [
                        'slider_image' => ['url' => $def_image],
                        'slider_title' => 'Healthy Foods',
                        'slider_desc' => 'Your journey to a healthier life starts here.',
                        'slider_btn_title' => 'Shop Now',
                        'slider_btn_link' => '#0'
                    ],
                    [
                        'slider_image' => ['url' => $def_image],
                        'slider_title' => 'Fresh Sale Days',
                        'slider_desc' => 'Special offers all fruit products',
                        'slider_btn_title' => 'Shop Now',
                        'slider_btn_link' => '#0'
                    ],
                    [
                        'slider_image' => ['url' => $def_image],
                        'slider_title' => 'Natural Aloe Vera',
                        'slider_desc' => 'Special offers this week',
                        'slider_btn_title' => 'Shop Now',
                        'slider_btn_link' => '#0'
                    ]
                ]
            ]
        );
        $this->add_control( 'autoplay',
            [
                'label' => esc_html__( 'Autoplay', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control( 'speed',
            [
                'label' => esc_html__( 'Speed', 'venam' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 10000,
                'step' => 100,
                'default' => 300,
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $settingsid = $this->get_id();
        $type = $settings['type'] == '2' ? '2' : '';
        $btnntype = $settings['type'] == '2' ? 'is-color-secondary' : 'is-brown';
        $count = 1;
        $height = 'yes' == $settings['adaptive_height'] ? 'true' : 'false';
        $autoplay = 'yes' == $settings['autoplay'] ? 'true' : 'false';

        echo '<div class="section section-custom-16">';
            echo '<div class="slider-hero'.$type.'">';
                echo '<div class="slick-slider" data-slider-options=\'{"height":'.$height.',"autoplay":'.$autoplay.',"speed": '.$settings['speed'].'}\'>';
                    foreach ( $settings['slider_items'] as $item ) {
                        $target = $item['slider_btn_link']['is_external'] ? ' target="_blank"' : '';
                        $nofollow = $item['slider_btn_link']['nofollow'] ? ' rel="nofollow"' : '';
                        echo '<div class="slick-slide">';
                            echo '<div class="slider-hero'.$type.'_item" data-ntr-background="'.$item['slider_image']['url'].'">';
                                echo '<div class="container">';
                                    echo '<div class="slider-hero'.$type.'_item_heading">';
                                        if($item['slider_title']){
                                            echo '<h1 class="slider-hero'.$type.'_item_title">'.$item['slider_title'].'</h1>';
                                        }
                                        if($item['slider_desc']){
                                            echo '<p class="slider-hero'.$type.'_item_summary">'.$item['slider_desc'].'</p>';
                                        }
                                        if($item['slider_btn_title']){
                                            echo '<p>';
                                                echo '<a class="link is-color-secondary" href="'.$item['slider_btn_link']['url'].'"'.$target.$nofollow.'>';
                                                    echo '<span class="link_text">'.$item['slider_btn_title'].'</span>';
                                                    echo '<span class="link_icon icon is-next"></span>';
                                                echo '</a>';
                                            echo '</p>';
                                        }
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                        $count++;
                    }
                echo '</div>';
            echo '</div>';
        echo '</div>';
    }
}
