<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Page_Hero_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-page-hero';
    }
    public function get_title() {
        return 'Page Hero (N)';
    }
    public function get_icon() {
        return 'eicon-columns';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_page_hero_settings',
            [
                'label'=> esc_html__( 'Text', 'naturally' ),
                'tab'=> Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control( 'hero_type',
            [
                'label' => esc_html__( 'Hero Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => '1',
                'options' => [
                    '1' => esc_html__( 'Big', 'naturally' ),
                    '2' => esc_html__( 'Small', 'naturally' ),
                    '3' => esc_html__( 'Mini', 'naturally' ),
                ]
            ]
        );
        $this->add_control( 'title_type',
            [
                'label' => esc_html__( 'Title Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => 'page',
                'options' => [
                    'page' => esc_html__( 'Page Title', 'naturally' ),
                    'custom' => esc_html__( 'Custom Text', 'naturally' )
                ]
            ]
        );
        $this->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => get_the_title(),
                'label_block' => true,
                'condition' => [ 'title_type' => 'custom' ],
            ]
        );
        $this->add_control( 'subtitle_type',
            [
                'label' => esc_html__( 'Subtitle Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => 'true',
                'default' => 'sitename',
                'options' => [
                    'sitename' => esc_html__( 'Site Name', 'naturally' ),
                    'custom' => esc_html__( 'Custom Text', 'naturally' )
                ]
            ]
        );
        $this->add_control( 'subtitle',
            [
                'label' => esc_html__( 'Subtitle', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.',
                'label_block' => true,
                'condition' => [ 'subtitle_type' => 'custom' ]
            ]
        );
        $this->add_control( 'image',
            [
                'label' => esc_html__( 'Bottom Image', 'naturally' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => plugins_url( 'assets/front/img/bg-6.jpg', __DIR__ )],
                'condition' => [ 'hero_type' => '1' ]
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'full',
                'condition' => [ 'image[url]!' => '' ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'herobg',
                'label' => esc_html__( 'Background Image', 'naturally' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .section-custom-13,{{WRAPPER}} .section-custom-5',
                'separator' => 'before',
            ]
        );
        $this->add_control( 'hide_bread',
            [
                'label' => esc_html__( 'Hide Breadcrumbs', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /***** Page Hero Style ******/
        /***** TITLE ******/
        $this->start_controls_section('naturally_hero_title_styling',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_title_hero_tabs');
        $this->start_controls_tab( 'naturally_title_hero_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='title_hero',$selector='.headline_title');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_title_hero_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='title_hero_hover',$selector='.headline_title:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();

        /***** DESCRIPTION ******/
        $this->start_controls_section('naturally_desc_title_styling',
            [
                'label' => esc_html__( 'Description', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_desc_hero_tabs');
        $this->start_controls_tab( 'naturally_desc_hero_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='desc_hero',$selector='.headline_summary');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_desc_hero_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='desc_hero_hover',$selector='.headline_summary:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();

        /***** BREDCRUMBS ******/
        $this->start_controls_section('naturally_bred_title_styling',
            [
                'label' => esc_html__( 'Bredcrumbs', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_bred_hero_tabs');
        $this->start_controls_tab( 'naturally_bred_hero_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->add_control( 'bred_active_color',
           [
               'label' => esc_html__( 'Active Color', 'naturally' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .breadcrumb_active' => 'color: {{VALUE}};']
           ]
       );

        $this->naturally_style_controls(array('shadow'),$id='bred_hero',$selector='.breadcrumb_link');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_bred_hero_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='bred_hero_hover',$selector='.breadcrumb_link:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();
        /***** End Page Hero Styling *****/
    }

    protected function render() {
        $settings   = $this->get_settings_for_display();
        $elementid  = $this->get_id();
        $image      = $this->get_settings( 'image' );
        $image_url  = Group_Control_Image_Size::get_attachment_image_src( $image['id'], 'thumbnail', $settings );
        $imagealt   = esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true));
        $imagealt   = $imagealt ? $imagealt : basename ( get_attached_file( $image['id'] ) );
        $imageurl   = empty( $image_url ) ? $image['url'] : $image_url;
        $hero_type  = $settings['hero_type'] == '1' ? 'section-custom-5' : 'section-custom-13';
        $hero_type  = $settings['hero_type'] == '3' ? 'text-center' : $hero_type;

        echo '<div class="section '.$hero_type.'">';
            echo '<div class="container">';
                echo '<div class="headline">';
                    if ( $settings['title_type'] == 'custom' ) {
                        if ( $settings['title'] ) {
                            echo '<h1 class="headline_title">'.$settings['title'].'</h1>';
                        }
                    } else {
                        echo '<h1 class="headline_title">'.get_the_title().'</h1>';
                    }
                    if ( $settings['subtitle_type'] == 'custom' ) {
                        if ( $settings['subtitle'] ) {
                            echo '<p class="headline_summary">'.$settings['subtitle'].'</p>';
                        }
                    } else {
                        echo '<p class="headline_summary">'.get_bloginfo('name').'</p>';
                    }
                echo '</div>';

                if ( $settings['hide_bread'] != 'yes' ) {
                    naturally_breadcrumbs();
                }
                
            echo '</div>';
            if ( $imageurl && $settings['hero_type'] == '1' ) {
                echo '<div class="mt-30">';
                    echo '<img src="'.$imageurl.'" alt="'.$imagealt.'">';
                echo '</div>';
            }
        echo '</div>';
    }
}
