<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Partners_Slider_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-partners-slider';
    }
    public function get_title() {
        return 'Partners Slider (N)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_partner_slider_settings',
            [
                'label' => esc_html__('Slider Content', 'naturally'),
            ]
        );
        $this->add_control( 'type',
            [
                'label' => esc_html__( 'Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__( 'Default', 'naturally' ),
                    '1' => esc_html__( 'With Heading', 'naturally' ),
                ]
            ]
        );
        $this->add_control( 'subtitle',
            [
                'label' => esc_html__( 'Subtitle', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Partners',
                'label_block' => true,
                'condition' => ['type' => '1']
            ]
        );
        $this->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => '<span>Naturally</span> <span>Brands</span>',
                'label_block' => true,
                'condition' => ['type' => '1']
            ]
        );
        $this->add_control( 'gallery',
            [
                'label' => esc_html__( 'Add Images', 'naturally' ),
                'type' => Controls_Manager::GALLERY,
                'default' => ['url' => plugins_url( 'assets/front/img/farmer-logo-7.jpg', __DIR__ )],
            ]
        );
        $this->add_group_control(
        Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'thumbnail',
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
    }

    protected function render() {
        $settings  = $this->get_settings_for_display();
        $elementid = $this->get_id();
        $size = $settings['thumbnail_size'] ? $settings['thumbnail_size'] : 'full';
        if ( 'custom' == $size ) {
            $sizew = $settings['thumbnail_custom_dimension']['width'];
            $sizeh = $settings['thumbnail_custom_dimension']['height'];
            $size = [ $sizew, $sizeh ];
        }
        echo '<div class="slider-logos" data-ntr-slider-logos>';
            echo '<div class="slick-slider">';
                foreach ( $settings['gallery'] as $image ) {
                    echo '<div class="slick-slide">';
                        echo '<div class="slider-logos_item">';
                        echo wp_get_attachment_image($image['id'], $size );
                        echo '</div>';
                    echo '</div>';
                }
            echo '</div>';
        echo '</div>';
    }
}
