<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Photo_Slider_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-photo-slider';
    }
    public function get_title() {
        return 'Photo Slider (N)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_partner_slider_settings',
            [
                'label' => esc_html__('Slider Content', 'naturally'),
            ]
        );
        $this->add_control( 'gallery',
            [
                'label' => esc_html__( 'Add Images', 'naturally' ),
                'type' => Controls_Manager::GALLERY
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
    }

    protected function render() {
        $settings  = $this->get_settings_for_display();
        $elementid = $this->get_id();
        echo '<div class="slider-photos" data-ntr-lightbox=\'{"type":"gallery","selector":".slider-photos_item"}\'>';
            echo '<div class="slick-slider">';
                foreach ( $settings['gallery'] as $image ) {
                    $imagealt = esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true));
                    $imagealt = $imagealt ? $imagealt : basename ( get_attached_file( $image['id'] ) );
                    echo '<div class="slick-slide">';
                        echo '<a class="slider-photos_item" href="'.$image['url'].'" title="'.$imagealt.'"><img src="'.$image['url'].'" alt="'.$imagealt.'"></a>';
                    echo '</div>';
                }
            echo '</div>';
        echo '</div>';
    }
}
