<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Product_Banner_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-product-banner';
    }
    public function get_title() {
        return 'Banner Box (N)';
    }
    public function get_icon() {
        return 'eicon-columns';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_banner_text_settings',
            [
                'label' => esc_html__( 'Text', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Up to 70% discount',
                'label_block' => true,
            ]
        );
        $this->add_control( 'btn_title',
            [
                'label' => esc_html__( 'Button Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Shop now',
                'label_block' => true,
            ]
        );
        $this->add_control( 'btn_link',
            [
                'label' => esc_html__( 'Link', 'naturally' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'default' => [
                    'url' => '#0',
                    'is_external' => ''
                ],
                'show_external' => true
            ]
        );
        $def_image = plugins_url( 'assets/front/img/banner-3.jpg', __DIR__ );
        $this->add_control( 'bg_img',
            [
                'label' => esc_html__( 'Image', 'naturally' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => $def_image],
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'full',
                'condition' => [ 'bg_img[url]!' => '' ],
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
    }

    protected function render() {
        $settings   = $this->get_settings_for_display();
        $target     = $settings['btn_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow   = $settings['btn_link']['nofollow'] ? ' rel="nofollow"' : '';
        $image      = $this->get_settings( 'bg_img' );
        $image_url  = Group_Control_Image_Size::get_attachment_image_src( $image['id'], 'thumbnail', $settings );
        $imageurl   = empty( $image_url ) ? $image['url'] : $image_url;
        $imagealt   = esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true));
        $imagealt   = $imagealt ? $imagealt : basename ( get_attached_file( $image['id'] ) );
        $blankimg = plugins_url( '/images/blank.gif', __DIR__ );
        
        $srcset1 = naturally_aq_resize( $imageurl, 400, 225, true, true, true );
        $srcset1 = $srcset1 == false ? wp_get_attachment_url( $image['id'], [400, 225] ) : $srcset1;
        $srcset2 = naturally_aq_resize( $imageurl, 800, 450, true, true, true );
        $srcset2 = $srcset2 == false ? wp_get_attachment_url( $image['id'], [800, 450] ) : $srcset2;

        echo '<div class="banner">';
            if ( $imageurl ) {
                echo '<div class="banner_photo"><img src="'.$blankimg.'" srcset="'.$srcset1.' 1x, '.$srcset2.' 2x" alt="'.$imagealt.'"></div>';

            }
            echo '<div class="banner_inner">';
                if ($settings['title']) {
                    echo '<a class="banner_title" href="'.$settings['btn_link']['url'].'"'.$target .$nofollow.'>'.$settings['title'].'</a>';
                }
                if ( $settings['btn_title'] ) {
                    echo '<a class="link is-color-secondary" href="'.$settings['btn_link']['url'].'"'.$target .$nofollow.'>';
                        echo '<span class="link_text">'.$settings['btn_title'].'</span>';
                        echo '<span class="link_icon icon is-next"></span>';
                    echo '</a>';
                }
            echo '</div>';
        echo '</div>';
    }
}
