<?php


if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;

class Naturally_Rev_Slider_Widget extends Widget_Base {

    public function get_name() {
        return 'naturally-rev-sliders';
    }
    public function get_title() {
        return 'Revolution Sliders (N)';
    }
    public function get_icon() {
        return 'eicon-carousel';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }

    // Registering Controls
    protected function register_controls() {
        $this->start_controls_section( 'naturally_rev_slider_controls_section',
            [
                'label' => esc_html__( 'Slider Data', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'naturally_rev_slider_id_control',
            [
                'label' => esc_html__( 'Select Slider', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'multiple' => false,
                'options' => $this->nt_get_rev_sliders(),
                'description' => 'Select Slider to Embed'
            ]
        );
        $this->end_controls_section();
    }

    public function nt_get_rev_sliders() {
        $options = array();
        if ( class_exists( 'RevSlider' ) ) {
            $rev_slider = new RevSlider();
            $rev_sliders = $rev_slider->getAllSliderAliases();

            if ( ! empty( $rev_sliders ) && ! is_wp_error( $rev_sliders ) ) {
                foreach ( $rev_sliders as $slider ) {
                    $options[ $slider ] = $slider;
                }
            }
        } else {
            $options = esc_html__('No sliders exist.', 'naturally');
        }
        return $options;
    }

    protected function render() {
        $settings  = $this->get_settings_for_display();
        if (!empty($settings['naturally_rev_slider_id_control'])){
            echo do_shortcode(sprintf('[rev_slider alias="%s"]', $settings['naturally_rev_slider_id_control']));
        } else {
            echo esc_html__('No sliders exist. You must create one first.', 'naturally');
        }
    }
}
