<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Social_Icons_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-social-icons';
    }
    public function get_title() {
        return 'Social Icons (N)';
    }
    public function get_icon() {
        return 'eicon-icon-box';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'social_profiles',
            [
                'label' => esc_html__( 'Social Profiles', 'naturally' )
            ]
        );
        $this->add_control( 'icon_type',
            [
                'label' => esc_html__( 'Icon Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'font',
                'options' => [
                    'theme' => esc_html__( 'Theme Icon', 'naturally' ),
                    'font' => esc_html__( 'From Library', 'naturally' ),
                ],
            ]
        );
        $this->add_responsive_control( 'alignment',
            [
                'label' => esc_html__( 'Alignment', 'naturally' ),
                'type' => Controls_Manager::CHOOSE,
                'selectors' => ['{{WRAPPER}} .social-icons' => 'justify-content: {{VALUE}};'],
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__( 'Left', 'naturally' ),
                        'icon' => 'fa fa-align-left'
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'naturally' ),
                        'icon' => 'fa fa-align-center'
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'Right', 'naturally' ),
                        'icon' => 'fa fa-align-right'
                    ]
                ],
                'toggle' => true,
                'default' => 'flex-start'
            ]
        );
        $this->add_control( 'social_icons1',
            [
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [
                        'icon1' => 'is-facebook'
                    ],
                    [
                        'icon1' => 'is-twitter'
                    ],
                    [
                        'icon1' => 'is-instagram'
                    ],
                    [
                        'icon1' => 'is-youtube'
                    ]
                ],
                'fields' => [
                    [
                        'name' => 'icon1',
                        'label' => esc_html__( 'Icon', 'naturally' ),
                        'type' => Controls_Manager::SELECT2,
                        'default' => 'facebook',
                        'multiple' => false,
                        'options' => $this->naturally_theme_icon_list(),
                    ],
                    [
                        'name' => 'link1',
                        'label' => esc_html__( 'Link', 'naturally' ),
                        'type' => Controls_Manager::URL,
                        'label_block' => true,
                        'default' => [
                            'url' => '#',
                            'is_external' => 'true',
                        ],
                        'placeholder' => esc_html__( 'Place URL here', 'naturally' )
                    ]
                ],
                'title_field' => 'Social Media #',
                'condition' => ['icon_type' => 'theme']
            ]
        );
        $this->add_control( 'social_icons',
            [
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [
                        'social' => [
                            'value' => 'fab fa-facebook',
                            'library' => 'fa-brands'
                        ]
                    ],
                    [
                        'social' => [
                            'value' => 'fab fa-twitter',
                            'library' => 'fa-brands'
                        ]
                    ],
                    [
                        'social' => [
                            'value' => 'fab fa-instagram',
                            'library' => 'fa-brands'
                        ]
                    ]
                ],
                'fields' => [
                    [
                        'name' => 'social',
                        'label' => esc_html__( 'Icon', 'naturally' ),
                        'type' => Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fab fa-wordpress',
                            'library' => 'fa-brands'
                        ],
                        'condition' => ['icon_type' => 'font']
                    ],
                    [
                        'name' => 'link',
                        'label' => esc_html__( 'Link', 'naturally' ),
                        'type' => Controls_Manager::URL,
                        'label_block' => true,
                        'default' => [
                            'url' => '#',
                            'is_external' => 'true',
                        ],
                        'placeholder' => esc_html__( 'Place URL here', 'naturally' )
                    ]
                ],
                'title_field' => 'Social Media #',
                'condition' => ['icon_type' => 'font']
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section( 'social_icons_style_controls_section',
            [
                'label'        => esc_html__( 'Mobile Toggle Bar', 'naturally' ),
                'tab'          => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_responsive_control( 'social_icons_size',
            [
                'label'         => esc_html__( 'Size', 'naturally' ),
                'type'          => Controls_Manager::SLIDER,
                'range'         => [ 'px'   => [ 'max' => 500 ] ],
                'selectors'     => [
                    '{{WRAPPER}} .social-icons .social-icons_link' => 'width: {{SIZE}}px;',
                    '{{WRAPPER}} .social-icons.naturally-icons .social-icons_link' => 'height: {{SIZE}}px;'
                ]
            ]
        );

        $this->start_controls_tabs('social_icons_normal_tabs');
        $this->start_controls_tab( 'social_icons_normal_tab',
            [ 'label'           => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->add_responsive_control( 'social_icons_normal_fontsz',
            [
                'label'         => esc_html__( 'Font-size', 'naturally' ),
                'type'          => Controls_Manager::SLIDER,
                'range'         => [ 'px'   => [ 'max' => 100 ] ],
                'selectors'     => [ '{{WRAPPER}} .social-icons .social-icons_link' => 'font-size: {{SIZE}}px;' ],
            ]
        );
        $this->add_control( 'social_icons_color',
            [
                'label'         => esc_html__( 'Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .social-icons .social-icons_link' => 'color: {{VALUE}};'],
                'separator'     => 'before'
            ]
        );
        $this->add_control( 'social_icons_bgcolor',
            [
                'label'         => esc_html__( 'Background', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .social-icons .social-icons_link' => 'background-color: {{VALUE}};'],
                'separator'     => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'          => 'social_icons_border',
                'label'         => esc_html__( 'Border', 'naturally' ),
                'selector'      => '{{WRAPPER}} .social-icons .social-icons_link',
                'separator'     => 'before'
            ]
        );
        $this->add_responsive_control( 'social_icons_border_radius',
            [
                'label'         => esc_html__( 'Border Radius', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px' ],
                'selectors'     => ['{{WRAPPER}} .social-icons .social-icons_link' => 'border-top-left-radius: {{TOP}}{{UNIT}};border-top-right-radius: {{RIGHT}}{{UNIT}};border-bottom-left-radius: {{BOTTOM}}{{UNIT}};border-bottom-right-radius: {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ]
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab('social_icons_hover_tab',
            [ 'label'           => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->add_responsive_control( 'social_icons_hover_fontsz',
            [
                'label'         => esc_html__( 'Font-size', 'naturally' ),
                'type'          => Controls_Manager::SLIDER,
                'range'         => [ 'px'   => [ 'max' => 100 ] ],
                'selectors'     => [ '{{WRAPPER}} .social-icons .social-icons_link:hover' => 'font-size: {{SIZE}}px;' ],
            ]
        );
        $this->add_control( 'social_icons_hover_color',
            [
                'label'         => esc_html__( 'Color', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .social-icons .social-icons_link:hover' => 'color: {{VALUE}};'],
                'separator'     => 'before'
            ]
        );
        $this->add_control( 'social_icons_hover_bgcolor',
            [
                'label'         => esc_html__( 'Background', 'naturally' ),
                'type'          => Controls_Manager::COLOR,
                'default'       => '',
                'selectors'     => ['{{WRAPPER}} .social-icons .social-icons_link:hover' => 'background-color: {{VALUE}};'],
                'separator'     => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'          => 'social_icons_hover_border',
                'label'         => esc_html__( 'Border', 'naturally' ),
                'selector'      => '{{WRAPPER}} .social-icons .social-icons_link:hover',
                'separator'     => 'before'
            ]
        );
        $this->add_responsive_control( 'social_icons_hover_border_radius',
            [
                'label'         => esc_html__( 'Border Radius', 'naturally' ),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => [ 'px' ],
                'selectors'     => ['{{WRAPPER}} .social-icons .social-icons_link:hover' => 'border-top-left-radius: {{TOP}}{{UNIT}};border-top-right-radius: {{RIGHT}}{{UNIT}};border-bottom-left-radius: {{BOTTOM}}{{UNIT}};border-bottom-right-radius: {{LEFT}}{{UNIT}};'],
                'default'       => [
                    'top'          => '',
                    'right'        => '',
                    'bottom'       => '',
                    'left'         => '',
                ]
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
    }
    protected function render() {
        $settings   = $this->get_settings_for_display();
        $elementid  = $this->get_id();
        echo '<div class="social-icons naturally-icons">';
        if ( $settings['icon_type'] == 'theme' ) {
            foreach ( $settings['social_icons1'] as $item ) {
                $target = $item['link1']['is_external'] ? ' target="_blank"' : '';
                echo '<a class="social-icons_link" href="'.esc_attr( $item['link1']['url'] ).'"'.$target.'>';
                    echo '<span class="icon '.$item['icon1'].'"></span>';
                echo '</a>';
            }
        } else {
            foreach ( $settings['social_icons'] as $item ) {
                $target = $item['link']['is_external'] ? ' target="_blank"' : '';
                echo '<a class="social-icons_link" href="'.esc_attr( $item['link']['url'] ).'"'.$target.'>';
                    if ( ! empty($item['social']['value']) ) {
                        Icons_Manager::render_icon( $item['social'], [ 'aria-hidden' => 'true' ] );
                    }
                echo '</a>';
            }
        }
        echo '</div>';
    }
}
