<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Split_Slider_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-split-slider';
    }
    public function get_title() {
        return 'Split Slider (N)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('naturally_split_slider_general_settings',
            [
                'label' => esc_html__( 'Genaral', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'hidetesti',
            [
                'label' => esc_html__( 'Hide Testimonials', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'hideblog',
            [
                'label' => esc_html__( 'Hide Blog Posts', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'testititle',
            [
                'label' => esc_html__( 'Section Testimonials Title', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Testimonials',
                'label_block' => true,
                'condition' => ['hidetesti!' => 'yes']
            ]
        );
        $this->add_control( 'blogtitle',
            [
                'label' => esc_html__( 'Section Blog Title', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Recent Posts',
                'label_block' => true,
                'condition' => ['hideblog!' => 'yes']
            ]
        );
        $this->add_control( 'autoplay',
            [
                'label' => esc_html__( 'Autoplay', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control( 'speed',
            [
                'label' => esc_html__( 'Speed', 'venam' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 10000,
                'step' => 100,
                'default' => 300,
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_split_slider_testimonials_settings',
            [
                'label' => esc_html__('Testimonials Items', 'naturally'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => ['hidetesti!' => 'yes']
            ]
        );
        $repeater = new Repeater();
        $repeater->add_control( 'testi_name',
            [
                'label' => esc_html__( 'Name', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Sam Peters',
                'label_block' => true
            ]
        );
        $repeater->add_control( 'testi_pos',
            [
                'label' => esc_html__( 'Position', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'CEO Solar Systems LLC',
                'label_block' => true
            ]
        );
        $repeater->add_control( 'testi_text',
            [
                'label' => esc_html__( 'Quote', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => '',
                'label_block' => true
            ]
        );
        $this->add_control( 'testi_items',
            [
                'label' => esc_html__( 'Items', 'naturally' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{testi_name}}',
                'default' => [
                    [
                        'testi_name' => 'Tiana Mcdonnell',
                        'testi_pos' => 'Sales Manager',
                        'testi_text' => 'Lorem ipsum dolor sit amet, consectetur elit. Maecenas dictum a dolor vitae varius. Cras at efficitur nisl, at varius leo. Vestibulum vel adipiscing orci justo.',
                    ],
                    [
                        'testi_name' => 'Terry Figueroa',
                        'testi_pos' => 'Marketing Manager',
                        'testi_text' => 'Lorem ipsum dolor sit amet, consectetur elit. Maecenas dictum a dolor vitae varius. Cras at efficitur nisl, at varius leo. Vestibulum vel adipiscing orci justo.',
                    ],
                    [
                        'testi_name' => 'Kaycee Hess',
                        'testi_pos' => 'Human Resources',
                        'testi_text' => 'Lorem ipsum dolor sit amet, consectetur elit. Maecenas dictum a dolor vitae varius. Cras at efficitur nisl, at varius leo. Vestibulum vel adipiscing orci justo.'
                    ]
                ]
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_split_slider_post_query',
            [
                'label' => esc_html__( 'Query', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => ['hideblog!' => 'yes'],
            ]
        );
        $this->add_control( 'author_filter_heading',
            [
                'label' => esc_html__( 'Author Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        $this->add_control( 'author_filter',
            [
                'label' => esc_html__( 'Author', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_get_users(),
                'description' => 'Select Author(s)'
            ]
        );
        $this->add_control( 'author_exclude_filter',
            [
                'label' => esc_html__( 'Exclude Author', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_get_users(),
                'description' => 'Select Author(s) to Exclude',
                'separator' => 'after'
            ]
        );
        $this->add_control( 'category_filter_heading',
            [
                'label' => esc_html__( 'Category Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        $this->add_control( 'category_filter',
            [
                'label' => esc_html__( 'Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_get_categories(),
                'description' => 'Select Category(s)'
            ]
        );
        $this->add_control( 'category_exclude_filter',
            [
                'label' => esc_html__( 'Exclude Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_get_categories(),
                'description' => 'Select Category(s) to Exclude',
                'separator' => 'after'
            ]
        );
        $this->add_control( 'tag_filter_heading',
            [
                'label' => esc_html__( 'Tag Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        $this->add_control( 'tag_filter',
            [
                'label' => esc_html__( 'Tag', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_get_tags(),
                'description' => 'Select Tag(s)'
            ]
        );
        $this->add_control( 'tag_exclude_filter',
            [
                'label' => esc_html__( 'Exclude Tag', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_get_tags(),
                'description' => 'Select Tag(s) to Exclude',
                'separator' => 'after'
            ]
        );
        $this->add_control( 'post_filter_heading',
            [
                'label' => esc_html__( 'Post Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        $this->add_control( 'post_filter',
            [
                'label' => esc_html__( 'Specific Post(s)', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_get_posts(),
                'description' => 'Select Specific Post(s)'
            ]
        );
        $this->add_control( 'post_exclude_filter',
            [
                'label' => esc_html__( 'Exclude Post', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_get_posts(),
                'description' => 'Select Post(s) to Exclude',
                'separator' => 'after'
            ]
        );
        $this->add_control( 'post_other_heading',
            [
                'label' => esc_html__( 'Other Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING
            ]
        );
        $this->add_control('post_per_page',
            [
                'label' => esc_html__( 'Posts Per Page', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 1000,
                'default' => 2
            ]
        );
        $this->add_control('offset',
            [
                'label' => esc_html__( 'Offset', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1000
            ]
        );
        $this->add_control( 'order',
            [
                'label' => esc_html__( 'Select Order', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => 'Ascending',
                    'DESC' => 'Descending'
                ],
                'default' => 'ASC'
            ]
        );
        $this->add_control( 'orderby',
            [
                'label' => esc_html__( 'Order By', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'none' => 'None',
                    'ID' => 'Post ID',
                    'author' => 'Author',
                    'title' => 'Title',
                    'name' => 'Slug',
                    'date' => 'Date',
                    'modified' => 'Last Modified Date',
                    'parent' => 'Post Parent ID',
                    'rand' => 'Random',
                    'comment_count' => 'Number of Comments',
                ],
                'default' => 'none'
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_post_options',
            [
                'label' => esc_html__( 'Post Options', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => ['hideblog!' => 'yes'],
            ]
        );
        $this->add_control( 'hidetitle',
            [
                'label' => esc_html__( 'Hide Title', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'hideauthor',
            [
                'label' => esc_html__( 'Hide Author', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'hidedate',
            [
                'label' => esc_html__( 'Hide Date', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'hideexcerpt',
            [
                'label' => esc_html__( 'Hide Excerpt', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'naturally' ),
                'label_off' => esc_html__( 'No', 'naturally' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );
        $this->add_control( 'excerpt_limit',
            [
                'label' => esc_html__( 'Excerpt Word Limit', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'default' => 20
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_testimonial_section_styles',
            [
                'label' => esc_html__( 'General Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['hidetesti!' => 'yes'],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'section_border',
                'label' => esc_html__( 'Border', 'naturally' ),
                'selector' => '{{WRAPPER}} .section-split',
                'separator' => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'section_split_border',
                'label' => esc_html__( 'Split Border', 'naturally' ),
                'selector' => '{{WRAPPER}} .section-split .grid_col:first-child:not(:last-child)',
                'separator' => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'section_background',
                'label' => esc_html__( 'Background', 'naturally' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .section-split',
                'separator' => 'before'
            ]
        );
        $this->add_responsive_control( 'section_padding',
            [
                'label' => esc_html__( 'Padding', 'naturally' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} .section-split .grid_col' => 'padding-top: {{TOP}}{{UNIT}};padding-right: {{RIGHT}}{{UNIT}};padding-bottom: {{BOTTOM}}{{UNIT}};padding-left: {{LEFT}}{{UNIT}};'],
                'default' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                ],
                'separator' => 'before'
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_testimonial_styles',
            [
                'label' => esc_html__( 'Testimonials Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['hidetesti!' => 'yes'],
            ]
        );
        $this->add_responsive_control( 'testi_alignment',
            [
                'label' => esc_html__( 'Alignment', 'naturally' ),
                'type' => Controls_Manager::CHOOSE,
                'selectors' => ['{{WRAPPER}} .slider-testimonials3' => 'text-align: {{VALUE}};'],
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'naturally' ),
                        'icon' => 'fa fa-align-left'
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'naturally' ),
                        'icon' => 'fa fa-align-center'
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'naturally' ),
                        'icon' => 'fa fa-align-right'
                    ]
                ],
                'toggle' => true,
                'default' => 'left'
            ]
        );
        $this->add_control( 'testi_heading',
            [
                'label' => esc_html__( 'HEADING', 'naturally' ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'testi_heading_typo',
                'label' => esc_html__( 'Typography', 'naturally' ),
                'selector' => '{{WRAPPER}} .slider-testimonials3_title'
            ]
        );
        $this->add_control( 'testi_heading_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .slider-testimonials3_title' => 'color: {{VALUE}};'],
            ]
        );
        $this->add_control( 'testi_quote_heading',
            [
                'label' => esc_html__( 'QUOTE', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'testi_quote_typo',
                'label' => esc_html__( 'Typography', 'naturally' ),
                'selector' => '{{WRAPPER}} .slider-testimonials3_item_text'
            ]
        );
        $this->add_control( 'testi_quote_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .slider-testimonials3_item_text' => 'color: {{VALUE}};'],
            ]
        );
        $this->add_control( 'testi_author_heading',
            [
                'label' => esc_html__( 'AUTHOR', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'testi_author_typo',
                'label' => esc_html__( 'Typography', 'naturally' ),
                'selector' => '{{WRAPPER}} .slider-testimonials3_item_by'
            ]
        );
        $this->add_control( 'testi_author_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .slider-testimonials3_item_by' => 'color: {{VALUE}};'],
            ]
        );
        $this->add_control( 'testi_position_heading',
            [
                'label' => esc_html__( 'POSITION', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'testi_position_typo',
                'label' => esc_html__( 'Typography', 'naturally' ),
                'selector' => '{{WRAPPER}} .slider-testimonials3_item_meta'
            ]
        );
        $this->add_control( 'testi_position_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .slider-testimonials3_item_meta' => 'color: {{VALUE}};'],
            ]
        );
        $this->add_control( 'testi_dots_heading',
            [
                'label' => esc_html__( 'DOTS', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control( 'testi_dots_size',
            [
                'label' => esc_html__( 'Size', 'naturally' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 60
                    ]
                ],
                'selectors' => [ '{{WRAPPER}} .slider-testimonials3 .slick-dots li button' => 'width: {{SIZE}}px;height: {{SIZE}}px;']
            ]
        );
        $this->start_controls_tabs('testi_dots_tabs');
        $this->start_controls_tab( 'testi_dots_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->add_control( 'testi_dots_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .slider-testimonials3 .slick-dots li button' => 'background-color: {{VALUE}};'],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab('testi_dots_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->add_control( 'testi_dots_hvrcolor',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .slider-testimonials3 .slick-dots li.slick-active button, {{WRAPPER}} .slider-testimonials3 .slick-dots li button:hover' => 'background-color: {{VALUE}};'],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_split_blog_styles',
            [
                'label' => esc_html__( 'Posts Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['hideblog!' => 'yes'],
            ]
        );
        $this->add_responsive_control( 'blog_alignment',
            [
                'label' => esc_html__( 'Alignment', 'naturally' ),
                'type' => Controls_Manager::CHOOSE,
                'selectors' => ['{{WRAPPER}} .slider-blog2' => 'text-align: {{VALUE}};'],
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'naturally' ),
                        'icon' => 'fa fa-align-left'
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'naturally' ),
                        'icon' => 'fa fa-align-center'
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'naturally' ),
                        'icon' => 'fa fa-align-right'
                    ]
                ],
                'toggle' => true,
                'default' => 'left'
            ]
        );
        $this->add_control( 'blog_heading',
            [
                'label' => esc_html__( 'HEADING', 'naturally' ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'blog_heading_typo',
                'label' => esc_html__( 'Typography', 'naturally' ),
                'selector' => '{{WRAPPER}} .slider-blog2_title'
            ]
        );
        $this->add_control( 'blog_heading_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .slider-blog2_title' => 'color: {{VALUE}};'],
            ]
        );
        $this->add_control( 'blog_excerpt_heading',
            [
                'label' => esc_html__( 'EXCERPT', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'blog_excerpt_typo',
                'label' => esc_html__( 'Typography', 'naturally' ),
                'selector' => '{{WRAPPER}} .slider-blog2_item_text'
            ]
        );
        $this->add_control( 'blog_excerpt_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .slider-blog2_item_text' => 'color: {{VALUE}};'],
            ]
        );
        $this->add_control( 'blog_author_heading',
            [
                'label' => esc_html__( 'AUTHOR', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'blog_author_typo',
                'label' => esc_html__( 'Typography', 'naturally' ),
                'selector' => '{{WRAPPER}} .slider-blog2_item_by a'
            ]
        );
        $this->add_control( 'blog_author_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .slider-blog2_item_by a' => 'color: {{VALUE}};'],
            ]
        );
        $this->add_control( 'blog_date_heading',
            [
                'label' => esc_html__( 'DATE', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'blog_date_typo',
                'label' => esc_html__( 'Typography', 'naturally' ),
                'selector' => '{{WRAPPER}} .slider-blog2_item_meta'
            ]
        );
        $this->add_control( 'blog_date_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .slider-blog2_item_meta' => 'color: {{VALUE}};'],
            ]
        );
        $this->add_control( 'blog_dots_heading',
            [
                'label' => esc_html__( 'DOTS', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control( 'blog_dots_size',
            [
                'label' => esc_html__( 'Size', 'naturally' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 60
                    ]
                ],
                'selectors' => [ '{{WRAPPER}} .slider-blog2 .slick-dots li button' => 'width: {{SIZE}}px;height: {{SIZE}}px;']
            ]
        );
        $this->start_controls_tabs('blog_dots_tabs');
        $this->start_controls_tab( 'blog_dots_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->add_control( 'blog_dots_color',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .slider-blog2 .slick-dots li button' => 'background-color: {{VALUE}};'],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab('blog_dots_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->add_control( 'blog_dots_hvrcolor',
            [
                'label' => esc_html__( 'Color', 'naturally' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .slider-blog2 .slick-dots li.slick-active button, {{WRAPPER}} .slider-blog2 .slick-dots li button:hover' => 'background-color: {{VALUE}};'],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $args = array(
            'post_type'        => 'post',
            'author__in'       => $settings['author_filter'],
            'author__not_in'   => $settings['author_exclude_filter'],
            'category__in'     => $settings['category_filter'],
            'category__not_in' => $settings['category_exclude_filter'],
            'tag__in'          => $settings['tag_filter'],
            'tag__not_in'      => $settings['tag_exclude_filter'],
            'post__in'         => $settings['post_filter'],
            'post__not_in'     => $settings['post_exclude_filter'],
            'posts_per_page'   => $settings['post_per_page'],
            'offset'           => $settings['offset'],
            'order'            => $settings['order'],
            'orderby'          => $settings['orderby']
        );
        $autoplay = 'yes' == $settings['autoplay'] ? 'true' : 'false';
        echo '<div class="section-split">';
            echo '<div class="container">';
                echo '<div class="grid">';
                    echo '<div class="grid_row">';

                        if ( 'yes' != $settings['hidetesti'] ) {
                            $columntesti = 'yes' == $settings['hideblog'] ? 12 : 6;
                            echo '<div class="grid_col is-12 is-xl-'.$columntesti.'">';
                                echo '<div class="slider-testimonials3" data-ntr-slider-testimonials3>';
                                    if( $settings['testititle'] ) {
                                        echo '<h3 class="slider-testimonials3_title">'.$settings['testititle'].'</h3>';
                                    }
                                    echo '<div class="slick-slider" data-slider-options=\'{"autoplay":'.$autoplay.',"speed": '.$settings['speed'].'}\'>';
                                        foreach ($settings['testi_items'] as $item) {
                                            echo '<div class="slick-slide">';
                                                echo '<div class="slider-testimonials3_item">';
                                                    if ( $item['testi_text'] ) {
                                                        echo '<div class="slider-testimonials3_item_text">'.$item['testi_text'].'</div>';
                                                    }
                                                    if ( $item['testi_name'] ) {
                                                        echo '<div class="slider-testimonials3_item_by">'.$item['testi_name'].'</div>';
                                                    }
                                                    if ( $item['testi_pos'] ) {
                                                        echo '<div class="slider-testimonials3_item_meta">'.$item['testi_pos'].'</div>';
                                                    }
                                                echo '</div>';
                                            echo '</div>';
                                        }
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        }
                        if ( 'yes' != $settings['hideblog'] ) {
                            $columnblog = 'yes' == $settings['hidetesti'] ? 12 : 6;
                            echo '<div class="grid_col is-12 is-xl-'.$columnblog.'">';
                                echo '<div class="slider-blog2" data-ntr-slider-blog2>';
                                    if( $settings['blogtitle'] ) {
                                        echo '<h3 class="slider-blog2_title">'.$settings['blogtitle'].'</h3>';
                                    }
                                    echo '<div class="slick-slider" data-slider-options=\'{"autoplay":'.$autoplay.',"speed": '.$settings['speed'].'}\'>';
                                        $the_query = new \WP_Query( $args );
                                        if( $the_query->have_posts() ) {
                                            while ($the_query->have_posts()) {
                                                $the_query->the_post();
                                                echo '<div class="slick-slide">';
                                                    echo '<div class="slider-blog2_item">';
                                                        if ( has_excerpt() && 'yes' != $settings['hideexcerpt'] ) {
                                                            echo '<div class="slider-blog2_item_text">'.wp_trim_words( get_the_excerpt(), $settings['excerpt_limit'] ).'</div>';
                                                        }
                                                        if ( 'yes' != $settings['hideauthor'] ) {
                                                            echo '<div class="slider-blog2_item_by"><a href="'.get_post_permalink().'">'.get_the_author().'</a></div>';
                                                        }
                                                        if ( 'yes' != $settings['hidedate'] ) {
                                                            echo '<div class="slider-blog2_item_meta">'.get_the_date().'</div>';
                                                        }
                                                    echo '</div>';
                                                echo '</div>';
                                            }
                                        }
                                        wp_reset_postdata();
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        echo '</div>';
    }
}
