<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Tabs_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-tabs';
    }
    public function get_title() {
        return 'Tabs (N)';
    }
    public function get_icon() {
        return 'eicon-tabs';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_tabs_settings',
            [
                'label' => esc_html__( 'Content', 'naturally'),
            ]
        );
        $this->add_control( 'tabs',
            [
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [
                        'content_type' => 'content',
                        'tab_title' => 'Tab 1',
                        'tab_content' => '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam et lacus libero. </p>'
                    ],
                    [
                        'content_type' => 'content',
                        'tab_title' => 'Tab 2',
                        'tab_content' => '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam et lacus libero. </p>'
                    ],
                    [
                        'content_type' => 'content',
                        'tab_title' => 'Tab 3',
                        'tab_content' => '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam et lacus libero. </p>'
                    ]
                ],
                'fields' => [
                    [
                        'name' => 'tab_title',
                        'label' => esc_html__('Tab Title', 'naturally'),
                        'type' => Controls_Manager::TEXT,
                        'default' => esc_html__('Tab Title', 'naturally'),
                        'label_block' => true
                    ],
                    [
                        'name' => 'content_type',
                        'label' => esc_html__('Content Type', 'naturally'),
                        'type' => Controls_Manager::SELECT,
                        'options' => [
                            'content' => esc_html__('Content', 'naturally'),
                            'template' => esc_html__('Saved Templates', 'naturally'),
                        ],
                        'default' => 'content'
                    ],
                    [
                        'name' => 'primary_templates',
                        'label' => esc_html__('Choose Template', 'naturally'),
                        'type' => Controls_Manager::SELECT2,
                        'options' => $this->naturally_get_elementor_templates(),
                        'condition' => [ 'content_type' => 'template' ]
                    ],
                    [
                        'name' => 'tab_content',
                        'label' => esc_html__('Tab Content', 'naturally'),
                        'type' => Controls_Manager::WYSIWYG,
                        'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam et lacus libero. Nunc tincidunt leo a mauris volutpat lobortis. Phasellus tristique libero et maximus imperdiet.', 'naturally'),
                        'dynamic' => ['active' => true],
                        'condition' => [ 'content_type' => 'content' ]
                    ],
                ],
                'title_field' => '{{tab_title}}'
            ]
        );
        $this->add_responsive_control( 'alignment',
            [
                'label' => esc_html__( 'Tab Alignment', 'naturally' ),
                'type' => Controls_Manager::CHOOSE,
                'selectors' => ['{{WRAPPER}} .tab_nav' => 'justify-content: {{VALUE}};'],
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__( 'Left', 'naturally' ),
                        'icon' => 'fa fa-align-left'
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'naturally' ),
                        'icon' => 'fa fa-align-center'
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'Right', 'naturally' ),
                        'icon' => 'fa fa-align-right'
                    ]
                ],
                'toggle' => true,
                'default' => ''
            ]
        );
        $this->add_responsive_control( 'content_alignment',
            [
                'label' => esc_html__( 'Tab Content Alignment', 'naturally' ),
                'type' => Controls_Manager::CHOOSE,
                'selectors' => ['{{WRAPPER}} .tab_page' => 'text-align: {{VALUE}};'],
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'naturally' ),
                        'icon' => 'fa fa-align-left'
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'naturally' ),
                        'icon' => 'fa fa-align-center'
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'naturally' ),
                        'icon' => 'fa fa-align-right'
                    ]
                ],
                'toggle' => true,
                'default' => ''
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings  = $this->get_settings_for_display();
        $elementid = $this->get_id();

        echo '<div class="tab" data-ntr-tab>';
            $count = 1;
            echo '<div class="tab_nav">';
                foreach ($settings['tabs'] as $tab) {
                    $is_active = 1 == $count ? ' is-active' : '';
                    if ( $tab['tab_title'] ) {
                    	echo '<a class="tab_nav_item'.$is_active.'" href="#" data-id="'.$count.'">'.$tab['tab_title'].'</a>';
                    } else {
                    	echo '<a class="tab_nav_item'.$is_active.'" href="#" data-id="'.$count.'">'.esc_html__('Add Title','naturally').'</a>';
                    }
                    $count++;
                }
            echo '</div>';
            
            $counttwo = 1;
            foreach ($settings['tabs'] as $tab) {
                $is_active = 1 == $counttwo ? ' is-active' : '';
                if ( $tab['tab_content'] || !empty($tab['primary_templates']) ) {
                	echo '<div class="tab_page'.$is_active.'" data-id="'.$counttwo.'">';
                        if ('template' == $tab['content_type']) {
                            if (!empty($tab['primary_templates'])) {
                                $template_id = $tab['primary_templates'];
                                $naturally_frontend = new Frontend;
                                echo $naturally_frontend->get_builder_content($template_id, true);
                            } else {
                            
                                echo do_shortcode($tab['tab_content']);
                            }

                        } else {
                            
                            echo do_shortcode($tab['tab_content']);
                        }
                	echo '</div>';
                } else {
                	echo '<div class="tab_page'.$is_active.'" data-id="'.$counttwo.'">';
                		echo esc_html__('Add Some Content Here','naturally');
                	echo '</div>';
                }

                $counttwo++;
            }
        echo '</div>';
    }
}
