<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Team_Member_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-team-member';
    }
    public function get_title() {
        return 'Team Member (N)';
    }
    public function get_icon() {
        return 'eicon-person';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_team_member_section',
            [
                'label' => esc_html__( 'Team Content', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'team_name',
            [
                'label' => esc_html__( 'Name', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'pleaceholder' => esc_html__( 'Enter name here', 'naturally' ),
                'default' => 'Terry Figueroa',
                'label_block' => true,
            ]
        );
        $this->add_control( 'team_pos',
            [
                'label' => esc_html__( 'Position', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'pleaceholder' => esc_html__( 'Enter position here', 'naturally' ),
                'default' => 'Marketing Manager',
                'label_block' => true,
            ]
        );
        $this->add_control( 'team_url',
            [
                'label' => esc_html__( 'Team member custom Link', 'naturally' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'default' => [
                    'url' => '#0',
                    'is_external' => ''
                ],
                'show_external' => true,
                'condition' => ['btn_action' => 'link']
            ]
        );
        $this->add_control( 'team_image',
            [
                'label' => esc_html__( 'Avatar Image', 'naturally' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => plugins_url( 'assets/front/img/team-member-1.jpg', __DIR__ )],
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'full',
                'condition' => [ 'team_image[url]!' => '' ],
            ]
        );
        
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
    }
    protected function render() {
        $settings   = $this->get_settings_for_display();
        $elementid  = $this->get_id();
        $image      = $this->get_settings( 'team_image' );
        $image_url  = Group_Control_Image_Size::get_attachment_image_src( $image['id'], 'thumbnail', $settings );
        $imagealt   = esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true));
        $imagealt   = $imagealt ? $imagealt : basename ( get_attached_file( $image['id'] ) );
        $imageurl   = empty( $image_url ) ? $image['url'] : $image_url;
        $teamurl    =  $settings['team_url'];
        $teamurl    = ! empty( $teamurl )  ? 'href="' . $team_url . '' : '';    

        if ( $imageurl ) {
            echo '<a class="team-member hover-up" '.$teamurl.'>';
                echo '<img class="team-member_photo" src="'.$imageurl.'" alt="'.$imagealt.'"/>';
                echo '<span class="team-member_info">';
                    if ( $settings['team_name'] ) {
                        echo '<span class="team-member_name">'.$settings['team_name'].'</span>';
                    }
                    if ( $settings['team_pos'] ) {
                        echo '<span class="team-member_title">'.$settings['team_pos'].'</span>';
                    }
                echo '</span>';
            echo '</a>';
        }
    }
}
