<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Testimonials_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-testimonials';
    }
    public function get_title() {
        return 'Testimonials (N)';
    }
    public function get_icon() {
        return 'eicon-testimonial';
    }
    public function get_categories() {
        return [ 'naturally' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_testimonials_one_text_settings',
            [
                'label' => esc_html__('General', 'naturally'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control( 'type',
            [
                'label' => esc_html__( 'Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__( 'Type 1', 'naturally' ),
                    '2' => esc_html__( 'Type 2', 'naturally' ),
                ]
            ]
        );
        $this->add_control( 'title',
            [
                'label' => esc_html__( 'Section Title', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Testimonials',
                'label_block' => true,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'bg_img',
                'label' => esc_html__( 'Background Image', 'naturally' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .section-custom-3,{{WRAPPER}} .section-custom-4',
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'naturally_testimonials_one_items_settings',
            [
                'label' => esc_html__('Testimonials Items', 'naturally'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new Repeater();
        $repeater->add_control( 'testi_name',
            [
                'label' => esc_html__( 'Name', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Sam Peters',
                'label_block' => true,
            ]
        );
        $repeater->add_control( 'testi_pos',
            [
                'label' => esc_html__( 'Position', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'CEO Solar Systems LLC',
                'label_block' => true,
            ]
        );
        $repeater->add_control( 'testi_text',
            [
                'label' => esc_html__( 'Quote', 'naturally' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => '',
                'label_block' => true,
            ]
        );
        $def_img = plugins_url( 'assets/front/img/avatar-2.jpg', __DIR__ );
        $repeater->add_control( 'testi_image',
            [
                'label' => esc_html__( 'Avatar', 'naturally' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => $def_img],
            ]
        );
        $this->add_control( 'testi_items',
            [
                'label' => esc_html__( 'Items', 'naturally' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{testi_name}}',
                'default' => [
                    [
                        'testi_name' => 'Tiana Mcdonnell',
                        'testi_pos' => 'Sales Manager',
                        'testi_text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vel purus fringilla, lobortis libero ut, interdum lacus. Ut quis urna sollicitudin, iaculis dolor sed, sodales mi. Proin a velit convallis, fermentum orci in, rutrum diam. Duis elementum odio a pharetra commodo. Sed eget massa sit amet nunc egestas tristique.'
                    ],
                    [
                        'testi_name' => 'Terry Figueroa',
                        'testi_pos' => 'Marketing Manager',
                        'testi_text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vel purus fringilla, lobortis libero ut, interdum lacus. Ut quis urna sollicitudin, iaculis dolor sed, sodales mi. Proin a velit convallis, fermentum orci in, rutrum diam. Duis elementum odio a pharetra commodo. Sed eget massa sit amet nunc egestas tristique.'
                    ],
                    [
                        'testi_name' => 'Kaycee Hess',
                        'testi_pos' => 'Human Resources',
                        'testi_text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vel purus fringilla, lobortis libero ut, interdum lacus. Ut quis urna sollicitudin, iaculis dolor sed, sodales mi. Proin a velit convallis, fermentum orci in, rutrum diam. Duis elementum odio a pharetra commodo. Sed eget massa sit amet nunc egestas tristique.'
                    ]
                ]
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /***** Testimonial Style ******/
        /***** TITLE ******/
        $this->start_controls_section('naturally_testi_title_styling',
            [
                'label' => esc_html__( 'Title', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_title_testi_tabs');
        $this->start_controls_tab( 'naturally_title_testi_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='title_testi',$selector='.slider-testimonials2_title, {{WRAPPER}} .slider-testimonials_title');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_title_testi_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='title_testi_hover',$selector='.slider-testimonials2_title:hover, {{WRAPPER}} .slider-testimonials_title:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();
        /***** END TITLE ******/

        /***** DESCRIPTION ******/
        $this->start_controls_section('naturally_desc_testi_styling',
            [
                'label' => esc_html__( 'Description', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_desc_testi_tabs');
        $this->start_controls_tab( 'naturally_desc_testi_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='desc_testi',$selector='.slider-testimonials2_item_text, {{WRAPPER}} .slider-testimonials_item_text');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_desc_testi_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='desc_testi_hover',$selector='.slider-testimonials2_item_text:hover, {{WRAPPER}} .slider-testimonials_item_text:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();
        /***** END DESCRIPTION ******/

        /***** NAME ******/
        $this->start_controls_section('naturally_name_testi_styling',
            [
                'label' => esc_html__( 'Name', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_name_testi_tabs');
        $this->start_controls_tab( 'naturally_name_testi_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='name_testi',$selector='.slider-testimonials2_item_user_name, {{WRAPPER}} .slider-testimonials_item_user_name');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_name_testi_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='name_testi_hover',$selector='.slider-testimonials2_item_user_name:hover, {{WRAPPER}} .slider-testimonials_item_user_name:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();
        /***** END NAME ******/

        /***** JOP ******/
        $this->start_controls_section('naturally_jop_testi_styling',
            [
                'label' => esc_html__( 'Jop', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_jop_testi_tabs');
        $this->start_controls_tab( 'naturally_jop_testi_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='jop_testi',$selector='.slider-testimonials2_item_user_title, {{WRAPPER}} .slider-testimonials_item_user_title');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_jop_testi_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='jop_testi_hover',$selector='.slider-testimonials2_item_user_title:hover, {{WRAPPER}} .slider-testimonials_item_user_title:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();
        /***** END JOP ******/
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        if ( $settings['type'] == '1' ) {
            echo '<div class="section-custom-3">';
                echo '<div class="container">';
                    echo '<div class="grid">';
                        echo '<div class="grid_row">';
                            echo '<div class="grid_col is-xl-7" data-ntr-animation=\'{"name":"fadein-up"}\'>';
                                echo '<div class="slider-testimonials" data-ntr-slider-testimonials>';
                                    if ( $settings['title'] ) {
                                        echo '<h2 class="slider-testimonials_title">'.$settings['title'].'</h2>';
                                    }
                                    echo '<div class="slick-slider">';
                                        foreach ($settings['testi_items'] as $item) {
                                            echo '<div class="slick-slide">';
                                                echo '<div class="slider-testimonials_item">';
                                                    if ( $item['testi_text'] ) {
                                                        echo '<div class="slider-testimonials_item_text">'.$item['testi_text'].'</div>';
                                                    }
                                                    if ($item['testi_name'] || $item['testi_pos']) {
                                                        echo '<div class="slider-testimonials_item_user">';
                                                            if ( $item['testi_name'] ) {
                                                                echo '<div class="slider-testimonials_item_user_name">'.$item['testi_name'].'</div>';
                                                            }
                                                            if ( $item['testi_pos'] ) {
                                                                echo '<div class="slider-testimonials_item_user_title">'.$item['testi_pos'].'</div>';
                                                            }
                                                        echo '</div>';
                                                    }
                                                echo '</div>';
                                            echo '</div>';
                                        }
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        } else {
            echo '<div class="section section-custom-4">';
                echo '<div class="container">';
                    echo '<div class="slider-testimonials2" data-ntr-slider-testimonials2>';
                        echo '<div class="slider-testimonials2_inner">';
                            if ( $settings['title'] ) {
                                echo '<h2 class="slider-testimonials2_title" data-ntr-animation=\'{"name":"fadein-up"}\'>'.$settings['title'].'</h2>';
                            }
                            echo '<div class="slick-slider">';
                                foreach ($settings['testi_items'] as $item) {
                                    $timagealt = esc_attr(get_post_meta($item['testi_image']['id'], '_wp_attachment_image_alt', true));
                                    $timagealt = $timagealt ? $timagealt : basename ( get_attached_file( $item['testi_image']['id'] ) );
                                    echo '<div class="slick-slide">';
                                        echo '<div class="slider-testimonials2_item">';
                                            if ($item['testi_text']) {
                                                echo '<div class="slider-testimonials2_item_text">'.$item['testi_text'].'</div>';
                                            }
                                            echo '<div class="slider-testimonials2_item_user">';
                                                if ($item['testi_image']['url']) {
                                                    echo '<div class="slider-testimonials2_item_user_photo"><img src="'.$item['testi_image']['url'].'" alt="'.$timagealt.'"></div>';
                                                }
                                                if ($item['testi_name']) {
                                                    echo '<div class="slider-testimonials2_item_user_name">'.$item['testi_name'].'</div>';
                                                }
                                                if ($item['testi_pos']) {
                                                    echo '<div class="slider-testimonials2_item_user_title">'.$item['testi_pos'].'</div>';
                                                }
                                            echo '</div>';
                                        echo '</div>';
                                    echo '</div>';
                                }
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }
    }
}
