<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Woo_Category_Grid_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-woo-category-grid';
    }
    public function get_title() {
        return 'Products Category Grid (N)';
    }
    public function get_icon() {
        return 'eicon-gallery-grid';
    }
    public function get_categories() {
        return [ 'naturally-woo' ];
    }
    // Registering Controls
    protected function _register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'products_slider_items_settings',
            [
                'label' => esc_html__('Products Items', 'naturally'),
            ]
        );
        $this->add_group_control(
        Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'thumbnail',
            ]
        );
        $this->add_control( 'type',
            [
                'label' => esc_html__( 'Data Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'woo',
                'options' => [
                    'woo' => esc_html__( 'WooCommerce', 'naturally' ),
                    'custom' => esc_html__( 'Custom', 'naturally' ),
                ]
            ]
        );
        $this->add_control( 'post_per_page',
            [
                'label' => esc_html__( 'Per Page', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 1000,
                'default' => 10,
                'condition' => [ 'type' => 'woo' ]
            ]
        );
        $this->add_control( 'order',
            [
                'label' => esc_html__( 'Select Order', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__( 'Ascending', 'naturally' ),
                    'DESC' => esc_html__( 'Descending', 'naturally' )
                ],
                'default' => 'ASC',
                'condition' => [ 'type' => 'woo' ]
            ]
        );
        $this->add_control( 'orderby',
            [
                'label' => esc_html__( 'Order By', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'id' => esc_html__( 'Post ID', 'naturally' ),
                    'menu_order' => esc_html__( 'Menu Order', 'naturally' ),
                    'rand' => esc_html__( 'Random', 'naturally' ),
                    'date' => esc_html__( 'Date', 'naturally' ),
                    'title' => esc_html__( 'Title', 'naturally' ),
                ],
                'default' => 'id',
                'condition' => [ 'type' => 'woo' ]
            ]
        );
        $this->add_control( 'category_exclude',
            [
                'label' => esc_html__( 'Exclude Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s) to Exclude',
                'separator' => 'after',
                'condition' => [ 'type' => 'woo' ]
            ]
        );
        $this->add_control( 'col_xl',
            [
                'label' => esc_html__( 'Column X-LARGE Device', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 12,
                'default' => 2,
            ]
        );
        $this->add_control( 'col_lg',
            [
                'label' => esc_html__( 'Column LARGE Device', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 12,
                'default' => 3,
            ]
        );
        $this->add_control( 'col_md',
            [
                'label' => esc_html__( 'Column MEDIUM Device', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 12,
                'default' => 4,
            ]
        );
        $this->add_control( 'col_sm',
            [
                'label' => esc_html__( 'Column SMALL Device', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 12,
                'default' => 6,
            ]
        );
        $this->add_responsive_control( 'alignment',
            [
                'label' => esc_html__( 'Alignment', 'naturally' ),
                'type' => Controls_Manager::CHOOSE,
                'selectors' => ['{{WRAPPER}} .grid .grid_row' => 'justify-content: {{VALUE}};'],
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__( 'Left', 'naturally' ),
                        'icon' => 'fa fa-align-left'
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'naturally' ),
                        'icon' => 'fa fa-align-center'
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'Right', 'naturally' ),
                        'icon' => 'fa fa-align-right'
                    ]
                ],
                'toggle' => true,
                'default' => 'left'
            ]
        );
        $this->add_control( 'hidecat',
            [
                'label' => esc_html__( 'Hide Category Name', 'wavo' ),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [ 'type' => 'woo' ]
            ]
        );
        $this->add_control( 'hidecount',
            [
                'label' => esc_html__( 'Hide Category Count', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [ 'type' => 'woo' ]
            ]
        );
        $this->add_control( 'cat_singular',
            [
                'label' => esc_html__( 'Category Text Singular', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Product',
                'pleaceholder' => esc_html__( 'Enter title here', 'naturally' )
            ]
        );
        $this->add_control( 'cat_plural',
            [
                'label' => esc_html__( 'Category Text Plural', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Products',
                'pleaceholder' => esc_html__( 'Enter title here', 'naturally' )
            ]
        );
        $def_image = plugins_url( 'assets/front/img/category-13.jpg', __DIR__ );
        $this->add_control( 'products',
            [
                'type' => Controls_Manager::REPEATER,
                'seperator' => 'before',
                'default' => [
                    [
                        'image' => ['url' => $def_image],
                        'cat' => 'Lemon',
                        'title' => '96 Products',
                        'link' => '#0'
                    ],
                    [
                        'image' => ['url' => $def_image],
                        'cat' => 'Tomato',
                        'title' => '91 Products',
                        'link' => '#0'
                    ],
                    [
                        'image' => ['url' => $def_image],
                        'cat' => 'Lettuce',
                        'title' => '86 Products',
                        'link' => '#0'
                    ],
                    [
                        'image' => ['url' => $def_image],
                        'cat' => 'Patato',
                        'title' => '81 Products',
                        'link' => '#0'
                    ],
                    [
                        'image' => ['url' => $def_image],
                        'cat' => 'Mushroom',
                        'title' => '76 Products',
                        'link' => '#0'
                    ],
                    [
                        'image' => ['url' => $def_image],
                        'cat' => 'Banana',
                        'title' => '71 Products',
                        'link' => '#0'
                    ],
                    [
                        'image' => ['url' => $def_image],
                        'cat' => 'Apple',
                        'title' => '66 Products',
                        'link' => '#0'
                    ],
                ],
                'fields' => [
                    [
                        'name' => 'image',
                        'label' => esc_html__( 'Image', 'naturally' ),
                        'type' => Controls_Manager::MEDIA,
                        'default' => ['url' => $def_image]
                    ],
                    [
                        'name' => 'cat',
                        'label' => esc_html__( 'Category', 'naturally' ),
                        'type' => Controls_Manager::TEXT,
                        'default' => 'Lemon',
                        'pleaceholder' => esc_html__( 'Enter title here', 'naturally' )
                    ],
                    [
                        'name' => 'title',
                        'label' => esc_html__( 'Title', 'naturally' ),
                        'type' => Controls_Manager::TEXTAREA,
                        'default' => '56 Products',
                        'pleaceholder' => esc_html__( 'Enter title here', 'naturally' )
                    ],
                    [
                        'name' => 'link',
                        'label' => esc_html__( 'Link', 'naturally' ),
                        'type' => Controls_Manager::URL,
                        'label_block' => true,
                        'default' => [
                            'url' => '#0',
                            'is_external' => 'true'
                        ],
                        'placeholder' => esc_html__( 'Place URL here', 'naturally' )
                    ]
                ],
                'title_field' => '{{title}}',
                'condition' => [ 'type' => 'custom' ]
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /***** Woo Slider Style ******/

        /***** BOX ******/
        $this->start_controls_section('naturally_woo_box_style',
            [
                'label' => esc_html__(  'Box Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->naturally_style_padding( 'woo_cat_box_padding','{{WRAPPER}} .grid-categories_item' );
        $this->start_controls_tabs('woo_cat_box_tabs');
        $this->start_controls_tab( 'woo_cat_box_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_background( 'woo_cat_box_bg','.grid-categories_item',array('classic','gradient') );
        $this->naturally_style_border( 'woo_cat_box_border','{{WRAPPER}} .grid-categories_item' );
        $this->naturally_style_box_shadow( 'woo_cat_box_shadow','{{WRAPPER}} .grid-categories_item' );
        $this->end_controls_tab();

        $this->end_controls_tab();
        $this->start_controls_tab( 'woo_cat_box_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_background( 'woo_cat_box_hvrbg','.grid-categories_item:hover',array('classic','gradient') );
        $this->naturally_style_border( 'woo_cat_box_hvrborder','{{WRAPPER}} .grid-categories_item:hover' );
        $this->naturally_style_box_shadow( 'woo_cat_box_hvrshadow','{{WRAPPER}} .grid-categories_item:hover' );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /***** END BOX ******/

        /***** IMAGE ******/
        $this->start_controls_section('naturally_woo_cat_image_style',
            [
                'label' => esc_html__(  'Image Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->naturally_style_padding( 'woo_cat_image_padding','{{WRAPPER}} .grid-categories_item .grid-categories_item_photo' );
        $this->naturally_style_border( 'woo_cat_image_border','{{WRAPPER}} .grid-categories_item .grid-categories_item_photo' );
        $this->naturally_style_box_shadow( 'woo_cat_image_shadow','{{WRAPPER}} .grid-categories_item_photo' );
        $this->end_controls_section();
        /***** END IMAGE ******/

        /***** IMAGE ******/
        $this->start_controls_section('naturally_woo_cat_name_style',
            [
                'label' => esc_html__(  'Name Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'hidecat!' => 'yes' ]
            ]
        );
        $this->naturally_style_typo( 'woo_cat_name_typo','{{WRAPPER}} .grid-categories_item .grid-categories_item_name' );
        $this->naturally_style_margin( 'woo_cat_name_margin','{{WRAPPER}} .grid-categories_item .grid-categories_item_name' );
        $this->naturally_style_margin( 'woo_cat_name_padding','{{WRAPPER}} .grid-categories_item .grid-categories_item_name' );

        $this->start_controls_tabs('woo_cat_name_tabs');
        $this->start_controls_tab( 'woo_cat_name_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_color( 'woo_cat_name_color','{{WRAPPER}} .grid-categories_item .grid-categories_item_name' );
        $this->naturally_style_border( 'woo_cat_name_border','{{WRAPPER}} .grid-categories_item .grid-categories_item_name' );
        $this->end_controls_tab();

        $this->end_controls_tab();
        $this->start_controls_tab( 'woo_cat_name_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_color( 'woo_cat_name_hvrcolor','{{WRAPPER}} .grid-categories_item:hover .grid-categories_item_name' );
        $this->naturally_style_border( 'woo_cat_name_hvrborder','{{WRAPPER}} .grid-categories_item:hover .grid-categories_item_name' );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /***** END NAME ******/

        /***** COUNT ******/
        $this->start_controls_section('naturally_woo_cat_count_style',
            [
                'label' => esc_html__(  'Count Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'hidecat!' => 'yes' ]
            ]
        );
        $this->naturally_style_typo( 'woo_cat_count_typo','{{WRAPPER}} .grid-categories_item .grid-categories_item_count' );
        $this->naturally_style_margin( 'woo_cat_count_margin','{{WRAPPER}} .grid-categories_item .grid-categories_item_count' );
        $this->naturally_style_margin( 'woo_cat_count_padding','{{WRAPPER}} .grid-categories_item .grid-categories_item_count' );

        $this->start_controls_tabs('woo_cat_count_tabs');
        $this->start_controls_tab( 'woo_cat_count_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_color( 'woo_cat_count_color','{{WRAPPER}} .grid-categories_item .grid-categories_item_count' );
        $this->naturally_style_border( 'woo_cat_count_border','{{WRAPPER}} .grid-categories_item .grid-categories_item_count' );
        $this->end_controls_tab();

        $this->end_controls_tab();
        $this->start_controls_tab( 'woo_cat_count_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_color( 'woo_cat_count_hvrcolor','{{WRAPPER}} .grid-categories_item:hover .grid-categories_item_count' );
        $this->naturally_style_border( 'woo_cat_count_hvrborder','{{WRAPPER}} .grid-categories_item:hover .grid-categories_item_count' );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /***** END COUNT ******/

    }

    protected function render() {
        $settings  = $this->get_settings_for_display();
        $elementid = $this->get_id();
        $colxl = $settings['col_xl'] ? $settings['col_xl'] : 2;
        $collg = $settings['col_lg'] ? $settings['col_lg'] : 3;
        $colmd = $settings['col_md'] ? $settings['col_md'] : 4;
        $colsm = $settings['col_sm'] ? $settings['col_sm'] : 6;

        $size = $settings['thumbnail_size'] ? $settings['thumbnail_size'] : 'full';
        if ( 'custom' == $size ) {
            $sizew = $settings['thumbnail_custom_dimension']['width'];
            $sizeh = $settings['thumbnail_custom_dimension']['height'];
            $size = [ $sizew, $sizeh ];
        }
        echo '<div class="section-custom-categories">';
            echo '<div class="container-off">';
                echo '<div class="grid">';
                    echo '<div class="grid_row is-30 is-md-40 justify-content-center">';
                        if ('woo' == $settings['type']) {
                            $cats = get_terms(
                                array(
                                    'taxonomy' => 'product_cat',
                                    'order' => $settings['order'],
                                    'orderby' => $settings['orderby'],
                                    'exclude' => $settings['category_exclude']
                                )
                            );
                            foreach ($cats as $cat) {
                                $imgid = get_term_meta($cat->term_id, 'thumbnail_id', true );
                                echo '<div class="grid_col is-12 is-sm-'.$colsm.' is-md-'.$colmd.' is-lg-'.$collg.' is-xl-'.$colxl.' product-items">';
                                    echo '<a class="grid-categories_item" href="'.esc_url( get_term_link( $cat ) ).'">';
                                        if ($imgid) {
                                            echo wp_get_attachment_image($imgid, $size, '', array('class'=>'grid-categories_item_photo') );
                                        }
                                        if ($cat->name && 'yes' != $settings['hidecat'] ) {
                                            echo '<span class="grid-categories_item_name">'.$cat->name.'</span>';
                                        }
                                        if ($cat->count > 0  && 'yes' != $settings['hidecount']) {
                                            echo '<span class="grid-categories_item_count">'.sprintf(_n('%d '.$settings['cat_singular'], '%d '.$settings['cat_plural'], $cat->count, 'naturally'),$cat->count) .'</span>';
                                        }
                                    echo '</a>';
                                echo '</div>';
                            }

                        } else {

                            foreach ( $settings['products'] as $item ) {
                                $target = $item['link']['is_external'] ? ' target="_blank"' : '';
                                $nofollow = $item['link']['nofollow'] ? ' rel="nofollow"' : '';

                                echo '<div class="grid_col is-12 is-sm-'.$colsm.' is-md-'.$colmd.' is-lg-'.$collg.' is-xl-'.$colxl.' product-items">';
                                    echo '<a class="slider-categories_item" href="'.$item['link']['url'].'"'.$target.$nofollow.'>';
                                        if ($item['image']['url']) {
                                            echo wp_get_attachment_image($item['image']['id'], $size, '', array('class'=>'slider-categories_item_photo') );
                                        }
                                        if ($item['cat']) {
                                            echo '<span class="slider-categories_item_name">'.$item['cat'].'</span>';
                                        }
                                        if ($item['title']) {
                                            echo '<span class="grid-categories_item_count">'.$item['title'].'</span>';
                                        }
                                    echo '</a>';
                                echo '</div>';
                            }
                        }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        echo '</div>';
    }
}
