<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Woo_Category_Slider_Widget extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-woo-category-slider';
    }
    public function get_title() {
        return 'Products Slider (N)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'naturally-woo' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'products_slider_items_settings',
            [
                'label' => esc_html__('Products Items', 'naturally'),
            ]
        );
        $this->add_control( 'type',
            [
                'label' => esc_html__( 'Data Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'woo',
                'options' => [
                    'woo' => esc_html__( 'WooCommerce', 'naturally' ),
                    'custom' => esc_html__( 'Custom', 'naturally' ),
                ]
            ]
        );
        // Category Filter
        $this->add_control( 'category_filter',
            [
                'label' => esc_html__( 'Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s)',
                'condition' => [ 'type' => 'woo' ]
            ]
        );
        // Order
        $this->add_control( 'order',
            [
                'label' => esc_html__( 'Select Order', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__( 'Ascending', 'naturally' ),
                    'DESC' => esc_html__( 'Descending', 'naturally' )
                ],
                'default' => 'ASC'
            ]
        );
        $this->add_control( 'orderby',
            [
                'label' => esc_html__( 'Order By', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'id' => esc_html__( 'Post ID', 'naturally' ),
                    'menu_order' => esc_html__( 'Menu Order', 'naturally' ),
                    'rand' => esc_html__( 'Random', 'naturally' ),
                    'date' => esc_html__( 'Date', 'naturally' ),
                    'title' => esc_html__( 'Title', 'naturally' ),
                ],
                'default' => 'id',
            ]
        );
        $this->add_control( 'cat_singular',
            [
                'label' => esc_html__( 'Category Text Singular', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Product',
                'pleaceholder' => esc_html__( 'Enter title here', 'naturally' )
            ]
        );
        $this->add_control( 'cat_plural',
            [
                'label' => esc_html__( 'Category Text Plural', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Products',
                'pleaceholder' => esc_html__( 'Enter title here', 'naturally' )
            ]
        );
        $def_image = plugins_url( 'assets/front/img/category-13.jpg', __DIR__ );
        $this->add_control( 'products',
            [
                'type' => Controls_Manager::REPEATER,
                'seperator' => 'before',
                'default' => [
                    [
                        'image' => ['url' => $def_image],
                        'cat' => 'Lemon',
                        'title' => '96 Products',
                        'link' => '#0'
                    ],
                    [
                        'image' => ['url' => $def_image],
                        'cat' => 'Tomato',
                        'title' => '91 Products',
                        'link' => '#0'
                    ],
                    [
                        'image' => ['url' => $def_image],
                        'cat' => 'Lettuce',
                        'title' => '86 Products',
                        'link' => '#0'
                    ],
                    [
                        'image' => ['url' => $def_image],
                        'cat' => 'Patato',
                        'title' => '81 Products',
                        'link' => '#0'
                    ],
                    [
                        'image' => ['url' => $def_image],
                        'cat' => 'Mushroom',
                        'title' => '76 Products',
                        'link' => '#0'
                    ],
                    [
                        'image' => ['url' => $def_image],
                        'cat' => 'Banana',
                        'title' => '71 Products',
                        'link' => '#0'
                    ],
                    [
                        'image' => ['url' => $def_image],
                        'cat' => 'Apple',
                        'title' => '66 Products',
                        'link' => '#0'
                    ],
                ],
                'fields' => [
                    [
                        'name' => 'image',
                        'label' => esc_html__( 'Image', 'naturally' ),
                        'type' => Controls_Manager::MEDIA,
                        'default' => ['url' => $def_image]
                    ],
                    [
                        'name' => 'cat',
                        'label' => esc_html__( 'Category', 'naturally' ),
                        'type' => Controls_Manager::TEXT,
                        'default' => 'Lemon',
                        'pleaceholder' => esc_html__( 'Enter title here', 'naturally' )
                    ],
                    [
                        'name' => 'title',
                        'label' => esc_html__( 'Title', 'naturally' ),
                        'type' => Controls_Manager::TEXTAREA,
                        'default' => '56 Products',
                        'pleaceholder' => esc_html__( 'Enter title here', 'naturally' )
                    ],
                    [
                        'name' => 'link',
                        'label' => esc_html__( 'Link', 'naturally' ),
                        'type' => Controls_Manager::URL,
                        'label_block' => true,
                        'default' => [
                            'url' => '#0',
                            'is_external' => 'true'
                        ],
                        'placeholder' => esc_html__( 'Place URL here', 'naturally' )
                    ]
                ],
                'title_field' => '{{title}}',
                'condition' => [ 'type' => 'custom' ]
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /***** Woo Slider Style ******/

        /***** NAME ******/
        $this->start_controls_section('naturally_woo_name_styling',
            [
                'label' => esc_html__(  'Items Name', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_name_woo_tabs');
        $this->start_controls_tab( 'naturally_name_woo_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='name_woo',$selector='.slider-categories_item_name');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_name_woo_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='name_woo_hover',$selector='.slider-categories_item_name:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();
        /***** END NAME ******/

        /***** COUNT ******/
        $this->start_controls_section('naturally_woo_count_styling',
            [
                'label' => esc_html__(  'Items Count', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->start_controls_tabs('naturally_count_woo_tabs');
        $this->start_controls_tab( 'naturally_count_woo_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='count_woo',$selector='.slider-categories_item_count');
        $this->end_controls_tab();
        //
        $this->end_controls_tab();
        $this->start_controls_tab( 'naturally_count_woo_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        $this->naturally_style_controls(array('shadow'),$id='count_woo_hover',$selector='.slider-categories_item_count:hover');
        $this->end_controls_tab();
        $this->end_controls_tabs();
        //
        $this->end_controls_section();
        /***** END COUNT ******/

        /*****End Woo Slider Style ******/

    }

    protected function render() {
        $settings  = $this->get_settings_for_display();
        $elementid = $this->get_id();
        echo '<div class="section-custom-categories">';
            echo '<div class="container">';
                echo '<div class="slider-categories">';
                    echo '<div class="slick-slider">';
                        if ('woo' == $settings['type']) {

                            $args = array(
                                'taxonomy' => 'product_cat',
                                'order' => $settings['order'],
                                'orderby' => $settings['orderby']
                            );

                            if ( !empty($settings['category_filter']) ) {
                                $args['include'] = $settings['category_filter'];
                            }

                            $cats = get_terms($args);

                            foreach ($cats as $cat) {
                                if ( !empty($cat) && is_object($cat) ) {
                                    $imgid = get_term_meta($cat->term_id, 'thumbnail_id', true );
                                    $imgsrc = wp_get_attachment_url( $imgid );
                                    echo '<div class="slick-item-inner">';
                                        echo '<a class="slider-categories_item" href="'.esc_url( get_term_link( $cat ) ).'">';
                                            if ($imgsrc) {
                                                echo wp_get_attachment_image($imgid, 'thumbnail', '', array('class'=>'slider-categories_item_photo') );
                                            }
                                            if ($cat->name) {
                                                echo '<span class="slider-categories_item_name">'.$cat->name.'</span>';
                                            }
                                            if ($cat->count > 0) {
                                                echo '<span class="slider-categories_item_count">'.sprintf(_n('%d '.$settings['cat_singular'], '%d '.$settings['cat_plural'], $cat->count, 'naturally'),$cat->count) .'</span>';
                                            }
                                        echo '</a>';
                                    echo '</div>';
                                }
                            }
                        } else {
                            foreach ( $settings['products'] as $item ) {
                                $target = $item['link']['is_external'] ? ' target="_blank"' : '';
                                $nofollow = $item['link']['nofollow'] ? ' rel="nofollow"' : '';
                                $imagealt = esc_attr(get_post_meta($item['image']['id'], '_wp_attachment_image_alt', true));
                                $imagealt = $imagealt ? $imagealt : basename(get_attached_file($item['image']['id']));
                                if ($item['image']['url']) {
                                    echo '<div class="slick-slide-inner">';
                                        echo '<a class="slider-categories_item" href="'.$item['link']['url'].'"'.$target.$nofollow.'>';
                                            echo wp_get_attachment_image($item['image']['id'], 'thumbnail', '', array('class'=>'slider-categories_item_photo') );
                                            if ($item['cat']) {
                                                echo '<span class="slider-categories_item_name">'.$item['cat'].'</span>';
                                            }
                                            if ($item['title']) {
                                                echo '<span class="slider-categories_item_count">'.$item['title'].'</span>';
                                            }
                                        echo '</a>';
                                    echo '</div>';
                                }
                            }
                        }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        echo '</div>';
    }
}
