<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Naturally_Woo_Flash_Deals_Slider extends Widget_Base {
    use Naturally_Helper;
    public function get_name() {
        return 'naturally-woo-flash-deals';
    }
    public function get_title() {
        return 'Woo Flash Deals Slider (N)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'naturally-woo' ];
    }
    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);

        wp_register_style( 'naturally-flash-deals', NATURALLY_PLUGIN_URL. 'widgets/woocommerce/css/style.css');
        wp_register_script( 'naturally-jquery-countdown', NATURALLY_PLUGIN_URL. 'widgets/woocommerce/js/jquery.countdown.min.js', [ 'jquery' ], '1.0.0', true);
        wp_register_script( 'naturally-flash-deals', NATURALLY_PLUGIN_URL. 'widgets/woocommerce/js/script.js', [ 'elementor-frontend' ], '1.0.0', true);

    }
    public function get_style_depends() {
        return [ 'naturally-flash-deals' ];
    }
    public function get_script_depends() {
        return [ 'naturally-jquery-countdown', 'naturally-flash-deals' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section( 'post_query_section',
            [
                'label' => esc_html__( 'Query', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'section_title',
            [
                'label' => esc_html__( 'Left Title', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => ''
            ]
        );
        $this->add_control( 'type',
            [
                'label' => esc_html__( 'Select Type', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'slider' => esc_html__( 'Slider', 'naturally' ),
                    'tabs' => esc_html__( 'Slider Tabbed', 'naturally' ),
                ],
                'default' => 'slider'
            ]
        );
        // Order
        $this->add_control( 'scenario',
            [
                'label' => esc_html__( 'Select Scenario', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '' => esc_html__( 'Select a scenario', 'naturally' ),
                    'featured' => esc_html__( 'Featured', 'naturally' ),
                    'on-sale' => esc_html__( 'On Sale', 'naturally' ),
                    'best' => esc_html__( 'Best Selling', 'naturally' ),
                    'custom' => esc_html__( 'Specific Categories', 'naturally' ),
                ],
                'default' => '',
                'separator' => 'before',
                'condition' => [ 'type' => 'slider' ]
            ]
        );
        // Category Filter Heading
        $this->add_control( 'category_filter_heading',
            [
                'label' => esc_html__( 'Category Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'scenario',
                            'operator' => '==',
                            'value' => 'custom'
                        ],
                        [
                            'name' => 'type',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'tabs'
                        ]
                    ]
                ]
            ]
        );
        // Category Filter
        $this->add_control( 'category_filter',
            [
                'label' => esc_html__( 'Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s)',
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'scenario',
                            'operator' => '==',
                            'value' => 'custom'
                        ],
                        [
                            'name' => 'type',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'slider'
                        ]
                    ]
                ]
            ]
        );
        $this->add_control( 'category_exclude',
            [
                'label' => esc_html__( 'Exclude Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_taxonomies('product_cat'),
                'description' => 'Select Category(s) to Exclude',
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'scenario',
                            'operator' => '==',
                            'value' => 'custom'
                        ],
                        [
                            'name' => 'type',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'tabs'
                        ]
                    ]
                ]
            ]
        );
        // Post Filter Heading
        $this->add_control( 'post_filter_heading',
            [
                'label' => esc_html__( 'Post Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'scenario',
                            'operator' => '==',
                            'value' => 'custom'
                        ],
                        [
                            'name' => 'type',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'slider'
                        ]
                    ]
                ]
            ]
        );
        // Specific Post
        $this->add_control( 'post_filter',
            [
                'label' => esc_html__( 'Specific Post(s)', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_get_post_title('product'),
                'description' => 'Select Specific Post(s)',
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'scenario',
                            'operator' => '==',
                            'value' => 'custom'
                        ],
                        [
                            'name' => 'type',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'slider'
                        ]
                    ]
                ]
            ]
        );
        // Exclude Post
        $this->add_control( 'post_exclude_filter',
            [
                'label' => esc_html__( 'Exclude Post', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->naturally_cpt_get_post_title('product'),
                'description' => 'Select Post(s) to Exclude',
                'separator' => 'after',
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'scenario',
                            'operator' => '==',
                            'value' => 'custom'
                        ],
                        [
                            'name' => 'type',
                            'operator' => '==', // it accepts:  =,==, !=,!==,  in, !in etc.
                            'value' => 'slider'
                        ]
                    ]
                ]
            ]
        );
        // Other Filter Heading
        $this->add_control( 'post_other_heading',
            [
                'label' => esc_html__( 'Other Filter', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control( 'post_per_page',
            [
                'label' => esc_html__( 'Posts Per Page', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 1000,
                'default' => 10
            ]
        );
        $this->add_control( 'order',
            [
                'label' => esc_html__( 'Select Order', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__( 'Ascending', 'naturally' ),
                    'DESC' => esc_html__( 'Descending', 'naturally' )
                ],
                'default' => 'ASC'
            ]
        );
        $this->add_control( 'orderby',
            [
                'label' => esc_html__( 'Order By', 'naturally' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'id' => esc_html__( 'Post ID', 'naturally' ),
                    'menu_order' => esc_html__( 'Menu Order', 'naturally' ),
                    'rand' => esc_html__( 'Random', 'naturally' ),
                    'date' => esc_html__( 'Date', 'naturally' ),
                    'title' => esc_html__( 'Title', 'naturally' ),
                ],
                'default' => 'id',
            ]
        );
        $this->add_group_control(
        Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'large',
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('counterdown_settings_section',
            [
                'label' => esc_html__( 'Countdown Settings', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [ 'type' => 'slider' ]
            ]
        );
        $this->add_control( 'ctitle',
            [
                'label' => esc_html__( 'Time Title Before', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Ends On:',
            ]
        );
        $this->add_control( 'time',
            [
                'label' => esc_html__( 'Time', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Usage : 01/01/2030 17:00:00', 'naturally' ),
                'default' => '01/01/2030 17:00:00',
            ]
        );
        $this->add_control( 'showlabel',
            [
                'label' => esc_html__( 'Display Time Labels?', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes'
            ]
        );
        $this->add_control( 'day',
            [
                'label' => esc_html__( 'Day', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Label Day', 'naturally' ),
                'default' => 'Day',
                'condition' => [ 'showlabel' => 'yes' ]
            ]
        );
        $this->add_control( 'days',
            [
                'label' => esc_html__( 'Days', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Label Days', 'naturally' ),
                'default' => 'Days',
                'condition' => [ 'showlabel' => 'yes' ]
            ]
        );
        $this->add_control( 'hour',
            [
                'label' => esc_html__( 'Hour', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Label Hour', 'naturally' ),
                'default' => 'Hour',
                'condition' => [ 'showlabel' => 'yes' ]
            ]
        );
        $this->add_control( 'hours',
            [
                'label' => esc_html__( 'Hours', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Label Hours', 'naturally' ),
                'default' => 'Hours',
                'condition' => [ 'showlabel' => 'yes' ]
            ]
        );
        $this->add_control( 'minute',
            [
                'label' => esc_html__( 'Minute', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Label Minutes', 'naturally' ),
                'default' => 'Minute',
                'condition' => [ 'showlabel' => 'yes' ]
            ]
        );
        $this->add_control( 'minutes',
            [
                'label' => esc_html__( 'Minutes', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Label Minutes', 'naturally' ),
                'default' => 'Minutes',
                'condition' => [ 'showlabel' => 'yes' ]
            ]
        );
        $this->add_control( 'second',
            [
                'label' => esc_html__( 'Second', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Label Second', 'naturally' ),
                'default' => 'Second',
                'condition' => [ 'showlabel' => 'yes' ]
            ]
        );
        $this->add_control( 'seconds',
            [
                'label' => esc_html__( 'Seconds', 'naturally' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Label Seconds', 'naturally' ),
                'default' => 'Seconds',
                'condition' => [ 'showlabel' => 'yes' ]
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('slider_settings_section',
            [
                'label' => esc_html__( 'Carousel Settings', 'naturally' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'items',
            [
                'label' => esc_html__( 'Show Items', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 6,
                'step' => 1,
                'default' => 3,
            ]
        );
        $this->add_control( 'itemssm',
            [
                'label' => esc_html__( 'Show Items ( Tablet )', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 3,
                'step' => 1,
                'default' => 2,
            ]
        );
        $this->add_control( 'itemsxs',
            [
                'label' => esc_html__( 'Show Items ( Phone )', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 2,
                'step' => 1,
                'default' => 1,
            ]
        );
        $this->add_control( 'rows',
            [
                'label' => esc_html__( 'Rows', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 3,
                'step' => 1,
                'default' => 1,
                'separator' => 'before',
            ]
        );
        $this->add_control( 'rowssm',
            [
                'label' => esc_html__( 'Rows ( Tablet )', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 3,
                'step' => 1,
                'default' => 1
            ]
        );
        $this->add_control( 'rowsxs',
            [
                'label' => esc_html__( 'Rows ( Phone )', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 3,
                'step' => 1,
                'default' => 1
            ]
        );
        $this->add_control( 'autoplay',
            [
                'label' => esc_html__( 'Autoplay', 'naturally' ),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
            ]
        );
        $this->add_control( 'speed',
            [
                'label' => esc_html__( 'Speed', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 5000,
                'step' => 100,
                'default' => 300
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('product_container_style_section',
            [
                'label' => esc_html__( 'Container Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->naturally_style_bgcolor( 'product_container_background','{{WRAPPER}} .new-arriavls' );
        $this->naturally_style_border( 'product_container_border','{{WRAPPER}} .new-arriavls' );
        $this->naturally_style_box_shadow( 'product_container_box_shadow','{{WRAPPER}} .new-arriavls' );
        $this->add_control( 'product_container_title_heading',
            [
                'label' => esc_html__( 'SECTION TITLE', 'naturally' ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->naturally_style_typo( 'product_container_title_typo','{{WRAPPER}} .tab_heading' );
        $this->naturally_style_color( 'product_container_title_color','{{WRAPPER}} .tab_heading' );
        $this->add_responsive_control( 'product_container_title_spacing',
            [
                'label' => esc_html__( 'Spacing ( px )', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 200,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .tab_heading' => 'margin-right:{{SIZE}}px;' ],
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('time_style_settings',
            [
                'label' => esc_html__( 'Time Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control( 'product_item_time_title_heading',
            [
                'label' => esc_html__( 'TIME TITLE BEFORE', 'naturally' ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->naturally_style_typo( 'product_item_time_title_typo','{{WRAPPER}} .box-timer h5' );
        $this->naturally_style_color( 'product_item_time_title_color','{{WRAPPER}} .box-timer h5' );

        $this->add_control( 'product_item_time_heading',
            [
                'label' => esc_html__( 'TIME', 'naturally' ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->naturally_style_slider_width( 'product_item_time_width', ['{{WRAPPER}} .woocommerce.new-arriavls .timer-grid .box-time-date' => 'width: {{SIZE}}%;'], 0, 100, '%' );
        $this->naturally_style_typo( 'product_item_time_typo','{{WRAPPER}} .box-time-list li span' );
        $this->naturally_style_color( 'product_item_time_color','{{WRAPPER}} .box-time-list li span' );
        $this->naturally_style_bgcolor( 'product_item_time_background','{{WRAPPER}} .box-time-list li' );
        $this->naturally_style_border( 'product_item_time_border','{{WRAPPER}} .box-time-list li' );

        $this->add_control( 'product_item_time_label_heading',
            [
                'label' => esc_html__( 'TIME LABEL', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->naturally_style_typo( 'product_item_time_label_typo','{{WRAPPER}} .box-time-list li p' );
        $this->naturally_style_color( 'product_item_time_label_color','{{WRAPPER}} .box-time-list li p' );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('product_post_style_section',
            [
                'label' => esc_html__( 'Post Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control( 'product_item_image_heading',
            [
                'label' => esc_html__( 'IMAGE', 'naturally' ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->naturally_style_bgcolor( 'product_item_image_background','{{WRAPPER}} .product-image img' );
        $this->naturally_style_border( 'product_item_image_border','{{WRAPPER}} .product-image img' );

        if ( defined( 'YITH_WCBR' ) ) {
            $this->add_control( 'product_item_brands_heading',
                [
                    'label' => esc_html__( 'BRANDS', 'naturally' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->naturally_style_typo( 'product_item_brands_typo','{{WRAPPER}} .new-arriavls .naturally-brands .badge' );
            $this->naturally_style_color( 'product_item_brands_color','{{WRAPPER}} .new-arriavls .naturally-brands .badge' );
            $this->naturally_style_bgcolor( 'product_item_brands_background','{{WRAPPER}} .new-arriavls .naturally-brands .badge' );
            $this->naturally_style_margin( 'product_item_brands_margin','{{WRAPPER}} .new-arriavls .naturally-brands .badge' );
        }

        $this->add_control( 'product_item_title_heading',
            [
                'label' => esc_html__( 'TITLE', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->naturally_style_typo( 'product_item_title_typo','{{WRAPPER}} .new-arriavls .product .product-info .name a' );
        $this->naturally_style_color( 'product_item_title_color','{{WRAPPER}} .new-arriavls .product .product-info .name a' );
        $this->naturally_style_margin( 'product_item_title_margin','{{WRAPPER}} .new-arriavls .product .product-info .name a' );

        $this->add_control( 'product_item_stars_heading',
            [
                'label' => esc_html__( 'STARS', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->naturally_style_slider_size( 'product_item_stars_size',['{{WRAPPER}} .woocommerce.new-arriavls .star-rating' => 'font-size:{{SIZE}}px;'], 0,50,'px' );

        $this->add_control( 'product_item_price_heading',
            [
                'label' => esc_html__( 'PRICE', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->naturally_style_typo( 'product_item_price_typo','{{WRAPPER}} .new-arriavls .product .product-info .product-price .price del,{{WRAPPER}} .new-arriavls .product .product-info .product-price .price ins' );
        $this->naturally_style_color( 'product_item_price_color','{{WRAPPER}} .new-arriavls .product .product-info .product-price .price del,{{WRAPPER}} .new-arriavls .product .product-info .product-price .price ins' );
        $this->naturally_style_margin( 'product_item_price_margin','{{WRAPPER}} .new-arriavls .product .product-info .product-price .price del,{{WRAPPER}} .new-arriavls .product .product-info .product-price .price ins' );

        $this->add_control( 'product_item_buttons_heading',
            [
                'label' => esc_html__( 'SALE PRICE', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->naturally_style_color( 'product_item_sale_price_color','{{WRAPPER}} .new-arriavls .product .product-info .product-price .price ins' );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('product_item_buttons_style_section',
            [
                'label' => esc_html__( 'Button Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->start_controls_tabs( 'product_item_btn_tabs');
        $this->start_controls_tab( 'product_item_btn_normal_tab',
            [ 'label'  => esc_html__( 'Normal', 'naturally' ) ]
        );
        // Style function
        $this->naturally_style_color( 'product_item_btn_color','{{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions a, {{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions .yith-wcwl-add-to-wishlist a, {{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions .yith-wcwl-add-to-wishlist' );
        $this->naturally_style_background( 'product_item_btn_background','{{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions a, {{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions .yith-wcwl-add-to-wishlist a, {{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions .yith-wcwl-add-to-wishlist',array('classic','gradient') );
        $this->naturally_style_border( 'product_item_btn_border','{{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions a, {{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions .yith-wcwl-add-to-wishlist a, {{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions .yith-wcwl-add-to-wishlist' );
        $this->end_controls_tab();

        $this->start_controls_tab( 'product_item_btn_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );
        // Style function
        $this->naturally_style_color( 'product_item_btn_hvr_color','{{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions a:hover, {{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions .yith-wcwl-add-to-wishlist a:hover, {{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions .yith-wcwl-add-to-wishlist:hover' );
        $this->naturally_style_background( 'product_item_btn_hvr_background','{{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions a:hover, {{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions .yith-wcwl-add-to-wishlist a:hover, {{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions .yith-wcwl-add-to-wishlist:hover',array('classic','gradient') );
        $this->naturally_style_border( 'product_item_btn_hvr_border','{{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions a:hover, {{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions .yith-wcwl-add-to-wishlist a:hover, {{WRAPPER}} .new-arriavls.woocommerce .shop-product_actions .yith-wcwl-add-to-wishlist:hover' );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('product_slider_nav_style_section',
            [
                'label'=> esc_html__( 'Slider Nav Style', 'naturally' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control( 'product_slider_nav_genaral_heading',
            [
                'label' => __( 'GENERAL Options', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );
        $this->naturally_style_slider_width( 'product_slider_nav_width',array( '{{WRAPPER}} .new-arriavls .slick-prev, {{WRAPPER}} .new-arriavls .slick-next' => 'width: {{SIZE}}px' ), $min=0, $max=200, $unit='px' );
        $this->naturally_style_slider_height( 'product_slider_nav_height',array( '{{WRAPPER}} .new-arriavls .slick-prev, {{WRAPPER}} .new-arriavls .slick-next' => 'height: {{SIZE}}px' ), $min=0, $max=200, $unit='px' );
        $this->naturally_style_box_shadow( 'product_slider_nav_box_shadow','{{WRAPPER}} .new-arriavls .slick-prev, {{WRAPPER}} .new-arriavls .slick-next' );

        $this->start_controls_tabs( 'product_slider_nav_tabs');
        $this->start_controls_tab( 'product_slider_nav_normal_tab',
            [ 'label'  => esc_html__( 'Normal', 'naturally' ) ]
        );

        $this->naturally_style_bgcolor( 'product_slider_nav_background','{{WRAPPER}} .new-arriavls .slick-prev, {{WRAPPER}} .new-arriavls .slick-next' );
        $this->naturally_style_color( 'product_slider_nav_color','{{WRAPPER}} .new-arriavls .slick-prev, {{WRAPPER}} .new-arriavls .slick-next' );
        $this->naturally_style_border( 'product_slider_nav_border','{{WRAPPER}} .new-arriavls .slick-prev, {{WRAPPER}} .new-arriavls .slick-next' );
        $this->end_controls_tab();

        $this->start_controls_tab( 'product_slider_nav_hover_tab',
            [ 'label' => esc_html__( 'Hover', 'naturally' ) ]
        );

        $this->naturally_style_bgcolor( 'product_slider_nav_hvr_background','{{WRAPPER}} .new-arriavls .slick-prev:hover, {{WRAPPER}} .slick-next:hover' );
        $this->naturally_style_color( 'product_slider_nav_hvr_color','{{WRAPPER}} .new-arriavls .slick-prev:hover, {{WRAPPER}} .slick-next:hover' );
        $this->naturally_style_border( 'product_slider_nav_hvr_border','{{WRAPPER}} .new-arriavls .slick-prev:hover, {{WRAPPER}} .slick-next:hover' );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control( 'product_slider_prev_heading',
            [
                'label' => __( 'PREV POSITION', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control( 'product_slider_prev_horizontal',
            [
                'label' => esc_html__( 'Horizontal Position ( % )', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .new-arriavls .slick-prev' => 'left:{{SIZE}}%;' ]
            ]
        );
        $this->add_responsive_control( 'product_slider_prev_vertical',
            [
                'label' => esc_html__( 'Vertical Position ( % )', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .new-arriavls .slick-prev' => 'top:{{SIZE}}%;' ]
            ]
        );

        $this->add_control( 'product_slider_next_heading',
            [
                'label' => __( 'NEXT POSITION', 'naturally' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control( 'product_slider_next_horizontal',
            [
                'label' => esc_html__( 'Horizontal Position ( % )', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => -100,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .new-arriavls .slick-next' => 'left:{{SIZE}}%;' ],
            ]
        );
        $this->add_responsive_control( 'product_slider_next_vertical',
            [
                'label' => esc_html__( 'Vertical Position ( % )', 'naturally' ),
                'type' => Controls_Manager::NUMBER,
                'min' => -100,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .new-arriavls .slick-next' => 'top:{{SIZE}}%;' ],
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
    }

    protected function render() {
        $settings  = $this->get_settings_for_display();
        $elementid = $this->get_id();
        remove_action( 'woocommerce_after_shop_loop_item', 'naturally_product_price', 5 );
        remove_action( 'woocommerce_after_shop_loop_item', 'naturally_before_product_buttons', 9 );
        remove_action( 'woocommerce_after_shop_loop_item', 'naturally_after_product_buttons', 25 );
        $time     = $settings['time'] ? $settings['time'] : '';
        $items    = $settings['items'] ? $settings['items'] : 4;
        $itemssm  = $settings['itemssm'] ? $settings['itemssm'] : 2;
        $itemsxs  = $settings['itemsxs'] ? $settings['itemsxs'] : 1;
        $rows     = $settings['rows'] ? $settings['rows'] : 1;
        $rowssm   = $settings['rowssm'] ? $settings['rowssm'] : 1;
        $rowsxs   = $settings['rowsxs'] ? $settings['rowsxs'] : 1;
        $speed    = $settings['speed'] ? $settings['speed'] : 300;
        $autoplay = 'yes' == $settings['autoplay'] ? 'true' : 'false';

        $tdays = $thours = $tminutes = $tseconds = '';
        
        $prev = '"<span class=\"slick-prev\"><span class=\"icon is-back\"></span></span>"';
        $next = '"<span class=\"slick-next\"><span class=\"icon is-next\"></span></span>"';

        $day  = $settings['day'];
        $days = $settings['days'];
        $hr   = $settings['hour'];
        $hrs  = $settings['hours'];
        $min  = $settings['minute'];
        $mins = $settings['minutes'];
        $sec  = $settings['second'];
        $secs = $settings['seconds'];

        if( $settings['showlabel'] == 'yes' ) {
            $tdays    = '<span class="days_text wf-second">'.$days.'</span>';
            $thours   = '<span class="hours_text wf-second">'.$hrs.'</span>';
            $tminutes = '<span class="minutes_text wf-second">'.$mins.'</span>';
            $tseconds = '<span class="seconds_text wf-second">'.$secs.'</span>';

        }
        $size = $settings['thumbnail_size'] ? $settings['thumbnail_size'] : 'full';
        if ( 'custom' == $size ) {
            $sizew = $settings['thumbnail_custom_dimension']['width'];
            $sizeh = $settings['thumbnail_custom_dimension']['height'];
            $size = [ $sizew, $sizeh ];
        }

        $tabbed = 'tabs' == $settings['type'] ? '-tabbed' : '';
        echo '<div class="section-off woo-slider3'.$tabbed.' show-items-'.$items.'">';

            if ( 'tabs' == $settings['type'] ) {

                $tabs = get_terms(
                    array(
                        'taxonomy' => 'product_cat',
                        'order' => $settings['order'],
                        'orderby' => $settings['orderby'],
                        'exclude' => $settings['category_exclude']
                    )
                );

                echo '<div class="tab">';
                    if ( $settings['section_title'] || $tabs ) {
                        echo '<div class="new-arriavls-title-wrapper">';
                            if ( $settings['section_title'] ) {
                                echo '<h3 class="tab_heading">'.$settings['section_title'].'</h3>';
                            }
                            if ( $tabs ) {
                                echo '<div class="nav_toggle">';
                                    echo '<div class="tab_nav_toggle_button">';
                                        echo '<span class="nav_toggle_button_icon icon is-filter"></span>';
                                    echo '</div>';
                                    $count = 1;
                                    echo '<div class="tab_nav">';
                                        foreach ( $tabs as $tab ) {
                                            $is_active = 1 == $count ? ' is-active' : '';
                                            if ( $tab->name ) {
                                            	echo '<a class="tab_nav_item'.$is_active.'" href="#" data-id="'.$tab->slug.'_'.$elementid.'">'.$tab->name.'</a>';
                                            }
                                            $count++;
                                        }
                                    echo '</div>';
                                echo '</div>';
                            }
                        echo '</div>';
                    }

                    $counttwo = 1;

                    foreach ( $tabs as $tab ) {

                        $is_active = 1 == $counttwo ? ' is-active' : '';
                        echo '<div class="tab_slider tab_page'.$is_active.'" id="tab_category_'.$elementid.'" data-id="'.$tab->slug.'_'.$elementid.'">';
                            echo '<div class="new-arriavls woocommerce type_tabbed">';
                                echo '<div class="slick-slider" data-slick=\'{"rows": '.$rowsxs.',"slidesToShow": '.$itemsxs.',"mobileFirst": true,"pauseOnHover": true,"autoplay": '.$autoplay.',"slidesToShow": '.$items.',"speed": '.$speed.',"prevArrow": '.$prev.',"nextArrow": '.$next.',"responsive":[{"breakpoint": 1024,"settings": {"rows": '.$rows.',"slidesToShow": '.$items.'}},{"breakpoint": 767,"settings": {"rows": '.$rowssm.',"slidesToShow": '.$itemssm.'}},{"breakpoint": 320,"settings": {"rows": '.$rowsxs.',"slidesToShow": '.$itemsxs.'}}]}\'>';

                                    $catargs = array(
                                        'post_type' => 'product',
                                        'posts_per_page' => $settings['post_per_page'],
                                        'order' => $settings['order'],
                                        'orderby' => $settings['orderby'],
                                        'tax_query' => array(
                                            array(
                                                'taxonomy' => 'product_cat',
                                                'field' => 'slug',
                                                'terms' => $tab->slug,
                                                //'operator' => 'NOT IN',
                                            )
                                        )
                                    );

                                    $the_query = new \WP_Query( $catargs );
                                    if( $the_query->have_posts() ) {
                                        while ($the_query->have_posts()) {
                                            $the_query->the_post();
                                            $product = new \WC_Product(get_the_ID());
                                            ob_start();
                                            wc_product_class( 'shop-product hover-shadow', $product );
                                            echo '<div '.ob_get_clean().'>';

                                                if ( function_exists( 'naturally_product_all_labels' ) ) {
                                                    naturally_product_all_labels();
                                                }

                                                echo '<div class="shop-product_photo">';
                                                    echo '<a href="'.get_permalink().'">';
                                                        if ( $size ) {
                                                            echo wp_get_attachment_image($product->get_image_id(), $size );
                                                        } else {
                                                            woocommerce_template_loop_product_thumbnail();
                                                        }
                                                    echo '</a>';
                                                echo '</div>';

                                                if ( defined( 'YITH_WCBR' ) && function_exists( 'naturally_product_brand' ) ) {
                                                    naturally_product_brand();
                                                }

                                                echo '<div class="shop-product_content">';
                                                    echo '<div class="shop-product_body">';

                                                        echo '<div class="shop-product_title">';
                                                            echo '<a href="'.get_permalink().'">'.get_the_title().'</a>';
                                                        echo '</div>';
                                                        if( wc_review_ratings_enabled() && $product->get_average_rating() ){
                                                            echo '<div class="shop-product_rating">';
                                                                echo '<div class="rating">';
                                                                    woocommerce_template_loop_rating();
                                                                echo '</div>';
                                                            echo '</div>';
                                                        }
                                                        if( $product->get_price_html() ){
                                                            echo '<div class="shop-product_prices">';
                                                                woocommerce_template_loop_price();
                                                            echo '</div>';
                                                        }
                                                    echo '</div>';

                                                    echo '<div class="shop-product_actions">';
                                                        do_action( 'woocommerce_after_shop_loop_item' );
                                                    echo '</div>';

                                                echo '</div>';
                                            echo '</div>';
                                        }
                                    }
                                    wp_reset_postdata();

                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                        $counttwo++;
                    }

                echo '</div>';

            } else {

                echo '<div class="new-arriavls  woocommerce">';
                    if ( $settings['section_title'] || $settings['time'] ) {
                        echo '<div class="new-arriavls-title-wrapper type_slider">';
                            if ( $settings['section_title'] ) {
                                echo '<h3 class="tab_heading">'.$settings['section_title'].'</h3>';
                            }
                            if ( $settings['time'] ) {
                                echo '<div class="box-timer">';
                                    if ( $settings['ctitle'] ) {
                                        echo '<h5>'.$settings['ctitle'].'</h5>';
                                    }

                                    echo '<div class="countbox_1 timer-grid" data-countdown-settings=\'{"time":"'.$time.'","tday":"'.$day.'","tdays":"'.$days.'","thour":"'.$hr.'","thours":"'.$hrs.'","tmin":"'.$min.'","tmins":"'.$mins.'","tsec":"'.$sec.'","tsecs":"'.$secs.'"}\'>';
                                        $has_label = 'yes' == $settings['showlabel'] ? 'has-time-label' : 'time-label-none';
                                            echo '<ul class="box-time-list '.$has_label.'">
                                                <li class="box-time-date"><span class="days wf-first">00</span>'.$tdays.'</li>
                                                <li class="box-time-date"><span class="hours wf-first">00</span>'.$thours.'</li>
                                                <li class="box-time-date"><span class="minutes wf-first">00</span>'.$tminutes.'</li>
                                                <li class="box-time-date"><span class="seconds wf-first">00</span>'.$tseconds.'</li>
                                            </ul>';
                                    echo '</div>';
                                echo '</div>';
                            }
                        echo '</div>';
                    }

                    echo '<div class="slick-slider" data-slick=\'{"rows": '.$rowsxs.',"slidesToShow": '.$itemsxs.',"mobileFirst": true,"pauseOnHover": true,"autoplay": '.$autoplay.',"slidesToShow": '.$items.',"speed": '.$speed.',"prevArrow": '.$prev.',"nextArrow": '.$next.',"responsive":[{"breakpoint": 1024,"settings": {"rows": '.$rows.',"slidesToShow": '.$items.'}},{"breakpoint": 767,"settings": {"rows": '.$rowssm.',"slidesToShow": '.$itemssm.'}},{"breakpoint": 320,"settings": {"rows": '.$rowsxs.',"slidesToShow": '.$itemsxs.'}}]}\'>';

                        $args = array(
                            'post_type'      => 'product',
                            'posts_per_page' => $settings['post_per_page'],
                            'post__in'       => $settings['post_filter'],
                            'post__not_in'   => $settings['post_exclude_filter'],
                            'order'          => $settings['order']
                        );

                        if ( 'featured' == $settings['scenario'] ) {
                           $args['tax_query'] = array(
                                array(
                                    'taxonomy' => 'product_visibility',
                                    'field'    => 'name',
                                    'terms'    => 'featured',
                                )
                            );
                            $args['orderby'] = $settings['orderby'];

                        } elseif('on-sale' == $settings['scenario']) {

                            $args['meta_query'] = array(
                                'relation' => 'OR',
                                array( // Simple products type
                                    'key'       => '_sale_price',
                                    'value'     => 0,
                                    'compare'   => '>',
                                    'type'      => 'numeric'
                                ),
                                array( // Variable products type
                                    'key'       => '_min_variation_sale_price',
                                    'value'     => 0,
                                    'compare'   => '>',
                                    'type'      => 'numeric'
                                )
                            );

                        } elseif('best' == $settings['scenario']) {

                            $args['orderby'] = 'meta_value_num';
                            $args['meta_key'] = 'total_sales';

                        } else {

                            $args['orderby'] = $settings['orderby'];

                        }
                        if ( $settings['category_filter'] ) {
                            $args['tax_query'] = array(
                                array(
                                    'taxonomy'  => 'product_cat',
                                    'field'     => 'id',
                                    'terms'     => $settings['category_filter'],
                                    'operator'  => 'IN'
                                )
                            );
                        }
                        if ( $settings['category_exclude'] ) {
                            $args['tax_query'] = array(
                                array(
                                    'taxonomy'  => 'product_cat',
                                    'field'     => 'id',
                                    'terms'     => $settings['category_exclude'],
                                    'operator'  => 'NOT IN'
                                )
                            );
                        }

                        $the_query = new \WP_Query( $args );
                        if( $the_query->have_posts() ) {
                            while ($the_query->have_posts()) {
                                $the_query->the_post();
                                $product = new \WC_Product(get_the_ID());
                                ob_start();
                                wc_product_class( 'shop-product hover-shadow', $product );
                                echo '<div '.ob_get_clean().'>';

                                    if ( function_exists( 'naturally_product_all_labels' ) ) {
                                        naturally_product_all_labels();
                                    }

                                    echo '<div class="shop-product_photo">';
                                        echo '<a href="'.get_permalink().'">';
                                            if ( $size ) {
                                                echo wp_get_attachment_image($product->get_image_id(), $size );
                                            } else {
                                                woocommerce_template_loop_product_thumbnail();
                                            }
                                        echo '</a>';
                                    echo '</div>';

                                    if ( defined( 'YITH_WCBR' ) && function_exists( 'naturally_product_brand' ) ) {
                                        naturally_product_brand();
                                    }

                                    echo '<div class="shop-product_content">';
                                        echo '<div class="shop-product_body">';

                                            echo '<div class="shop-product_title">';
                                                echo '<a href="'.get_permalink().'">'.get_the_title().'</a>';
                                            echo '</div>';
                                            if( wc_review_ratings_enabled() && $product->get_average_rating() ){
                                                echo '<div class="shop-product_rating">';
                                                    echo '<div class="rating">';
                                                        woocommerce_template_loop_rating();
                                                    echo '</div>';
                                                echo '</div>';
                                            }
                                            if( $product->get_price_html() ){
                                                echo '<div class="shop-product_prices">';
                                                    woocommerce_template_loop_price();
                                                echo '</div>';
                                            }
                                        echo '</div>';

                                        echo '<div class="shop-product_actions">';
                                            do_action( 'woocommerce_after_shop_loop_item' );
                                        echo '</div>';

                                    echo '</div>';
                                echo '</div>';
                            }
                        }
                        wp_reset_postdata();

                    echo '</div>';
                echo '</div>';
            }
        echo '</div>';
        add_action( 'woocommerce_after_shop_loop_item', 'naturally_product_price', 5 );
        add_action( 'woocommerce_after_shop_loop_item', 'naturally_before_product_buttons', 9 );
        add_action( 'woocommerce_after_shop_loop_item', 'naturally_after_product_buttons', 25 );
    }
}
